/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryExecuteMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPDataCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.ROLAPAggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.util.ConfigurationValues;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ROLAPBaseDataCache
extends ROLAPDataCache {
    private AtomicBoolean startedLoadingAggregates = new AtomicBoolean(false);
    private boolean finishedLoadingAggregates;
    private List<ROLAPQueryExecuteMetrics> metricsForAllAggregates = new ArrayList<ROLAPQueryExecuteMetrics>();

    public ROLAPBaseDataCache(ROLAPCube cube, ROLAPCacheBase theParent) {
        super(cube, theParent);
    }

    public AggregateCubeletStorage createAggregateStorage(ROLAPCube cube) {
        AggregateCubeletStorage newAggregateStorage = null;
        List<AggregateDefinition> aggregateDefinitions = ROLAPAggregateDefinition.load(cube);
        int inMemoryAggregateSizeInMeg = cube.getConfigMaxAggregateCacheSize();
        int maxDataCacheAggregateCount = ConfigurationValues.getInt("MaxDataCacheAggregateDefinitions", 0);
        if (aggregateDefinitions != null && aggregateDefinitions.size() > 0 && inMemoryAggregateSizeInMeg > 0 || maxDataCacheAggregateCount > 0) {
            newAggregateStorage = AggregateCubeletStorage.createInstance(cube, aggregateDefinitions);
        }
        if (aggregateDefinitions != null && aggregateDefinitions.size() > 0 && inMemoryAggregateSizeInMeg == 0) {
            ROLAPLog.logWarn("ROLAPCubes.AggregateCache", "The loading of all in-memory aggregates has been skipped since the max aggregate cache size is zero.");
            cube.getMessages().addMessage(XQEMessageKeys.RLU_InMemoryAggregatesLoadSkipped);
        }
        return newAggregateStorage;
    }

    public boolean canStartLoadingAggregates() {
        return this.startedLoadingAggregates.compareAndSet(false, true);
    }

    public void resetStartedLoadingAggregates() {
        this.startedLoadingAggregates.set(false);
    }

    public boolean isFinishedLoadingAggregates() {
        return this.finishedLoadingAggregates;
    }

    public void setFinishedLoadingAggregates(boolean finished) {
        this.finishedLoadingAggregates = finished;
    }

    public List<ROLAPQueryExecuteMetrics> getMetricsForAllAggregates() {
        return this.metricsForAllAggregates;
    }

    public void addMetricsForSingleAggregate(ROLAPQueryExecuteMetrics metricsForSingleAggregate) {
        this.metricsForAllAggregates.add(metricsForSingleAggregate);
    }
}

