/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPNamedSet;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPMemberCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPSharedDimensionCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaNamedSet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.List;

public class ROLAPBaseMemberCache
extends ROLAPMemberCache {
    public ROLAPBaseMemberCache(ROLAPCube cube) {
        super(cube);
    }

    @Override
    protected void initializeCacheImpl() {
        ROLAPCube cube = this.getCube();
        ROLAPMetaCube modelCube = cube.getModelCube();
        if (modelCube != null) {
            String measureName = modelCube.getMetaCubeModel().getMeasureDimensionName();
            ROLAPDimension measures = new ROLAPDimension(measureName, this.getCube(), null, null, DimensionTypeEnum.MEASURE);
            ROLAPMetaDimension[] dims = modelCube.getDimensions();
            if (dims != null) {
                for (ROLAPMetaDimension metaDim : dims) {
                    String dimName = metaDim.getName();
                    DimensionTypeEnum dimType = DimensionTypeEnum.REGULAR;
                    if (metaDim.isTimeDimension()) {
                        dimType = DimensionTypeEnum.TIME;
                    }
                    ROLAPMetaHierarchy metaDefaultHierarchy = modelCube.getDefaultHierarchy(metaDim);
                    String sharedDimUUID = metaDim.getSharedDimensionUUID(this.getCube());
                    if (sharedDimUUID != null && !ROLAPSharedDimensionCache.DISABLESHAREDDIMENSIONCACHE && !cube.isCubingServicesCompatible()) {
                        ROLAPSharedDimensionCache.getInstance().getOrCreateShareableDimension(this.getCube(), dimName, metaDim, modelCube, sharedDimUUID, dimType, metaDefaultHierarchy);
                        continue;
                    }
                    ROLAPDimension rolapDimension = new ROLAPDimension(dimName, this.getCube(), metaDim, metaDefaultHierarchy, dimType);
                    for (ROLAPMetaHierarchy hier : modelCube.getHierarchies(metaDim)) {
                        ROLAPHierarchy rolapHier = rolapDimension.addHierarchy(hier);
                        if (!hier.getName().equals(metaDefaultHierarchy.getName())) continue;
                        rolapDimension.setDefaultHierarchy(rolapHier);
                    }
                }
                for (String internalDimensionName : INTERNAL_DIMENSION_NAMES) {
                    new ROLAPDimension(internalDimensionName, this.getCube(), null, null, DimensionTypeEnum.INTERNAL);
                }
            } else {
                ROLAPMetaHierarchy[] hiers = modelCube.getHierarchies();
                for (int i = 0; i < hiers.length; ++i) {
                    IDimension dimension;
                    ROLAPMetaDimension dim = hiers[i].getDimension(modelCube);
                    String dimName = dim.getName();
                    DimensionTypeEnum dimType = DimensionTypeEnum.REGULAR;
                    if (dim.isTimeDimension()) {
                        dimType = DimensionTypeEnum.TIME;
                    }
                    if ((dimension = this.getDimension(dimName)) == null) {
                        new ROLAPDimension(dimName, this.getCube(), dim, hiers[i], dimType);
                        continue;
                    }
                    ROLAPDimension csDimension = (ROLAPDimension)dimension;
                    csDimension.addHierarchy(hiers[i]);
                }
            }
        }
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        ROLAPContext context = ROLAPContext.get(execEnv);
        this.loadBaseCubeHierarchies(context.getReservation(cube));
        this.loadNamedSets(cube, modelCube);
    }

    private void loadNamedSets(ROLAPCube cube, ROLAPMetaCube metaCubeModel) {
        if (metaCubeModel == null) {
            return;
        }
        List<ROLAPMetaNamedSet> metaNamedSets = metaCubeModel.getNamedSets();
        if (metaNamedSets != null) {
            for (ROLAPMetaNamedSet metaNamedSet : metaNamedSets) {
                ROLAPNamedSet namedSet = new ROLAPNamedSet(cube, metaNamedSet);
                if (this.containsNamedSet(namedSet)) {
                    String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_DuplicateNamedSetName, XQEMessages.getCurrProductLocale(), namedSet.getUniqueName());
                    ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, errorMessage);
                    continue;
                }
                this.addNamedSet(namedSet);
            }
        }
    }
}

