/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate;

import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCallable;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryExecuteMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadExceptionInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadTaskInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AggregateCacheLoader;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AggregateLoadTaskResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AggregateLoadTreeExecution;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.IAggregateLoadListener;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.ROLAPAggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.List;

public class AggregateLoadTask
extends ROLAPCallable<AggregateLoadTaskResult> {
    private static final String ZIPI_AGGREGATE_LOAD = "DCAggregateLoad";
    private static final String TASK_DESCRIPTION = "Dynamic Cube Aggregate Load: ";
    private final ROLAPBaseCube cube;
    private final AggregateDefinition aggregateDefinition;
    private final AggregateLoadTreeExecution loadTree;
    private final String aggregateNames;
    private final AggregateCubeletStorage aggregateCache;
    private final ROLAPCubeReservation parentReservation;
    private final List<AggregateLoadTaskInfo> aggregateLoadTaskInfos = new ArrayList<AggregateLoadTaskInfo>();

    public AggregateLoadTask(ROLAPBaseCube theCube, AggregateCubeletStorage theAggregateCache, AggregateDefinition theAggregateDefinition, ROLAPCubeReservation theParentReservation) {
        super(theCube);
        this.cube = theCube;
        this.aggregateCache = theAggregateCache;
        this.aggregateDefinition = theAggregateDefinition;
        this.parentReservation = theParentReservation;
        this.mZipiAction = ZIPI_AGGREGATE_LOAD;
        this.loadTree = null;
        this.aggregateNames = this.aggregateDefinition.getName();
    }

    public AggregateLoadTask(ROLAPBaseCube theCube, AggregateCubeletStorage theAggregateCache, AggregateLoadTreeExecution theLoadTree, ROLAPCubeReservation theParentReservation) {
        super(theCube);
        this.cube = theCube;
        this.aggregateCache = theAggregateCache;
        this.aggregateDefinition = null;
        this.parentReservation = theParentReservation;
        this.mZipiAction = ZIPI_AGGREGATE_LOAD;
        this.loadTree = theLoadTree;
        this.aggregateNames = theLoadTree.toString();
    }

    @Override
    public AggregateLoadTaskResult callImpl() throws Exception {
        ExecutionEnvironment executionEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        return this.loadAggregate(executionEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AggregateLoadTaskResult loadAggregate(ExecutionEnvironment executionEnv) throws Exception {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapAggregate", this.aggregateNames);
        boolean registered = false;
        try {
            AggregateLoadListener loadListener;
            block9: {
                registered = this.cube.registerCurrentThread(false);
                ROLAPLog.log("ROLAPCubes.AggregateCache", "Aggregate load began.");
                ROLAPContext context = ROLAPContext.get();
                context.addReservation(this.parentReservation, executionEnv);
                loadListener = new AggregateLoadListener();
                try {
                    long loadStartTime = System.currentTimeMillis();
                    if (this.loadTree != null) {
                        this.loadTree.execute(loadListener);
                        ROLAPLog.log("ROLAPCubes.AggregateCache", String.format("Stacked aggregate load finished in %,dms (%,dms was loading aggregates from DB), %d loaded from the database containing %,d cells, %d loaded from other aggregates containing %,d cells, %d failed.", System.currentTimeMillis() - loadStartTime, loadListener.getTotalTimeLoadingAggregatesFromDB(), loadListener.getNumAggregatesLoadedFromDB(), loadListener.getNumCellsFromDB(), loadListener.getNumAggregatesLoadedFromRollups(), loadListener.getNumCellsFromRollups(), loadListener.getNumFailedAggregates()));
                        break block9;
                    }
                    try {
                        ROLAPQueryExecuteMetrics metrics = AggregateCacheLoader.loadSingleCacheSlice(this.cube, this.aggregateCache, this.aggregateDefinition);
                        loadListener.aggregateLoadSuccessful(this.aggregateDefinition, metrics, System.currentTimeMillis() - loadStartTime);
                    }
                    catch (Exception e) {
                        loadListener.aggregateLoadFailed(this.aggregateDefinition, true, e);
                        throw e;
                    }
                    ROLAPLog.log("ROLAPCubes.AggregateCache", "Aggregate load succeeded.");
                }
                finally {
                    context.removeReservation(this.parentReservation);
                }
            }
            AggregateLoadTaskResult aggregateLoadTaskResult = new AggregateLoadTaskResult(loadListener.getNumAggregatesLoadedFromRollups(), loadListener.getMetricsFromAggregateLoadedFromDB(), loadListener.getNumFailedAggregates());
            return aggregateLoadTaskResult;
        }
        finally {
            this.cube.deregisterCurrentThread(false, registered);
            traceContext.exit();
        }
    }

    public List<AggregateLoadTaskInfo> getAggregateLoadTaskInfo() {
        return this.aggregateLoadTaskInfos;
    }

    public String toString() {
        return TASK_DESCRIPTION + this.cube.getName() + ": " + this.aggregateNames;
    }

    private class AggregateLoadListener
    implements IAggregateLoadListener {
        private long numCellsFromDB = 0L;
        private long numCellsFromRollups = 0L;
        private List<ROLAPQueryExecuteMetrics> metricsFromAggregateLoadedFromDB = new ArrayList<ROLAPQueryExecuteMetrics>();
        private int numAggregatesLoadedFromRollups = 0;
        private int numFailedAggregates = 0;
        private long totalTimeLoadingAggregatesFromDB = 0L;

        private AggregateLoadListener() {
        }

        public long getNumCellsFromDB() {
            return this.numCellsFromDB;
        }

        public long getNumCellsFromRollups() {
            return this.numCellsFromRollups;
        }

        public int getNumAggregatesLoadedFromDB() {
            return this.metricsFromAggregateLoadedFromDB.size();
        }

        public List<ROLAPQueryExecuteMetrics> getMetricsFromAggregateLoadedFromDB() {
            return this.metricsFromAggregateLoadedFromDB;
        }

        public int getNumAggregatesLoadedFromRollups() {
            return this.numAggregatesLoadedFromRollups;
        }

        public int getNumFailedAggregates() {
            return this.numFailedAggregates;
        }

        public long getTotalTimeLoadingAggregatesFromDB() {
            return this.totalTimeLoadingAggregatesFromDB;
        }

        @Override
        public void aggregateLoadSuccessful(AggregateDefinition definition, ROLAPQueryExecuteMetrics dbMetrics, long loadTime) {
            String aggregateName = definition.getName();
            ((ROLAPAggregateDefinition)definition).setStorageLocation(AggregateLoadTask.this.aggregateCache);
            AggregateLoadTask.this.aggregateCache.notifyAggregateDefinitionLoaded(definition);
            AggregateLoadTask.this.parentReservation.getDataCache().incrementLoadedInMemoryAggregateCount();
            AggregateLoadTaskInfo aggregateLoadTaskInfo = new AggregateLoadTaskInfo();
            aggregateLoadTaskInfo.setAggregateDefinition(definition);
            aggregateLoadTaskInfo.setAggregateName(aggregateName);
            aggregateLoadTaskInfo.setAggregateSizeInBytes(AggregateLoadTask.this.aggregateCache.getCubeletSize(aggregateName));
            aggregateLoadTaskInfo.setAggregateSizeInCells(definition.getCellCount());
            aggregateLoadTaskInfo.setAggregateLoadTime(loadTime);
            AggregateLoadTask.this.aggregateLoadTaskInfos.add(aggregateLoadTaskInfo);
            if (dbMetrics != null) {
                this.numCellsFromDB += (long)((int)definition.getCellCount());
                this.metricsFromAggregateLoadedFromDB.add(dbMetrics);
                this.totalTimeLoadingAggregatesFromDB += loadTime;
            } else {
                this.numCellsFromRollups += (long)((int)definition.getCellCount());
                ++this.numAggregatesLoadedFromRollups;
            }
        }

        @Override
        public void aggregateLoadFailed(AggregateDefinition definition, boolean loadFromDB, Exception error) {
            AggregateLoadTaskInfo aggregateLoadTaskInfo = new AggregateLoadTaskInfo();
            aggregateLoadTaskInfo.setAggregateDefinition(definition);
            aggregateLoadTaskInfo.setAggregateName(definition.getName());
            aggregateLoadTaskInfo.setAggregateLoadExceptionInfo(new AggregateLoadExceptionInfo(error));
            AggregateLoadTask.this.aggregateLoadTaskInfos.add(aggregateLoadTaskInfo);
            ++this.numFailedAggregates;
        }
    }
}

