/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinitionGraphSubscriber;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.AggregateCalculationGraph;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.AggregateCalculationGraphSubscriber;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.LevelSetWithMeasures;
import com.cognos.xqe.trace.LogLevel;
import java.util.ArrayList;
import java.util.List;

public class AggregateRelationshipGraph {
    public static AggregateCalculationGraph buildGraph(ROLAPBaseCube cube, List<AggregateDefinition> loadedAggregates, List<AggregateDefinition> newAggregates) {
        AggregateCalculationGraph fullGraph = new AggregateCalculationGraph(cube, true);
        int numLoadedAggregates = 0;
        if (loadedAggregates != null) {
            numLoadedAggregates = loadedAggregates.size();
            AggregateRelationshipGraph.loadGraph(cube, fullGraph, loadedAggregates, true);
        }
        AggregateRelationshipGraph.loadGraph(cube, fullGraph, newAggregates, false);
        fullGraph.optimize();
        if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE)) {
            ROLAPLog.logTrace("ROLAPCubes.AggregateCache", "Initial aggregate graph is " + fullGraph.toString());
        }
        AggregateRelationshipGraph.removeLoadedNodesWithoutTargets(fullGraph);
        if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.INFO)) {
            ROLAPLog.log("ROLAPCubes.AggregateCache", "Loading of " + newAggregates.size() + " with " + numLoadedAggregates + " aggregates already loaded resulted in this graph: " + fullGraph);
        }
        return fullGraph;
    }

    private static boolean aggregateAlreadyLoaded(AggregateCalculationGraph.AGNode node) {
        for (AggregateCalculationGraphSubscriber subscriber : node.getSubscribers()) {
            if (((AggregateDefinitionGraphSubscriber)subscriber).isLoaded()) continue;
            return false;
        }
        return true;
    }

    private static void loadGraph(ROLAPBaseCube cube, AggregateCalculationGraph fullGraph, List<AggregateDefinition> aggregateDefinitions, boolean existingAggregates) {
        for (AggregateDefinition aggDef : aggregateDefinitions) {
            AggregateDefinitionGraphSubscriber adgs = new AggregateDefinitionGraphSubscriber(cube, existingAggregates, aggDef);
            ArrayList<AggregateDefinitionGraphSubscriber> definitions = new ArrayList<AggregateDefinitionGraphSubscriber>();
            definitions.add(adgs);
            LevelSetWithMeasures levelSet = new LevelSetWithMeasures(adgs.getLevelsAsSingleArray(), aggDef.getMeasures());
            fullGraph.insertNode(levelSet, definitions);
        }
    }

    private static List<AggregateDefinition> removeLoadedNodesWithoutTargets(AggregateCalculationGraph fullGraph) {
        ArrayList<AggregateDefinition> removedDefinitions = new ArrayList<AggregateDefinition>();
        boolean somethingRemoved = true;
        while (somethingRemoved) {
            somethingRemoved = false;
            for (AggregateCalculationGraph.AGNode node : fullGraph) {
                if (!AggregateRelationshipGraph.aggregateAlreadyLoaded(node) || node.getDependents().size() != 0) continue;
                fullGraph.removeNode(node);
                somethingRemoved = true;
                for (AggregateCalculationGraphSubscriber subscriber : node.getSubscribers()) {
                    removedDefinitions.add(((AggregateDefinitionGraphSubscriber)subscriber).getAggregateDefinition());
                }
            }
        }
        return removedDefinitions;
    }
}

