/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadTaskInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.model.ROLAPMetaInMemoryAggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPBaseDataCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AbstractAggregateLoadManagerCubeTask;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AggregateLoadTask;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AggregateLoadTaskResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.ROLAPAggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletMonitor;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;

public class AutonomicAggregateLoadManagerCubeTask
extends AbstractAggregateLoadManagerCubeTask {
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private static final String NEW_LINE = "\n";
    private static final XQELogger AGGREGATE_CACHE_LOGGER = ROLAPLog.getLogger("ROLAPCubes.AggregateCache");
    private static final XQELogger AUTOMATIC_AGGREGATE_OPTIMIZATION_LOGGER = ROLAPLog.getLogger("ROLAPCubes.AutomaticAggregateOptimization");
    private static final Locale LOG_MESSAGE_LOCALE = XQEMessages.getCurrProductLocale();
    private static final String FORMAT_D = "%,d";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm:ss a", LOG_MESSAGE_LOCALE);
    private List<AggregateDefinition> aggregateDefinitionsToRemove = new ArrayList<AggregateDefinition>();
    private List<AggregateDefinition> aggregateDefinitionsToAdd = new ArrayList<AggregateDefinition>();
    private List<AggregateDefinition> aggregateDefinitionsToRemoveAndAdd = new ArrayList<AggregateDefinition>();

    public AutonomicAggregateLoadManagerCubeTask(ROLAPBaseCube theCube) {
        super(theCube);
    }

    @Override
    protected void loadAggregates(ROLAPCubeReservation reservation) {
        ROLAPBaseDataCache dataCache = (ROLAPBaseDataCache)reservation.getDataCache();
        AggregateCubeletStorage aggregateCubeletStorage = dataCache.getAggregateStorage();
        if (aggregateCubeletStorage == null) {
            aggregateCubeletStorage = this.createAggregateCubeletStorage(dataCache);
        }
        int dataCacheID = dataCache.getID();
        try {
            AGGREGATE_CACHE_LOGGER.log(String.format("Loading the aggregates autonomically into data cache %d began.", dataCacheID));
            dataCache.setInMemoryAggregateLoadEndTime(0L);
            long loadStartTime = System.currentTimeMillis();
            dataCache.setInMemoryAggregateLoadStartTime(loadStartTime);
            this.updateCacheMetrics(dataCache);
            this.loadAggregateXMLFromContentStore();
            this.determineAggregatesToRemoveAndAdd(aggregateCubeletStorage);
            this.removeAggregates(dataCache);
            this.addAggregates(dataCache, reservation);
            this.updateCacheMetrics(dataCache);
            long loadEndTime = System.currentTimeMillis();
            dataCache.setInMemoryAggregateLoadEndTime(loadEndTime);
            this.logAggregateLoadManagerTaskInfo(loadStartTime, loadEndTime);
            AGGREGATE_CACHE_LOGGER.log(String.format("Loading the aggregates autonomically into data cache %d succeeded.", dataCacheID));
        }
        catch (Exception ex) {
            AGGREGATE_CACHE_LOGGER.log(LogLevel.ERROR, String.format("Loading the aggregates autonomically into data cache %d failed.", dataCacheID), (Throwable)ex);
            throw XQERuntimeException.wrap(ex);
        }
        finally {
            dataCache.setFinishedLoadingAggregates(true);
        }
    }

    private AggregateCubeletStorage createAggregateCubeletStorage(ROLAPBaseDataCache dataCache) {
        ArrayList<AggregateDefinition> aggregateDefinitions = new ArrayList<AggregateDefinition>();
        AggregateCubeletStorage aggregateCubeletStorage = AggregateCubeletStorage.createInstance(this.cube, aggregateDefinitions);
        dataCache.setAggregateStorage(aggregateCubeletStorage);
        return aggregateCubeletStorage;
    }

    private void loadAggregateXMLFromContentStore() throws Exception {
        AGGREGATE_CACHE_LOGGER.log("Loading the in-memory aggregate XML from the content store");
        ROLAPMetaInMemoryAggregate metaInMemoryAggregate = this.cube.loadInMemoryAggregateSchema();
        this.cube.setInMemoryAggregateModel(metaInMemoryAggregate);
    }

    private void determineAggregatesToRemoveAndAdd(AggregateCubeletStorage aggregateCubeletStorage) {
        List<AggregateDefinition> oldAggregateDefinitions = aggregateCubeletStorage.getAllAggregateDefinitions(false);
        List<AggregateDefinition> newAggregateDefinitions = ROLAPAggregateDefinition.load(this.cube);
        ROLAPAggregateDefinition.determineAggregateDefinitionsToRemoveAndAdd(oldAggregateDefinitions, newAggregateDefinitions, this.aggregateDefinitionsToRemove, this.aggregateDefinitionsToAdd);
        List<AggregateDefinition> loadedAggregateDefinitions = aggregateCubeletStorage.getAvailableAggregateDefinitions(false);
        this.aggregateDefinitionsToRemoveAndAdd.clear();
        this.aggregateDefinitionsToRemoveAndAdd.addAll(oldAggregateDefinitions);
        this.aggregateDefinitionsToRemoveAndAdd.removeAll(this.aggregateDefinitionsToRemove);
        this.aggregateDefinitionsToRemoveAndAdd.removeAll(loadedAggregateDefinitions);
        if (AGGREGATE_CACHE_LOGGER.isOn()) {
            AGGREGATE_CACHE_LOGGER.log(AutonomicAggregateLoadManagerCubeTask.formatAggregateDefinitions(String.format("Aggregates loaded in the aggregate cache (total = %d):", loadedAggregateDefinitions.size()), loadedAggregateDefinitions));
            AGGREGATE_CACHE_LOGGER.log(AutonomicAggregateLoadManagerCubeTask.formatAggregateDefinitions(String.format("Aggregates defined in the aggregate cache (total = %d):", oldAggregateDefinitions.size()), oldAggregateDefinitions));
            AGGREGATE_CACHE_LOGGER.log(AutonomicAggregateLoadManagerCubeTask.formatAggregateDefinitions(String.format("Aggregates defined in the content store (total = %d):", newAggregateDefinitions.size()), newAggregateDefinitions));
            AGGREGATE_CACHE_LOGGER.log(AutonomicAggregateLoadManagerCubeTask.formatAggregateDefinitions(String.format("Aggregates to remove from the aggregate cache (total = %d):", this.aggregateDefinitionsToRemove.size()), this.aggregateDefinitionsToRemove));
            AGGREGATE_CACHE_LOGGER.log(AutonomicAggregateLoadManagerCubeTask.formatAggregateDefinitions(String.format("Aggregates to add to the aggregate cache (total = %d):", this.aggregateDefinitionsToAdd.size()), this.aggregateDefinitionsToAdd));
            AGGREGATE_CACHE_LOGGER.log(AutonomicAggregateLoadManagerCubeTask.formatAggregateDefinitions(String.format("Aggregates to remove from and add to the aggregate cache (total = %d):", this.aggregateDefinitionsToRemoveAndAdd.size()), this.aggregateDefinitionsToRemoveAndAdd));
        }
        if (AUTOMATIC_AGGREGATE_OPTIMIZATION_LOGGER.isOn()) {
            int aggregateDefinitionsToRemoveCount = this.aggregateDefinitionsToRemove.size() + this.aggregateDefinitionsToRemoveAndAdd.size();
            int aggregateDefinitionsToAddCount = this.aggregateDefinitionsToAdd.size() + this.aggregateDefinitionsToRemoveAndAdd.size();
            AUTOMATIC_AGGREGATE_OPTIMIZATION_LOGGER.log(XQEMessages.getMessage(XQEMessageKeys.RAO_AdvisorRecommendedRemovingAndAddingAggregates, LOG_MESSAGE_LOCALE, String.format(LOG_MESSAGE_LOCALE, FORMAT_D, aggregateDefinitionsToRemoveCount), String.format(LOG_MESSAGE_LOCALE, FORMAT_D, aggregateDefinitionsToAddCount)));
        }
    }

    private void removeAggregates(ROLAPBaseDataCache dataCache) {
        ArrayList<AggregateDefinition> aggregateDefinitions = new ArrayList<AggregateDefinition>();
        aggregateDefinitions.addAll(this.aggregateDefinitionsToRemove);
        aggregateDefinitions.addAll(this.aggregateDefinitionsToRemoveAndAdd);
        if (aggregateDefinitions.isEmpty()) {
            AGGREGATE_CACHE_LOGGER.log("Skipping the removing of aggregates from the aggregate cache because there are no aggregates to remove");
            return;
        }
        AutonomicAggregateLoadManagerCubeTask.logAggregates(aggregateDefinitions, XQEMessageKeys.RAO_AdvisorRecommendedRemovingAggregates);
        int aggregateDefinitionCount = aggregateDefinitions.size();
        AGGREGATE_CACHE_LOGGER.log(String.format("Removing %d aggregates from the aggregate cache", aggregateDefinitionCount));
        AutonomicAggregateLoadManagerCubeTask.logCacheMetrics(dataCache);
        AggregateCubeletStorage aggregateCubeletStorage = dataCache.getAggregateStorage();
        for (AggregateDefinition aggregateDefinition : aggregateDefinitions) {
            String aggregateName = aggregateDefinition.getName();
            IMember[] measures = aggregateDefinition.getMeasures();
            String measureNamesString = AutonomicAggregateLoadManagerCubeTask.getMeasureNamesString(measures);
            long startTime = System.currentTimeMillis();
            String startTimeString = this.dateFormat.format(new Date(startTime));
            long aggregateCacheSizeBefore = aggregateCubeletStorage.getSize();
            AGGREGATE_CACHE_LOGGER.log(String.format("Removing an aggregate from the aggregate cache: name = \"%s\", measures = %s", aggregateName, measureNamesString));
            boolean isAggregateLoaded = aggregateCubeletStorage.isAggregateLoaded(aggregateDefinition);
            if (isAggregateLoaded) {
                dataCache.decrementLoadedInMemoryAggregateCount(1L);
                aggregateCubeletStorage.removeLoadedAggregateDefinition(aggregateDefinition);
                aggregateCubeletStorage.removeCubelet(aggregateName);
            }
            dataCache.decrementDefinedInMemoryAggregateCount(1L);
            aggregateCubeletStorage.removeDefinedAggregateDefinition(aggregateDefinition);
            long aggregateCacheSizeAfter = aggregateCubeletStorage.getSize();
            long aggregateSize = aggregateCacheSizeBefore - aggregateCacheSizeAfter;
            String aggregateSizeString = String.format(LOG_MESSAGE_LOCALE, FORMAT_D, aggregateSize);
            AUTOMATIC_AGGREGATE_OPTIMIZATION_LOGGER.log(XQEMessages.getMessage(XQEMessageKeys.RAO_ServerRemovedAggregate, LOG_MESSAGE_LOCALE, aggregateName, measureNamesString, aggregateSizeString, startTimeString));
            AGGREGATE_CACHE_LOGGER.log(String.format("Removed an aggregate from the aggregate cache: name = \"%s\", measures = %s, aggregate was loaded = %s, aggregate size = %d bytes", aggregateName, measureNamesString, isAggregateLoaded, aggregateSize));
            AutonomicAggregateLoadManagerCubeTask.logCacheMetrics(dataCache);
        }
        AGGREGATE_CACHE_LOGGER.log(String.format("The total aggregate cache size after removing aggregates from the aggregate cache is %,d bytes.", aggregateCubeletStorage.getSize()));
    }

    private void addAggregates(ROLAPBaseDataCache dataCache, ROLAPCubeReservation reservation) {
        ArrayList<AggregateDefinition> aggregateDefinitions = new ArrayList<AggregateDefinition>();
        aggregateDefinitions.addAll(this.aggregateDefinitionsToAdd);
        aggregateDefinitions.addAll(this.aggregateDefinitionsToRemoveAndAdd);
        if (aggregateDefinitions.isEmpty()) {
            AGGREGATE_CACHE_LOGGER.log("Skipping the adding of aggregates to the aggregate cache because there are no aggregates to add");
            return;
        }
        AutonomicAggregateLoadManagerCubeTask.logAggregates(aggregateDefinitions, XQEMessageKeys.RAO_AdvisorRecommendedAddingAggregates);
        int aggregateDefinitionCount = aggregateDefinitions.size();
        AGGREGATE_CACHE_LOGGER.log(String.format("Adding %d aggregates to the aggregate cache", aggregateDefinitionCount));
        AutonomicAggregateLoadManagerCubeTask.logCacheMetrics(dataCache);
        AggregateCubeletStorage aggregateCubeletStorage = dataCache.getAggregateStorage();
        aggregateCubeletStorage.addDefinedAggregateDefinitions(aggregateDefinitions);
        dataCache.incrementDefinedInMemoryAggregateCount(aggregateDefinitionCount);
        List<AggregateLoadTask> aggregateLoadTasks = this.createLoadTasks(aggregateCubeletStorage, aggregateDefinitions, reservation);
        List<Callable<AggregateLoadTaskResult>> loadTasks = this.decorateLoadTasks(aggregateLoadTasks);
        int loadTaskCount = loadTasks.size();
        AGGREGATE_CACHE_LOGGER.log(String.format("Created %d tasks to add aggregates to the aggregate cache", loadTaskCount));
        AutonomicAggregateLoadManagerCubeTask.logCacheMetrics(dataCache);
        int loadTaskFailureCount = 0;
        for (int loadTaskIndex = 0; loadTaskIndex < loadTaskCount; ++loadTaskIndex) {
            Callable<AggregateLoadTaskResult> loadTask = loadTasks.get(loadTaskIndex);
            AggregateDefinition aggregateDefinition = (AggregateDefinition)aggregateDefinitions.get(loadTaskIndex);
            String aggregateName = aggregateDefinition.getName();
            IMember[] measures = aggregateDefinition.getMeasures();
            String measureNamesString = AutonomicAggregateLoadManagerCubeTask.getMeasureNamesString(measures);
            try {
                long startTime = System.currentTimeMillis();
                long aggregateCacheSizeBefore = aggregateCubeletStorage.getSize();
                AGGREGATE_CACHE_LOGGER.log(String.format("Adding an aggregate to the aggregate cache: name = \"%s\", measures = %s", aggregateName, measureNamesString));
                loadTask.call();
                long aggregateCacheSizeAfter = aggregateCubeletStorage.getSize();
                long aggregateSize = aggregateCacheSizeAfter - aggregateCacheSizeBefore;
                String aggregateSizeString = String.format(LOG_MESSAGE_LOCALE, FORMAT_D, aggregateSize);
                long endTime = System.currentTimeMillis();
                String endTimeString = this.dateFormat.format(new Date(endTime));
                long elapsedTime = (endTime - startTime) / 1000L;
                String elapsedTimeString = String.format(LOG_MESSAGE_LOCALE, FORMAT_D, elapsedTime);
                AUTOMATIC_AGGREGATE_OPTIMIZATION_LOGGER.log(XQEMessages.getMessage(XQEMessageKeys.RAO_ServerAddedAggregate, LOG_MESSAGE_LOCALE, aggregateName, measureNamesString, aggregateSizeString, endTimeString, elapsedTimeString));
                AGGREGATE_CACHE_LOGGER.log(String.format("Added an aggregate to the aggregate cache: name = \"%s\", measures = %s, aggregate size = %d bytes, elapsed time = %d ms", aggregateName, measureNamesString, aggregateSize, endTime - startTime));
            }
            catch (OperationCanceledException ex) {
                throw ex;
            }
            catch (Exception ex) {
                AUTOMATIC_AGGREGATE_OPTIMIZATION_LOGGER.log(XQEMessages.getMessage(XQEMessageKeys.RAO_ServerFailedToAddAggregate, LOG_MESSAGE_LOCALE, aggregateName, measureNamesString), (Throwable)ex);
                AGGREGATE_CACHE_LOGGER.log(LogLevel.ERROR, String.format("The task \"%s\" adding the aggregate at index %d to the aggregate cache failed.", loadTask, loadTaskIndex), (Throwable)ex);
                ++loadTaskFailureCount;
            }
            AutonomicAggregateLoadManagerCubeTask.logCacheMetrics(dataCache);
            AggregateLoadTask aggregateLoadTask = aggregateLoadTasks.get(loadTaskIndex);
            List<AggregateLoadTaskInfo> aggregateLoadTaskInfo = aggregateLoadTask.getAggregateLoadTaskInfo();
            this.aggregateLoadManagerTaskInfo.addAggregateLoadTaskInfo(aggregateLoadTaskInfo);
        }
        AGGREGATE_CACHE_LOGGER.log(String.format("Finished executing %d tasks to add aggregates to the aggregate cache (%d succeeded, %d failed)", loadTaskCount, loadTaskCount - loadTaskFailureCount, loadTaskFailureCount));
        AGGREGATE_CACHE_LOGGER.log(String.format("The total aggregate cache size after adding aggregates to the aggregate cache is %,d bytes.", aggregateCubeletStorage.getSize()));
    }

    @Override
    protected void logAggregateLoadManagerTaskInfo() throws Exception {
        if (this.aggregateDefinitionsToRemove.isEmpty() && this.aggregateDefinitionsToAdd.isEmpty() && this.aggregateDefinitionsToRemoveAndAdd.isEmpty()) {
            return;
        }
        ArrayList<AggregateDefinition> aggregateDefinitions = new ArrayList<AggregateDefinition>();
        aggregateDefinitions.addAll(this.aggregateDefinitionsToRemove);
        aggregateDefinitions.addAll(this.aggregateDefinitionsToRemoveAndAdd);
        this.cube.getAggregateLoadInfoLogger().logSubsequentLoad(this.aggregateLoadManagerTaskInfo, aggregateDefinitions);
    }

    private void updateCacheMetrics(ROLAPBaseDataCache dataCache) {
        long loadedAggregateDefinitionCount;
        long loadedInMemoryAggregateCount;
        AGGREGATE_CACHE_LOGGER.log("Updating inconsistent data cache and aggregate cache metrics began");
        AutonomicAggregateLoadManagerCubeTask.logCacheMetrics(dataCache);
        AggregateCubeletStorage aggregateCubeletStorage = dataCache.getAggregateStorage();
        long definedInMemoryAggregateCount = dataCache.getDefinedInMemoryAggregateCount();
        long definedAggregateDefinitionCount = aggregateCubeletStorage.getAllAggregateDefinitions(false).size();
        if (definedInMemoryAggregateCount != definedAggregateDefinitionCount) {
            dataCache.setDefinedInMemoryAggregateCount(definedAggregateDefinitionCount);
            AGGREGATE_CACHE_LOGGER.log(String.format("Updated the defined in-memory aggregate count in the data cache to the defined aggregate definition count in the aggregate cache (%d -> %d)", definedInMemoryAggregateCount, definedAggregateDefinitionCount));
        }
        if ((loadedInMemoryAggregateCount = dataCache.getLoadedInMemoryAggregateCount()) != (loadedAggregateDefinitionCount = (long)aggregateCubeletStorage.getAvailableAggregateDefinitions(false).size())) {
            dataCache.setLoadedInMemoryAggregateCount(loadedAggregateDefinitionCount);
            AGGREGATE_CACHE_LOGGER.log(String.format("Updated the loaded in-memory aggregate count in the data cache to the loaded aggregate definition count in the aggregate cache (%d -> %d)", loadedInMemoryAggregateCount, loadedAggregateDefinitionCount));
        }
        AutonomicAggregateLoadManagerCubeTask.logCacheMetrics(dataCache);
        AGGREGATE_CACHE_LOGGER.log("Updating inconsistent data cache and aggregate cache metrics ended");
    }

    private static void logCacheMetrics(ROLAPBaseDataCache dataCache) {
        if (!AGGREGATE_CACHE_LOGGER.isOn(LogLevel.TRACE)) {
            return;
        }
        AggregateCubeletStorage aggregateCubeletStorage = dataCache.getAggregateStorage();
        AggregateCubeletMonitor aggregateCubeletMonitor = (AggregateCubeletMonitor)aggregateCubeletStorage.getCubeletMonitor();
        AGGREGATE_CACHE_LOGGER.log(LogLevel.TRACE, String.format("Defined in-memory aggregate count = %d, loaded in-memory aggregate count = %d, defined aggregate definition count = %d, loaded aggregate definition count = %d, aggregate cache size = %d, aggregate cubelet monitor total memory = %d", dataCache.getDefinedInMemoryAggregateCount(), dataCache.getLoadedInMemoryAggregateCount(), aggregateCubeletStorage.getAllAggregateDefinitions(false).size(), aggregateCubeletStorage.getAvailableAggregateDefinitions(false).size(), aggregateCubeletStorage.getSize(), aggregateCubeletMonitor.getTotalMemory()));
    }

    private static void logAggregates(List<AggregateDefinition> aggregateDefinitions, IMessageKey.Param0 headerMessageKey) {
        if (!AUTOMATIC_AGGREGATE_OPTIMIZATION_LOGGER.isOn()) {
            return;
        }
        String headerMessage = XQEMessages.getMessage(headerMessageKey, LOG_MESSAGE_LOCALE);
        String logMessage = AutonomicAggregateLoadManagerCubeTask.formatAggregateDefinitions(headerMessage, aggregateDefinitions);
        AUTOMATIC_AGGREGATE_OPTIMIZATION_LOGGER.log(logMessage);
    }

    private static String formatAggregateDefinitions(String headerMessage, List<AggregateDefinition> aggregateDefinitions) {
        StringBuilder sb = new StringBuilder();
        sb.append(NEW_LINE);
        sb.append(headerMessage);
        sb.append(NEW_LINE);
        int nameColumnWidth = AutonomicAggregateLoadManagerCubeTask.getLengthOfLongestAggregateName(aggregateDefinitions);
        String format = "%-" + nameColumnWidth + "s %s\n";
        AggregateDefinition[] aggregateDefinitionArray = new AggregateDefinition[aggregateDefinitions.size()];
        aggregateDefinitionArray = aggregateDefinitions.toArray(aggregateDefinitionArray);
        Arrays.sort(aggregateDefinitionArray, new AggregateDefinitionComparator());
        aggregateDefinitions = Arrays.asList(aggregateDefinitionArray);
        for (AggregateDefinition aggregateDefinition : aggregateDefinitions) {
            String aggregateName = aggregateDefinition.getName();
            IMember[] measures = aggregateDefinition.getMeasures();
            String measureNamesString = AutonomicAggregateLoadManagerCubeTask.getMeasureNamesString(measures);
            sb.append(String.format(format, aggregateName, measureNamesString));
        }
        return sb.toString();
    }

    private static int getLengthOfLongestAggregateName(List<AggregateDefinition> aggregateDefinitions) {
        int maxLength = 0;
        for (AggregateDefinition aggregateDefinition : aggregateDefinitions) {
            String aggregateName = aggregateDefinition.getName();
            int aggregateNameLength = aggregateName.length();
            if (aggregateNameLength <= maxLength) continue;
            maxLength = aggregateNameLength;
        }
        return maxLength;
    }

    private static String getMeasureNamesString(IMember[] measures) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (measures != null) {
            int measureCount = measures.length;
            for (int i = 0; i < measureCount; ++i) {
                IMember measure = measures[i];
                String measureName = measure.getName();
                sb.append(measureName);
                if (i + 1 >= measureCount) continue;
                sb.append(", ");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private static class AggregateDefinitionComparator
    implements Comparator<AggregateDefinition> {
        private AggregateDefinitionComparator() {
        }

        @Override
        public int compare(AggregateDefinition aggregateDefinition1, AggregateDefinition aggregateDefinition2) {
            String aggregateName1 = aggregateDefinition1.getName();
            String aggregateName2 = aggregateDefinition2.getName();
            return aggregateName1.compareTo(aggregateName2);
        }
    }
}

