/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.model.ROLAPMetaInMemoryAggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletStorage;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.xml.Document;
import com.cognos.xqe.util.xml.Node;
import com.cognos.xqe.util.xml.NodeList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ROLAPAggregateDefinition
implements AggregateDefinition {
    private static final String COMMA_DELIMITER = ", ";
    private String name = null;
    private List<ILevel> levels = null;
    private IMember[] measures = null;
    private long cellCount = 0L;
    private int baseIncrementId = 0;
    private CubeletStorage storageLocation = null;

    public ROLAPAggregateDefinition(String aName, List<ILevel> theLevels, IMember[] theMeasures) {
        this.name = aName;
        this.levels = theLevels;
        this.measures = theMeasures;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<ILevel> getLevels() {
        return this.levels;
    }

    @Override
    public IMember[] getMeasures() {
        return this.measures;
    }

    @Override
    public long getCellCount() {
        return this.cellCount;
    }

    public void setCellCount(long theCellCount) {
        this.cellCount = theCellCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(UniqueNameGenerator.createUniqueName(this.name));
        sb.append(":{");
        boolean needComma = false;
        for (ILevel l : this.levels) {
            if (needComma) {
                sb.append(COMMA_DELIMITER);
            }
            sb.append(l.getUniqueName());
            needComma = true;
        }
        for (IMember m : this.measures) {
            sb.append(COMMA_DELIMITER);
            sb.append(m.getUniqueName());
        }
        sb.append('}');
        return sb.toString();
    }

    public static List<AggregateDefinition> load(ROLAPCube cube) {
        ROLAPMetaInMemoryAggregate model;
        ArrayList<AggregateDefinition> aggregateDefinitions = new ArrayList<AggregateDefinition>();
        if (cube instanceof ROLAPBaseCube && (model = ((ROLAPBaseCube)cube).getInMemoryAggregateModel()) != null) {
            aggregateDefinitions.addAll(ROLAPAggregateDefinition.load(cube, model));
        }
        return aggregateDefinitions;
    }

    public static List<AggregateDefinition> load(ROLAPCube cube, ROLAPMetaInMemoryAggregate model) {
        ArrayList<AggregateDefinition> aggregates = new ArrayList<AggregateDefinition>();
        Document doc = model.getDocument();
        NodeList levelRefNodes = doc.getElementsByTagName("levelRef");
        NodeList allLevelRefNodes = doc.getElementsByTagName("allLevel");
        NodeList rootLevelNodes = doc.getElementsByTagName("rootLevel");
        NodeList allAggregateNodes = doc.getElementsByTagName("aggregate");
        NodeList allMeasureRefNodes = doc.getElementsByTagName("measureRef");
        for (int i = 0; i < allAggregateNodes.getLength(); ++i) {
            Object allLevelRefNode2;
            ILevel level;
            Node aggregateNode = allAggregateNodes.item(i);
            String aggregateName = aggregateNode.getAttribute("name");
            List<Node> levelRefNodesForThisAggregate = ROLAPAggregateDefinition.getNodesWithParent(aggregateNode, levelRefNodes);
            ArrayList<ILevel> levels = new ArrayList<ILevel>();
            for (Node node : levelRefNodesForThisAggregate) {
                String string;
                Node hierarchyRefNode = node.getParentNode();
                Node node2 = hierarchyRefNode.getParentNode();
                String hierName = hierarchyRefNode.getAttribute("name");
                String dimName = node2.getAttribute("name");
                level = ROLAPAggregateDefinition.findLevel(cube, dimName, hierName, string = node.getAttribute("name"));
                if (level != null) {
                    levels.add(level);
                    continue;
                }
                throw new XQERuntimeException(XQEMessageKeys.ROL_InMemoryAggregateDefinition_InvalidLevel, (Object)UniqueNameGenerator.createUniqueName(aggregateName), (Object)UniqueNameGenerator.createUniqueName(cube.getName()), (Object)UniqueNameGenerator.createUniqueName(dimName, hierName, string));
            }
            List<Node> allLevelRefNodesForThisAggregate = ROLAPAggregateDefinition.getNodesWithParent(aggregateNode, allLevelRefNodes);
            for (Object allLevelRefNode2 : allLevelRefNodesForThisAggregate) {
                Node node = ((Node)allLevelRefNode2).getParentNode();
                Node dimensionRefNode = node.getParentNode();
                String hierName = node.getAttribute("name");
                String string = dimensionRefNode.getAttribute("name");
                level = ROLAPAggregateDefinition.findAllLevel(cube, string, hierName);
                if (level != null) {
                    levels.add(level);
                    continue;
                }
                throw new XQERuntimeException(XQEMessageKeys.ROL_InMemoryAggregateDefinition_InvalidAllLevel, (Object)UniqueNameGenerator.createUniqueName(aggregateName), (Object)UniqueNameGenerator.createUniqueName(cube.getName()), (Object)UniqueNameGenerator.createUniqueName(string, hierName));
            }
            List<Node> list = ROLAPAggregateDefinition.getNodesWithParent(aggregateNode, rootLevelNodes);
            allLevelRefNode2 = list.iterator();
            while (allLevelRefNode2.hasNext()) {
                Node node = (Node)allLevelRefNode2.next();
                Node hierarchyRefNode = node.getParentNode();
                Node dimensionRefNode = hierarchyRefNode.getParentNode();
                String string = hierarchyRefNode.getAttribute("name");
                String dimName = dimensionRefNode.getAttribute("name");
                ILevel level2 = ROLAPAggregateDefinition.findRootLevel(cube, dimName, string);
                if (level2 != null) {
                    levels.add(level2);
                    continue;
                }
                throw new XQERuntimeException(XQEMessageKeys.ROL_InMemoryAggregateDefinition_InvalidRootLevel, (Object)UniqueNameGenerator.createUniqueName(aggregateName), (Object)UniqueNameGenerator.createUniqueName(cube.getName()), (Object)UniqueNameGenerator.createUniqueName(dimName, string));
            }
            HashSet<IHierarchy> allHiers = new HashSet<IHierarchy>();
            allHiers.addAll(cube.getHierarchies());
            for (IHierarchy h : allHiers) {
                if (h.getDimension().getType() != DimensionTypeEnum.INTERNAL) continue;
                levels.add(h.getLevel(0));
            }
            ArrayList<IMember> arrayList = new ArrayList<IMember>();
            List<Node> allMeasureRefNodesForThisAggregate = ROLAPAggregateDefinition.getNodesWithParent(aggregateNode, allMeasureRefNodes);
            for (Node node : allMeasureRefNodesForThisAggregate) {
                String measureName = node.getAttribute("name");
                IMember measure = cube.getMeasure(measureName);
                if (measure != null) {
                    if (!measure.isCalculatedMember()) {
                        arrayList.add(measure);
                        continue;
                    }
                    throw new XQERuntimeException(XQEMessageKeys.ROL_InMemoryAggregateDefinition_InvalidCalculatedMeasure, (Object)UniqueNameGenerator.createUniqueName(aggregateName), (Object)UniqueNameGenerator.createUniqueName(cube.getName()), (Object)UniqueNameGenerator.createUniqueName(measureName));
                }
                throw new XQERuntimeException(XQEMessageKeys.ROL_InMemoryAggregateDefinition_InvalidMeasure, (Object)UniqueNameGenerator.createUniqueName(aggregateName), (Object)UniqueNameGenerator.createUniqueName(cube.getName()), (Object)UniqueNameGenerator.createUniqueName(measureName));
            }
            IMember[] measuresArray = arrayList.toArray(new IMember[arrayList.size()]);
            for (ILevel l : levels) {
                IHierarchy levelHier = l.getHierarchy();
                if (allHiers.remove(levelHier)) continue;
                throw new XQERuntimeException(XQEMessageKeys.ROL_InMemoryAggregateDefinition_HierarchyReferencedTwice, (Object)UniqueNameGenerator.createUniqueName(aggregateName), (Object)UniqueNameGenerator.createUniqueName(cube.getName()), (Object)levelHier.getUniqueName());
            }
            for (IHierarchy h : allHiers) {
                if (h.getDimension().isMeasuresDimension()) continue;
                throw new XQERuntimeException(XQEMessageKeys.ROL_InMemoryAggregateDefinition_MissingHierarchy, (Object)UniqueNameGenerator.createUniqueName(aggregateName), (Object)UniqueNameGenerator.createUniqueName(cube.getName()), (Object)h.getUniqueName());
            }
            ROLAPAggregateDefinition rOLAPAggregateDefinition = new ROLAPAggregateDefinition(aggregateName, levels, measuresArray);
            aggregates.add(rOLAPAggregateDefinition);
        }
        return aggregates;
    }

    private static ILevel findAllLevel(ROLAPCube cube, String dimName, String hierName) {
        ROLAPLevel rolapLevel;
        ILevel level = ROLAPAggregateDefinition.findLevel(cube, dimName, hierName, null);
        if (level != null && level instanceof ROLAPLevel && !(rolapLevel = (ROLAPLevel)level).isAllLevel()) {
            level = null;
        }
        return level;
    }

    private static ILevel findRootLevel(ROLAPCube cube, String dimName, String hierName) {
        ROLAPLevel rolapLevel;
        ILevel level = ROLAPAggregateDefinition.findLevel(cube, dimName, hierName, null);
        if (level != null && level instanceof ROLAPLevel && !(rolapLevel = (ROLAPLevel)level).isRootLevel()) {
            level = null;
        }
        return level;
    }

    private static ILevel findLevel(ROLAPCube cube, String dimName, String hierName, String levelName) {
        ILevel level = null;
        IDimension dim = cube.getDimension(dimName);
        if (dim != null) {
            IHierarchy hier;
            if (cube.isCubingServicesCompatible()) {
                ROLAPMetaHierarchy defaultHierarchy;
                ROLAPMetaCube modelCube = cube.getModelCube();
                ROLAPMetaDimension metaDimension = null;
                for (ROLAPMetaDimension d : modelCube.getDimensions()) {
                    if (!dimName.equals(d.getName())) continue;
                    metaDimension = d;
                    break;
                }
                if (metaDimension != null && hierName.equals((defaultHierarchy = modelCube.getDefaultHierarchy(metaDimension)).getName())) {
                    hierName = dimName;
                }
            }
            if ((hier = dim.getHierarchy(hierName)) != null) {
                level = levelName == null ? hier.getLevel(0) : hier.getLevel(levelName);
            }
        }
        return level;
    }

    private static List<Node> getNodesWithParent(Node parentNode, NodeList nodes) {
        ArrayList<Node> sameParentNodes = new ArrayList<Node>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!n.isAParent(parentNode)) continue;
            sameParentNodes.add(n);
        }
        return sameParentNodes;
    }

    @Override
    public int getBaseIncrementId() {
        return this.baseIncrementId;
    }

    public void setBaseIncrementId(int theBaseIncrementId) {
        this.baseIncrementId = theBaseIncrementId;
    }

    public static void determineAggregateDefinitionsToRemoveAndAdd(List<AggregateDefinition> oldAggregateDefinitions, List<AggregateDefinition> newAggregateDefinitions, List<AggregateDefinition> aggregateDefinitionsToRemove, List<AggregateDefinition> aggregateDefinitionsToAdd) {
        ArrayList<AggregateDefinition> oldAggregateDefinitionsToIgnore = new ArrayList<AggregateDefinition>();
        ArrayList<AggregateDefinition> newAggregateDefinitionsToIgnore = new ArrayList<AggregateDefinition>();
        block0: for (AggregateDefinition oldAggregateDefinition : oldAggregateDefinitions) {
            ROLAPAggregateDefinition oldROLAPAggregateDefinition = (ROLAPAggregateDefinition)oldAggregateDefinition;
            for (AggregateDefinition newAggregateDefinition : newAggregateDefinitions) {
                ROLAPAggregateDefinition newROLAPAggregateDefinition;
                if (newAggregateDefinitionsToIgnore.contains(newAggregateDefinition) || !oldROLAPAggregateDefinition.isSame(newROLAPAggregateDefinition = (ROLAPAggregateDefinition)newAggregateDefinition)) continue;
                oldAggregateDefinitionsToIgnore.add(oldAggregateDefinition);
                newAggregateDefinitionsToIgnore.add(newAggregateDefinition);
                continue block0;
            }
        }
        aggregateDefinitionsToRemove.clear();
        aggregateDefinitionsToRemove.addAll(oldAggregateDefinitions);
        aggregateDefinitionsToRemove.removeAll(oldAggregateDefinitionsToIgnore);
        aggregateDefinitionsToAdd.clear();
        aggregateDefinitionsToAdd.addAll(newAggregateDefinitions);
        aggregateDefinitionsToAdd.removeAll(newAggregateDefinitionsToIgnore);
    }

    public boolean isSame(ROLAPAggregateDefinition aggregateDefinition) {
        return this.hasSameMeasures(aggregateDefinition) && this.hasSameLevels(aggregateDefinition);
    }

    private boolean hasSameMeasures(ROLAPAggregateDefinition aggregateDefinition) {
        IMember[] measures2;
        IMember[] measures1 = this.getMeasures();
        if (measures1.length != (measures2 = aggregateDefinition.getMeasures()).length) {
            return false;
        }
        for (int i = 0; i < measures2.length; ++i) {
            IMember measure = measures2[i];
            if (this.hasMeasure(measure)) continue;
            return false;
        }
        return true;
    }

    private boolean hasMeasure(IMember measure) {
        String measureUniqueNameToFind = measure.getUniqueName();
        for (int i = 0; i < this.measures.length; ++i) {
            String measureUniqueName = this.measures[i].getUniqueName();
            if (!measureUniqueName.equals(measureUniqueNameToFind)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSameLevels(ROLAPAggregateDefinition aggregateDefinition) {
        List<ILevel> levels1 = this.getLevels();
        List<ILevel> levels2 = aggregateDefinition.getLevels();
        if (levels1.size() != levels2.size()) {
            return false;
        }
        for (ILevel level : levels2) {
            if (this.hasLevel(level)) continue;
            return false;
        }
        return true;
    }

    private boolean hasLevel(ILevel level) {
        String levelUniqueNameToFind = level.getUniqueName();
        for (ILevel lvl : this.levels) {
            String levelUniqueName = lvl.getUniqueName();
            if (!levelUniqueName.equals(levelUniqueNameToFind)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CubeletStorage getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(CubeletStorage theStorageLocation) {
        this.storageLocation = theStorageLocation;
    }

    @Override
    public boolean canBeEvicted() {
        return false;
    }
}

