/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.model;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAbstractHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPRelativeTimeMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateLevelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateSlice;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public class ROLAPMetaAggregateHierarchyRef
extends ROLAPMetaObject {
    private LinkedHashMap<String, ROLAPMetaAggregateLevelRef> aggregateLevelRefs = null;
    private ROLAPMetaAggregateLevelRef lowestLevel = null;
    private ROLAPMetaAggregateSlice aggregateSlice = null;
    private static final String MEMBER_LEVEL = "Member_Level";
    private ILevel aggregateSliceLevel = null;

    @Override
    public void captureContents() {
        super.captureContents();
        this.getAggregateLevelRefs();
        this.clearDOMNode();
    }

    public ROLAPMetaAggregateLevelRef[] getAggregateLevelRefs() {
        if (this.aggregateLevelRefs == null) {
            this.aggregateLevelRefs = new LinkedHashMap();
            int ct = this.getChildCount();
            for (int i = 0; i < ct; ++i) {
                ROLAPMetaObject obj = this.getChild(i);
                if (!(obj instanceof ROLAPMetaAggregateLevelRef)) continue;
                ROLAPMetaAggregateLevelRef aggregateLevelRef = (ROLAPMetaAggregateLevelRef)obj;
                this.aggregateLevelRefs.put(aggregateLevelRef.getName(), aggregateLevelRef);
                this.lowestLevel = aggregateLevelRef;
            }
        }
        return this.aggregateLevelRefs.values().toArray(new ROLAPMetaAggregateLevelRef[0]);
    }

    public ROLAPMetaAggregateLevelRef getLowestAggregateLevelRef() {
        return this.lowestLevel;
    }

    public ROLAPMetaAggregateLevelRef getAggregateLevel(ROLAPLevel level) {
        if (this.aggregateLevelRefs == null) {
            return null;
        }
        if (level.getHierarchy().isParentChild()) {
            ROLAPMetaAggregateMember aggregateMember;
            IMember member;
            if (this.getAggregateSlice() != null && (member = level.getMember((aggregateMember = this.getAggregateSlice().getAggregateMembers().get(0)).getName())) == null) {
                return null;
            }
            Object[] metaAggrLevelRefs = this.aggregateLevelRefs.values().toArray();
            for (int i = 0; i < metaAggrLevelRefs.length; ++i) {
                ROLAPMetaAggregateLevelRef metaAggrLevelRef = (ROLAPMetaAggregateLevelRef)metaAggrLevelRefs[i];
                if (!metaAggrLevelRef.getName().equals(MEMBER_LEVEL)) continue;
                return metaAggrLevelRef;
            }
            return null;
        }
        return this.aggregateLevelRefs.get(level.getName());
    }

    public boolean isLowestAggregateLevel(ROLAPLevel level) {
        if (this.lowestLevel != null) {
            return level.getName().equals(this.lowestLevel.getName());
        }
        return false;
    }

    public ROLAPMetaAggregateSlice getAggregateSlice() {
        if (this.aggregateSlice == null) {
            int ct = this.getChildCount();
            for (int i = 0; i < ct; ++i) {
                ROLAPMetaObject obj = this.getChild(i);
                if (!(obj instanceof ROLAPMetaAggregateSlice)) continue;
                this.aggregateSlice = (ROLAPMetaAggregateSlice)obj;
            }
        }
        return this.aggregateSlice;
    }

    public ILevel getAggregateSliceLevel(IHierarchy hierarchy) {
        block6: {
            if (this.getAggregateSlice() == null || this.aggregateSliceLevel != null) break block6;
            ROLAPMetaAggregateMember aggregateMember = this.getAggregateSlice().getAggregateMembers().get(0);
            if (hierarchy.isParentChild()) {
                for (ILevel level : hierarchy.getLevels()) {
                    IMember member = level.getMember(aggregateMember.getName());
                    if (member == null || !aggregateMember.getName().equals(member.getUniqueName())) continue;
                    this.aggregateSliceLevel = level;
                    break;
                }
            } else {
                for (ROLAPMetaAggregateLevelRef aggrLevel : this.getAggregateLevelRefs()) {
                    ILevel level = hierarchy.getLevel(aggrLevel.getName());
                    IMember member = level.getMember(aggregateMember.getName());
                    if (member == null && hierarchy.getDimension().isTimeDimension()) {
                        String cubeName = hierarchy.getDimension().getCube().getName();
                        List<ROLAPCalculatedMember> calcMembers = ((ROLAPAbstractHierarchy)hierarchy).getROLAPCalculatedMembers(cubeName);
                        for (IMember iMember : calcMembers) {
                            if (!(iMember instanceof ROLAPRelativeTimeMember) || iMember.isExtendedCalculatedMemberWithFormula() || !iMember.getUniqueName().equals(aggregateMember.getName()) || level != iMember.getLevel()) continue;
                            member = iMember;
                            break;
                        }
                    }
                    if (member == null || !aggregateMember.getName().equals(member.getUniqueName())) continue;
                    this.aggregateSliceLevel = level;
                    break;
                }
            }
        }
        return this.aggregateSliceLevel;
    }

    public HashSet<IMember> getAggregateSliceMemberObjects(IHierarchy hierarchy) {
        HashSet<IMember> sliceMembers = new HashSet<IMember>();
        ILevel sliceLevel = this.getAggregateSliceLevel(hierarchy);
        for (ROLAPMetaAggregateMember sliceMember : this.getAggregateSlice().getAggregateMembers()) {
            IMember aggrMember = sliceLevel.getMember(sliceMember.getName());
            if (aggrMember == null) continue;
            sliceMembers.add(aggrMember);
        }
        return sliceMembers;
    }
}

