/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.model;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCaption;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCubeModel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDefaultHierarchyRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDescription;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimensionRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchyRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMdSchema;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaName;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObjectKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.SimpleSaxParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.SimpleXMLValidator;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleUtility;
import com.cognos.xqe.util.LocalizedString;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.Flat3Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ROLAPMetaObject {
    private static final String LOCALE = "locale";
    private static final String DESCRIPTION = "description";
    private static final String NULL_NODE_ERROR = "XML node cannot be null";
    private static final String NAME_ATTR = "name";
    private static final String MD_SCHEMA = "mdSchema";
    private static final String VERSION = "version";
    private static final String SPACE = " ";
    private static final String CLASS_PACKAGE = "com.cognos.xqe.runtree.olap.mdx.rolapprovider.model";
    private static final String CLASS_PREFIX = "ROLAPMeta";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final int THREE = 3;
    private static final String CALC_MEASURE = "calculatedMeasure";
    private static final String CALC_MEASURE_REF = "calculatedMeasureRef";
    private static final String CALC_MEMBER = "calculatedMember";
    private static final String MODEL_PATH = "/com/cognos/xqe/runtree/olap/mdx/rolapprovider/model/schemas/RolapCubeModel.xsd";
    private static final URL METADATA_SCHEMA = ROLAPMetaObject.class.getResource("/com/cognos/xqe/runtree/olap/mdx/rolapprovider/model/schemas/RolapCubeModel.xsd");
    private static final String LOCALIZE_NAME = "name";
    private static final String[] NODES_TO_CAPTURE_ARRAY = new String[]{"aggregateCube", "aggregateContent", "aggregateDimensionRef", "aggregateHierarchyRef", "aggregateLevelRef", "aggregateLevelKeyRef", "aggregateMeasureRef", "aggregateMember", "aggregateSlice", "aggregation", "attribute", "calculatedMeasure", "calculatedMeasureRef", "calculatedMember", "cube", "cubeDimensionRef", "cubeFacts", "cubeModel", "defaultAttributeRef", "defaultConvergenceLevel", "defaultMeasureRef", "defaultHierarchyRef", "defaultMemberRef", "deny", "dimension", "dimensionInfo", "dimensionRef", "displayPath", "facts", "factTransactionId", "fillerDataMemberCaptionType", "grant", "hierarchy", "hierarchyRef", "level", "levelKeyRef", "locales", "locale", "lookupTableQueryItem", "lookupTableFilter", "captionAttributeRef", "currentPeriodExpression", "customSimpleRelativeTimeMember", "customPTDRelativeTimeMember", "customRollingTotalRelativeTimeMember", "targetPeriod", "contextPeriod", "todatePeriod", "descriptionAttributeRef", "businessKeyAttributeRef", "localeQueryItemRef", "levelRef", "mdSchema", "V5Expression", "measure", "measureRef", "measureFolder", "namedSet", "namedSets", "orderAttributeRef", "parent", "relatedAttributeRef", "rule", "ruleRef", "security", "securityDimensionRef", "securityHierarchyRef", "securityRules", "solveOrder", "view", "views", "virtualCubeModels", "modelPath", "queryItem", "dirtyDataCompensation", "fmFilter", "name", "description", "caption", "allMemberCaption", "allLevelName"};
    private static final String[] NODES_TO_RENAME_ARRAY = new String[]{"calculatedMeasure", "calculatedMeasureRef", "calculatedMember"};
    private Node node;
    private String name = null;
    private String comments = null;
    private ROLAPMetaObject parent;
    private ArrayList<ROLAPMetaObject> children;
    private Map<String, ROLAPMetaObject> nameToChild;
    private static Set<String> nodesToCaptureSet = new HashSet<String>(Arrays.asList(NODES_TO_CAPTURE_ARRAY));
    private static Set<String> nodesToRenameSet = new HashSet<String>(Arrays.asList(NODES_TO_RENAME_ARRAY));
    private static boolean enableModelValidation = Boolean.valueOf(System.getProperty("disableRolapModelValidation", "false")) == false;
    ILocalizedString localizedNamesCache = null;
    ILocalizedString localizedDescriptionCache = null;
    ILocalizedString localizedCaptionCache = null;
    private boolean completedCallingCollect = false;

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node n) {
        this.node = n;
    }

    private boolean hasCompletedCallingCollect() {
        return this.completedCallingCollect;
    }

    protected void collectComplete() {
        this.completedCallingCollect = true;
    }

    private String getLocalizedValue(String elementName, String locale) {
        List elements;
        Node saxNode = this.getNode();
        if (saxNode != null && (elements = ((Element)saxNode).elements(elementName)) != null) {
            for (int index = 0; index < elements.size(); ++index) {
                Element element = (Element)elements.get(index);
                String elementLocale = element.attributeValue(LOCALE);
                String text = element.getText();
                if (!locale.equals(elementLocale)) continue;
                return text;
            }
        }
        return null;
    }

    public String getName() {
        Node saxNode;
        if (!this.hasCompletedCallingCollect()) {
            String localizedNameFromModel = this.getLocalizedValue("name", this.getDefaultLocale());
            if (localizedNameFromModel != null) {
                return localizedNameFromModel;
            }
        } else {
            String localizedName = this.getName(this.getDefaultLocale());
            if (localizedName != null) {
                return localizedName;
            }
        }
        if (this.name == null && (saxNode = this.getNode()) != null) {
            this.name = ((Element)saxNode).attributeValue("name");
        }
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public void setLocalizedNamesCache(ILocalizedString theLocalizedNamesCache) {
        this.localizedNamesCache = theLocalizedNamesCache;
    }

    protected void collectNames() {
        ROLAPMetaName metaName;
        if (this.localizedNamesCache != null) {
            return;
        }
        ArrayList<ROLAPMetaObject> names = new ArrayList<ROLAPMetaObject>();
        this.getFirstChildByType(ROLAPMetaName.class, names);
        for (ROLAPMetaObject object : names) {
            metaName = (ROLAPMetaName)object;
            if (!this.getDefaultLocale().equalsIgnoreCase(metaName.getLocale())) continue;
            this.localizedNamesCache = this.generateLocalizedString(names.size(), metaName.getLocale(), metaName.getLocalizedName());
            names.remove(metaName);
            break;
        }
        for (ROLAPMetaObject object : names) {
            metaName = (ROLAPMetaName)object;
            if (this.localizedNamesCache == null) {
                this.localizedNamesCache = this.generateLocalizedString(names.size(), metaName.getLocale(), metaName.getLocalizedName());
                continue;
            }
            this.localizedNamesCache.put(metaName.getLocale(), metaName.getLocalizedName());
        }
    }

    protected void collectDescriptions() {
        ROLAPMetaDescription metaDescription;
        if (this.localizedDescriptionCache != null) {
            return;
        }
        ArrayList<ROLAPMetaObject> names = new ArrayList<ROLAPMetaObject>();
        this.getFirstChildByType(ROLAPMetaDescription.class, names);
        for (ROLAPMetaObject object : names) {
            metaDescription = (ROLAPMetaDescription)object;
            if (!this.getDefaultLocale().equalsIgnoreCase(metaDescription.getLocale())) continue;
            this.localizedDescriptionCache = this.generateLocalizedString(names.size(), metaDescription.getLocale(), metaDescription.getLocalizedDescription());
            names.remove(metaDescription);
            break;
        }
        for (ROLAPMetaObject object : names) {
            metaDescription = (ROLAPMetaDescription)object;
            if (this.localizedDescriptionCache == null) {
                this.localizedDescriptionCache = this.generateLocalizedString(names.size(), metaDescription.getLocale(), metaDescription.getLocalizedDescription());
                continue;
            }
            this.localizedDescriptionCache.put(metaDescription.getLocale(), metaDescription.getLocalizedDescription());
        }
    }

    protected void collectCaptions() {
        ROLAPMetaCaption metaCaption;
        if (this.localizedCaptionCache != null) {
            return;
        }
        ArrayList<ROLAPMetaObject> names = new ArrayList<ROLAPMetaObject>();
        this.getFirstChildByType(ROLAPMetaCaption.class, names);
        for (ROLAPMetaObject object : names) {
            metaCaption = (ROLAPMetaCaption)object;
            if (!this.getDefaultLocale().equalsIgnoreCase(metaCaption.getLocale())) continue;
            this.localizedCaptionCache = this.generateLocalizedString(names.size(), metaCaption.getLocale(), metaCaption.getLocalizedCaption());
            names.remove(metaCaption);
            break;
        }
        for (ROLAPMetaObject object : names) {
            metaCaption = (ROLAPMetaCaption)object;
            if (this.localizedCaptionCache == null) {
                this.localizedCaptionCache = this.generateLocalizedString(names.size(), metaCaption.getLocale(), metaCaption.getLocalizedCaption());
                continue;
            }
            this.localizedCaptionCache.put(metaCaption.getLocale(), metaCaption.getLocalizedCaption());
        }
    }

    public String getName(String locale) {
        if (this.localizedNamesCache == null) {
            return null;
        }
        locale = LocaleUtility.getSupportedLocale(locale, this.localizedNamesCache, this.getDefaultLocale());
        return this.localizedNamesCache.toString(locale);
    }

    public ILocalizedString getNames() {
        return this.localizedNamesCache;
    }

    public ILocalizedString getCaptions() {
        return this.localizedCaptionCache;
    }

    public ILocalizedString getDescriptions() {
        return this.localizedDescriptionCache;
    }

    public String getDescription(String locale) {
        if (this.localizedDescriptionCache == null) {
            return null;
        }
        return this.localizedDescriptionCache.toString(locale);
    }

    public String getCaption(String locale) {
        if (this.localizedCaptionCache == null) {
            return null;
        }
        locale = LocaleUtility.getSupportedLocale(locale, this.localizedCaptionCache, this.getDefaultLocale());
        return this.localizedCaptionCache.toString(locale);
    }

    public String getComments() {
        Node saxNode;
        if (!this.hasCompletedCallingCollect()) {
            String localizedDescriptionFromModel = this.getLocalizedValue(DESCRIPTION, this.getDefaultLocale());
            if (localizedDescriptionFromModel != null) {
                return localizedDescriptionFromModel;
            }
        } else {
            String localizedDescription = this.getDescription(this.getDefaultLocale());
            if (localizedDescription != null) {
                return localizedDescription;
            }
        }
        if (this.comments == null && (saxNode = this.getNode()) != null) {
            this.comments = ((Element)saxNode).attributeValue("comments");
        }
        return this.comments;
    }

    public ROLAPMetaObject getParent() {
        return this.parent;
    }

    public void setParent(ROLAPMetaObject p) {
        this.parent = p;
    }

    public ArrayList<ROLAPMetaObject> getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList<ROLAPMetaObject> childrenList) {
        this.children = childrenList;
    }

    public Map<String, ROLAPMetaObject> getNameToChild() {
        return this.nameToChild;
    }

    public void setNameToChild(Map<String, ROLAPMetaObject> nameToChildMap) {
        this.nameToChild = nameToChildMap;
    }

    public ROLAPMetaMdSchema getMdSchema() {
        ROLAPMetaObject result;
        for (result = this; result != null && !(result instanceof ROLAPMetaMdSchema); result = result.getParent()) {
        }
        return (ROLAPMetaMdSchema)result;
    }

    public ROLAPMetaCubeModel getMetaCubeModel() {
        ROLAPMetaObject result;
        for (result = this; result != null && !(result instanceof ROLAPMetaCubeModel); result = result.getParent()) {
        }
        return (ROLAPMetaCubeModel)result;
    }

    public ROLAPMetaObject getChild(int i) {
        if (this.children != null) {
            return this.children.get(i);
        }
        return null;
    }

    public ROLAPMetaObject getChild(String childName) {
        if (this.nameToChild != null) {
            return this.nameToChild.get(childName);
        }
        return null;
    }

    public int getChildCount() {
        int result = 0;
        ArrayList<ROLAPMetaObject> ch = this.getChildren();
        if (ch != null) {
            result = ch.size();
        }
        return result;
    }

    public ROLAPMetaObject getFirstChildByType(Class<? extends ROLAPMetaObject> type) {
        ROLAPMetaObject result = null;
        ArrayList<ROLAPMetaObject> childList = this.getChildren();
        if (childList != null) {
            Iterator it = childList.iterator();
            while (result == null && it.hasNext()) {
                ROLAPMetaObject child = (ROLAPMetaObject)it.next();
                if (!type.isInstance(child)) continue;
                result = child;
            }
        }
        return result;
    }

    public void getFirstChildByType(Class<? extends ROLAPMetaObject> type, List<ROLAPMetaObject> listOfTypes) {
        ArrayList<ROLAPMetaObject> childList = this.getChildren();
        if (childList != null) {
            for (ROLAPMetaObject child : childList) {
                if (!type.isInstance(child)) continue;
                listOfTypes.add(child);
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + ".[" + this.getName() + "]";
    }

    public String captureAttribute(String theName) {
        Node saxNode = this.getNode();
        if (saxNode == null) {
            throw new IllegalStateException(NULL_NODE_ERROR);
        }
        return ((Element)saxNode).attributeValue(theName);
    }

    public void captureContents() {
        String indent = SPACE;
        for (int ct = this.getDepth(); ct > 0; --ct) {
            indent = indent + SPACE;
        }
        Node saxNode = this.getNode();
        if (saxNode instanceof Element) {
            Element element = (Element)saxNode;
            int size = element.nodeCount();
            for (int i = 0; i < size; ++i) {
                String typeName;
                ROLAPMetaObject cbobject;
                Node child = element.node(i);
                if (!(child instanceof Element) || (cbobject = this.createMetaObject(typeName = child.getName())) == null) continue;
                if (nodesToRenameSet.contains(typeName)) {
                    Attribute nameAttribute = ((Element)child).attribute("name");
                    String theName = nameAttribute.getValue();
                    int idxOpenBracket = theName.indexOf("[");
                    int idxCloseBracket = theName.lastIndexOf("]");
                    if (theName != null && theName.length() > 2 && idxOpenBracket == 0 && idxCloseBracket == theName.length() - 1) {
                        theName = theName.substring(idxOpenBracket + 1, idxCloseBracket);
                        nameAttribute.setValue(theName);
                    }
                }
                cbobject.setNode(child);
                cbobject.setParent(this);
                this.addChild(cbobject);
                cbobject.captureContents();
                this.addObjectToSchema(typeName, cbobject);
            }
        }
        this.getName();
        this.getComments();
    }

    private void addChild(ROLAPMetaObject child) {
        ArrayList<ROLAPMetaObject> theChildren = this.getChildren();
        Map<String, ROLAPMetaObject> mNameToChild = this.getNameToChild();
        if (theChildren == null) {
            theChildren = new ArrayList();
            this.setChildren(theChildren);
            mNameToChild = new HashMap<String, ROLAPMetaObject>(1, 1.0f);
            this.setNameToChild(mNameToChild);
        }
        theChildren.add(child);
        mNameToChild.put(child.getName(), child);
    }

    protected void addObjectToSchema(String typeName, ROLAPMetaObject object) {
        if (!typeName.equalsIgnoreCase(MD_SCHEMA) && !typeName.endsWith("Ref") && object.getName() != null) {
            ROLAPMetaCubeModel cubeModel = object.getMetaCubeModel();
            String cubeModelName = null;
            if (cubeModel != null) {
                cubeModelName = cubeModel.getName();
            }
            Class<?> objectType = object.getClass();
            String objectName = object.getName();
            ROLAPMetaObject theParent = object.getParent();
            Class<?> parentType = theParent.getClass();
            String parentName = theParent.getName();
            ROLAPMetaObjectKey objectKey = ROLAPMetaObject.createMetaObjectKey(cubeModelName, parentType, parentName, objectType, objectName);
            theParent.getMdSchema().put(objectKey, object);
        }
    }

    private int getDepth() {
        int depth = 0;
        ROLAPMetaObject current = this;
        while (current.getParent() != null) {
            current = current.getParent();
            ++depth;
        }
        return depth;
    }

    public static ROLAPMetaObjectKey createMetaObjectKey(String cubeModelName, Class<? extends ROLAPMetaObject> parentType, String parentName, Class<? extends ROLAPMetaObject> objectType, String objectName) {
        return new ROLAPMetaObjectKey(cubeModelName, parentType, parentName, objectType, objectName);
    }

    private ROLAPMetaObject createMetaObject(String metaObjectElementName) {
        ROLAPMetaObject classInstance = null;
        if (nodesToCaptureSet.contains(metaObjectElementName)) {
            String className = this.getFullyQualifiedClassName(metaObjectElementName);
            try {
                classInstance = (ROLAPMetaObject)Class.forName(className).newInstance();
            }
            catch (IllegalAccessException e) {
                throw new XQERuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new XQERuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new XQERuntimeException(e);
            }
        }
        return classInstance;
    }

    private String getFullyQualifiedClassName(String metaObjectElementName) {
        String className = this.getClassPackage() + "." + this.getClassName(metaObjectElementName);
        return className;
    }

    private String getClassName(String metaObjectElementName) {
        String className = this.getClassPrefix() + metaObjectElementName.substring(0, 1).toUpperCase() + metaObjectElementName.substring(1);
        return className;
    }

    protected String getClassPackage() {
        return CLASS_PACKAGE;
    }

    protected String getClassPrefix() {
        return CLASS_PREFIX;
    }

    public void clearDOMNode() {
        Node saxNode = this.getNode();
        if (saxNode != null) {
            this.setNode(null);
            ArrayList<ROLAPMetaObject> theChildren = this.getChildren();
            if (theChildren != null) {
                for (ROLAPMetaObject child : theChildren) {
                    child.clearDOMNode();
                }
                theChildren.trimToSize();
                Map<String, ROLAPMetaObject> mNameToChild = this.getNameToChild();
                if (mNameToChild.size() <= 3) {
                    this.setNameToChild((Map<String, ROLAPMetaObject>)new Flat3Map(mNameToChild));
                }
            }
        }
    }

    protected static List<ROLAPMetaHierarchy> getHierarchies(ROLAPMetaCube metaCube) {
        ArrayList<ROLAPMetaHierarchy> hierarchies = new ArrayList<ROLAPMetaHierarchy>();
        int ct = metaCube.getChildCount();
        for (int i = 0; i < ct; ++i) {
            ROLAPMetaObject obj = metaCube.getChild(i);
            if (obj instanceof ROLAPMetaHierarchyRef) {
                ROLAPMetaHierarchy hier = ROLAPMetaObject.getHierarchy((ROLAPMetaHierarchyRef)obj);
                hierarchies.add(hier);
                continue;
            }
            if (obj instanceof ROLAPMetaHierarchy) {
                hierarchies.add((ROLAPMetaHierarchy)obj);
                continue;
            }
            if (!(obj instanceof ROLAPMetaDimensionRef)) continue;
            ROLAPMetaDimensionRef dimRef = (ROLAPMetaDimensionRef)obj;
            hierarchies.addAll(ROLAPMetaObject.getHierarchies(dimRef));
        }
        return hierarchies;
    }

    protected static List<ROLAPMetaHierarchy> getHierarchies(ROLAPMetaDimensionRef metaDimensionRef) {
        ArrayList<ROLAPMetaHierarchy> hierarchies = new ArrayList<ROLAPMetaHierarchy>();
        int ct = metaDimensionRef.getChildCount();
        for (int i = 0; i < ct; ++i) {
            ROLAPMetaObject obj = metaDimensionRef.getChild(i);
            if (!(obj instanceof ROLAPMetaHierarchyRef) || obj instanceof ROLAPMetaDefaultHierarchyRef) continue;
            ROLAPMetaHierarchy hier = ROLAPMetaObject.getHierarchy((ROLAPMetaHierarchyRef)obj, metaDimensionRef.getName(), metaDimensionRef.getDimensionCategory());
            hierarchies.add(hier);
        }
        return hierarchies;
    }

    protected static ROLAPMetaHierarchy getHierarchy(ROLAPMetaHierarchyRef metaHierarchyRef) {
        String dimName = metaHierarchyRef.getDimensionName();
        String category = metaHierarchyRef.getDimensionCategory();
        return ROLAPMetaObject.getHierarchy(metaHierarchyRef, dimName, category);
    }

    protected static ROLAPMetaHierarchy getHierarchy(ROLAPMetaHierarchyRef metaHierarchyRef, String dimensionName, String dimensionCategory) {
        ROLAPMetaHierarchy hier = metaHierarchyRef.getHierarchy(dimensionName, dimensionCategory);
        hier.setDimensionName(dimensionName);
        hier.setDimensionCategory(dimensionCategory);
        return hier;
    }

    protected Element captureElement(String eltName) {
        Node saxNode = this.getNode();
        if (saxNode == null) {
            throw new IllegalStateException(NULL_NODE_ERROR);
        }
        return ((Element)saxNode).element(eltName);
    }

    protected List<Element> captureElements(String eltName) {
        Node saxNode = this.getNode();
        if (saxNode == null) {
            throw new IllegalStateException(NULL_NODE_ERROR);
        }
        return ((Element)saxNode).elements(eltName);
    }

    public static ROLAPMetaMdSchema parse(String xmlcText) throws Exception {
        SimpleSaxParser saxParser = new SimpleSaxParser();
        xmlcText = ROLAPMetaObject.removeInvalidXMLCharacters(xmlcText);
        if (enableModelValidation) {
            ROLAPMetaObject.validateMetadata(xmlcText);
        }
        saxParser.parseString(xmlcText);
        Element rootElement = saxParser.getDocument().getRootElement();
        ROLAPMetaObject rootObject = new ROLAPMetaObject();
        rootObject.setNode((Node)rootElement);
        rootObject.captureContents();
        rootObject.clearDOMNode();
        ROLAPMetaMdSchema mdSchema = (ROLAPMetaMdSchema)rootObject.getFirstChildByType(ROLAPMetaMdSchema.class);
        if (enableModelValidation) {
            mdSchema.validateModel();
        }
        mdSchema.setVersion(rootElement.attributeValue(VERSION));
        return mdSchema;
    }

    public String getDefaultLocale() {
        ROLAPMetaMdSchema schema = this.getMdSchema();
        String locale = null;
        if (schema != null) {
            locale = schema.getMdSchemaDefaultLocale();
        }
        return locale;
    }

    public ILocalizedString generateLocalizedString(int count, String locale, String value) {
        if (count == 1) {
            return AbstractSingleLocaleString.getSingleLocaleString(locale, value);
        }
        return new LocalizedString(locale, value);
    }

    public ILocalizedString generateLocalizedString(int count, Locale locale, String value) {
        if (count == 1) {
            return AbstractSingleLocaleString.getSingleLocaleString(locale, value);
        }
        return new LocalizedString(locale, value);
    }

    protected boolean isSingleLocale() {
        ROLAPMetaMdSchema schema = this.getMdSchema();
        if (schema != null) {
            return schema.isSingleLocale();
        }
        return true;
    }

    private static String removeInvalidXMLCharacters(String input) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char item = input.charAt(i);
            if (!(item == '\t' || item == '\n' || item == '\r' || item >= ' ' && item <= '\ud7ff' || item >= '\ue000' && item <= '\ufffd') && (item < '\u10000' || item > '\u10ffff')) continue;
            buffer.append(item);
        }
        return buffer.toString();
    }

    private static void validateMetadata(String xmlcText) throws Exception {
        SimpleXMLValidator validator = new SimpleXMLValidator();
        StringBuilder sb = new StringBuilder();
        validator.validateString(xmlcText, METADATA_SCHEMA);
        if (validator.encounteredErrors()) {
            String message;
            for (SAXParseException se : validator.getFatalErrors()) {
                message = se.getLineNumber() + ":" + se.getMessage();
                XQEDebugLog.err.println(message);
                sb.append(message).append(NEWLINE);
            }
            for (SAXParseException se : validator.getErrors()) {
                message = se.getLineNumber() + ":" + se.getMessage();
                XQEDebugLog.err.println(message);
                sb.append(message).append(NEWLINE);
            }
            for (SAXParseException se : validator.getWarnings()) {
                message = se.getLineNumber() + ":" + se.getMessage();
                XQEDebugLog.err.println(message);
                sb.append(message).append(NEWLINE);
            }
            throw new SAXException("Errors encountered when validating schema: \n" + sb.toString());
        }
    }
}

