/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.security;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.IROLAPSecurityManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecViewCombinationHierarchyRestriction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecViewHierarchyLookupTableRestriction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecViewHierarchyRestriction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecViewRestriction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SecViewCombinationRestriction {
    private ConcurrentHashMap<IHierarchy, SecViewCombinationHierarchyRestriction> dimensionHierarchyMembersRestrictionMap;
    private ConcurrentHashMap<IHierarchy, SecViewCombinationHierarchyRestriction> dimensionHierarchyValuesRestrictionMap;
    private ConcurrentHashMap<IHierarchy, SecViewCombinationHierarchyRestriction> dimensionHierarchyAttributesRestrictionMap;
    private final List<SecViewRestriction> views;
    private Set<IHierarchy> securedValueHierarchies = new HashSet<IHierarchy>();
    private Set<IHierarchy> memberOrValueRestrictedHierarchies = new HashSet<IHierarchy>();
    private Set<IHierarchy> securedAttributesHierarchies = new HashSet<IHierarchy>();
    private String viewCombinationName;
    private boolean isAllDenied = false;
    private boolean isAllAccessToNonCalcMembers = false;
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";
    private static final String RIGHT_BRACKET_SPACE = "] ";
    private static final String COMMA = ",";
    private static final String NEWLINE = "\n";

    public boolean isSingleView() {
        return this.views.size() <= 1;
    }

    public List<SecViewRestriction> getViews() {
        return this.views;
    }

    public SecViewCombinationRestriction(String pViewCombination, List<SecViewRestriction> pViews, ROLAPBaseCube cube) {
        this.viewCombinationName = pViewCombination;
        this.views = pViews;
        this.initializeViewCombinationRestriction(cube);
    }

    private void setAllDenied() {
        this.securedValueHierarchies.clear();
        if (this.dimensionHierarchyMembersRestrictionMap != null) {
            this.dimensionHierarchyMembersRestrictionMap.clear();
            this.dimensionHierarchyMembersRestrictionMap = null;
        }
        if (this.dimensionHierarchyValuesRestrictionMap != null) {
            this.dimensionHierarchyValuesRestrictionMap.clear();
            this.dimensionHierarchyValuesRestrictionMap = null;
        }
        if (this.dimensionHierarchyAttributesRestrictionMap != null) {
            this.dimensionHierarchyAttributesRestrictionMap.clear();
            this.dimensionHierarchyAttributesRestrictionMap = null;
        }
        this.isAllDenied = true;
    }

    public String getViewCombination() {
        return this.viewCombinationName;
    }

    public boolean isAllAccessGranted() {
        return !(this.isAllDenied() || this.dimensionHierarchyMembersRestrictionMap != null && this.dimensionHierarchyMembersRestrictionMap.size() != 0 || this.dimensionHierarchyValuesRestrictionMap != null && this.dimensionHierarchyValuesRestrictionMap.size() != 0);
    }

    public boolean isAllDenied() {
        return this.isAllDenied;
    }

    public SecViewCombinationHierarchyRestriction getRestriction(IHierarchy hierarchy, SecManager.SecurityType securityType) {
        ConcurrentHashMap<IHierarchy, SecViewCombinationHierarchyRestriction> theMap = this.getMap(securityType);
        if (theMap != null) {
            return theMap.get(hierarchy);
        }
        return null;
    }

    public boolean hasRestriction(IHierarchy hierarchy, SecManager.SecurityType securityType) {
        if (this.isAllDenied()) {
            return true;
        }
        if (this.isAllAccessGranted()) {
            return false;
        }
        SecViewCombinationHierarchyRestriction restriction = this.getRestriction(hierarchy, securityType);
        return restriction != null && !restriction.isAllAccess();
    }

    public IMember getDefaultMember(IHierarchy hierarchy) {
        SecViewCombinationHierarchyRestriction hierarchyRestriction;
        if (this.isAllDenied()) {
            return null;
        }
        if (this.dimensionHierarchyMembersRestrictionMap != null && (hierarchyRestriction = this.dimensionHierarchyMembersRestrictionMap.get(hierarchy)) != null) {
            return hierarchyRestriction.getDefaultMember();
        }
        return hierarchy.getDefaultMember();
    }

    public boolean isRestricted(Dimension dimension) {
        if (dimension == null) {
            return true;
        }
        int hierarchyCount = dimension.getHierarchyCount();
        for (int i = 0; i < hierarchyCount; ++i) {
            IHierarchy hierarchy = dimension.getHierarchy(i);
            if (this.isRestricted(hierarchy)) continue;
            return false;
        }
        return true;
    }

    public boolean isRestricted(IHierarchy hierarchy) {
        SecViewCombinationHierarchyRestriction hierarchyRestriction;
        if (hierarchy == null) {
            return true;
        }
        if (this.isAllAccessGranted()) {
            return false;
        }
        if (this.isAllDenied()) {
            return true;
        }
        if (this.dimensionHierarchyMembersRestrictionMap != null && (hierarchyRestriction = this.dimensionHierarchyMembersRestrictionMap.get(hierarchy)) != null) {
            return hierarchyRestriction.isAllDenied();
        }
        return false;
    }

    public boolean isRestricted(IProperty property) {
        SecViewCombinationHierarchyRestriction hierarchyRestriction;
        if (property == null) {
            return true;
        }
        if (this.isAllAccessGranted()) {
            return false;
        }
        if (this.isAllDenied()) {
            return true;
        }
        return this.dimensionHierarchyAttributesRestrictionMap != null && (hierarchyRestriction = this.dimensionHierarchyAttributesRestrictionMap.get(property.getHierarchy())) != null;
    }

    public boolean isRestricted(ILevel level) {
        if (level == null) {
            return true;
        }
        return this.isRestricted(level.getHierarchy());
    }

    public Set<IHierarchy> getSecuredValueHierarchies() {
        return this.securedValueHierarchies;
    }

    public Set<IHierarchy> getMemberOrValueRestrictedHierarchies() {
        return this.memberOrValueRestrictedHierarchies;
    }

    public boolean isSecuredMember(IMember member) {
        return this.isSecuredMember(member, null, null, null);
    }

    public boolean isSecuredMember(IMember member, SecViewCombinationHierarchyRestriction hierarchyRestriction, SecManager.MostRecentlyCheckedAncestors mrcgAncestors, SecManager.MostRecentlyCheckedAncestors mrcdAncestors) {
        IROLAPSecurityManager.MemberStatus memberStatus;
        if (this.isAllDenied()) {
            return true;
        }
        if (member == null) {
            return false;
        }
        if (hierarchyRestriction == null && this.dimensionHierarchyMembersRestrictionMap != null) {
            IHierarchy hierarchy = member.getHierarchy();
            hierarchyRestriction = this.dimensionHierarchyMembersRestrictionMap.get(hierarchy);
        }
        return hierarchyRestriction != null && ((memberStatus = hierarchyRestriction.getMemberStatus(member, true, mrcgAncestors, mrcdAncestors)) == IROLAPSecurityManager.MemberStatus.DENIED || memberStatus == IROLAPSecurityManager.MemberStatus.NONE);
    }

    public boolean isSecuredAttribute(IProperty property) {
        IROLAPSecurityManager.AttributeStatus attributeStatus;
        IHierarchy hierarchy;
        SecViewCombinationHierarchyRestriction hierarchyRestriction;
        if (this.isAllDenied()) {
            return true;
        }
        if (property == null) {
            return false;
        }
        return this.dimensionHierarchyAttributesRestrictionMap != null && (hierarchyRestriction = this.dimensionHierarchyAttributesRestrictionMap.get(hierarchy = property.getHierarchy())) != null && ((attributeStatus = hierarchyRestriction.getAttributeStatus(property)) == IROLAPSecurityManager.AttributeStatus.DENIED || attributeStatus == IROLAPSecurityManager.AttributeStatus.NONE);
    }

    public boolean isSecuredAttribute(String propertyName, IHierarchy hierarchy) {
        IROLAPSecurityManager.AttributeStatus attributeStatus;
        SecViewCombinationHierarchyRestriction hierarchyRestriction;
        if (this.isAllDenied()) {
            return true;
        }
        if (propertyName == null) {
            return false;
        }
        return this.dimensionHierarchyAttributesRestrictionMap != null && (hierarchyRestriction = this.dimensionHierarchyAttributesRestrictionMap.get(hierarchy)) != null && ((attributeStatus = hierarchyRestriction.getAttributeStatus(propertyName)) == IROLAPSecurityManager.AttributeStatus.DENIED || attributeStatus == IROLAPSecurityManager.AttributeStatus.NONE);
    }

    public boolean isSecuredValueMember(IMember member) {
        IROLAPSecurityManager.MemberStatus memberStatus;
        SecViewCombinationHierarchyRestriction hierarchyRestriction;
        if (member == null) {
            return false;
        }
        IHierarchy hierarchy = member.getHierarchy();
        if (this.dimensionHierarchyValuesRestrictionMap != null && (hierarchyRestriction = this.dimensionHierarchyValuesRestrictionMap.get(hierarchy)) != null && ((memberStatus = hierarchyRestriction.getMemberStatus(member, false)) == IROLAPSecurityManager.MemberStatus.DENIED || memberStatus == IROLAPSecurityManager.MemberStatus.NONE)) {
            return true;
        }
        return this.dimensionHierarchyMembersRestrictionMap != null && (hierarchyRestriction = this.dimensionHierarchyMembersRestrictionMap.get(hierarchy)) != null && ((memberStatus = hierarchyRestriction.getMemberStatus(member, true)) == IROLAPSecurityManager.MemberStatus.VISIBLE_ANCESTOR || memberStatus == IROLAPSecurityManager.MemberStatus.SECURED_PADDING_MEMBER);
    }

    private void initializeViewCombinationRestriction(ROLAPBaseCube rolapBaseCube) {
        Set<IHierarchy> hiers;
        boolean allowMemberRollUpThroughViewCombination;
        SecViewCombinationHierarchyRestriction hierarchyRestriction;
        Iterator<SecViewCombinationHierarchyRestriction> it;
        Collection<SecViewCombinationHierarchyRestriction> hierarchyRestrictions;
        for (SecViewRestriction view : this.views) {
            if (!view.getName().equals("<Deny All>")) continue;
            this.setAllDenied();
            return;
        }
        this.initializeViewCombinationRestrictions(rolapBaseCube, SecManager.SecurityType.member);
        this.initializeViewCombinationRestrictions(rolapBaseCube, SecManager.SecurityType.member_LookupTable);
        this.initializeViewCombinationRestrictions(rolapBaseCube, SecManager.SecurityType.value);
        this.initializeViewCombinationRestrictions(rolapBaseCube, SecManager.SecurityType.attribute);
        this.isAllAccessToNonCalcMembers = true;
        if (this.dimensionHierarchyMembersRestrictionMap != null) {
            hierarchyRestrictions = this.dimensionHierarchyMembersRestrictionMap.values();
            it = hierarchyRestrictions.iterator();
            while (it.hasNext()) {
                hierarchyRestriction = it.next();
                allowMemberRollUpThroughViewCombination = true;
                for (SecViewRestriction view : this.views) {
                    hiers = view.getSecuredHierarchies();
                    if (!hiers.contains(hierarchyRestriction.getHierarchy()) || hiers.size() <= 1) continue;
                    allowMemberRollUpThroughViewCombination = false;
                }
                hierarchyRestriction.initializeState(allowMemberRollUpThroughViewCombination);
                this.isAllAccessToNonCalcMembers &= hierarchyRestriction.isAllAccessToNonCalcMembers();
                if (hierarchyRestriction.isAllAccess()) {
                    it.remove();
                    continue;
                }
                this.memberOrValueRestrictedHierarchies.add(hierarchyRestriction.getHierarchy());
                if (!hierarchyRestriction.hasVisibleAncestors() && !hierarchyRestriction.hasSecurityPaddingMembers()) continue;
                this.securedValueHierarchies.add(hierarchyRestriction.getHierarchy());
            }
            if (hierarchyRestrictions.size() == 0) {
                this.dimensionHierarchyMembersRestrictionMap.clear();
                this.dimensionHierarchyMembersRestrictionMap = null;
            }
        }
        if (this.dimensionHierarchyValuesRestrictionMap != null) {
            hierarchyRestrictions = this.dimensionHierarchyValuesRestrictionMap.values();
            it = hierarchyRestrictions.iterator();
            while (it.hasNext()) {
                hierarchyRestriction = it.next();
                allowMemberRollUpThroughViewCombination = true;
                for (SecViewRestriction view : this.views) {
                    hiers = view.getSecuredHierarchies();
                    if (!hiers.contains(hierarchyRestriction.getHierarchy()) || hiers.size() <= 1) continue;
                    allowMemberRollUpThroughViewCombination = false;
                }
                hierarchyRestriction.initializeState(allowMemberRollUpThroughViewCombination);
                this.isAllAccessToNonCalcMembers &= hierarchyRestriction.isAllAccessToNonCalcMembers();
                if (hierarchyRestriction.isAllAccess()) {
                    it.remove();
                    continue;
                }
                this.memberOrValueRestrictedHierarchies.add(hierarchyRestriction.getHierarchy());
                this.securedValueHierarchies.add(hierarchyRestriction.getHierarchy());
            }
            if (hierarchyRestrictions.size() == 0) {
                this.dimensionHierarchyValuesRestrictionMap.clear();
                this.dimensionHierarchyValuesRestrictionMap = null;
            }
        }
        if (this.dimensionHierarchyAttributesRestrictionMap != null) {
            hierarchyRestrictions = this.dimensionHierarchyAttributesRestrictionMap.values();
            it = hierarchyRestrictions.iterator();
            while (it.hasNext()) {
                hierarchyRestriction = it.next();
                hierarchyRestriction.initializeState(false);
                if (hierarchyRestriction.isAllAccess()) {
                    it.remove();
                    continue;
                }
                this.securedAttributesHierarchies.add(hierarchyRestriction.getHierarchy());
            }
            if (hierarchyRestrictions.size() == 0) {
                this.dimensionHierarchyAttributesRestrictionMap.clear();
                this.dimensionHierarchyAttributesRestrictionMap = null;
            }
        }
    }

    private ConcurrentHashMap<IHierarchy, SecViewCombinationHierarchyRestriction> getMap(SecManager.SecurityType securityType) {
        return this.getOrCreateMap(securityType, false);
    }

    private ConcurrentHashMap<IHierarchy, SecViewCombinationHierarchyRestriction> getOrCreateMap(SecManager.SecurityType securityType, boolean createMap) {
        ConcurrentHashMap<IHierarchy, SecViewCombinationHierarchyRestriction> theMap = null;
        if (securityType == SecManager.SecurityType.value) {
            if (createMap && this.dimensionHierarchyValuesRestrictionMap == null) {
                this.dimensionHierarchyValuesRestrictionMap = new ConcurrentHashMap();
            }
            theMap = this.dimensionHierarchyValuesRestrictionMap;
        } else if (securityType == SecManager.SecurityType.attribute) {
            if (createMap && this.dimensionHierarchyAttributesRestrictionMap == null) {
                this.dimensionHierarchyAttributesRestrictionMap = new ConcurrentHashMap();
            }
            theMap = this.dimensionHierarchyAttributesRestrictionMap;
        } else {
            if (createMap && this.dimensionHierarchyMembersRestrictionMap == null) {
                this.dimensionHierarchyMembersRestrictionMap = new ConcurrentHashMap();
            }
            theMap = this.dimensionHierarchyMembersRestrictionMap;
        }
        return theMap;
    }

    private void initializeViewCombinationRestrictions(ROLAPCube cube, SecManager.SecurityType securityType) {
        HashMap<IHierarchy, HashSet<SecViewHierarchyRestriction>> hierRestrictionMap = new HashMap<IHierarchy, HashSet<SecViewHierarchyRestriction>>();
        for (SecViewRestriction view : this.views) {
            Set<IHierarchy> hierarchies = view.getSecuredHierarchies();
            for (IHierarchy hierarchy : hierarchies) {
                SecViewHierarchyRestriction hierRestriction = null;
                if (securityType == SecManager.SecurityType.member_LookupTable) {
                    SecViewHierarchyLookupTableRestriction hierLookupTableRestriction = view.getLookupTableRestriction(hierarchy);
                    if (hierLookupTableRestriction != null) {
                        hierRestriction = hierLookupTableRestriction.createUserHierarchyRestriction(cube);
                    }
                } else {
                    hierRestriction = view.getRestriction(hierarchy, securityType);
                }
                if (hierRestriction == null) continue;
                HashSet<SecViewHierarchyRestriction> hierRestrictions = (HashSet<SecViewHierarchyRestriction>)hierRestrictionMap.get(hierarchy);
                if (hierRestrictions == null) {
                    hierRestrictions = new HashSet<SecViewHierarchyRestriction>();
                    hierRestrictionMap.put(hierarchy, hierRestrictions);
                }
                hierRestrictions.add(hierRestriction);
            }
        }
        for (IHierarchy hierarchy : hierRestrictionMap.keySet()) {
            Set hierarchyRestrictions = (Set)hierRestrictionMap.get(hierarchy);
            if (hierarchyRestrictions == null) continue;
            ConcurrentHashMap<IHierarchy, SecViewCombinationHierarchyRestriction> theMap = this.getOrCreateMap(securityType, true);
            SecViewCombinationHierarchyRestriction combinationHierarchyRestriction = theMap.get(hierarchy);
            if (combinationHierarchyRestriction == null) {
                combinationHierarchyRestriction = new SecViewCombinationHierarchyRestriction(this.getViewCombination(), cube, hierarchy, securityType);
                theMap.put(hierarchy, combinationHierarchyRestriction);
            }
            combinationHierarchyRestriction.addRestrictions(hierarchyRestrictions);
        }
    }

    public String getAuditString() {
        SecViewCombinationHierarchyRestriction hierarchyRestriction;
        Iterator<SecViewCombinationHierarchyRestriction> it;
        Collection<SecViewCombinationHierarchyRestriction> hierarchyRestrictions;
        String logString = "";
        logString = logString + "Restrictions for security view combination: " + this.viewCombinationName;
        logString = logString + NEWLINE;
        List<SecViewRestriction> viewsForUser = this.getViews();
        logString = logString + "Assigned security views: ";
        for (SecViewRestriction view : viewsForUser) {
            logString = logString + LEFT_BRACKET + view.getName() + RIGHT_BRACKET + COMMA;
        }
        logString = logString + NEWLINE;
        HashSet<IDimension> grantedDimensions = new HashSet<IDimension>();
        HashSet<IDimension> deniedDimensions = new HashSet<IDimension>();
        for (SecViewRestriction view : viewsForUser) {
            grantedDimensions.addAll(view.getDimensionsGranted());
            deniedDimensions.addAll(view.getDimensionsDenied());
        }
        logString = logString + "Secured dimensions: ";
        if (grantedDimensions.isEmpty()) {
            if (deniedDimensions.isEmpty()) {
                logString = logString + "None ";
            } else {
                for (IDimension dimension : deniedDimensions) {
                    logString = logString + LEFT_BRACKET + dimension.getName() + RIGHT_BRACKET + COMMA;
                }
            }
        } else {
            grantedDimensions.removeAll(deniedDimensions);
            if (grantedDimensions.isEmpty()) {
                logString = logString + "All ";
            } else {
                logString = logString + "All except ";
                for (IDimension dimension : grantedDimensions) {
                    logString = logString + LEFT_BRACKET + dimension.getName() + RIGHT_BRACKET + COMMA;
                }
            }
        }
        logString = logString + NEWLINE;
        if (this.dimensionHierarchyMembersRestrictionMap != null) {
            hierarchyRestrictions = this.dimensionHierarchyMembersRestrictionMap.values();
            it = hierarchyRestrictions.iterator();
            logString = logString + "Member security settings:\n";
            while (it.hasNext()) {
                hierarchyRestriction = it.next();
                logString = logString + hierarchyRestriction.getAuditString();
            }
        } else {
            logString = logString + "Secured members: None\n";
        }
        if (this.dimensionHierarchyAttributesRestrictionMap != null) {
            hierarchyRestrictions = this.dimensionHierarchyAttributesRestrictionMap.values();
            it = hierarchyRestrictions.iterator();
            logString = logString + "Attributes security settings:\n";
            while (it.hasNext()) {
                hierarchyRestriction = it.next();
                logString = logString + hierarchyRestriction.getAuditString();
            }
        } else {
            logString = logString + "Secured attributes: None\n";
        }
        return logString;
    }

    public boolean isAllAccessToNonCalcMembers() {
        return this.isAllAccessToNonCalcMembers;
    }
}

