/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.security;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPCommonMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQueryResultIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaRule;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecViewHierarchyRestriction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecurityLookupQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecurityLookupQueryCache;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.trace.LogLevel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class SecViewHierarchyLookupTableRestriction {
    private final List<SecurityLookupQuery> grantLookupQueries;
    private final List<SecurityLookupQuery> denyLookupQueries;
    ROLAPHierarchy mHier;
    boolean mIsAllMembersDenied;
    SecViewHierarchyRestriction.GrantType mGrantType;
    private static final int DISPLAY = 100;
    private static final String RIGHT_ACOLADE = "}";
    private static final String QUOTE = "\"";
    private final ConcurrentHashMap<String, SecViewHierarchyRestriction> hierarchyRestrictionMap = new ConcurrentHashMap();

    public SecViewHierarchyLookupTableRestriction(List<SecurityLookupQuery> grantLookupQueryList, List<SecurityLookupQuery> denyLookupQueryList, ROLAPHierarchy hier, boolean isAllMembersDenied, SecViewHierarchyRestriction.GrantType grantType) {
        this.grantLookupQueries = grantLookupQueryList;
        this.denyLookupQueries = denyLookupQueryList;
        this.mHier = hier;
        this.mIsAllMembersDenied = isAllMembersDenied;
        this.mGrantType = grantType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueries(ROLAPCube cube, List<SecurityLookupQuery> lookupQueries, HashSet<IMember> selves, HashSet<IMember> ancestors, SecManager.RuleType ruleType) {
        SecManager secManager = (SecManager)cube.getSecurityManager();
        SecurityLookupQueryCache lookupCache = secManager.getLookupQueryCache();
        for (SecurityLookupQuery query : lookupQueries) {
            SecurityLookupQueryCache.MemberSetEntry memberSetEntry;
            ROLAPMemberQuery memberQuery = new ROLAPMemberQuery(cube.getSchema(), cube);
            memberQuery.setFilterExpression(query.getFilterExpression());
            ArrayList<String[]> dataItems = query.getDataItemDefs();
            memberQuery.setDataItemInfo(dataItems);
            AtomicReference<SecurityLookupQueryCache.MemberSetEntry> memberSetRef = new AtomicReference<SecurityLookupQueryCache.MemberSetEntry>();
            AtomicReference<String> queryRef = new AtomicReference<String>();
            String queryPrefix = this.mHier.getUniqueName() + query.getScope().toString();
            IROLAPQueryResultIterator resultIterator = memberQuery.execute(lookupCache, queryRef, memberSetRef, queryPrefix);
            if (ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.INFO)) {
                ROLAPLog.log("ROLAPCubes.Security", "Processed security lookup query '" + queryRef.get() + "'");
            }
            if ((memberSetEntry = memberSetRef.get()) != null) {
                if (ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.INFO)) {
                    ROLAPLog.log("ROLAPCubes.Security", "Found stored member set");
                }
            } else {
                if (ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.INFO)) {
                    ROLAPLog.log("ROLAPCubes.Security", "Building new member set");
                }
                HashSet<IMember> memberSet = new HashSet<IMember>();
                ROLAPMember.LevelKeys levelKeys = new ROLAPMember.LevelKeys(null);
                try {
                    int rowCount = 0;
                    while (resultIterator.hasNext()) {
                        IValue[] keyValues;
                        IValue[] rowValues = resultIterator.next().getColumns();
                        if (ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.TRACE) && ++rowCount < 100) {
                            ArrayList<String> strRowValues = new ArrayList<String>();
                            for (IValue value : rowValues) {
                                if (value == null || value.isNull()) {
                                    strRowValues.add(null);
                                    continue;
                                }
                                strRowValues.add(value.toString());
                            }
                            ROLAPLog.log("ROLAPCubes.Security", "Row values retrieved for SQL query: " + strRowValues.toString() + RIGHT_ACOLADE);
                        }
                        rowValues = this.processValues(rowValues);
                        Level keysLevel = null;
                        if (this.mHier.isParentChild()) {
                            keyValues = query.getKeys(null, rowValues);
                        } else {
                            keysLevel = (Level)query.findLevel(rowValues);
                            if (keysLevel == null) {
                                this.logMemberNotFoundMsg(rowValues, null, null);
                                continue;
                            }
                            keyValues = query.getKeys(keysLevel, rowValues);
                        }
                        if (keyValues.length == 0) {
                            Level level0 = (Level)this.mHier.getLevel(0);
                            if (!level0.isAllLevel()) {
                                this.logMemberNotFoundMsg(rowValues, null, null);
                                continue;
                            }
                            IMember member2 = level0.getMember(0);
                            memberSet.add(member2);
                            continue;
                        }
                        levelKeys.setKeyValues(keyValues);
                        IMember member = null;
                        if (keysLevel != null) {
                            member = ((ROLAPLevel)keysLevel).getMember(levelKeys);
                        } else {
                            ILevel level;
                            Iterator<ILevel> member2 = this.mHier.getLevels().iterator();
                            while (member2.hasNext() && (member = ((ROLAPLevel)(level = member2.next())).getMember(levelKeys)) == null) {
                            }
                        }
                        if (member != null) {
                            memberSet.add(member);
                            IMember dataMember = member.getDataMember();
                            if (dataMember == null) continue;
                            memberSet.add(dataMember);
                            continue;
                        }
                        this.logMemberNotFoundMsg(rowValues, levelKeys, keysLevel);
                    }
                    if (ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.INFO)) {
                        ROLAPLog.log("ROLAPCubes.Security", "Number of rows retrieved from SQL query: " + rowCount + RIGHT_ACOLADE);
                    }
                    memberSetEntry = lookupCache.put(queryRef.get(), memberSet);
                }
                finally {
                    resultIterator.close();
                }
            }
            if (ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.TRACE)) {
                ROLAPLog.log("ROLAPCubes.Security", "Member set: " + memberSetEntry.toString());
            }
            this.addMembers(memberSetEntry.getGeneralSet(), selves, ancestors, query.getScope(), ruleType);
        }
    }

    private void addMembers(HashSet<IMember> hierarchyMembers, HashSet<IMember> selves, HashSet<IMember> ancestors, ROLAPMetaRule.Scope scope, SecManager.RuleType ruleType) {
        if (ruleType == SecManager.RuleType.deny_member) {
            for (IMember member : hierarchyMembers) {
                ancestors.add(member);
            }
        } else {
            for (IMember member : hierarchyMembers) {
                if (scope.addDescendants()) {
                    ancestors.add(member);
                } else {
                    selves.add(member);
                }
                if (!scope.addAscendants()) continue;
                SecManager.addAscendantsTo(selves, member.getParent());
            }
        }
    }

    private void logMemberNotFoundMsg(IValue[] rowValues, ROLAPMember.LevelKeys keys, Level keysLevel) {
        IMember member;
        if (!ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.TRACE)) {
            return;
        }
        ArrayList<String> columns = new ArrayList<String>();
        for (IValue val : rowValues) {
            if (val == null || val.isNull()) {
                columns.add(null);
                continue;
            }
            columns.add(val.toString());
        }
        String dataTypeMissmatchMsg = "";
        if (keysLevel != null && keys != null && (member = keysLevel.getMember(0)) != null) {
            ROLAPMember.LevelKeys lKeys = ((IROLAPCommonMember)((Object)member)).getLevelKeys();
            IValue[] memberKeyValues = lKeys.getKeyValues();
            IValue[] lookupTableKeyValues = keys.getKeyValues();
            for (int i = 0; i < lookupTableKeyValues.length && i < memberKeyValues.length; ++i) {
                if (lookupTableKeyValues[i].getDataType() == memberKeyValues[i].getDataType()) continue;
                dataTypeMissmatchMsg = ". Possible incompatible data type for level key \"" + lookupTableKeyValues[i].toString() + QUOTE + ". Security lookup table column type: " + lookupTableKeyValues[i].getDataType().toString() + ". Dimension table column type: " + memberKeyValues[i].getDataType().toString();
            }
        }
        ROLAPLog.log("ROLAPCubes.Security", "Member not found: " + columns.toString() + dataTypeMissmatchMsg);
    }

    private IValue[] processValues(IValue[] rowValues) {
        IValue[] processedValues = new IValue[rowValues.length];
        for (int i = 0; i < rowValues.length; ++i) {
            if (rowValues[i] instanceof TextValue) {
                ((TextValue)rowValues[i]).setCollator(null);
                rowValues[i].hashCode();
            }
            if (!rowValues[i].isNull() && rowValues[i].toString().length() == 0) {
                processedValues[i] = DataValueFactory.createVarcharValue();
                processedValues[i].setNull();
                continue;
            }
            processedValues[i] = rowValues[i];
        }
        return processedValues;
    }

    public SecViewHierarchyRestriction createUserHierarchyRestriction(ROLAPCube cube) {
        SecurityManagerInterface secManager = cube.getSecurityManager();
        String userKey = secManager.getAuthorizationKeyForCurrentUser();
        Map<IMember, List<IMember>> calcMemberMap = ((SecManager)secManager).buildCalcMemberMap(this.mHier);
        HashSet<IMember> grantedSelves = new HashSet<IMember>();
        HashSet<IMember> grantedAncestors = new HashSet<IMember>();
        HashSet<IMember> deniedSelves = new HashSet<IMember>();
        HashSet<IMember> deniedAncestors = new HashSet<IMember>();
        this.processQueries(cube, this.grantLookupQueries, grantedSelves, grantedAncestors, SecManager.RuleType.grant_member);
        this.processQueries(cube, this.denyLookupQueries, deniedSelves, deniedAncestors, SecManager.RuleType.deny_member);
        SecViewHierarchyRestriction hierarchyMembersRestriction = new SecViewHierarchyRestriction(grantedSelves, grantedAncestors, deniedSelves, deniedAncestors, this.mIsAllMembersDenied, this.mGrantType);
        SecViewHierarchyRestriction storedUserHierarchyRest = this.hierarchyRestrictionMap.putIfAbsent(userKey, hierarchyMembersRestriction);
        if (storedUserHierarchyRest != null) {
            hierarchyMembersRestriction = storedUserHierarchyRest;
        }
        return hierarchyMembersRestriction;
    }

    public SecViewHierarchyRestriction getUserHierarchyRestriction(String userKey) {
        SecViewHierarchyRestriction hierarchyRestriction = this.hierarchyRestrictionMap.get(userKey);
        return hierarchyRestriction;
    }

    public List<String> getFilterExpressions() {
        ArrayList<String> filterExpList = new ArrayList<String>();
        for (SecurityLookupQuery secQuery : this.grantLookupQueries) {
            filterExpList.add(secQuery.getFilterExpression());
        }
        for (SecurityLookupQuery secQuery : this.denyLookupQueries) {
            filterExpList.add(secQuery.getFilterExpression());
        }
        return filterExpList;
    }
}

