/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.security;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeAction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeNameWrapper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMdSchema;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaView;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecViewDefinitionsFactory;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualSecurityManager;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import java.util.Map;

public class SecurityManagerFactory {
    public SecurityManagerInterface create(ROLAPCubeAction cubeAction, ROLAPBaseCube cube, SecurityManagerInterface currentSecurityManager) {
        if (ROLAPCubeAction.START != cubeAction && ROLAPCubeAction.REFRESH_MEMBER_CACHE != cubeAction && ROLAPCubeAction.REFRESH_SECURITY != cubeAction) {
            return null;
        }
        SecManager secMgr = null;
        if (ROLAPCubeAction.START == cubeAction || currentSecurityManager == null) {
            Map<String, ROLAPMetaView> securityViews = SecViewDefinitionsFactory.getFromLoadedCubeModel(cube);
            secMgr = new SecManager(cube, securityViews);
        } else if (ROLAPCubeAction.REFRESH_MEMBER_CACHE == cubeAction || ROLAPCubeAction.REFRESH_SECURITY == cubeAction) {
            ROLAPMetaMdSchema schemaOriginal = null;
            ROLAPMetaMdSchema schemaReload = null;
            try {
                schemaOriginal = cube.getSchema();
                schemaReload = cube.loadSchema();
            }
            catch (Throwable th) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CubeInitFailed, th, (Object)new ROLAPCubeNameWrapper(cube.getName()));
            }
            if (ROLAPMetaCube.nodesEqual(schemaOriginal, schemaReload)) {
                Map<String, ROLAPMetaView> refreshedSecurityViews = SecViewDefinitionsFactory.getSecurityViewFromRefreshedSchema(schemaReload, cube);
                secMgr = new SecManager(cube, refreshedSecurityViews);
            } else {
                secMgr = ROLAPCubeAction.REFRESH_SECURITY == cubeAction ? new SecManager((SecManager)currentSecurityManager, false) : new SecManager((SecManager)currentSecurityManager, true);
                cube.getMessages().addMessage(XQEMessageKeys.RLU_SecurityRefreshOnlyUserMapping);
                ROLAPLog.logWarn("ROLAPCubes.Security", "Security views and rules have not been refreshed since the cube model has been significantly changed; therefore only security user mappings have been refreshed");
            }
        }
        return secMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityManagerInterface create(ROLAPCubeAction cubeAction, ROLAPVirtualCube cube) {
        if (ROLAPCubeAction.START != cubeAction && ROLAPCubeAction.REFRESH_MEMBER_CACHE != cubeAction && ROLAPCubeAction.REFRESH_SECURITY != cubeAction) {
            return null;
        }
        ROLAPVirtualSecurityManager secMgr = null;
        ROLAPCube[] sourceCubes = cube.getSourceCubes();
        ROLAPCubeReservation[] res = ROLAPVirtualCube.reserveSourceCubes(sourceCubes);
        try {
            secMgr = new ROLAPVirtualSecurityManager(cube, sourceCubes);
        }
        finally {
            ROLAPVirtualCube.unreserveSourceCubes(res);
        }
        return secMgr;
    }
}

