/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.tool;

import com.cognos.developer.schemas.bibus._3.AccessEnum;
import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.Group;
import com.cognos.developer.schemas.bibus._3.Permission;
import com.cognos.developer.schemas.bibus._3.Role;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;

public class SecurityPolicySpec {
    private static final String SINGLE_QUOTE = "'";
    private String securityObject = null;
    private SecurityObjectType securityObjectType;
    private AccessType access = AccessType.deny;

    public SecurityPolicySpec(String securityObj, SecurityObjectType securityObjType, AccessType policyAccess) {
        this.securityObject = securityObj.replaceAll("&quot;", SINGLE_QUOTE).replaceAll("\"", SINGLE_QUOTE);
        this.securityObjectType = securityObjType;
        this.access = policyAccess;
    }

    public String getSecurityObject() {
        return this.securityObject;
    }

    public SecurityObjectType getSecurityObjectType() {
        return this.securityObjectType;
    }

    public AccessType getAccess() {
        return this.access;
    }

    public BaseClass createCMSecurityObject() {
        Object securityObj = null;
        securityObj = this.getSecurityObjectType() == SecurityObjectType.Group ? new Group() : (this.getSecurityObjectType() == SecurityObjectType.Role ? new Role() : new Account());
        StringProp secObjSearchPath = new StringProp();
        secObjSearchPath.setValue(this.getSecurityObject());
        securityObj.setSearchPath(secObjSearchPath);
        return securityObj;
    }

    public Permission createCMPermissionObject() {
        Permission pmn = new Permission();
        pmn.setName("read");
        if (this.access == AccessType.grant) {
            pmn.setAccess(AccessEnum.grant);
        } else {
            pmn.setAccess(AccessEnum.deny);
        }
        return pmn;
    }

    public static enum AccessType {
        grant,
        deny;


        public static AccessType getAccessType(String typeName) {
            if (typeName.equalsIgnoreCase(grant.toString())) {
                return grant;
            }
            return deny;
        }
    }

    public static enum SecurityObjectType {
        Account,
        Group,
        Role;


        public static SecurityObjectType getObjectType(String typeName) throws Exception {
            if (typeName.equalsIgnoreCase(Role.toString()) || typeName.equalsIgnoreCase("com.cognos.developer.schemas.bibus._3.Role")) {
                return Role;
            }
            if (typeName.equalsIgnoreCase(Group.toString()) || typeName.equalsIgnoreCase("com.cognos.developer.schemas.bibus._3.Group")) {
                return Group;
            }
            if (typeName.equalsIgnoreCase(Account.toString()) || typeName.equalsIgnoreCase("com.cognos.developer.schemas.bibus._3.Account") || typeName.equalsIgnoreCase("com.cognos.developer.schemas.bibus._3.Nil")) {
                return Account;
            }
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolInvalidSecurityObjectType, typeName);
        }
    }
}

