/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.mdx.XMdxElement;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ICalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetConfiguration;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetFactory;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.CrossJoinTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SingleHierarchySimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.AggregateMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.IAggregateMeasure;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAggregationRule;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.util.OrdinalMath;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.ArrayCast;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.MapCast;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.primitive.ArrayListInt;
import com.cognos.xqe.util.primitive.HashSetInt;
import com.cognos.xqe.util.primitive.LongArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.MultiValueMap;

public class AggregationUtils {
    private static final String NONE = "none";
    private static final String COLUMN_PREFIX = "[column";
    private static final String DATASTREAM_COLMUN_PREFIX = "[dataStream].[column";
    private static final String REF_MEASURE = "RefMeasure";
    private static final String COLUMN_REF_LEVEL = "columnRefLevel";

    public static Object executeCalculatedMemberSet(CalculatedMember cm, CrossJoinedSet calcSet, InterpreterContext interpreterContext) throws InterpreterException {
        boolean isUserDefined;
        IMember cmParent = cm.getParent();
        boolean bl = isUserDefined = cm.getType() == MemberTypeEnum.SESSION_CALCULATION || cm.getType() == MemberTypeEnum.QUERY_CALCULATION;
        if (cmParent == null || !isUserDefined || MemberOperations.applySecurityToMember(cmParent, interpreterContext) != null) {
            ResultSetConfiguration config = interpreterContext.getResultSetConfiguration();
            boolean pipeEnable = config.setSupportPipelineProcessing(false);
            boolean defer = interpreterContext.isDeferredGettingValue();
            if (defer) {
                interpreterContext.setDeferredGettingValue(false);
            }
            IResultSet rs = cm.fetchTupleValues(calcSet, interpreterContext);
            interpreterContext.setDeferredGettingValue(defer);
            config.setSupportPipelineProcessing(pipeEnable);
            rs = ResultSetFactory.ensureInstanceSupportsRandomAccess(rs);
            Object result = AggregationUtils.consumeAggregateContext(rs, interpreterContext);
            if (result instanceof TextValue && ((TextValue)result).equals(TextValue.ERROR_VALUE) && rs.size() == 1L) {
                Cell cell = rs.getCellAtOrdinal(0L);
                if (cell != null) {
                    return cell.getObjectValue();
                }
                return rs.getDefaultValue();
            }
            return result;
        }
        return DataValueFactory.createNullValue();
    }

    public static IResultSet addAggregateContext(InterpreterContext interpreterCxt, IResultSet rs) throws InterpreterException {
        CrossJoinedSet contextSet = interpreterCxt.getContextSet();
        int hierIndex = AggregationUtils.getAggregateMemberHierarchyIndex(contextSet);
        if (hierIndex == -1) {
            return rs;
        }
        rs = ResultSetFactory.ensureInstanceSupportsRandomAccess(rs);
        int index = -1;
        IIterator it = contextSet.iterator();
        CrossJoinedSet rsSet = rs.getAxisCrossJoinedSet();
        Boolean needReorder = null;
        AggregateMember lastAggMember = null;
        while (it.hasNext()) {
            Tuple tuple = (Tuple)it.next();
            ++index;
            IMember m = tuple.getMember(hierIndex);
            if (!m.isCalculatedMember() || !((CalculatedMember)m).isAggregateMember()) continue;
            ITuple aggTuple = ((com.cognos.xqe.runtree.olap.mdx.interpreter.Set)rsSet).getTuple(index);
            if (needReorder == null || m != lastAggMember) {
                needReorder = ((AggregateMember)m).tupleNeedsReorder(aggTuple);
                lastAggMember = (AggregateMember)m;
            }
            if (needReorder.booleanValue()) {
                aggTuple = ((AggregateMember)m).orderTuple(aggTuple);
            }
            ((AggregateMember)m).addTuple((Tuple)aggTuple);
            Cell cell = rs.getCellAtOrdinal(index);
            if (cell == null) continue;
            ((AggregateMember)m).addValue((Value)cell.getObjectValue());
        }
        return rs;
    }

    public static void addAggregateContext(InterpreterContext interpreterContext, LongArrayList extAggSetsOrdinalsSurrogateIds, com.cognos.xqe.runtree.olap.mdx.interpreter.Set[] extAggregateSets, Value[] extAggregateValues) throws InterpreterException {
        OrdinalMath ordinalMath = interpreterContext.getOrdinalMath();
        CrossJoinedSet contextSet = interpreterContext.getContextSet();
        int hierIndex = AggregationUtils.getAggregateMemberHierarchyIndex(contextSet);
        if (hierIndex == -1) {
            return;
        }
        int index = 0;
        IIterator it = contextSet.iterator();
        long nextOrdinalSurrogateId = 0L;
        while (it.hasNext() && index < extAggregateSets.length) {
            Tuple tuple = (Tuple)it.next();
            if (ordinalMath.compare(nextOrdinalSurrogateId, extAggSetsOrdinalsSurrogateIds.get(index)) < 0) {
                nextOrdinalSurrogateId = ordinalMath.add(nextOrdinalSurrogateId, 1L);
                continue;
            }
            nextOrdinalSurrogateId = ordinalMath.add(nextOrdinalSurrogateId, 1L);
            IMember m = tuple.getMember(hierIndex);
            if (m.isCalculatedMember() && ((CalculatedMember)m).isAggregateMember()) {
                if (extAggregateSets[index] != null) {
                    ((AggregateMember)m).addTuples(extAggregateSets[index], interpreterContext);
                }
                if (extAggregateValues[index] != null && !extAggregateValues[index].isNull()) {
                    ((AggregateMember)m).addValue(extAggregateValues[index]);
                }
            }
            ++index;
        }
    }

    private static boolean equalValues(Object o1, Cell o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 == o2.getObjectValue()) {
            return true;
        }
        return o1.equals(o2.getObjectValue());
    }

    public static int getIndexOfHighestSolveOrder(ArrayList<AggregateMember> aggregateMembers) {
        int solveOrder = -1;
        int indexHighestSolveOrder = -1;
        for (int j = 0; j < aggregateMembers.size(); ++j) {
            if (aggregateMembers.get(j).getSolveOrder() <= solveOrder) continue;
            solveOrder = aggregateMembers.get(j).getSolveOrder();
            indexHighestSolveOrder = j;
        }
        return indexHighestSolveOrder;
    }

    public static int getAggregateMemberHierarchyIndex(com.cognos.xqe.runtree.olap.mdx.interpreter.Set contextSet) throws InterpreterException {
        Tuple tup = (Tuple)contextSet.getTuple(0L);
        ArrayList<AggregateMember> aggMembers = tup.getAggregateMembers();
        int hierIndex = -1;
        int index = AggregationUtils.getIndexOfHighestSolveOrder(aggMembers);
        if (index != -1) {
            hierIndex = contextSet.getHierarchyIndex(aggMembers.get(index).getHierarchy());
        }
        return hierIndex;
    }

    public static Object evaluateCalculatedMembersTuple(CalculatedMember calculatedMember, CrossJoinedSet calcSet, InterpreterContext interpreterContext) {
        boolean isUserDefined;
        IMember cmParent = calculatedMember.getParent();
        boolean bl = isUserDefined = calculatedMember.getType() == MemberTypeEnum.SESSION_CALCULATION || calculatedMember.getType() == MemberTypeEnum.QUERY_CALCULATION;
        if (cmParent == null || !isUserDefined || MemberOperations.applySecurityToMember(cmParent, interpreterContext) != null) {
            Object calcMemResult;
            block7: {
                calcMemResult = null;
                try {
                    XMdxNode xNode = (XMdxNode)calculatedMember.getRuntreeCalculatedMember().getChild(0);
                    if (AggregationUtils.isSimpleTupleNode(xNode, interpreterContext, XMdxElement.SIMPLE_METAFUNCTIONS)) {
                        XDataContext dataContext = interpreterContext.getXDataContext();
                        calcMemResult = ((CubicsValue)xNode.execute(dataContext)).getCubicsObject();
                        if (calcMemResult instanceof Block) {
                            calcMemResult = ((Block)calcMemResult).first();
                        }
                        break block7;
                    }
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (calcMemResult instanceof IMember) {
                return new Tuple((IMember)calcMemResult);
            }
            if (calcMemResult instanceof Tuple) {
                return calcMemResult;
            }
        }
        return null;
    }

    public static boolean isSimpleTupleNode(IXQEQueryNode node, InterpreterContext interpreterContext, List<String> invalidFunctionNames) {
        boolean returnVal = true;
        IXQEQueryNode[] children = node.getChildren();
        ICalculationEngine calculationEngine = interpreterContext.getCalculationEngine();
        for (int i = 0; i < children.length; ++i) {
            XNode x = (XNode)children[i];
            if (x.getType() == 501059) {
                String identifier = ((XMdxElement)x).getValue();
                if (invalidFunctionNames.contains(identifier)) {
                    return false;
                }
                if (calculationEngine.findCalculatedMember(identifier) != null) {
                    return false;
                }
                if (calculationEngine.getNamedSet(identifier) != null) {
                    return false;
                }
                if (((XMdxElement)x).hasExpressionList()) {
                    return false;
                }
            } else {
                if (x.getType() == 501074 || x.getType() == 501062 || x.getType() == 501067 || x.getType() == 501055 || x.getType() == 501056 || x.getType() == 501089 || x.getType() == 501063 || x.getType() == 501068 || x.getType() == 501076 || x.getType() == 501073 || x.getType() == 501127 || x.getType() == 501061) {
                    return false;
                }
                returnVal = AggregationUtils.isSimpleTupleNode(x, interpreterContext, invalidFunctionNames);
            }
            if (returnVal) continue;
            return returnVal;
        }
        return returnVal;
    }

    public static boolean executeCalculationSet(InterpreterContext interpreterContext, com.cognos.xqe.runtree.olap.mdx.interpreter.Set[] aggSets, Value[] aggValues) throws InterpreterException {
        int iteration;
        boolean modifiedAtLeastOneSet = false;
        int maxIterations = 100;
        boolean[] calculationSets = new boolean[aggSets.length];
        boolean resolvedCalcDuringPreviousIteration = true;
        for (iteration = 0; AggregationUtils.determineCalculationSets(aggSets, calculationSets) && resolvedCalcDuringPreviousIteration && iteration < 100; ++iteration) {
            resolvedCalcDuringPreviousIteration = AggregationUtils.executeHighestSOCalc(interpreterContext, calculationSets, aggSets, aggValues);
            if (!resolvedCalcDuringPreviousIteration) continue;
            modifiedAtLeastOneSet = true;
        }
        if (iteration >= 100) {
            for (int i = 0; i < aggSets.length; ++i) {
                if (!calculationSets[i]) continue;
                aggValues[i] = TextValue.ERROR_VALUE;
                aggSets[i] = null;
                modifiedAtLeastOneSet = true;
            }
        }
        return modifiedAtLeastOneSet;
    }

    private static boolean executeHighestSOCalc(InterpreterContext interpreterContext, boolean[] calculationSets, com.cognos.xqe.runtree.olap.mdx.interpreter.Set[] aggSets, Value[] aggValues) throws InterpreterException {
        boolean resolvedCalc = false;
        CalculationEngine ce = new CalculationEngine();
        for (int i = 0; i < aggSets.length; ++i) {
            if (!calculationSets[i]) continue;
            CrossJoinedSet cjs = new CrossJoinedSet(new com.cognos.xqe.runtree.olap.mdx.interpreter.Set[]{aggSets[i]});
            ce.initialize(interpreterContext);
            ce.populateBaseAndCalculationSets(cjs, interpreterContext.getCube());
            Map calculatedMemberToSet = MapCast.uncheckedCast(ce.getCalculatedMemberToSet());
            if (ce.getBaseSet() != null && !ce.getBaseSet().isEmpty()) {
                aggValues[i] = TextValue.ERROR_VALUE;
                aggSets[i] = null;
                resolvedCalc = true;
                continue;
            }
            Set keySet = calculatedMemberToSet.keySet();
            if (keySet.size() != 1) {
                aggValues[i] = TextValue.ERROR_VALUE;
                aggSets[i] = null;
                resolvedCalc = true;
                continue;
            }
            CalculatedMember calculatedMember = (CalculatedMember)keySet.iterator().next();
            if (MemberOperations.applySecurityToMember(calculatedMember, interpreterContext) == null) continue;
            CrossJoinedSet calcSet = (CrossJoinedSet)calculatedMemberToSet.get(calculatedMember);
            calcSet = AggregationUtils.initializeAggregateContext(calcSet, calculatedMember);
            Object result = AggregationUtils.executeCalculatedMemberSet(calculatedMember, calcSet, interpreterContext);
            resolvedCalc = true;
            if (result instanceof com.cognos.xqe.runtree.olap.mdx.interpreter.Set) {
                aggSets[i] = (com.cognos.xqe.runtree.olap.mdx.interpreter.Set)result;
                if (!aggSets[i].isEmpty()) continue;
                aggSets[i] = null;
                continue;
            }
            if (!(result instanceof Value)) continue;
            aggValues[i] = (Value)result;
            aggSets[i] = null;
        }
        return resolvedCalc;
    }

    private static CrossJoinedSet initializeAggregateContext(CrossJoinedSet calcSet, CalculatedMember calculatedMember) throws InterpreterException {
        int hierIndex = calcSet.getHierarchyIndex(calculatedMember.getHierarchy());
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        IIterator calcSetIt = calcSet.iterator();
        while (calcSetIt.hasNext()) {
            Tuple tuple = (Tuple)calcSetIt.next();
            if (tuple.getMember(hierIndex) != calculatedMember) {
                return calcSet;
            }
            AggregateMember aggMember = new AggregateMember(calculatedMember, calcSet.getHierarchies());
            tuple.replaceMember(hierIndex, aggMember);
            tuples.add(tuple);
        }
        calcSet = new CrossJoinedSet(new com.cognos.xqe.runtree.olap.mdx.interpreter.Set[]{new com.cognos.xqe.runtree.olap.mdx.interpreter.Set(tuples.toArray(new Tuple[tuples.size()]))});
        return calcSet;
    }

    private static Object consumeAggregateContext(IResultSet rs, InterpreterContext interpreterContext) throws InterpreterException {
        boolean dmrCube = false;
        if (interpreterContext.getCube() instanceof DMRCube) {
            dmrCube = true;
        }
        CrossJoinedSet rsSet = rs.getAxisCrossJoinedSet();
        IIterator rsSetIter = rsSet.iterator();
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        long ordinal = 0L;
        while (rsSetIter.hasNext()) {
            ArrayList<Tuple> aggregateTuples;
            Tuple t = (Tuple)rsSetIter.next();
            ArrayList<AggregateMember> aggregateMembers = t.getAggregateMembers();
            if (aggregateMembers.size() == 1) {
                if (aggregateMembers.get(0).resultsInErrorCell() || !AggregationUtils.equalValues(aggregateMembers.get(0).getValue(), rs.getCellAtOrdinal(ordinal))) {
                    return TextValue.ERROR_VALUE;
                }
                aggregateTuples = aggregateMembers.get(0).getTuples();
                if (aggregateTuples.isEmpty() && aggregateMembers.get(0).getValue() != null) {
                    return TextValue.ERROR_VALUE;
                }
                if (dmrCube) {
                    Dimension measuresDim = (Dimension)interpreterContext.getCube().getMeasuresHierarchy().getDimension();
                    CrossJoinedSet contextSet = interpreterContext.getContextSet();
                    IMember[] measures = ((com.cognos.xqe.runtree.olap.mdx.interpreter.Set)contextSet).getMembers(measuresDim);
                    com.cognos.xqe.runtree.olap.mdx.interpreter.Set s = new com.cognos.xqe.runtree.olap.mdx.interpreter.Set(aggregateTuples.toArray(new Tuple[aggregateTuples.size()]));
                    if (AggregationUtils.haveMembersOutOfMeasureScope(s, interpreterContext, measures, new ArrayList<IMember>(0))) {
                        return TextValue.ERROR_VALUE;
                    }
                }
            } else {
                return TextValue.ERROR_VALUE;
            }
            tuples.addAll(aggregateTuples);
            ++ordinal;
        }
        return new com.cognos.xqe.runtree.olap.mdx.interpreter.Set(tuples.toArray(new Tuple[tuples.size()]));
    }

    public static V5ValueSummaryFunction buildAggregateExpression(PlanningEnvironment planEnv, IXQEQueryNode selection, IXQEQueryNode dataItem, List<IMetadata> projectedColumns, Map<IMetadata, Integer> metadataToPosition, IAggregateMeasure measure, List<IMetadata> levelAggrFor) {
        ICube cube = measure.getDimension().getCube();
        XQENodeFactory nodeFactory = planEnv.getNodeFactory();
        String dataItemName = (String)dataItem.getPropertyValue("name");
        V5ValueSummaryFunction aggrExpression = null;
        IAggregateRule[] rules = measure.getAggregateRules();
        String measureAggregate = measure.getV5AggregateAttribute();
        if (AggregationUtils.isNoneCalculatedOrAutomaticAggregate(measureAggregate)) {
            measureAggregate = measure.getV5AggregateForModelAggregate();
        }
        String origMeasureAggregate = measureAggregate;
        AggregationMethodEnum aggMethod = AggregationMethodEnum.aggregationMethod(measure.getDescription());
        ArrayList<Level> projMetadataMeasureAggrGrain = new ArrayList<Level>();
        for (int projIdx = 0; projIdx < levelAggrFor.size(); ++projIdx) {
            IMetadata projMetadata = levelAggrFor.get(projIdx);
            if (projMetadata.getObjectType() != MetadataType.LEVEL) continue;
            if (measure instanceof DMRMeasure) {
                DMRLevel scopeToLevel = V5QueryOverTabularStream.getLowestLevelFromScope(measure, (ILevel)projMetadata);
                if (((ILevel)projMetadata).getIndex() <= scopeToLevel.getIndex()) {
                    scopeToLevel = (DMRLevel)projMetadata;
                }
                for (DMRLevel parentLevel : scopeToLevel.getParentLevelToQueryWith()) {
                    projMetadataMeasureAggrGrain.add(parentLevel);
                }
                continue;
            }
            for (ROLAPLevel rolapLevel = (ROLAPLevel)projMetadata; rolapLevel != null && rolapLevel.getMetaLevel() != null; rolapLevel = (ROLAPLevel)rolapLevel.getPreviousLevel()) {
                projMetadataMeasureAggrGrain.add(rolapLevel);
            }
        }
        HashMap<ILevel, String> levelToColumnRefLevel = new HashMap<ILevel, String>();
        int columnIdxRef = 0;
        for (int currentAggregation = -1; currentAggregation < rules.length; ++currentAggregation) {
            int aggrRuleIdx;
            if (aggMethod == AggregationMethodEnum.AGG_METHOD_3 && measure instanceof DMRMeasure && currentAggregation >= 0 && currentAggregation < rules.length - 1 && rules[aggrRuleIdx = currentAggregation + 1].getAggregate() == rules[aggrRuleIdx - 1].getAggregate()) continue;
            ArrayList<ILevel> measureAggrGrain = new ArrayList<ILevel>();
            measureAggrGrain.addAll(projMetadataMeasureAggrGrain);
            for (int aggrRuleIdx2 = currentAggregation + 1; aggrRuleIdx2 < rules.length; ++aggrRuleIdx2) {
                IAggregateRule rule = rules[aggrRuleIdx2];
                IDimension dimensionWithAggrRule = null;
                dimensionWithAggrRule = measure instanceof DMRMeasure ? V5QueryOverTabularStream.getLowestDimensionInContext((DMRCube)cube, levelAggrFor, rule) : cube.getDimension(rule.getDimensionRef());
                int nbrLevel = dimensionWithAggrRule.getLevelCount();
                ILevel projMetadata = dimensionWithAggrRule.getLevel(nbrLevel - 1);
                if (measure instanceof DMRMeasure) {
                    DMRLevel scopeToLevel = V5QueryOverTabularStream.getLowestLevelFromScope(measure, projMetadata);
                    if (projMetadata.getIndex() <= scopeToLevel.getIndex()) {
                        scopeToLevel = (DMRLevel)projMetadata;
                    }
                    for (ILevel iLevel : scopeToLevel.getParentLevelToQueryWith()) {
                        measureAggrGrain.add(iLevel);
                    }
                    continue;
                }
                for (ROLAPLevel rolapLevel = (ROLAPLevel)projMetadata; rolapLevel != null && rolapLevel.getMetaLevel() != null; rolapLevel = (ROLAPLevel)rolapLevel.getPreviousLevel()) {
                    measureAggrGrain.add(rolapLevel);
                }
            }
            V5ValueSummaryFunction currentAggrExpression = (V5ValueSummaryFunction)nodeFactory.createNode(201031);
            boolean bDecomposeDMRCalculatedMeasure = false;
            if (cube instanceof DMRCube) {
                bDecomposeDMRCalculatedMeasure = ((DMRCube)cube).getDecomposeCalculatedMeasure();
            }
            AggregationUtils.convertAggregateNameToV5AggregateFunctionSubtype(planEnv, measure.getUniqueName(), AggregationUtils.getMeasureAggregate(origMeasureAggregate, rules, aggMethod, currentAggregation), currentAggrExpression, measure.getDataType(), bDecomposeDMRCalculatedMeasure);
            if (aggrExpression == null) {
                V5MultiPartIdentifier dataItemIdentifier = (V5MultiPartIdentifier)nodeFactory.createNode(201030);
                currentAggrExpression.addChild(dataItemIdentifier);
                String dataItemRefName = dataItemName + REF_MEASURE;
                dataItemIdentifier.setIdentifier('[' + dataItemRefName + ']');
                IXQEQueryNode dataItemRefMeasure = nodeFactory.createNode(101003);
                dataItemRefMeasure.setPropertyValue("name", dataItemRefName);
                selection.addChild(dataItemRefMeasure);
                IXQEQueryNode expression = nodeFactory.createNode(101004);
                dataItemRefMeasure.addChild(expression);
                if (metadataToPosition.size() > 0) {
                    int pos = metadataToPosition.get(measure);
                    expression.setPropertyValue("expression", DATASTREAM_COLMUN_PREFIX + pos + ']');
                } else {
                    expression.setPropertyValue("expression", measure.getQueryItemExpression(planEnv));
                }
            } else {
                currentAggrExpression.addChild(aggrExpression);
            }
            V5AggregateBreakClause forClause = (V5AggregateBreakClause)nodeFactory.createNode(201037);
            currentAggrExpression.addChild(forClause);
            HashSet<String> alreadyAddedExpression = new HashSet<String>();
            for (ILevel forLevel : measureAggrGrain) {
                String levelExpression;
                if (measure instanceof DMRMeasure && alreadyAddedExpression.contains(levelExpression = ((DMRLevel)forLevel).getQueryItemExpressionForKey())) continue;
                V5MultiPartIdentifier dataItemIdentifier = (V5MultiPartIdentifier)nodeFactory.createNode(201030);
                forClause.addChild(dataItemIdentifier);
                int n = projectedColumns.indexOf(forLevel);
                if (n >= 0) {
                    if (measure instanceof DMRMeasure) {
                        dataItemIdentifier.setIdentifier(COLUMN_PREFIX + n + ']');
                        String levelExpression2 = ((DMRLevel)forLevel).getQueryItemExpressionForKey();
                        alreadyAddedExpression.add(levelExpression2);
                        continue;
                    }
                    dataItemIdentifier.setIdentifier('[' + ((ROLAPLevel)projectedColumns.get(n)).getMetaLevel().getLevelKeys().get(0).getName() + ']');
                    continue;
                }
                String dataItemRefLevelName = (String)levelToColumnRefLevel.get(forLevel);
                if (dataItemRefLevelName == null && measure instanceof DMRMeasure) {
                    String levelExpression3 = ((DMRLevel)forLevel).getQueryItemExpressionForKey();
                    alreadyAddedExpression.add(levelExpression3);
                    dataItemRefLevelName = DMRUtilities.findDataItem(selection, levelExpression3);
                }
                if (dataItemRefLevelName == null) {
                    dataItemRefLevelName = COLUMN_REF_LEVEL + columnIdxRef++;
                    levelToColumnRefLevel.put(forLevel, dataItemRefLevelName);
                    IXQEQueryNode dataItemRefLevel = nodeFactory.createNode(101003);
                    dataItemRefLevel.setPropertyValue("name", dataItemRefLevelName);
                    selection.addChild(dataItemRefLevel);
                    IXQEQueryNode expression = nodeFactory.createNode(101004);
                    dataItemRefLevel.addChild(expression);
                    if (metadataToPosition.size() > 0) {
                        int pos = metadataToPosition.get(forLevel);
                        expression.setPropertyValue("expression", DATASTREAM_COLMUN_PREFIX + pos + ']');
                    } else {
                        String levelExpression4 = null;
                        if (measure instanceof DMRMeasure) {
                            levelExpression4 = ((DMRLevel)forLevel).getQueryItemExpressionForKey();
                        } else {
                            ROLAPMetaAttribute levelKeyAttrib = ((ROLAPLevel)forLevel).getMetaLevel().getLevelKeys().get(0);
                            levelExpression4 = levelKeyAttrib.getQueryItem();
                        }
                        expression.setPropertyValue("expression", levelExpression4);
                    }
                }
                dataItemIdentifier.setIdentifier('[' + dataItemRefLevelName + ']');
            }
            aggrExpression = currentAggrExpression;
        }
        return aggrExpression;
    }

    private static String getMeasureAggregate(String measureAggregate, IAggregateRule[] rules, AggregationMethodEnum aggMethod, int currentAggregation) {
        switch (aggMethod) {
            case AGG_METHOD_1: {
                if (currentAggregation < 0) {
                    return measureAggregate;
                }
                return rules[currentAggregation].getAggregate().toV5Type();
            }
            case AGG_METHOD_2: 
            case AGG_METHOD_3: {
                if (currentAggregation == rules.length - 1) {
                    return measureAggregate;
                }
                return rules[currentAggregation + 1].getAggregate().toV5Type();
            }
        }
        return null;
    }

    public static V5ValueSummaryFunction buildAggregateExpression(PlanningEnvironment planEnv, IXQEQueryNode selection, IXQEQueryNode dataItem, List<ROLAPMetaAttribute> projectedColumns, IAggregateMeasure measure) {
        ICube cube = measure.getDimension().getCube();
        XQENodeFactory nodeFactory = planEnv.getNodeFactory();
        String dataItemName = (String)dataItem.getPropertyValue("name");
        V5ValueSummaryFunction aggrExpression = null;
        IAggregateRule[] rules = measure.getAggregateRules();
        String measureAggregate = measure.getV5AggregateAttribute();
        if (AggregationUtils.isNoneCalculatedOrAutomaticAggregate(measureAggregate)) {
            measureAggregate = measure.getV5AggregateForModelAggregate();
        }
        ArrayList<ROLAPMetaAttribute> projMetadataMeasureAggrGrain = new ArrayList<ROLAPMetaAttribute>();
        projMetadataMeasureAggrGrain.addAll(projectedColumns);
        HashMap<ROLAPMetaAttribute, String> columnToDataItemRef = new HashMap<ROLAPMetaAttribute, String>();
        int columnIdxRef = 0;
        for (int currentAggregation = -1; currentAggregation < rules.length; ++currentAggregation) {
            ArrayList<ROLAPMetaAttribute> measureAggrGrain = new ArrayList<ROLAPMetaAttribute>();
            measureAggrGrain.addAll(projMetadataMeasureAggrGrain);
            for (int aggrRuleIdx = currentAggregation + 1; aggrRuleIdx < rules.length; ++aggrRuleIdx) {
                IAggregateRule rule = rules[aggrRuleIdx];
                String[] dimReferences = ((ROLAPAggregationRule)rule).getDimensionRefs();
                if (dimReferences == null) continue;
                for (String dimRef : dimReferences) {
                    IDimension aggrRuleDimension = cube.getDimension(dimRef);
                    if (aggrRuleDimension == null) continue;
                    ROLAPMetaLevel metaLevel = null;
                    ROLAPMetaDimension metaDim = ((ROLAPDimension)aggrRuleDimension).getMetaDimension();
                    if (metaDim != null) {
                        metaLevel = metaDim.getConvergenceLevel();
                    }
                    if (metaLevel == null) {
                        int nbrLevel = aggrRuleDimension.getLevelCount();
                        ROLAPLevel projLevel = (ROLAPLevel)aggrRuleDimension.getLevel(nbrLevel - 1);
                        metaLevel = projLevel.getMetaLevel();
                    }
                    measureAggrGrain.addAll(metaLevel.getLevelKeys());
                }
            }
            V5ValueSummaryFunction currentAggrExpression = (V5ValueSummaryFunction)nodeFactory.createNode(201031);
            AggregationUtils.convertAggregateNameToV5AggregateFunctionSubtype(planEnv, measure.getUniqueName(), measureAggregate, currentAggrExpression, measure.getDataType());
            if (aggrExpression == null) {
                V5MultiPartIdentifier dataItemIdentifier = (V5MultiPartIdentifier)nodeFactory.createNode(201030);
                currentAggrExpression.addChild(dataItemIdentifier);
                String dataItemRefName = dataItemName + REF_MEASURE;
                dataItemIdentifier.setIdentifier('[' + dataItemRefName + ']');
                IXQEQueryNode dataItemRefMeasure = nodeFactory.createNode(101003);
                dataItemRefMeasure.setPropertyValue("name", dataItemRefName);
                selection.addChild(dataItemRefMeasure);
                IXQEQueryNode expression = nodeFactory.createNode(101004);
                dataItemRefMeasure.addChild(expression);
                expression.setPropertyValue("expression", measure.getQueryItemExpression(planEnv));
            } else {
                currentAggrExpression.addChild(aggrExpression);
            }
            V5AggregateBreakClause forClause = (V5AggregateBreakClause)nodeFactory.createNode(201037);
            currentAggrExpression.addChild(forClause);
            for (ROLAPMetaAttribute forColumn : measureAggrGrain) {
                V5MultiPartIdentifier dataItemIdentifier = (V5MultiPartIdentifier)nodeFactory.createNode(201030);
                forClause.addChild(dataItemIdentifier);
                int projectedPos = projectedColumns.indexOf(forColumn);
                if (projectedPos >= 0) {
                    dataItemIdentifier.setIdentifier('[' + projectedColumns.get(projectedPos).getParentQualifiedQueryName() + ']');
                    continue;
                }
                String dataItemRefName = (String)columnToDataItemRef.get(forColumn);
                if (dataItemRefName == null) {
                    dataItemRefName = COLUMN_REF_LEVEL + columnIdxRef++;
                    columnToDataItemRef.put(forColumn, dataItemRefName);
                    IXQEQueryNode dataItemRef = nodeFactory.createNode(101003);
                    dataItemRef.setPropertyValue("name", dataItemRefName);
                    selection.addChild(dataItemRef);
                    IXQEQueryNode expression = nodeFactory.createNode(101004);
                    dataItemRef.addChild(expression);
                    String columnExpression = forColumn.getQueryItem();
                    expression.setPropertyValue("expression", columnExpression);
                }
                dataItemIdentifier.setIdentifier('[' + dataItemRefName + ']');
            }
            if (currentAggregation + 1 < rules.length) {
                measureAggregate = rules[currentAggregation + 1].getAggregate().toV5Type();
            }
            aggrExpression = currentAggrExpression;
        }
        return aggrExpression;
    }

    public static boolean isNoneCalculatedOrAutomaticAggregate(String aggregate) {
        return aggregate == null || aggregate.equals(NONE) || aggregate.equals("calculated") || aggregate.equals("automatic");
    }

    public static void convertAggregateNameToV5AggregateFunctionSubtype(PlanningEnvironment planningEnvironment, String itemName, String aggregateName, V5ValueSummaryFunction v5Node, IDataType dataType) {
        AggregationUtils.convertAggregateNameToV5AggregateFunctionSubtype(planningEnvironment, itemName, aggregateName, v5Node, dataType, false);
    }

    public static void convertAggregateNameToV5AggregateFunctionSubtype(PlanningEnvironment planningEnvironment, String itemName, String aggregateName, V5ValueSummaryFunction v5Node, IDataType dataType, boolean setDecomposeFlag) {
        Pair v5AggregateFunctionSubtype = AggregationUtils.convertAggregateNameToV5AggregateFunctionSubtype(aggregateName, dataType);
        Integer aggSubType = (Integer)v5AggregateFunctionSubtype.getFirst();
        v5Node.setSubType(aggSubType);
        v5Node.setDistinct((Boolean)v5AggregateFunctionSubtype.getSecond());
        if (setDecomposeFlag && "calculated".equals(aggregateName) && aggSubType == 0) {
            v5Node.setPropertyValue("calculated", Boolean.TRUE);
        }
        if (aggregateName.equals(AggregateTypeEnum.UNSUPPORTED.toV5Type()) || aggregateName.equals(AggregateTypeEnum.UNKNOWN.toV5Type()) || aggregateName.equals("notApplicable")) {
            RQPUtilities.appendDefaultToAutomaticWarningMessage(planningEnvironment, itemName, v5Node);
        }
    }

    public static Pair convertAggregateNameToV5AggregateFunctionSubtype(String aggregateName, IDataType dataType) {
        int subtype = 9;
        boolean distinct = false;
        if (aggregateName.equals("sum") || aggregateName.equals("total")) {
            subtype = 9;
        } else if (aggregateName.equals("count")) {
            subtype = 2;
        } else if (aggregateName.equals("countDistinct") || aggregateName.equals("countdistinct")) {
            subtype = 2;
            distinct = true;
        } else if (aggregateName.equals("min") || aggregateName.equals("minimum") || aggregateName.equals(NONE) || aggregateName.equals("first")) {
            subtype = 6;
        } else if (aggregateName.equals("max") || aggregateName.equals("maximum") || aggregateName.equals("last")) {
            subtype = 4;
        } else if (aggregateName.equals("avg") || aggregateName.equals("average")) {
            subtype = 1;
        } else if (aggregateName.equals("median")) {
            subtype = 5;
        } else if (aggregateName.equals("standardDeviation") || aggregateName.equals("standarddeviation")) {
            subtype = 7;
        } else if (aggregateName.equals("variance")) {
            subtype = 10;
        } else if (aggregateName.equals("calculated")) {
            subtype = 0;
        } else if (aggregateName.equals(AggregateTypeEnum.UNSUPPORTED.toV5Type()) || aggregateName.equals(AggregateTypeEnum.UNKNOWN.toV5Type()) || aggregateName.equals("notApplicable")) {
            subtype = RQPUtilities.getDefaultAggregateBasedOnDataType(dataType);
        }
        return new Pair(subtype, distinct);
    }

    public static boolean determineCalculationSets(com.cognos.xqe.runtree.olap.mdx.interpreter.Set[] aggSets, boolean[] calculationSets) {
        int aggSetIndex = 0;
        boolean containsCalcSet = false;
        while (aggSetIndex < aggSets.length) {
            calculationSets[aggSetIndex] = false;
            if (aggSets[aggSetIndex] == null) {
                ++aggSetIndex;
                continue;
            }
            IIterator tupleIter = aggSets[aggSetIndex].iterator();
            while (tupleIter.hasNext()) {
                Tuple tuple = (Tuple)tupleIter.next();
                if (!tuple.containsCalculation()) continue;
                calculationSets[aggSetIndex] = true;
                containsCalcSet = true;
                break;
            }
            ++aggSetIndex;
        }
        return containsCalcSet;
    }

    public static boolean haveMembersOutOfMeasureScope(com.cognos.xqe.runtree.olap.mdx.interpreter.Set set, InterpreterContext interpreterContext, IMember[] measures, List<IMember> scopeMembers) throws InterpreterException {
        if (!(interpreterContext.getCube() instanceof DMRCube)) {
            return false;
        }
        if (set == null) {
            return false;
        }
        IDimension[] setDimensions = set.getDimensions();
        if (setDimensions.length == 0) {
            return false;
        }
        Tuple tuple = (Tuple)set.getTuple(0L);
        for (int j = 0; j < setDimensions.length; ++j) {
            for (int k = 0; k < measures.length; ++k) {
                int memberLevelInd;
                IMember member;
                ILevel memberLevel;
                DMRLevel scopeLevel;
                int scopeLevelInd;
                if (measures[k] instanceof CalculatedMember || ((DMRMeasure)measures[k]).isManual() || (scopeLevelInd = (scopeLevel = V5QueryOverTabularStream.getLowestLevelFromScope((IMeasure)measures[k], memberLevel = (member = tuple.getMember(setDimensions[j])).getLevel())).getIndex()) >= (memberLevelInd = memberLevel.getIndex())) continue;
                IMember scopeMember = member;
                while (scopeLevelInd < memberLevelInd && (scopeMember = scopeMember.getParent()) != null) {
                    memberLevelInd = scopeMember.getLevel().getIndex();
                }
                if (scopeMember == null) continue;
                scopeMembers.add(scopeMember);
            }
        }
        return !scopeMembers.isEmpty();
    }

    public static boolean checkMembersHaveSameParent(com.cognos.xqe.runtree.olap.mdx.interpreter.Set aggregateSet) {
        if (aggregateSet == null) {
            return false;
        }
        IHierarchy[] setHierarchies = aggregateSet.getHierarchies();
        if (setHierarchies.length == 0) {
            return false;
        }
        for (int j = 0; j < setHierarchies.length; ++j) {
            IMember[] members = aggregateSet.getMembers(setHierarchies[j]);
            IMember parent = null;
            for (IMember member : members) {
                if (parent == null) {
                    parent = member.getParent();
                    continue;
                }
                if (member.getParent().equals(parent)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean sameLevel(IMember[] members) {
        ILevel level = null;
        for (IMember member : members) {
            if (level == null) {
                level = member.getLevel();
                continue;
            }
            if (member.getLevel().equals(level)) continue;
            return false;
        }
        return true;
    }

    public static HashSet<ILevel> getAggregateLevels(com.cognos.xqe.runtree.olap.mdx.interpreter.Set aggregateSet) {
        int i;
        HashSet<ILevel> aggregateLevels = new HashSet<ILevel>();
        IHierarchy[] hiers = aggregateSet.getHierarchies();
        HashSet[] levelsSets = new HashSet[hiers.length];
        HashSet[] membersSets = new HashSet[hiers.length];
        for (int i2 = 0; i2 < membersSets.length; ++i2) {
            membersSets[i2] = new HashSet();
            levelsSets[i2] = new HashSet();
        }
        IIterator it = aggregateSet.iterator();
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            for (i = 0; i < t.size(); ++i) {
                IMember member = t.getMember(i);
                membersSets[i].add(member);
                levelsSets[i].add(member.getLevel());
            }
        }
        int[] hierCardinality = new int[hiers.length];
        for (i = 0; i < membersSets.length; ++i) {
            hierCardinality[i] = membersSets[i].size();
        }
        for (i = 0; i < hierCardinality.length; ++i) {
            if (hierCardinality[i] <= 1) continue;
            aggregateLevels.addAll(levelsSets[i]);
        }
        return aggregateLevels;
    }

    public static List<ArrayListInt> findDifferentSelections(int selectionXIndex, Object[][] allSelections, HashSetInt selectionsCombined) {
        List<Object> thisSelection = Arrays.asList(allSelections[selectionXIndex]);
        ArrayList<ArrayListInt> differentSelections = new ArrayList<ArrayListInt>();
        for (int j = 0; j < allSelections.length; ++j) {
            ArrayListInt differentColumns = new ArrayListInt();
            if (allSelections[j] == null) {
                differentSelections.add(differentColumns);
                continue;
            }
            if (!selectionsCombined.contains(j)) {
                block1: for (int k = 0; k < thisSelection.size(); ++k) {
                    if (thisSelection.get(k) instanceof IMember && allSelections[j][k] instanceof ArrayList || thisSelection.get(k) instanceof ArrayList && allSelections[j][k] instanceof IMember) {
                        differentColumns.add(k);
                        continue;
                    }
                    if (thisSelection.get(k) instanceof IMember && allSelections[j][k] instanceof IMember) {
                        if ((IMember)thisSelection.get(k) == (IMember)allSelections[j][k]) continue;
                        differentColumns.add(k);
                        continue;
                    }
                    if (((List)thisSelection.get(k)).size() != ((List)allSelections[j][k]).size()) {
                        differentColumns.add(k);
                        continue;
                    }
                    Iterator membersIt = CollectionCast.uncheckedCast((List)allSelections[j][k]).iterator();
                    List column = CollectionCast.uncheckedCast((List)thisSelection.get(k));
                    while (membersIt.hasNext()) {
                        if (column.contains(membersIt.next())) continue;
                        differentColumns.add(k);
                        continue block1;
                    }
                }
            }
            differentSelections.add(differentColumns);
        }
        return differentSelections;
    }

    public static List<List<Object>> getSelectionCombinations(com.cognos.xqe.runtree.olap.mdx.interpreter.Set[] aggSets, HashSet<ILevel> aggregateLevels, List<IHierarchy> hierarchies, MultiValueMap combinationToSetIndex) {
        return AggregationUtils.getSelectionCombinations(null, aggSets, aggregateLevels, hierarchies, combinationToSetIndex);
    }

    public static List<List<Object>> getSelectionCombinations(ICube cube, com.cognos.xqe.runtree.olap.mdx.interpreter.Set[] aggSets, HashSet<ILevel> aggregateLevels, List<IHierarchy> hierarchies, MultiValueMap combinationToSetIndex) {
        ArrayList<List<Object>> combinations = new ArrayList<List<Object>>();
        Object[][] selectionsByHierarchy = AggregationUtils.getSelectionsByHierarchies(cube, aggSets, hierarchies);
        HashSetInt selectionsAlreadyCombined = new HashSetInt();
        for (int i = 0; i < selectionsByHierarchy.length; ++i) {
            if (selectionsByHierarchy[i] == null || selectionsAlreadyCombined.contains(i)) continue;
            List<Object> combination = Arrays.asList(selectionsByHierarchy[i]);
            selectionsAlreadyCombined.add(i);
            combinations.add(combination);
            combinationToSetIndex.put((Object)(combinations.size() - 1), (Object)i);
            List<ArrayListInt> differentSelections = AggregationUtils.findDifferentSelections(i, selectionsByHierarchy, selectionsAlreadyCombined);
            int[] oneDifferentCounter = new int[hierarchies.size()];
            for (int k = 0; k < differentSelections.size(); ++k) {
                if (differentSelections.get(k).size() != 1) continue;
                int n = differentSelections.get(k).get(0);
                oneDifferentCounter[n] = oneDifferentCounter[n] + 1;
            }
            int optimalHierarchy = 0;
            int maxCount = 0;
            for (int k = 0; k < oneDifferentCounter.length; ++k) {
                if (oneDifferentCounter[k] <= maxCount) continue;
                optimalHierarchy = k;
                maxCount = oneDifferentCounter[k];
            }
            AggregationUtils.addSetSelectionsToCombination(selectionsByHierarchy, selectionsAlreadyCombined, combinations, combinationToSetIndex, aggregateLevels, differentSelections, optimalHierarchy);
        }
        return combinations;
    }

    public static com.cognos.xqe.runtree.olap.mdx.interpreter.Set getAggregateSet(com.cognos.xqe.runtree.olap.mdx.interpreter.Set aSet, IHierarchy[] aggHierarchies) {
        ArrayList<ITupleList> childTupleLists = new ArrayList<ITupleList>();
        for (IHierarchy hier : aggHierarchies) {
            childTupleLists.add(SingleHierarchySimpleTupleList.construct(aSet.getMembers(hier)));
        }
        com.cognos.xqe.runtree.olap.mdx.interpreter.Set aggregateSet = new com.cognos.xqe.runtree.olap.mdx.interpreter.Set(CrossJoinTupleList.construct(childTupleLists));
        return aggregateSet;
    }

    public static HashMap<com.cognos.xqe.runtree.olap.mdx.interpreter.Set, List<List<Tuple>>> getExecutionSets(com.cognos.xqe.runtree.olap.mdx.interpreter.Set[] aggSets, IHierarchy[] aggHierarchies) {
        if (aggHierarchies.length == 0) {
            return null;
        }
        HashMap<com.cognos.xqe.runtree.olap.mdx.interpreter.Set, List<List<Tuple>>> executionSets = new HashMap<com.cognos.xqe.runtree.olap.mdx.interpreter.Set, List<List<Tuple>>>();
        for (com.cognos.xqe.runtree.olap.mdx.interpreter.Set aSet : aggSets) {
            com.cognos.xqe.runtree.olap.mdx.interpreter.Set aggregateSet;
            if (aSet == null || (aggregateSet = AggregationUtils.getAggregateSet(aSet, aggHierarchies)).isEmpty()) continue;
            com.cognos.xqe.runtree.olap.mdx.interpreter.Set contextSet = new com.cognos.xqe.runtree.olap.mdx.interpreter.Set(((com.cognos.xqe.runtree.olap.mdx.interpreter.Set)aSet.removeHierarchies(aggHierarchies, false)).getTupleList());
            if (contextSet.size() > 1L) {
                return null;
            }
            Tuple contextTuple = (Tuple)contextSet.getTuple(0L);
            List<List<Tuple>> contextSets = executionSets.get(aggregateSet);
            if (contextSets == null) {
                contextSets = new ArrayList<List<Tuple>>();
                ArrayList<Tuple> aContextSet = new ArrayList<Tuple>();
                aContextSet.add(contextTuple);
                contextSets.add(aContextSet);
            } else {
                boolean bMatchedSameLevelContextSet = false;
                for (List<Tuple> aContextSet : contextSets) {
                    boolean bSameLevel = true;
                    Tuple tuple = aContextSet.get(0);
                    for (IHierarchy tupleHier : tuple.getHierarchies()) {
                        ILevel level = contextTuple.getMember(tupleHier).getLevel();
                        if (level.equals(tuple.getMember(tupleHier).getLevel())) continue;
                        bSameLevel = false;
                        break;
                    }
                    if (!bSameLevel) continue;
                    aContextSet.add(contextTuple);
                    bMatchedSameLevelContextSet = true;
                    break;
                }
                if (!bMatchedSameLevelContextSet) {
                    List<Tuple> aContextSet;
                    aContextSet = new ArrayList<Tuple>();
                    aContextSet.add(contextTuple);
                    contextSets.add(aContextSet);
                }
            }
            executionSets.put(aggregateSet, contextSets);
        }
        return executionSets;
    }

    private static void addSetSelectionsToCombination(Object[][] selectionsByHierarchy, HashSetInt selectionsAlreadyCombined, List<List<Object>> combinations, MultiValueMap combinationToSetIndex, HashSet<ILevel> aggregateLevels, List<ArrayListInt> differentSelections, int optimalHierarchy) {
        int currentCombinationInd = combinations.size() - 1;
        List<Object> currentCombination = combinations.get(currentCombinationInd);
        for (int selection = 0; selection < differentSelections.size(); ++selection) {
            if (differentSelections.get(selection).size() != 1 || differentSelections.get(selection).get(0) != optimalHierarchy) continue;
            int hierarchyInd = differentSelections.get(selection).get(0);
            boolean combine = true;
            if (selectionsByHierarchy[selection][hierarchyInd] instanceof IMember) {
                IMember member0;
                IMember selectionMember = (IMember)selectionsByHierarchy[selection][hierarchyInd];
                if (selectionMember instanceof IMeasure || aggregateLevels.contains(selectionMember.getLevel())) break;
                if (currentCombination.get(hierarchyInd) instanceof ArrayList) {
                    member0 = (IMember)((ArrayList)currentCombination.get(hierarchyInd)).get(0);
                    if (member0.getLevel() == selectionMember.getLevel()) {
                        ((List)currentCombination.get(hierarchyInd)).add(selectionMember);
                    } else {
                        combine = false;
                    }
                } else {
                    member0 = (IMember)currentCombination.get(hierarchyInd);
                    if (member0.getLevel() == selectionMember.getLevel()) {
                        ArrayList<IMember> list = new ArrayList<IMember>();
                        list.add(member0);
                        list.add(selectionMember);
                        currentCombination.set(hierarchyInd, list);
                    } else {
                        combine = false;
                    }
                }
            } else {
                IMember member0;
                IMember member1;
                List selections = (List)selectionsByHierarchy[selection][hierarchyInd];
                if (selections.size() > 0 && aggregateLevels.contains((member1 = (IMember)selections.get(0)).getLevel())) break;
                for (IMember member : selections) {
                    if (currentCombination.get(hierarchyInd) instanceof List) {
                        member0 = (IMember)((List)currentCombination.get(hierarchyInd)).get(0);
                        if (member0.getLevel() == member.getLevel()) continue;
                        combine = false;
                        break;
                    }
                    member0 = (IMember)currentCombination.get(hierarchyInd);
                    if (member0.getLevel() == member.getLevel()) continue;
                    combine = false;
                    break;
                }
                if (!combine) continue;
                for (IMember member : selections) {
                    if (currentCombination.get(hierarchyInd) instanceof List) {
                        if (((List)currentCombination.get(hierarchyInd)).contains(member)) continue;
                        List list = (List)currentCombination.get(hierarchyInd);
                        list.add(member);
                        currentCombination.set(hierarchyInd, list);
                        continue;
                    }
                    member0 = (IMember)currentCombination.get(hierarchyInd);
                    ArrayList<IMember> list = new ArrayList<IMember>();
                    list.add(member0);
                    if (!list.contains(member)) {
                        list.add(member);
                    }
                    currentCombination.set(hierarchyInd, list);
                }
            }
            if (!combine) continue;
            combinationToSetIndex.put((Object)currentCombinationInd, (Object)selection);
            selectionsAlreadyCombined.add(selection);
        }
    }

    private static Object[][] getSelectionsByHierarchies(ICube cube, com.cognos.xqe.runtree.olap.mdx.interpreter.Set[] aggSets, List<IHierarchy> hierarchies) {
        Object[][] selectionsByHierarchy = (Object[][])ArrayCast.uncheckedCast(new Object[aggSets.length][hierarchies.size()]);
        for (int j = 0; j < aggSets.length; ++j) {
            if (aggSets[j] != null && !aggSets[j].isEmpty()) {
                aggSets[j] = aggSets[j].removeInvalidTuples(cube, null);
            }
            if (aggSets[j] == null || aggSets[j].isEmpty()) {
                selectionsByHierarchy[j] = null;
                continue;
            }
            for (int i = 0; i < hierarchies.size(); ++i) {
                IHierarchy hier = hierarchies.get(i);
                IMember[] mems = aggSets[j].getMembers(hier);
                selectionsByHierarchy[j][i] = mems.length == 1 ? mems[0] : new ArrayList<IMember>(Arrays.asList(mems));
            }
        }
        return selectionsByHierarchy;
    }

    public static boolean areMembersAtSameLevels(Tuple tuple1, Tuple tuple2) {
        IHierarchy[] hierarchies;
        if (tuple1.getHierarchies().length != tuple2.getHierarchies().length) {
            return false;
        }
        for (IHierarchy hierarchy : hierarchies = tuple1.getHierarchies()) {
            IMember member1 = tuple1.getMember(hierarchy);
            ILevel level1 = member1.getLevel();
            ILevel level2 = null;
            IMember member2 = tuple2.getMember(hierarchy);
            if (member2 != null) {
                level2 = member2.getLevel();
            }
            if (level1.equals(level2)) continue;
            return false;
        }
        return true;
    }

    private static enum AggregationMethodEnum {
        AGG_METHOD_1,
        AGG_METHOD_2,
        AGG_METHOD_3;


        public static AggregationMethodEnum aggregationMethod(String descr) {
            AggregationMethodEnum aggMethod = AGG_METHOD_1;
            if (descr != null) {
                if (descr.contains("method=2")) {
                    aggMethod = AGG_METHOD_2;
                } else if (descr.contains("method=3")) {
                    aggMethod = AGG_METHOD_3;
                }
            }
            return aggMethod;
        }
    }
}

