/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLSetOperator;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5QueryOperation;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class RolapV5Builder {
    private static final String ALL_ROWS = "allRows";
    private static final String QFPROVIDERTYPE_VALUE = "XQEQueryProvider";

    public static V5Query addQueryNode(XQENodeFactory nodeFactory, V5QuerySet v5QuerySet, String queryName) {
        V5Query query = (V5Query)nodeFactory.createNode(101006);
        query.setPropertyValue("name", queryName);
        query.setPropertyValue(V5Query.QueryHint.EXECUTION_OPTIMIZATION.getPropertyName(), ALL_ROWS);
        query.setPropertyValue(V5Query.QueryHint.QUERY_PROCESSING.getPropertyName(), "minimizeLocal");
        query.setPropertyValue(V5Query.QueryHint.LOCAL_CACHE.getPropertyName(), false);
        query.setPropertyValue("containsQueryHint", true);
        query.setPropertyValue("relationalSubquerySource", V5Query.RelationalSubquerySource.ROLAP.getName());
        v5QuerySet.addChild(query);
        return query;
    }

    public static IXQEQueryNode addRelationalSourceNode(XQENodeFactory nodeFactory, IXQEQueryNode query) {
        IXQEQueryNode source = RolapV5Builder.addSourceNode(nodeFactory, query);
        source.setPropertyValue("relational", true);
        return source;
    }

    public static IXQEQueryNode addSourceNode(XQENodeFactory nodeFactory, IXQEQueryNode query) {
        IXQEQueryNode source = nodeFactory.createNode(101007);
        query.addChild(source);
        return source;
    }

    public static IXQEQueryNode addUnionQueryNode(XQENodeFactory nodeFactory, V5QuerySet v5QuerySet, boolean preserveDuplicates, List<IXQEQueryNode> projectionDataItems, Map<String, String> projDataItemNameToAggType, IXQEQueryNode groupBody, IXQEQueryNode ... queries) {
        String unionQueryName = RolapV5Builder.getUnionQueryName(queries);
        V5Query unionQuery = RolapV5Builder.addQueryNode(nodeFactory, v5QuerySet, unionQueryName);
        IXQEQueryNode source = RolapV5Builder.addSourceNode(nodeFactory, unionQuery);
        String queryOperationName = RolapV5Builder.getUnionOperationName(queries);
        RolapV5Builder.addUnionQueryOperation(nodeFactory, preserveDuplicates, projectionDataItems, source, queryOperationName, queries);
        IXQEQueryNode selection = RolapV5Builder.addSelectionNode(nodeFactory, unionQuery, true);
        for (IXQEQueryNode projectedItem : projectionDataItems) {
            String projectedItemName = (String)projectedItem.getPropertyValue("name");
            String projectedItemExpression = UniqueNameGenerator.createUniqueName(queryOperationName, projectedItemName);
            String aggrType = projDataItemNameToAggType.get(projectedItemName);
            RolapV5Builder.addDataItem(nodeFactory, selection, groupBody, projectedItemName, projectedItemExpression, aggrType);
        }
        return unionQuery;
    }

    public static void addUnionQueryOperation(XQENodeFactory nodeFactory, boolean preserveDuplicates, List<IXQEQueryNode> projectionDataItems, IXQEQueryNode source, String queryOperationName, IXQEQueryNode ... queries) {
        V5QueryOperation queryOperation = (V5QueryOperation)nodeFactory.createNode(101018);
        source.addChild(queryOperation);
        queryOperation.setPropertyValue("name", queryOperationName);
        queryOperation.setPropertyValue("setOperation", SQLSetOperator.SubType.UNION.key().toUpperCase());
        queryOperation.setDuplicatesPreserve(preserveDuplicates);
        for (IXQEQueryNode query : queries) {
            IXQEQueryNode queryRef = nodeFactory.createNode(101023);
            queryRef.setPropertyValue("refQuery", query.getPropertyValue("name"));
            queryOperation.addChild(queryRef);
        }
        IXQEQueryNode projectionList = nodeFactory.createNode(101020);
        queryOperation.addChild(projectionList);
        projectionList.setPropertyValue("autoGenerated", true);
        for (IXQEQueryNode projectedItem : projectionDataItems) {
            IXQEQueryNode queryItem = nodeFactory.createNode(101022);
            projectionList.addChild(queryItem);
            queryItem.setPropertyValue("name", projectedItem.getPropertyValue("name"));
        }
    }

    public static String concatenateQueryNames(IXQEQueryNode ... queries) {
        StringBuilder unionQueryNames = new StringBuilder();
        for (IXQEQueryNode query : queries) {
            unionQueryNames.append(query.getPropertyValue("name"));
        }
        return unionQueryNames.toString();
    }

    public static String getUnionQueryName(IXQEQueryNode ... queries) {
        return "UnionQuery:" + RolapV5Builder.concatenateQueryNames(queries);
    }

    public static String getUnionOperationName(IXQEQueryNode ... queries) {
        return "UnionOp:" + RolapV5Builder.concatenateQueryNames(queries);
    }

    public static IXQEQueryNode addSelectionNode(XQENodeFactory nodeFactory, IXQEQueryNode query, boolean autoSummary) {
        IXQEQueryNode selection = nodeFactory.createNode(101009);
        selection.setPropertyValue("autoSummary", autoSummary);
        query.addChild(selection);
        return selection;
    }

    public static IXQEQueryNode addRelationalQuerySelection(XQENodeFactory nodeFactory, V5QuerySet v5QuerySet, String queryName) {
        V5Query query = RolapV5Builder.addQueryNode(nodeFactory, v5QuerySet, queryName);
        IXQEQueryNode selection = RolapV5Builder.addSelectionNode(nodeFactory, query, true);
        RolapV5Builder.addRelationalSourceNode(nodeFactory, query);
        return selection;
    }

    public static V5ValueSet buildAndInsertQRD(XQENodeFactory nodeFactory, V5QuerySet v5QuerySet, String queryName, IXQEQueryNode groupBody) {
        IXQEQueryNode qrd = nodeFactory.createNode(101055);
        qrd.setPropertyValue("name", queryName);
        qrd.setPropertyValue("refQuery", queryName);
        v5QuerySet.addChild(qrd);
        IXQEQueryNode edge = nodeFactory.createNode(101049);
        edge.setPropertyValue("name", queryName);
        qrd.addChild(edge);
        IXQEQueryNode edgeGroup = nodeFactory.createNode(101050);
        edge.addChild(edgeGroup);
        V5ValueSet valueSet = (V5ValueSet)nodeFactory.createNode(101057);
        valueSet.setNameProperty(queryName);
        valueSet.addChild(groupBody);
        edgeGroup.addChild(valueSet);
        return valueSet;
    }

    public static IXQEQueryNode addGroupBodyNode(XQENodeFactory nodeFactory, String queryName) {
        IXQEQueryNode groupBody = nodeFactory.createNode(101051);
        groupBody.setPropertyValue("name", queryName);
        return groupBody;
    }

    public static void setV5QuerySetProperties(PlanningEnvironment planEnv, String modelPath, V5QuerySet v5QuerySet) {
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        v5QuerySet.setPropertyValue("expressionLocale", LocaleConverter.localeToStr(reqEnv.getExpressionLocale()));
        v5QuerySet.setPropertyValue("modelPath", modelPath);
        reqEnv.setModelPathIfNotSet(modelPath);
    }

    public static V5QuerySet addNewV5QuerySetToPlanner(PlanningEnvironment planEnv, String modelPath, XQENodeFactory nodeFactory) {
        V5QuerySet v5QuerySet = (V5QuerySet)nodeFactory.createV5Node("querySet");
        planEnv.getNodeIndex().addNode(v5QuerySet);
        RolapV5Builder.setV5QuerySetProperties(planEnv, modelPath, v5QuerySet);
        return v5QuerySet;
    }

    public static void addDataItem(XQENodeFactory nodeFactory, IXQEQueryNode selection, IXQEQueryNode groupBody, String dataItemName, String dataItemExpression, String aggregateType) {
        IXQEQueryNode dataItem = nodeFactory.createNode(101003);
        dataItem.setPropertyValue("name", dataItemName);
        if (aggregateType != null) {
            dataItem.setPropertyValue("aggregate", aggregateType);
        }
        selection.addChild(dataItem);
        IXQEQueryNode expression = nodeFactory.createNode(101004);
        expression.setPropertyValue("expression", dataItemExpression);
        dataItem.addChild(expression);
        if (groupBody != null) {
            IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", dataItemName);
            groupBody.addChild(dataItemRef);
        }
    }

    public static void addDetailFilterForStringExpression(XQENodeFactory nodeFactory, V5Query query, String expression) {
        V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
        detailFilter.setPostAutoAggregation(false);
        query.addChild(detailFilter);
        IXQEQueryNode filterExpression = nodeFactory.createNode(101013);
        filterExpression.setPropertyValue("expression", expression);
        detailFilter.addChild(filterExpression);
    }

    public static void setupConnectionElement(ExecutionEnvironment execEnv) {
        if (null == execEnv.getConnectionElement()) {
            RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
            Element connectionElement = DocumentHelper.createElement((String)"connection");
            RolapV5Builder.addElement(connectionElement, "QFProviderType", "value", QFPROVIDERTYPE_VALUE);
            RolapV5Builder.addElement(connectionElement, "productLocale", "value", LocaleConverter.localeToStr(reqEnv.getProductLocale()));
            RolapV5Builder.addElement(connectionElement, "runLocale", "value", LocaleConverter.localeToStr(reqEnv.getRunLocale()));
            execEnv.setConnectionElement(connectionElement);
        }
    }

    private static void addElement(Element parentElement, String childElementName, String childAttributeName, String childAttributeValue) {
        Element childElement = DocumentHelper.createElement((String)childElementName);
        childElement.addAttribute(childAttributeName, childAttributeValue);
        parentElement.add(childElement);
    }

    public static void setRequestEnvironmentCubeInfo(RequestEnvironment reqEnv, ROLAPCube cube) {
        String currentUserPassport = reqEnv.getCAMUserPassport();
        reqEnv.setCMRequestExecutor(cube.getAccountManager());
        reqEnv.setCubeName(cube.getName());
        reqEnv.setCAMUserPassport(currentUserPassport);
    }
}

