/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.validate;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.validate.AbstractValidationTask;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.validate.RelationalMetadata;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.validate.ValidationTaskResult;
import com.cognos.xqe.util.SingletonHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ValidationManager {
    private static SingletonHelper<ValidationManager> singletonHelper = new SingletonHelper<ValidationManager>(){

        @Override
        protected ValidationManager newInstance() {
            return new ValidationManager();
        }

        @Override
        protected void initializeImpl(ValidationManager theInstance) {
            theInstance.initialize();
        }

        @Override
        protected void releaseImpl(ValidationManager theInstance) {
            theInstance.release();
        }
    };

    public static ValidationManager getInstance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    public List<ValidationTaskResult> validate(ROLAPBaseCube cube, int maxConcurrentTasks) {
        RelationalMetadata relMD = new RelationalMetadata(cube);
        List<AbstractValidationTask> validationTasks = this.createTasks(relMD, cube);
        ExecutorService executorService = this.createExecutorService(validationTasks.size(), maxConcurrentTasks);
        ExecutorCompletionService<ValidationTaskResult> ecs = new ExecutorCompletionService<ValidationTaskResult>(executorService);
        for (AbstractValidationTask task : validationTasks) {
            ecs.submit(task);
        }
        ArrayList<ValidationTaskResult> results = new ArrayList<ValidationTaskResult>();
        int numFailedTasks = 0;
        while (numFailedTasks + results.size() < validationTasks.size()) {
            try {
                results.add((ValidationTaskResult)ecs.take().get());
            }
            catch (InterruptedException e) {
                executorService.shutdownNow();
                ROLAPLog.log("ROLAPCubes.Validation", "Validation was interrrupted.");
                throw new XQERuntimeException(e);
            }
            catch (ExecutionException e) {
                ++numFailedTasks;
                ROLAPLog.logError("ROLAPCubes.Validation", "Validation task failed.", e);
            }
        }
        return results;
    }

    protected ValidationManager() {
    }

    protected void initialize() {
    }

    private void release() {
    }

    protected List<AbstractValidationTask> createTasks(RelationalMetadata relMD, ROLAPBaseCube cube) {
        ArrayList<AbstractValidationTask> tasks = new ArrayList<AbstractValidationTask>();
        return tasks;
    }

    private ExecutorService createExecutorService(int taskCount, int maxTasks) {
        int concurrencyLevel = Math.min(taskCount, maxTasks);
        concurrencyLevel = Math.max(concurrencyLevel, 1);
        return Executors.newFixedThreadPool(concurrencyLevel);
    }
}

