/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAbstractHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.DummyVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.IROLAPVirtualCubeDef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.IROLAPVirtualMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCalculatedMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCalculatedMemberDef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualHierarchyModelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMeasureFolder;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMemberModelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualSecurityManager;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.transformation.rolap.ROLAPUtilities;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.LightweightOrderedMap;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.primitive.HashMapObjectBoolean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ROLAPVirtualHierarchy
extends ROLAPAbstractHierarchy {
    private final boolean twoPartUniqueName;
    private static final String NEWLN = System.getProperty("line.separator");
    private final IROLAPHierarchy[] mSourceHierarchies;
    private IMember mCurrentPeriodMember = null;
    private boolean isCurrentPeriodMemberSet = false;
    private HashMap<String, ROLAPVirtualMemberModelRef> virtualMemberModelRefs;
    private ROLAPAbstractHierarchy mRelativeTimeDefinitionHierarchy = null;

    public ROLAPVirtualHierarchy(IROLAPHierarchy[] hierarchies, String name, ROLAPVirtualDimension dimension, boolean useTwoPartUniqueName, List<ROLAPVirtualCalculatedMemberDef> defs) {
        super(name, dimension);
        this.virtualMemberModelRefs = new HashMap();
        this.mSourceHierarchies = hierarchies;
        this.twoPartUniqueName = useTwoPartUniqueName;
        this.initHierTypeAttributes();
        this.initializeLevels();
        this.initializeCalculatedMembers(defs);
        this.initializeDefaultMember();
        this.createRelativeTimeMembers((IROLAPCube)((Object)dimension.getCube()));
        this.loadMeasureFolders();
        this.warnIfConfigCausesDeadCube();
    }

    public ROLAPVirtualHierarchy(String name, Dimension dimension) {
        super(name, dimension);
        this.mSourceHierarchies = null;
        this.twoPartUniqueName = true;
    }

    private void warnIfConfigCausesDeadCube() {
        IROLAPCube[] sourceCubes = ((IROLAPVirtualCube)((Object)this.getDimension().getCube())).getSourceCubes();
        if (this.mSourceHierarchies.length != sourceCubes.length && this.getROLAPAllMember() == null) {
            HashSet<IROLAPCube> representedCubes = new HashSet<IROLAPCube>(Arrays.asList(sourceCubes));
            for (IROLAPHierarchy sourceHier : this.mSourceHierarchies) {
                if (sourceHier == null) continue;
                representedCubes.remove(sourceHier.getDimension().getCube());
            }
            String newln = System.getProperty(NEWLN);
            StringBuilder message = new StringBuilder("The virtual hierarchy does not have an ALL member ");
            message.append("and does not merge hierarchies from all the source cubes. No queries will be routed to ");
            message.append("the cubes corresponding to the missing source hierarchies. This usually indicates a model error.");
            message.append(newln);
            message.append("Virtual hierarchy: ");
            message.append(this.getUniqueName());
            message.append(newln);
            message.append("Missing hierarchies for cubes:");
            for (IROLAPCube cube : representedCubes) {
                message.append(newln);
                message.append(((Cube)((Object)cube)).getUniqueName());
            }
            ROLAPLog.logWarn("ROLAPCubes.Virtual", message.toString());
        }
    }

    @Override
    protected IMember createCalculatedMember(IROLAPCube cube, String name, IMember parentMember, int relaTimeMemberType, IMember relaTimeRefMember, String expression, ROLAPMetaObject metaMember, Set<String> existingCalcMembers) {
        ROLAPVirtualCalculatedMemberDef def = this.createRelativeTimeCalculatedMemberDef(name, parentMember, relaTimeMemberType, relaTimeRefMember, expression, -1);
        ROLAPCalculatedMember member = (ROLAPCalculatedMember)this.addROLAPVirtualCalculatedMember(def, parentMember, null, relaTimeMemberType, relaTimeRefMember, metaMember);
        return member;
    }

    private ROLAPVirtualCalculatedMemberDef createRelativeTimeCalculatedMemberDef(String name, IMember parentMember, int relaTimeMemberType, IMember relaTimeRefMember, String expression, int solveOrder) {
        ROLAPVirtualCalculatedMemberDef def = new ROLAPVirtualCalculatedMemberDef();
        def.setName(name);
        if (parentMember != null) {
            def.setParentUniqueName(parentMember.getUniqueName());
        }
        if (expression != null) {
            def.setV5Expression(expression);
        } else {
            def.setV5Expression(relaTimeRefMember.getV5UniqueName());
        }
        def.setSolveOrder(solveOrder);
        return def;
    }

    private SecurityManagerInterface getSecurityManager() {
        ROLAPVirtualDimension dimension = (ROLAPVirtualDimension)this.getDimension();
        IROLAPVirtualCube cube = (IROLAPVirtualCube)((Object)dimension.getCube());
        SecurityManagerInterface securityManager = cube.getSecurityManager(cube.getProvider());
        return securityManager;
    }

    @Override
    public IROLAPMember getROLAPAllMember() {
        Level l = (Level)this.getLevel(0);
        if (!l.isAllLevel()) {
            return null;
        }
        IMember allMember = l.getMember(0);
        SecurityManagerInterface securityManager = this.getSecurityManager();
        if (securityManager != null) {
            IMember[] members = new IMember[]{allMember};
            if ((members = securityManager.applySecurity(members, l.getHierarchy())).length == 0) {
                allMember = null;
            }
        }
        return (IROLAPMember)allMember;
    }

    @Override
    public long getROLAPCardinality() {
        long cardinality = 0L;
        int numLevels = this.getLevelCount();
        for (int levelx = 0; levelx < numLevels; ++levelx) {
            cardinality += (long)((ROLAPVirtualLevel)this.getLevel(levelx)).getROLAPCardinality();
        }
        return cardinality;
    }

    @Override
    public int getROLAPDeploymentType() {
        return 16;
    }

    @Override
    public IROLAPDimension getROLAPDimension() {
        return (IROLAPDimension)this.getDimension();
    }

    @Override
    public int getROLAPDimensionType() {
        return this.getROLAPDimension().getROLAPType();
    }

    public int getROLAPHierarchyType() {
        ROLAPVirtualSecurityManager secManager;
        SecurityManagerInterface securityManager = this.getSecurityManager();
        if (securityManager != null && (secManager = (ROLAPVirtualSecurityManager)securityManager).hasRestrictions(this)) {
            return 4;
        }
        if (this.isUnbalanced()) {
            return 4;
        }
        if (this.isRagged()) {
            return 2;
        }
        return 1;
    }

    @Override
    public IROLAPLevel getROLAPLevel(int levelNo) {
        return (IROLAPLevel)this.getLevel(levelNo);
    }

    @Override
    public IROLAPLevel[] getROLAPLevels() {
        Level[] levels = this.getLevels().toArray(new Level[0]);
        IROLAPLevel[] result = new IROLAPLevel[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            result[i] = (IROLAPLevel)((Object)levels[i]);
        }
        return result;
    }

    @Override
    public IROLAPMember[] getROLAPRootMembers(boolean applySecurity) throws Exception {
        SecurityManagerInterface securityManager = this.getSecurityManager();
        ILevel rootLevel = this.getLevel(0);
        ArrayList<IMember> runningList = new ArrayList<IMember>();
        List<IMember> rootLevelMembers = ((Level)rootLevel).getMembers(true, false);
        for (IMemberCubics iMemberCubics : rootLevelMembers) {
            if (iMemberCubics.isFillerMember() || this.isRestricted(iMemberCubics, applySecurity, securityManager)) {
                this.getROLAPRootMembersRecursive(iMemberCubics, runningList, applySecurity, securityManager);
                continue;
            }
            runningList.add(iMemberCubics);
        }
        List<ROLAPCalculatedMember> rootLevelCalcMembers = ((IROLAPLevel)rootLevel).getROLAPCalculatedMembers(true);
        for (ROLAPCalculatedMember mem : rootLevelCalcMembers) {
            if (this.isRestricted(mem, applySecurity, securityManager)) continue;
            runningList.add(mem);
        }
        return runningList.toArray(new IROLAPMember[runningList.size()]);
    }

    private boolean isRestricted(IMemberCubics member, boolean applySecurity, SecurityManagerInterface securityManager) {
        if (applySecurity && securityManager != null) {
            IMember[] members = new IMember[]{member};
            IHierarchy hier = null;
            if (member != null) {
                hier = member.getHierarchy();
            }
            return (members = securityManager.applySecurity(members, hier)).length == 0;
        }
        return false;
    }

    private void getROLAPRootMembersRecursive(IMemberCubics parent, List<IMember> runningList, boolean applySecurity, SecurityManagerInterface securityManager) throws Exception {
        List<IMember> children = parent.getChildren(true);
        for (IMemberCubics iMemberCubics : children) {
            if (iMemberCubics.isFillerMember() || this.isRestricted(iMemberCubics, applySecurity, securityManager)) {
                this.getROLAPRootMembersRecursive(iMemberCubics, runningList, applySecurity, securityManager);
                continue;
            }
            runningList.add(iMemberCubics);
        }
        List<ROLAPCalculatedMember> calcChildren = ((IROLAPMember)parent).getROLAPCalculatedMembers(true);
        for (ROLAPCalculatedMember child : calcChildren) {
            if (this.isRestricted(child, applySecurity, securityManager)) continue;
            runningList.add(child);
        }
    }

    public int getROLAPValueType() {
        return 0;
    }

    @Override
    public List<ROLAPCalculatedMeasure> getROLAPCalculatedMeasures() {
        return null;
    }

    @Override
    public IROLAPMember getDefaultROLAPMember() throws Exception {
        return (IROLAPMember)this.getDefaultMember();
    }

    @Override
    public int getDimNumber() {
        return this.getDimension().getIndex();
    }

    @Override
    public boolean isMeasure() {
        return this.getDimension().isMeasuresDimension();
    }

    public IMember[] getAllMembers() {
        return this.allMembers;
    }

    @Override
    public String getV5UniqueName() {
        return this.getV5UniqueName(null);
    }

    @Override
    public String getV5UniqueName(String cubeName) {
        return UniqueNameGenerator.createROLAPV5UniqueName(cubeName, ROLAPUtilities.getExpressionLocale(this), this);
    }

    @Override
    public String getName(String locale) {
        ROLAPVirtualHierarchyModelRef hierarchyModelRef;
        String localizedName = null;
        IROLAPVirtualCube virtualCube = (IROLAPVirtualCube)((Object)this.getDimension().getCube());
        if (virtualCube.getROLAPVirtualCubeDef() != null && this.isTwoPartUniqueName() && (hierarchyModelRef = virtualCube.getROLAPVirtualCubeDef().getVirtualHierarchyModel(this.getUniqueName())) != null) {
            localizedName = hierarchyModelRef.getName(locale);
        }
        if (localizedName == null) {
            localizedName = this.getName();
        }
        return localizedName;
    }

    private void initializeLevels() {
        IROLAPVirtualCubeDef cubeDef = ((ROLAPVirtualDimension)this.getDimension()).getROLAPVirtualCubeDef();
        HashMap<String, String> fqNameToOutputLevelName = cubeDef.getFqToOutputLevelName();
        int levelCount = 0;
        int maxLevelNo = 0;
        ILevel[][] sourceLevelsForSourceHierarchies = new ILevel[this.mSourceHierarchies.length][];
        for (int srcIdx = 0; srcIdx < this.mSourceHierarchies.length; ++srcIdx) {
            IROLAPHierarchy hierarchy = this.mSourceHierarchies[srcIdx];
            if (hierarchy == null) continue;
            ILevel[] levels = hierarchy.getLevels().toArray(new ILevel[0]);
            if (levels.length > maxLevelNo) {
                maxLevelNo = levels.length;
            }
            sourceLevelsForSourceHierarchies[srcIdx] = levels;
        }
        IROLAPCube[] sourceCubes = ((IROLAPVirtualCube)((Object)this.getDimension().getCube())).getSourceCubes();
        for (int i = 0; i < maxLevelNo; ++i) {
            ILevel[] sourceLevels = new ILevel[sourceCubes.length];
            ArrayList<String> outputLevelNames = new ArrayList<String>();
            for (int srcIdx = 0; srcIdx < sourceLevelsForSourceHierarchies.length; ++srcIdx) {
                ILevel sourceLevel;
                ILevel[] sourceHierarchyLevels = sourceLevelsForSourceHierarchies[srcIdx];
                if (sourceHierarchyLevels == null || i >= sourceHierarchyLevels.length || cubeDef.isSourceLevelHidden((ICube)((Object)sourceCubes[srcIdx]), sourceLevel = sourceHierarchyLevels[i])) continue;
                String fqName = ROLAPVirtualCube.getFullyQualifiedLevelName((ICube)((Object)sourceCubes[srcIdx]), sourceLevel);
                sourceLevels[srcIdx] = sourceLevel;
                String outputName = fqNameToOutputLevelName.get(fqName);
                if (outputName == null) {
                    outputName = sourceLevel.getName();
                }
                boolean bFound = false;
                for (String name : outputLevelNames) {
                    if (!outputName.equalsIgnoreCase(name)) continue;
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                outputLevelNames.add(outputName);
            }
            if (outputLevelNames.isEmpty()) continue;
            String levelName = "";
            for (String name : outputLevelNames) {
                if (levelName.length() != 0) {
                    levelName = levelName + " ";
                }
                levelName = levelName + name;
            }
            new ROLAPVirtualLevel(sourceCubes, sourceLevels, levelName, this);
            ++levelCount;
        }
        if (levelCount == 0) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidModelEmptyHierarchy, this.getDimension().getCube().getUniqueName(), this.getUniqueName());
        }
    }

    public void addMemberDef(String identifier, ROLAPVirtualMemberModelRef memberDef) {
        this.virtualMemberModelRefs.put(identifier, memberDef);
    }

    public ROLAPVirtualMemberModelRef getMemberDefinition(String identifier) {
        return this.virtualMemberModelRefs.get(identifier);
    }

    public IHierarchy[] getSourceHierarchies() {
        return this.mSourceHierarchies;
    }

    private void initializeDefaultMember() {
        IROLAPVirtualCubeDef cubeDef = ((ROLAPVirtualDimension)this.getDimension()).getROLAPVirtualCubeDef();
        HashMap<String, String> fqMemberNameToOutputName = cubeDef.getFqMemberNameToOutputName();
        HashSet<String> hiddenMembers = cubeDef.getHiddenMembers();
        String defaultMbr = cubeDef.getVHierarchyUniqueNameToDefaultMember().get(this.getUniqueName());
        if (defaultMbr == null) {
            for (int srcIdx = 0; srcIdx < this.mSourceHierarchies.length; ++srcIdx) {
                IROLAPHierarchy hierarchy = this.mSourceHierarchies[srcIdx];
                if (hierarchy != null) {
                    ICube sourceCube = (ICube)((Object)((IROLAPVirtualCube)((Object)this.getDimension().getCube())).getSourceCubes()[srcIdx]);
                    String defaultMun = hierarchy.getDefaultMember().getUniqueName();
                    try {
                        String[] elements = UniqueNameParser.parse(defaultMun);
                        String fqMemberName = ROLAPVirtualCube.getFullyQualifiedUniqueName(sourceCube, (IMetadata)hierarchy.getDefaultMember());
                        if (!hiddenMembers.contains(fqMemberName)) {
                            String[] vhElements = UniqueNameParser.parse(this.getUniqueName());
                            for (int i = 0; i < vhElements.length; ++i) {
                                elements[i] = vhElements[i];
                            }
                            String virtualMemberName = fqMemberNameToOutputName.get(fqMemberName);
                            if (virtualMemberName != null) {
                                elements[elements.length - 1] = virtualMemberName;
                            }
                        }
                        defaultMbr = UniqueNameGenerator.createUniqueName(elements);
                    }
                    catch (UniqueNameParserException e) {
                        throw new XQERuntimeException(e);
                    }
                }
                if (defaultMbr != null) break;
            }
        }
        if (defaultMbr == null) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_DefaultMemberException, "\"\"");
        }
        if (defaultMbr != null && defaultMbr.length() > 0) {
            String fqDefaultMbr = defaultMbr;
            if (!UniqueNameGenerator.hasOutterBraces(defaultMbr)) {
                fqDefaultMbr = UniqueNameGenerator.createUniqueName(defaultMbr);
            }
            if (!defaultMbr.startsWith(this.getUniqueName())) {
                fqDefaultMbr = UniqueNameGenerator.join(this.getUniqueName(), fqDefaultMbr);
            }
            IMember mbr = null;
            IROLAPVirtualCube cube = (IROLAPVirtualCube)((Object)this.getDimension().getCube());
            mbr = cube.getCalculatedMember(fqDefaultMbr);
            if (mbr == null) {
                mbr = this.findMember(defaultMbr);
            }
            this.setDefaultMember(mbr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOrderedMap<IMember> fetchFirstLevelMembers() throws MetadataException, ProviderException {
        String useOldVCMeasureMUN = System.getProperty("useOldVCMeasureMUN");
        boolean bUseOldVCMeasureMUN = false;
        if (useOldVCMeasureMUN != null) {
            bUseOldVCMeasureMUN = true;
        }
        IROLAPVirtualCubeDef cubeDef = ((ROLAPVirtualDimension)this.getDimension()).getROLAPVirtualCubeDef();
        ROLAPVirtualLevel level0 = (ROLAPVirtualLevel)this.getLevel(0);
        LightweightOrderedMap<IMember> result = new LightweightOrderedMap<IMember>();
        HashMapObjectBoolean<String> outputNameToIsVisible = null;
        HashMap<String, String> outputNameToFormat = null;
        if (this.isMeasure()) {
            outputNameToIsVisible = cubeDef.getOutputNameToIsVisible();
            outputNameToFormat = cubeDef.getOutputNameToFormat();
        }
        HashSet<String> hiddenMembers = cubeDef.getHiddenMembers();
        HashMap<String, String> fnNameToOutputName = cubeDef.getFqMemberNameToOutputName();
        IROLAPCube[] sourceCubes = cubeDef.getSourceCubes();
        HashMap<String, ROLAPVirtualMemberModelRef> membersDef = cubeDef.getVirtualMemberModel();
        ROLAPVirtualMemberModelRef memberDef = null;
        HashMap<String, IMember[]> memberMap = new HashMap<String, IMember[]>();
        ArrayList<String> orderedNameList = new ArrayList<String>();
        HashMap<String, String> captions = new HashMap<String, String>();
        HashMap<String, String> fqNames = new HashMap<String, String>();
        HashMap<String, StringBuilder> identifiers = new HashMap<String, StringBuilder>();
        boolean isCubingServicesCompatible = cubeDef.isCubingServicesCompatible();
        for (int srcIdx = 0; srcIdx < this.mSourceHierarchies.length; ++srcIdx) {
            IROLAPHierarchy hierarchy = this.mSourceHierarchies[srcIdx];
            if (hierarchy == null) continue;
            ICube sourceCube = (ICube)((Object)sourceCubes[srcIdx]);
            String previousCurrentCubeName = ROLAPContext.getCurrentCubeName();
            ROLAPContext.removeCurrentCubeName(previousCurrentCubeName != null);
            ROLAPContext.setCurrentCubeName(sourceCube.getName());
            try {
                IMember[] haMembers;
                Level baseLevel = (Level)hierarchy.getLevel(0);
                if (cubeDef.isSourceLevelHidden(sourceCube, baseLevel)) continue;
                for (IMember member : haMembers = baseLevel.getMembers(false, this.isMeasure()).toArray(new IMember[0])) {
                    String outputName;
                    String fqName = ROLAPVirtualCube.getFullyQualifiedUniqueName(sourceCube, (IMetadata)member);
                    if (hiddenMembers.contains(fqName) || ROLAPVirtualHierarchy.isCalculatedMember(member)) continue;
                    String caption = outputName = fnNameToOutputName.get(fqName);
                    if (outputName == null) {
                        boolean outputNameIsVisible;
                        outputName = member.getName();
                        caption = member.getCaption();
                        if (member.isMeasure() && (outputNameIsVisible = outputNameToIsVisible.get(outputName))) {
                            boolean memberIsVisible = ((IROLAPMeasure)member).isVisible();
                            outputNameToIsVisible.put(outputName, memberIsVisible);
                        }
                    } else if (!(isCubingServicesCompatible || !bUseOldVCMeasureMUN && this.getDimension().isMeasuresDimension())) {
                        String memberIdentifier = member.getName();
                        StringBuilder fullIdentifier = (StringBuilder)identifiers.get(outputName);
                        if (fullIdentifier == null) {
                            fullIdentifier = new StringBuilder(memberIdentifier);
                        } else if (!fullIdentifier.toString().equals(memberIdentifier)) {
                            fullIdentifier.append("?").append(memberIdentifier);
                        }
                        identifiers.put(outputName, fullIdentifier);
                        memberDef = membersDef.get(fqName);
                        if (memberDef != null) {
                            this.addMemberDef(fullIdentifier.toString(), memberDef);
                        }
                    } else if (!isCubingServicesCompatible && (memberDef = membersDef.get(fqName)) != null) {
                        this.addMemberDef(outputName, memberDef);
                    }
                    fqNames.put(outputName, fqName);
                    captions.put(outputName, caption);
                    IMember[] sourceMembers = (IMember[])memberMap.get(outputName);
                    if (sourceMembers == null) {
                        sourceMembers = new IMember[sourceCubes.length];
                        memberMap.put(outputName, sourceMembers);
                        orderedNameList.add(outputName);
                    }
                    sourceMembers[srcIdx] = member;
                }
                continue;
            }
            finally {
                ROLAPContext.removeCurrentCubeName(true);
                if (previousCurrentCubeName != null) {
                    ROLAPContext.setCurrentCubeName(previousCurrentCubeName);
                }
            }
        }
        ArrayList<ROLAPVirtualMemberProxy> mems = new ArrayList<ROLAPVirtualMemberProxy>();
        for (String outputName : orderedNameList) {
            StringBuilder sbIdentifier;
            IMember[] sourceMembers = (IMember[])memberMap.get(outputName);
            IROLAPVirtualMember virtualMember = null;
            MetadataCacheKey cacheKey = null;
            String identifier = outputName;
            if (!isCubingServicesCompatible && (sbIdentifier = (StringBuilder)identifiers.get(outputName)) != null) {
                identifier = sbIdentifier.toString();
            }
            IROLAPVirtualCube cube = (IROLAPVirtualCube)((Object)this.getDimension().getCube());
            cacheKey = cube.cacheVirtualMemberData(sourceMembers, identifier, level0, null, identifier);
            if (!this.isMeasure()) {
                virtualMember = ROLAPVirtualCube.useVirtualMemberProxy() ? new ROLAPVirtualMemberProxy(cacheKey, identifier, level0, null, sourceMembers) : new ROLAPVirtualMember(cacheKey, sourceMembers, identifier, level0, (String)captions.get(outputName));
            } else {
                boolean memberIsVisible = outputNameToIsVisible.get(outputName);
                String formatString = outputNameToFormat.get(outputName);
                FormatId formatId = ROLAPMetaMeasure.generateFormatId(formatString);
                AggregateTypeEnum aggType = ROLAPVirtualHierarchy.determineAggregateType(sourceMembers, cubeDef.getMergeOperator());
                ArrayList<IAggregateRule> rules = ROLAPVirtualHierarchy.determineAggregateRules(sourceMembers, cubeDef);
                virtualMember = new ROLAPVirtualMeasure(cacheKey, sourceMembers, identifier, level0, (String)captions.get(outputName), memberIsVisible, aggType, rules, formatId);
                if (ROLAPCubeManager.getInstance().getConfig().isVCFirstLastAggregateRulesEnabled() && ROLAPLog.isOn("ROLAPCubes.Virtual", LogLevel.TRACE)) {
                    ROLAPLog.logTrace("ROLAPCubes.Virtual", String.format("First/Last aggregation rules for the virtual member " + virtualMember.getUniqueName() + ": ", new Object[0]));
                    for (IAggregateRule rule : rules) {
                        ROLAPLog.logTrace("ROLAPCubes.Virtual", " ... " + rule.toString());
                    }
                }
            }
            mems.add((ROLAPVirtualMemberProxy)virtualMember);
        }
        result.retainAll(mems);
        return result;
    }

    private static AggregateTypeEnum determineAggregateType(IMember[] sourceMembers, String mergeOperator) {
        AggregateTypeEnum aggType = null;
        if (sourceMembers.length == 1) {
            aggType = ((IROLAPMeasure)sourceMembers[0]).getRegularAggregate();
        } else {
            boolean allTheSame = true;
            for (IMember member : sourceMembers) {
                if (member == null) continue;
                if (aggType == null) {
                    aggType = ((IROLAPMeasure)member).getRegularAggregate();
                    continue;
                }
                if (((IROLAPMeasure)member).getRegularAggregate() == aggType) continue;
                allTheSame = false;
                break;
            }
            if (!allTheSame) {
                aggType = ROLAPVirtualHierarchy.determineAggregateTypeFromMergeOperator(mergeOperator);
            }
        }
        return aggType;
    }

    private static ArrayList<IAggregateRule> determineAggregateRules(IMember[] sourceMembers, IROLAPVirtualCubeDef cubeDef) {
        ArrayList<IAggregateRule> aggRules = new ArrayList<IAggregateRule>();
        if (!ROLAPCubeManager.getInstance().getConfig().isVCFirstLastAggregateRulesEnabled()) {
            return aggRules;
        }
        IROLAPCube[] sourceCubes = cubeDef.getSourceCubes();
        for (IROLAPCube sourceCube : sourceCubes) {
            if (!((ROLAPCube)sourceCube).isVirtual()) continue;
            String newln = System.getProperty(NEWLN);
            StringBuffer message = new StringBuffer("The external aggregation rules are not supported ");
            message.append("for the virtual cubes that were based on source virtual cube(s). ");
            message.append("No external aggregate rules will be applied.");
            message.append(newln);
            message.append("Virtual cube: ");
            message.append(cubeDef.getCubeName(cubeDef.getDefaultLocale()));
            message.append(newln);
            message.append("Source cube:");
            message.append(newln);
            message.append(((Cube)((Object)sourceCube)).getUniqueName());
            ROLAPLog.logWarn("ROLAPCubes.Virtual", message.toString());
            return aggRules;
        }
        for (IMember member : sourceMembers) {
            IAggregateRule[] rules;
            if (member == null || !(member instanceof ROLAPMeasure)) continue;
            for (IAggregateRule rule : rules = ((ROLAPMeasure)member).getAggregateRules()) {
                aggRules.add(rule);
            }
            break;
        }
        return aggRules;
    }

    private static AggregateTypeEnum determineAggregateTypeFromMergeOperator(String op) {
        if (op.equalsIgnoreCase("+") || op.equalsIgnoreCase("SUM")) {
            return AggregateTypeEnum.SUM;
        }
        if (op.equalsIgnoreCase("*") || op.equalsIgnoreCase("PRODUCT")) {
            return AggregateTypeEnum.SUM;
        }
        if (op.equalsIgnoreCase("-") || op.equalsIgnoreCase("MINUS")) {
            return AggregateTypeEnum.SUM;
        }
        if (op.equalsIgnoreCase("/") || op.equalsIgnoreCase("DIVIDE")) {
            return AggregateTypeEnum.SUM;
        }
        if (op.equalsIgnoreCase("MAX")) {
            return AggregateTypeEnum.MAX;
        }
        if (op.equalsIgnoreCase("MIN")) {
            return AggregateTypeEnum.MIN;
        }
        if (op.equalsIgnoreCase("NOP")) {
            return AggregateTypeEnum.UNKNOWN;
        }
        return null;
    }

    public static boolean isCalculatedMember(IMember member) {
        return member instanceof ROLAPCalculatedMember || member instanceof ROLAPCalculatedMeasure;
    }

    private void initHierTypeAttributes() {
        boolean initialized = false;
        boolean ragged = false;
        boolean unbalanced = false;
        boolean parentChild = false;
        for (IROLAPHierarchy hier : this.mSourceHierarchies) {
            if (hier == null) continue;
            if (!initialized) {
                initialized = true;
                ragged = hier.isRagged();
                unbalanced = hier.isUnbalanced();
                parentChild = hier.isParentChild();
                continue;
            }
            ragged |= hier.isRagged();
            unbalanced |= hier.isUnbalanced();
            parentChild |= hier.isParentChild();
        }
        this.setRagged(ragged);
        this.setUnbalanced(unbalanced);
        this.setParentChild(parentChild);
    }

    @Override
    public String getUniqueName() {
        ROLAPVirtualDimension d = (ROLAPVirtualDimension)this.getDimension();
        if (this.isTwoPartUniqueName()) {
            return UniqueNameGenerator.createUniqueName(d.getName(), this.getName());
        }
        return UniqueNameGenerator.createUniqueName(this.getName());
    }

    @Override
    public boolean isTwoPartUniqueName() {
        return this.twoPartUniqueName;
    }

    @Override
    public MetadataConnection getConnection() {
        return this.getDimension().getConnection();
    }

    @Override
    public ROLAPMetaHierarchy getMetaHierarchy() {
        IHierarchy[] baseHierarchies;
        for (IHierarchy baseHier : baseHierarchies = this.getSourceHierarchies()) {
            if (baseHier == null) continue;
            return ((IROLAPHierarchy)baseHier).getMetaHierarchy();
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public String getCaption() {
        ROLAPVirtualHierarchyModelRef hierarchyModelRef;
        Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
        String locale = LocaleConverter.localeToStr(runLocale);
        String localizedName = null;
        IROLAPVirtualCube virtualCube = (IROLAPVirtualCube)((Object)this.getDimension().getCube());
        if (virtualCube.getROLAPVirtualCubeDef() != null && (hierarchyModelRef = virtualCube.getROLAPVirtualCubeDef().getVirtualHierarchyModel(this.getUniqueName())) != null && (localizedName = hierarchyModelRef.getName(locale)) == null) {
            localizedName = hierarchyModelRef.getName(virtualCube.getDefaultLocale());
        }
        if (localizedName == null) {
            localizedName = super.getName();
        }
        return localizedName;
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        return this.getLocalizedName();
    }

    @Override
    public ILocalizedString getLocalizedName() {
        ROLAPVirtualHierarchyModelRef hierModelRef;
        ILocalizedString lcName = null;
        IROLAPVirtualCube virtualCube = (IROLAPVirtualCube)((Object)this.getDimension().getCube());
        if (virtualCube.getROLAPVirtualCubeDef() != null && this.isTwoPartUniqueName() && (hierModelRef = virtualCube.getROLAPVirtualCubeDef().getVirtualHierarchyModel(this.getUniqueName())) != null) {
            lcName = hierModelRef.getName();
        }
        if (lcName == null) {
            lcName = AbstractSingleLocaleString.getSingleLocaleString(virtualCube.getDefaultLocale(), this.getName());
        }
        return lcName;
    }

    @Override
    public ILocalizedString getLocalizedDescription() {
        return LocalizedString.emptyString();
    }

    @Override
    public IROLAPHierarchy.FillerCaptionType getFillerCaptionType() {
        for (IROLAPHierarchy hier : this.mSourceHierarchies) {
            if (hier == null) continue;
            return hier.getFillerCaptionType();
        }
        return null;
    }

    @Override
    public IMember getOriginalCalculatedMeasure(String originalV5Name) {
        List<ROLAPCalculatedMember> calcMeasures = this.getROLAPCalculatedMembers(this.getDimension().getCube().getName());
        for (ROLAPVirtualCalculatedMeasure rOLAPVirtualCalculatedMeasure : calcMeasures) {
            if (!rOLAPVirtualCalculatedMeasure.getV5UniqueName().equals(originalV5Name) && !rOLAPVirtualCalculatedMeasure.getV5UniqueCaption().equals(originalV5Name)) continue;
            return rOLAPVirtualCalculatedMeasure;
        }
        return null;
    }

    @Override
    public CalculatedMember getOriginalCalculatedMember(IROLAPCube cube, String originalV5Name) {
        List<ROLAPCalculatedMember> hierCalculatedMmebers = this.getROLAPCalculatedMembers(cube.getName());
        for (ROLAPCalculatedMember rolapMember : hierCalculatedMmebers) {
            if (!rolapMember.getV5UniqueName(cube.getName()).equals(originalV5Name)) continue;
            return rolapMember;
        }
        return null;
    }

    @Override
    protected boolean isRelativeTimeEnabled() {
        ROLAPVirtualHierarchyModelRef hierarchyModelRef;
        IROLAPVirtualCube virtualCube;
        if (this.getDimension().isTimeDimension() && (virtualCube = (IROLAPVirtualCube)((Object)this.getDimension().getCube())).getROLAPVirtualCubeDef() != null && (hierarchyModelRef = virtualCube.getROLAPVirtualCubeDef().getVirtualHierarchyModel(this.getUniqueName())) != null) {
            return hierarchyModelRef.hasRelativeTimeMembers();
        }
        return false;
    }

    @Override
    public IMember getCurrentPeriodMember() {
        if (!this.isCurrentPeriodMemberSet) {
            this.isCurrentPeriodMemberSet = true;
            this.setCurrentPeriodMember();
        }
        return this.mCurrentPeriodMember;
    }

    private void setCurrentPeriodMember() {
        IMember baseCurrentPeriodMember = null;
        for (IROLAPHierarchy hierarchy : this.mSourceHierarchies) {
            if (hierarchy != null && (baseCurrentPeriodMember = ((ROLAPAbstractHierarchy)hierarchy).getCurrentPeriodMember()) != null) break;
        }
        if (baseCurrentPeriodMember == null) {
            return;
        }
        ILevel baseCurrentPeriodMemberLevel = baseCurrentPeriodMember.getLevel();
        Level virtualCurrentPeriodMemberLevel = null;
        for (int i = 0; i < this.getLevelCount(); ++i) {
            ILevel[] sourceLevels;
            ROLAPVirtualLevel virtualLevel = (ROLAPVirtualLevel)this.getLevel(i);
            for (ILevel sourceLevel : sourceLevels = virtualLevel.getSourceLevels()) {
                if (sourceLevel == null || !sourceLevel.equals(baseCurrentPeriodMemberLevel)) continue;
                virtualCurrentPeriodMemberLevel = virtualLevel;
                break;
            }
            if (virtualCurrentPeriodMemberLevel != null) break;
        }
        if (virtualCurrentPeriodMemberLevel == null) {
            return;
        }
        ROLAPVirtualMember virtualCurrentPeriodMember = null;
        List<IMember> virtualMembers = virtualCurrentPeriodMemberLevel.getMembers();
        for (IMember virtualMember : virtualMembers) {
            Pair[] sourceMemberPairs;
            for (Pair sourceMemberPair : sourceMemberPairs = ((ROLAPVirtualMember)virtualMember).getSourceMembers()) {
                if (!sourceMemberPair.getFirst().equals(baseCurrentPeriodMember)) continue;
                virtualCurrentPeriodMember = (ROLAPVirtualMember)virtualMember;
                break;
            }
            if (virtualCurrentPeriodMember == null) continue;
            break;
        }
        this.mCurrentPeriodMember = virtualCurrentPeriodMember;
        this.mRelativeTimeDefinitionHierarchy = (ROLAPAbstractHierarchy)baseCurrentPeriodMember.getHierarchy();
    }

    @Override
    public boolean shouldShowRelativeTimePriorPeriodMembers() {
        if (this.mRelativeTimeDefinitionHierarchy != null) {
            return this.mRelativeTimeDefinitionHierarchy.shouldShowRelativeTimePriorPeriodMembers();
        }
        return true;
    }

    @Override
    public boolean shouldShowRelativeTimeNextPeriodMembers() {
        if (this.mRelativeTimeDefinitionHierarchy != null) {
            return this.mRelativeTimeDefinitionHierarchy.shouldShowRelativeTimeNextPeriodMembers();
        }
        return false;
    }

    @Override
    public boolean shouldShowRelativeTimeSubtreeMembers() {
        if (this.mRelativeTimeDefinitionHierarchy != null) {
            return this.mRelativeTimeDefinitionHierarchy.shouldShowRelativeTimeSubtreeMembers();
        }
        return true;
    }

    private void loadMeasureFolders() {
        if (this.getDimension().isMeasuresDimension()) {
            ICube cube = this.getDimension().getCube();
            if (cube instanceof DummyVirtualCube) {
                return;
            }
            ROLAPVirtualCube rolapCube = (ROLAPVirtualCube)cube;
            IROLAPVirtualCubeDef cubeDef = ((ROLAPVirtualDimension)this.getDimension()).getROLAPVirtualCubeDef();
            List<Object> measureItemsDef = cubeDef.getMeasureItems();
            ROLAPVirtualMeasureFolder rootMeasureFolder = new ROLAPVirtualMeasureFolder(rolapCube, measureItemsDef);
            rolapCube.setRootMeasureFolder(rootMeasureFolder);
        }
    }

    @Override
    public ArrayList<ROLAPMetaObject> getCustomRelativeTimeMembers() {
        ArrayList<ROLAPMetaObject> retArrayList = this.mRelativeTimeDefinitionHierarchy != null ? this.mRelativeTimeDefinitionHierarchy.getCustomRelativeTimeMembers() : new ArrayList();
        return retArrayList;
    }

    @Override
    public boolean isRecursive() {
        IHierarchy[] baseHierarchies;
        boolean isRecursive = false;
        for (IHierarchy baseHierarchy : baseHierarchies = this.getSourceHierarchies()) {
            if (baseHierarchy == null || !((IROLAPHierarchy)baseHierarchy).isRecursive()) continue;
            isRecursive = true;
            break;
        }
        return isRecursive;
    }

    public IHierarchy getBaseCubeHierarchy(ICube cube) {
        IHierarchy[] baseHierarchies;
        IHierarchy hier = null;
        for (IHierarchy baseHierarchy : baseHierarchies = this.getSourceHierarchies()) {
            if (baseHierarchy == null || !((IROLAPHierarchy)baseHierarchy).getDimension().getCube().equals(cube)) continue;
            hier = baseHierarchy;
            break;
        }
        return hier;
    }
}

