/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual;

import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPFolder;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPFolder;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCalculatedMemberDef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMeasureFolderModelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMemberModelRef;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ROLAPVirtualMeasureFolder
extends ROLAPFolder {
    public ROLAPVirtualMeasureFolder(IROLAPCube parentCube, List<Object> virtualMeasureItemsDef) {
        super(null, parentCube, "MeasureFolderRoot", null);
        this.setMeasureItems(virtualMeasureItemsDef);
    }

    private ROLAPVirtualMeasureFolder(ROLAPVirtualMeasureFolder parentFolder, ROLAPVirtualMeasureFolderModelRef virtualFolderDef, List<IMetadata> childObjects) {
        super(parentFolder, parentFolder.getCube(), virtualFolderDef.getDefaultName(), virtualFolderDef.getLocalizedName());
        this.addChildren(childObjects);
    }

    private ROLAPVirtualMeasureFolder(ROLAPVirtualMeasureFolder srcFolder, List<IMetadata> childObjects) {
        super(srcFolder.getParent(), srcFolder.getCube(), srcFolder.getName(), srcFolder.getLocalizedCaption());
        this.addChildren(childObjects);
    }

    private void setMeasureItems(List<Object> metaMeasureItems) {
        IMember[] measures = ((ROLAPVirtualCube)this.getCube()).getMeasures(true);
        HashMap<String, IMember> measuresMap = new HashMap<String, IMember>();
        for (int i = 0; i < measures.length; ++i) {
            measuresMap.put(measures[i].getName(), measures[i]);
        }
        HashSet<IMember> addedMeasures = new HashSet<IMember>();
        List<IMetadata> childObjects = this.addAllDescendants(measuresMap, metaMeasureItems, addedMeasures);
        this.addChildren(childObjects);
        for (IMember measure : measures) {
            if (addedMeasures.contains(measure)) continue;
            this.addChild(measure);
        }
    }

    private List<IMetadata> addAllDescendants(HashMap<String, IMember> measures, List<Object> metaMeasureItems, Set<IMember> addedMeasures) {
        IMetadata childToAdd = null;
        ArrayList<IMetadata> childList = new ArrayList<IMetadata>();
        for (Object item : metaMeasureItems) {
            childToAdd = null;
            if (item instanceof ROLAPVirtualCalculatedMemberDef) {
                IMember calcMeasure = measures.get(((ROLAPVirtualCalculatedMemberDef)item).getName());
                if (addedMeasures.add(calcMeasure)) {
                    childToAdd = calcMeasure;
                }
            } else if (item instanceof ROLAPVirtualMemberModelRef) {
                IMember measure = measures.get(((ROLAPVirtualMemberModelRef)item).getDefaultName());
                if (addedMeasures.add(measure)) {
                    childToAdd = measure;
                }
            } else if (item instanceof ROLAPVirtualMeasureFolderModelRef) {
                List<Object> childDefList = ((ROLAPVirtualMeasureFolderModelRef)item).getChildren();
                List<IMetadata> newFolderChildList = this.addAllDescendants(measures, childDefList, addedMeasures);
                ROLAPVirtualMeasureFolder measureFolder = new ROLAPVirtualMeasureFolder(this, (ROLAPVirtualMeasureFolderModelRef)item, newFolderChildList);
                childToAdd = measureFolder;
            }
            if (childToAdd == null) continue;
            childList.add(childToAdd);
        }
        return childList;
    }

    @Override
    public IROLAPFolder applySecurity(SecurityManagerInterface securityManager) {
        if (securityManager == null) {
            return this;
        }
        List<IMetadata> measureItems = this.getChildren();
        ArrayList<IMetadata> tempMeasureItems = new ArrayList<IMetadata>();
        for (IMetadata measureItem : measureItems) {
            Object result;
            if (measureItem instanceof IROLAPFolder) {
                result = ((IROLAPFolder)measureItem).applySecurity(securityManager);
                if (result == null) continue;
                tempMeasureItems.add((IMetadata)result);
                continue;
            }
            result = new IMember[]{(IMember)measureItem};
            if (((IMember[])(result = securityManager.applySecurity((IMember[])result, result[0].getHierarchy()))).length == 0) continue;
            tempMeasureItems.add(measureItem);
        }
        if (tempMeasureItems.isEmpty()) {
            return null;
        }
        return new ROLAPVirtualMeasureFolder(this, tempMeasureItems);
    }

    @Override
    public boolean isVisible() {
        for (IMetadata childItem : this.getChildren()) {
            if (!(childItem instanceof IROLAPFolder ? ((IROLAPFolder)childItem).isVisible() : ((IROLAPMeasure)childItem).isVisible())) continue;
            return true;
        }
        return false;
    }
}

