/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.CubeRequestMetrics;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.VirtualCubeRequestMetrics;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.TestEnvironmentOptions;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSetIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetToListAdaptor;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SecuredResultSetHelper;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SetSelections;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.PipelineResultSet;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCallable;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryExecuteMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ShareableROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.IROLAPSecurityManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.IROLAPVirtualMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualSecurityManager;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageRequest;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorageRequest;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.combination.BlockTupleStorageFetchResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.composite.ICompositionCalculator;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.util.OrdinalMath;
import com.cognos.xqe.runtree.olap.mdx.v5provider.XProfileInfoCollector;
import com.cognos.xqe.runtree.olap.mdx.v5provider.XQueryStrategy;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.ArrayCast;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.concurrent.ThreadPool;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import com.cognos.xqe.util.primitive.ArrayListInt;
import com.cognos.xqe.util.primitive.HashMapObjectInt;
import com.cognos.xqe.util.primitive.HashMapObjectLong;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;

public class ROLAPVirtualQueryStrategy
extends QueryStrategy {
    static final int MERGE_OP_SUM = 1;
    static final int MERGE_OP_MULTIPLY = 2;
    static final int MERGE_OP_MINUS = 3;
    static final int MERGE_OP_DIVIDE = 4;
    static final int MERGE_OP_MAX = 5;
    static final int MERGE_OP_MIN = 6;
    static final int MERGE_OP_NOP = 7;
    private static final int SELECTIONTOINDEXBYHIER_NULL_VALUE = -1;
    private static final String NEWLN = System.getProperty("line.separator");
    private HashMapObjectLong<IMember> memberCmps = null;
    private String cubeletHint = null;
    private ROLAPQueryExecuteMetrics lastQueryMetrics = null;
    CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CrossJoinedSet cjs, IResultSet resultSet) throws InterpreterException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DCExecutionInQueryStrategy", ZipiContext.getQRDName());
        try {
            this.tryToExecute(cjs, resultSet);
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToExecute(CrossJoinedSet cjs, IResultSet resultSet) throws InterpreterException {
        long cacheHits;
        long startTime;
        XQueryStrategy queryStrategyProfiler;
        ROLAPQueryExecuteMetrics queryMetrics;
        TraceContext traceCtx;
        block13: {
            traceCtx = TraceContext.enter();
            traceCtx.addAttribute("rolapCube", this.getCube().getName());
            ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPQuery.Performance", "Started execution of Virtual Query Strategy.");
            queryMetrics = new ROLAPQueryExecuteMetrics(resultSet.cellCount());
            queryStrategyProfiler = (XQueryStrategy)this.getInfoData().getQueryStrategyProfileNode();
            queryMetrics.setProfileNode(queryStrategyProfiler);
            this.lastQueryMetrics = queryMetrics;
            startTime = System.nanoTime();
            queryStrategyProfiler.begin();
            try {
                if (cjs.size() <= 0L) break block13;
                ISet setToFetch = cjs;
                SetSelections setSel = new SetSelections(setToFetch);
                this.populateErrorCells(setSel, resultSet);
                ROLAPVirtualCube combiCube = (ROLAPVirtualCube)this.getCube();
                IBlockTupleStorage blockStorage = combiCube.getBlockTupleStorage();
                IMember[][] memberSelections = null;
                if (this.isDataCacheEnabled() && !cjs.exceedsThreshold()) {
                    queryMetrics.notifyOperationStart(XQueryStrategy.Operation.DATA_CACHE_RETRIEVAL);
                    HighPrecisionStopWatch timer = new HighPrecisionStopWatch(true);
                    try {
                        this.memberCmps = null;
                        IBlockTupleStorageRequest request = this.constructBlockStorageRequest(setSel, combiCube, new ResultSetToListAdaptor(resultSet));
                        BlockTupleStorageFetchResult fetchResult = ((CubeletStorage)blockStorage).getTupleValues(request);
                        memberSelections = fetchResult.getSelectionsToFetch();
                        setToFetch = fetchResult.createSet();
                        queryMetrics.notifyOperationEnd(XQueryStrategy.Operation.DATA_CACHE_RETRIEVAL, resultSet.cellCount());
                        BigInteger returnSetSize = BigInteger.ZERO;
                        if (setToFetch != null && setToFetch.size() != 0L) {
                            returnSetSize = ((CrossJoinedSet)setToFetch).noOverflowSize();
                        }
                        queryMetrics.setDataCacheMetrics(cjs.noOverflowSize(), returnSetSize, timer.getElapsedTimeInMilliseconds());
                    }
                    catch (Throwable throwable) {
                        queryMetrics.notifyOperationEnd(XQueryStrategy.Operation.DATA_CACHE_RETRIEVAL, resultSet.cellCount());
                        BigInteger returnSetSize = BigInteger.ZERO;
                        if (setToFetch != null && setToFetch.size() != 0L) {
                            returnSetSize = ((CrossJoinedSet)setToFetch).noOverflowSize();
                        }
                        queryMetrics.setDataCacheMetrics(cjs.noOverflowSize(), returnSetSize, timer.getElapsedTimeInMilliseconds());
                        throw throwable;
                    }
                }
                if (setToFetch == null || setToFetch.isEmpty()) break block13;
                this.executeToTupleStorage(setToFetch, memberSelections, resultSet, blockStorage, queryMetrics);
            }
            catch (Throwable throwable) {
                long cacheHits2 = queryMetrics.getDataCacheHits();
                if (cacheHits2 > 0L) {
                    this.incrementCacheHits(cacheHits2);
                }
                ((ROLAPCube)this.getCube()).getMetrics().recordQueryTime(queryMetrics.getVirutalCubeSourceCubeOperationDuration(), System.nanoTime() - startTime);
                if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.INFO)) {
                    long cacheMisses = queryMetrics.getFetchCount();
                    String msg = String.format("Finished execution of Virtual Query Strategy for report " + ROLAPVirtualQueryStrategy.getReportName() + NEWLN + "   Requested %d tuples" + NEWLN + "   Found %d tuples in data cache" + NEWLN + "   Merged %d tuples from source cubes.", cjs.size(), cacheHits2, cacheMisses);
                    ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPQuery.Performance", msg);
                }
                TestEnvironmentOptions.TestHitCountTracker.updateFromQueryMetrics(queryMetrics);
                RequestEnvironment reqEnv = (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment();
                CubeRequestMetrics reqMetrics = reqEnv.getRequestMetrics().getCubeMetrics(this.getCube());
                reqMetrics.update(queryMetrics);
                if (resultSet instanceof PipelineResultSet) {
                    reqMetrics.incrementPipelineWaitTime(((PipelineResultSet)resultSet).getTotalCellEnqueueWaitTime());
                }
                queryStrategyProfiler.end();
                traceCtx.exit();
                throw throwable;
            }
        }
        if ((cacheHits = (long)queryMetrics.getDataCacheHits()) > 0L) {
            this.incrementCacheHits(cacheHits);
        }
        ((ROLAPCube)this.getCube()).getMetrics().recordQueryTime(queryMetrics.getVirutalCubeSourceCubeOperationDuration(), System.nanoTime() - startTime);
        if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.INFO)) {
            long cacheMisses = queryMetrics.getFetchCount();
            String msg = String.format("Finished execution of Virtual Query Strategy for report " + ROLAPVirtualQueryStrategy.getReportName() + NEWLN + "   Requested %d tuples" + NEWLN + "   Found %d tuples in data cache" + NEWLN + "   Merged %d tuples from source cubes.", cjs.size(), cacheHits, cacheMisses);
            ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPQuery.Performance", msg);
        }
        TestEnvironmentOptions.TestHitCountTracker.updateFromQueryMetrics(queryMetrics);
        RequestEnvironment reqEnv = (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment();
        CubeRequestMetrics reqMetrics = reqEnv.getRequestMetrics().getCubeMetrics(this.getCube());
        reqMetrics.update(queryMetrics);
        if (resultSet instanceof PipelineResultSet) {
            reqMetrics.incrementPipelineWaitTime(((PipelineResultSet)resultSet).getTotalCellEnqueueWaitTime());
        }
        queryStrategyProfiler.end();
        traceCtx.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeToTupleStorage(ISet setToFetch, IMember[][] setToFetchMemberSelections, IResultSet resultSet, IBlockTupleStorage tupleStorage, ROLAPQueryExecuteMetrics queryMetrics) throws InterpreterException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DCExecutingToTupleStorage", ZipiContext.getQRDName());
        try {
            this.tryToExecuteToTupleStorage(setToFetch, setToFetchMemberSelections, resultSet, tupleStorage, queryMetrics);
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToExecuteToTupleStorage(ISet setToFetch, IMember[][] setToFetchMemberSelections, IResultSet resultSet, IBlockTupleStorage tupleStorage, ROLAPQueryExecuteMetrics queryMetrics) throws InterpreterException {
        if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.TRACE)) {
            ROLAPLog.logOpStart(LogLevel.TRACE, "ROLAPQuery.Performance", "Started executing to Tuple Storage: " + setToFetch.toString());
        }
        long dataQueryStartTime = System.nanoTime();
        queryMetrics.notifyOperationStart(XQueryStrategy.Operation.CUBE_RETRIEVAL);
        try {
            ROLAPVirtualCube combiCube = (ROLAPVirtualCube)this.getCube();
            IHierarchy[] hierarchies = combiCube.getHierarchies().toArray(new Hierarchy[0]);
            int hierCount = hierarchies.length;
            ArrayList[] selectionsByHierarchy = (ArrayList[])ArrayCast.uncheckedCast(new ArrayList[hierCount]);
            if (setToFetchMemberSelections == null) {
                setToFetchMemberSelections = setToFetch.getMembers(hierarchies);
            }
            for (int i = 0; i < hierCount; ++i) {
                IMember[] mems = setToFetchMemberSelections[i];
                ArrayList<IMember> al = new ArrayList<IMember>();
                al.addAll(Arrays.asList(mems));
                selectionsByHierarchy[i] = al;
            }
            HashMap<Cube, SourceCubeQueryReturnType> cubeToSourceCubeQueryResult = new HashMap<Cube, SourceCubeQueryReturnType>();
            ArrayList[] vcSelectionsLists = (ArrayList[])ArrayCast.uncheckedCast(new ArrayList[selectionsByHierarchy.length]);
            for (int i = 0; i < selectionsByHierarchy.length; ++i) {
                vcSelectionsLists[i] = new ArrayList(selectionsByHierarchy[i]);
            }
            this.performSourceCubeQueries(vcSelectionsLists, cubeToSourceCubeQueryResult);
            this.queryResultToTupleStorage(resultSet, tupleStorage, cubeToSourceCubeQueryResult, vcSelectionsLists, setToFetch);
        }
        finally {
            queryMetrics.incrementVirutalCubeSourceCubeOperationDuration(System.nanoTime() - dataQueryStartTime);
            queryMetrics.notifyOperationEnd(XQueryStrategy.Operation.CUBE_RETRIEVAL, resultSet.cellCount());
            if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.TRACE)) {
                ROLAPLog.logOpEnd(LogLevel.TRACE, "ROLAPQuery.Performance", "Finished executing to Tuple Storage.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryResultToTupleStorage(IResultSet resultSet, IBlockTupleStorage tupleStorage, Map<Cube, SourceCubeQueryReturnType> cubeToSourceCubeQueryResult, ArrayList<IMember>[] vcSelections, ISet fetchedSet) throws InterpreterException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DCMergingQueryResultsToTupleStorage", ZipiContext.getQRDName());
        try {
            this.tryToQueryResultToTupleStorage(resultSet, tupleStorage, cubeToSourceCubeQueryResult, vcSelections, fetchedSet);
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToQueryResultToTupleStorage(IResultSet resultSet, IBlockTupleStorage tupleStorage, Map<Cube, SourceCubeQueryReturnType> cubeToSourceCubeQueryResult, ArrayList<IMember>[] vcSelections, ISet fetchedSet) throws InterpreterException {
        if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.TRACE)) {
            ROLAPLog.logOpStart(LogLevel.TRACE, "ROLAPQuery.Performance", "Started merging query results to Tuple Storage: " + fetchedSet.toString());
        }
        ArrayList<TupleValue> mergedResults = null;
        if (this.isDataCacheEnabled() && !resultSet.getQuerySet().exceedsThreshold()) {
            mergedResults = new ArrayList<TupleValue>();
        }
        int initialResultSetCellCount = resultSet.cellCount();
        HighPrecisionStopWatch mergeOperationTime = new HighPrecisionStopWatch(true);
        try {
            ROLAPVirtualCube combiCube = (ROLAPVirtualCube)this.getCube();
            ROLAPCube[] cubes = combiCube.getSourceCubes();
            if (cubes.length == 2) {
                XQEDebugLog.out.println(" ->Cube A = " + cubes[0].getName());
                XQEDebugLog.out.println(" ->Cube B = " + cubes[1].getName());
            }
            HashMapObjectInt<ROLAPCube> cubeToIndex = new HashMapObjectInt<ROLAPCube>();
            for (int j = 0; j < cubes.length; ++j) {
                cubeToIndex.put(cubes[j], j);
            }
            String op = combiCube.getMergeOperator();
            int defaultOpId = ROLAPVirtualQueryStrategy.opStringToId(op);
            if (ROLAPLog.isOn("ROLAPCubes.Virtual", LogLevel.TRACE)) {
                ROLAPLog.log("ROLAPCubes.Virtual", "Default merge operation = " + op + ", id = " + defaultOpId);
            }
            HashMap<IMember, int[]> memberToSourceMemberOpIds = new HashMap<IMember, int[]>();
            HashMap<IMember, int[]> memberToSourceMemberOpPrecidence = new HashMap<IMember, int[]>();
            HashMap<String, String> fqMemberNameToMergeOperator = combiCube.getROLAPVirtualCubeDef().getFqMemberNameToMergeOperator();
            HashMap<String, String> fqMemberNameToPrecedence = combiCube.getROLAPVirtualCubeDef().getFqMemberNameToPrecedence();
            for (int i = 0; i < vcSelections.length; ++i) {
                IMember[] dimMembers = vcSelections[i].toArray(new IMember[vcSelections[i].size()]);
                boolean isSharedDimension = false;
                int[] sharedDimensionCubeIndexes = null;
                Pair[] sharedMembers = null;
                for (int j = 0; j < dimMembers.length; ++j) {
                    if (j == 0 && (isSharedDimension = dimMembers[0].getDimension().isShareable())) {
                        sharedDimensionCubeIndexes = ((ShareableROLAPDimension)dimMembers[0].getDimension()).getVirtualCubeSourceCubeIndexes(this.getCube().getName());
                        sharedMembers = new Pair[sharedDimensionCubeIndexes.length];
                    }
                    Pair[] sourceMembers = isSharedDimension ? sharedMembers : ((IROLAPMember)dimMembers[j]).getSourceMembers();
                    int[] opIds = new int[sourceMembers.length];
                    int[] opPrecidence = new int[sourceMembers.length];
                    for (int k = 0; k < sourceMembers.length; ++k) {
                        ROLAPCube sourceMemberCube;
                        IMember sourceMember;
                        if (isSharedDimension) {
                            sourceMember = dimMembers[j];
                            sourceMemberCube = cubes[sharedDimensionCubeIndexes[k]];
                        } else {
                            sourceMember = (IMember)sourceMembers[k].getFirst();
                            sourceMemberCube = cubes[(Integer)sourceMembers[k].getSecond()];
                        }
                        String fqName = ROLAPVirtualCube.getFullyQualifiedUniqueName(sourceMemberCube, (IMetadata)sourceMember);
                        String mergeOpString = fqMemberNameToMergeOperator.get(fqName);
                        if (mergeOpString != null) {
                            opIds[k] = ROLAPVirtualQueryStrategy.opStringToId(mergeOpString);
                            String precidenceString = fqMemberNameToPrecedence.get(fqName);
                            try {
                                opPrecidence[k] = Integer.parseInt(precidenceString);
                            }
                            catch (NumberFormatException e) {
                                opPrecidence[k] = Integer.MIN_VALUE;
                            }
                            continue;
                        }
                        opIds[k] = Integer.MIN_VALUE;
                    }
                    memberToSourceMemberOpIds.put(dimMembers[j], opIds);
                    memberToSourceMemberOpPrecidence.put(dimMembers[j], opPrecidence);
                }
            }
            SourceCubeQueryReturnType[] sourceResults = new SourceCubeQueryReturnType[cubes.length];
            for (int i = 0; i < cubes.length; ++i) {
                sourceResults[i] = cubeToSourceCubeQueryResult.get(cubes[i]);
            }
            SourceCubeResultIterator sourceCubeResultIter = new SourceCubeResultIterator(sourceResults, vcSelections);
            while (sourceCubeResultIter.hasNext()) {
                Cell[] srcCells = sourceCubeResultIter.next();
                int[] registers = sourceCubeResultIter.nextRegisters();
                if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                int opId = defaultOpId;
                int opCubeIndex = 0;
                int highestPrecidence = Integer.MIN_VALUE;
                boolean opIdInitialized = false;
                for (int j = 0; j < vcSelections.length; ++j) {
                    Pair[] sourceMembers;
                    IMember member = vcSelections[j].get(registers[j]);
                    boolean isSharedDimension = member.getDimension().isShareable();
                    int[] sharedDimensionCubeIndexes = null;
                    if (isSharedDimension) {
                        sharedDimensionCubeIndexes = ((ShareableROLAPDimension)member.getDimension()).getVirtualCubeSourceCubeIndexes(this.getCube().getName());
                        sourceMembers = new Pair[sharedDimensionCubeIndexes.length];
                    } else {
                        sourceMembers = ((IROLAPMember)member).getSourceMembers();
                    }
                    int[] opIds = (int[])memberToSourceMemberOpIds.get(member);
                    for (int k = 0; k < sourceMembers.length; ++k) {
                        ROLAPCube sourceMemberCube;
                        if (isSharedDimension) {
                            sourceMemberCube = ((ROLAPVirtualCube)this.getCube()).getSourceCubes()[sharedDimensionCubeIndexes[k]];
                        } else {
                            int cubeIdx = (Integer)sourceMembers[k].getSecond();
                            sourceMemberCube = ((ROLAPVirtualCube)this.getCube()).getSourceCubes()[cubeIdx];
                        }
                        if (opIds[k] == Integer.MIN_VALUE) continue;
                        int[] opPrecidences = (int[])memberToSourceMemberOpPrecidence.get(member);
                        if (opIdInitialized && opPrecidences[k] <= highestPrecidence) continue;
                        opIdInitialized = true;
                        opId = opIds[k];
                        opCubeIndex = cubeToIndex.get(sourceMemberCube);
                        highestPrecidence = opPrecidences[k];
                        if (opId == defaultOpId || !ROLAPLog.isOn("ROLAPCubes.Virtual", LogLevel.TRACE)) continue;
                        Tuple outputTuple = SelectionsIterator.getTuple(vcSelections, registers);
                        ROLAPLog.log("ROLAPCubes.Virtual", "Merge operator overridden. id =" + opId + NEWLN + "for Tuple " + outputTuple.toString() + NEWLN + "caused by Member " + member.getUniqueName());
                    }
                }
                Value value = this.calculateMergedValue(srcCells, opId, opCubeIndex);
                if (value == null) continue;
                Tuple outputTuple = SelectionsIterator.getTuple(vcSelections, registers);
                ROLAPVirtualMeasure measure = (ROLAPVirtualMeasure)outputTuple.getMember(this.getCube().getMeasureDimension());
                FormatId directFormatId = measure.getFormatId();
                if (directFormatId != null) {
                    value.setFormatId(directFormatId);
                }
                Cell outputCell = new Cell(value);
                resultSet.addCell(outputTuple, outputCell);
                if (mergedResults == null) continue;
                mergedResults.add(new TupleValue(outputTuple, outputCell));
            }
            if (mergedResults != null) {
                this.incrementCacheMisses(mergedResults.size());
                IBlockTupleStorageRequest request = this.constructBlockStorageRequest(new SetSelections(fetchedSet), combiCube, mergedResults);
                ((CubeletStorage)tupleStorage).putTupleValues(request);
            }
        }
        finally {
            RequestEnvironment reqEnv = (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment();
            VirtualCubeRequestMetrics reqMetrics = (VirtualCubeRequestMetrics)reqEnv.getRequestMetrics().getCubeMetrics(this.getCube());
            reqMetrics.incrementVirtualCubeMerge(mergeOperationTime.getElapsedTimeInMilliseconds(), resultSet.cellCount() - initialResultSetCellCount);
            if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.TRACE)) {
                int mergedResultsSize = 0;
                if (mergedResults != null) {
                    mergedResultsSize = mergedResults.size();
                }
                ROLAPLog.logOpEnd(LogLevel.TRACE, "ROLAPQuery.Performance", "Finished merging query results to Tuple Storage: " + mergedResultsSize + " values.");
            }
        }
    }

    private void populateErrorCells(SetSelections setSelections, IResultSet resultSet) {
        if (!ROLAPCubeManager.getInstance().getConfig().isVCMergeNonExistentMeasuresAsErrors()) {
            return;
        }
        ROLAPVirtualCube combiCube = (ROLAPVirtualCube)this.getCube();
        ROLAPCube[] cubes = combiCube.getSourceCubes();
        IHierarchy[] hierarchies = combiCube.getHierarchies().toArray(new Hierarchy[0]);
        if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.INFO)) {
            ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPQuery.Performance", "Started populating result set with error cells for virtual cube " + combiCube.getName() + "Set size: " + setSelections.size());
        }
        IMember[][] memberSelections = setSelections.getSelectionsArrays(hierarchies, false);
        boolean[] selHasNullSrcMembers = new boolean[memberSelections.length];
        ArrayList selWithNullSrcMembers = new ArrayList();
        ArrayList<Integer> nullSelToOrigSel = new ArrayList<Integer>();
        for (int hierIdx = 0; hierIdx < memberSelections.length; ++hierIdx) {
            boolean isSharedDimension = ((Hierarchy)hierarchies[hierIdx]).getDimension().isShareable();
            if (isSharedDimension) continue;
            ROLAPVirtualHierarchy hierarchy = (ROLAPVirtualHierarchy)hierarchies[hierIdx];
            IHierarchy[] srcHierarchies = hierarchy.getSourceHierarchies();
            boolean checkHierarchy = true;
            for (IHierarchy srcHierachy : srcHierarchies) {
                if (srcHierachy != null) continue;
                checkHierarchy = false;
                break;
            }
            if (!checkHierarchy) continue;
            ArrayList<IMember> nullSrcMembers = null;
            for (int memIdx = 0; memIdx < memberSelections[hierIdx].length; ++memIdx) {
                if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                IMember member = memberSelections[hierIdx][memIdx];
                if (((IROLAPMember)member).isPaddingMember() || ((IROLAPMember)member).isSecurityPaddingMember()) continue;
                IMember[] sourceMembers = ((IROLAPVirtualMember)member).getOrderedSourceMembers();
                for (int cubeIdx = 0; cubeIdx < sourceMembers.length; ++cubeIdx) {
                    if (sourceMembers[cubeIdx] != null) continue;
                    if (!selHasNullSrcMembers[hierIdx]) {
                        selHasNullSrcMembers[hierIdx] = true;
                        nullSrcMembers = new ArrayList<IMember>();
                        selWithNullSrcMembers.add(nullSrcMembers);
                        nullSelToOrigSel.add(hierIdx);
                    }
                    nullSrcMembers.add(member);
                }
            }
        }
        ArrayList[] vcSelectionsLists = (ArrayList[])ArrayCast.uncheckedCast(new ArrayList[memberSelections.length]);
        for (int i = 0; i < memberSelections.length; ++i) {
            vcSelectionsLists[i] = new ArrayList();
            vcSelectionsLists[i].addAll(Arrays.asList(memberSelections[i]));
        }
        ArrayList[] nullSelectionsLists = (ArrayList[])ArrayCast.uncheckedCast(selWithNullSrcMembers.toArray(new ArrayList[selWithNullSrcMembers.size()]));
        int nullCount = 0;
        ArrayList[] virtualMemWithNullSrcMem = (ArrayList[])ArrayCast.uncheckedCast(new ArrayList[cubes.length]);
        for (int cubeIdx = 0; cubeIdx < cubes.length; ++cubeIdx) {
            virtualMemWithNullSrcMem[cubeIdx] = new ArrayList();
        }
        int[] origSelIdx = new int[cubes.length];
        long errorCellsAdded = resultSet.cellCount();
        for (int nullSelIdx1 = 0; nullSelIdx1 < nullSelectionsLists.length - 1; ++nullSelIdx1) {
            for (int nullSelIdx2 = nullSelIdx1 + 1; nullSelIdx2 < nullSelectionsLists.length; ++nullSelIdx2) {
                ArrayList[] nullSelListComb = (ArrayList[])ArrayCast.uncheckedCast(new ArrayList[]{nullSelectionsLists[nullSelIdx1], nullSelectionsLists[nullSelIdx2]});
                SelectionsIterator itr = new SelectionsIterator(nullSelListComb);
                ResourceMonitor.checkMaxSetSize(itr.size(), this.getInfoData(), XQEMessageKeys.MDX_MaxSubQuerySize);
                while (itr.hasNext()) {
                    int[] registers = itr.getNext();
                    nullCount = 0;
                    for (int cubeIdx = 0; cubeIdx < cubes.length; ++cubeIdx) {
                        virtualMemWithNullSrcMem[cubeIdx].clear();
                        origSelIdx[cubeIdx] = 0;
                    }
                    block10: for (int j = 0; j < nullSelListComb.length && nullCount < cubes.length; ++j) {
                        IMember member = (IMember)nullSelListComb[j].get(registers[j]);
                        IMember[] sourceMembers = ((IROLAPVirtualMember)member).getOrderedSourceMembers();
                        for (int cubeIdx = 0; cubeIdx < sourceMembers.length; ++cubeIdx) {
                            if (sourceMembers[cubeIdx] != null || virtualMemWithNullSrcMem[cubeIdx].size() != 0) continue;
                            virtualMemWithNullSrcMem[cubeIdx].add(member);
                            origSelIdx[cubeIdx] = (Integer)nullSelToOrigSel.get(nullSelIdx1 + j);
                            ++nullCount;
                            continue block10;
                        }
                    }
                    if (nullCount < cubes.length) continue;
                    ArrayList[] errorSelectionsLists = (ArrayList[])vcSelectionsLists.clone();
                    for (int i = 0; i < virtualMemWithNullSrcMem.length; ++i) {
                        errorSelectionsLists[origSelIdx[i]] = virtualMemWithNullSrcMem[i];
                    }
                    SelectionsIterator errorSelIter = new SelectionsIterator(errorSelectionsLists);
                    ResourceMonitor.checkMaxSetSize(errorSelIter.size(), this.getInfoData(), XQEMessageKeys.MDX_MaxSubQuerySize);
                    while (errorSelIter.hasNext()) {
                        int[] errorSelIterRegisters = errorSelIter.getNext();
                        TextValue value = TextValue.ERROR_VALUE;
                        Tuple outputTuple = SelectionsIterator.getTuple(errorSelectionsLists, errorSelIterRegisters);
                        Cell outputCell = new Cell(value);
                        resultSet.addCell(outputTuple, outputCell);
                    }
                }
            }
        }
        if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.INFO)) {
            errorCellsAdded = (long)resultSet.cellCount() - errorCellsAdded;
            ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPQuery.Performance", "Finished populating result set with error cells for virtual cube " + combiCube.getName() + ". Number of error cells added to result set:  " + errorCellsAdded);
        }
    }

    private IBlockTupleStorageRequest constructBlockStorageRequest(SetSelections setSel, ROLAPVirtualCube combiCube, List<TupleValue> values) {
        BlockTupleStorageRequest request = new BlockTupleStorageRequest();
        request.setHint(this.cubeletHint);
        IHierarchy[] cubeHiers = combiCube.getHierarchies().toArray(new IHierarchy[combiCube.getHierarchies().size()]);
        request.setCubeHierarchies(cubeHiers);
        request.setRequestedSetSelections(setSel);
        request.setTupleValues(values);
        if (!((IROLAPSecurityManager)combiCube.getSecurityManager()).hasNoRestrictions()) {
            request.setCompositionCalculator((ICompositionCalculator)((Object)combiCube.getSecurityManager()));
            if (this.memberCmps == null) {
                this.memberCmps = this.calculateMemberCompositions(setSel.getSelections(cubeHiers, false));
            }
            request.setMemberCompositions(this.memberCmps);
        }
        return request;
    }

    private void incrementCacheHits(long hitCount) {
        ((Cube)this.getCube()).getTupleStorageMetrics().incrementHits(hitCount);
        ((ROLAPCube)this.getCube()).getMetrics().recordDataCacheAccess(hitCount, hitCount);
    }

    private void incrementCacheMisses(long missCount) {
        ((Cube)this.getCube()).getTupleStorageMetrics().incrementMisses();
        ((ROLAPCube)this.getCube()).getMetrics().recordDataCacheAccess(0L, missCount);
    }

    private Value calculateMergedValue(Cell[] sourceCells, int opId, int opCubeIndex) {
        double outputValue = 0.0;
        boolean allNull = true;
        boolean anyNull = false;
        FormatId outputFormatId = null;
        block10: for (int j = 0; j < sourceCells.length; ++j) {
            Cell cell = sourceCells[j];
            if (cell == null) {
                anyNull = true;
                continue;
            }
            Value v = (Value)cell.getValue();
            if (v.isError()) {
                return v;
            }
            double value = cell.getDoubleValue();
            if (Double.isNaN(value)) {
                anyNull = true;
                continue;
            }
            switch (opId) {
                case 0: {
                    allNull = false;
                    outputValue = 0.0;
                    continue block10;
                }
                case 1: {
                    if (allNull) {
                        allNull = false;
                        outputValue = value;
                    } else {
                        outputValue += value;
                    }
                    outputFormatId = ROLAPVirtualQueryStrategy.calculateMergeFormatId("Add", outputFormatId, cell);
                    continue block10;
                }
                case 2: {
                    if (allNull) {
                        allNull = false;
                        outputValue = value;
                    } else {
                        outputValue *= value;
                    }
                    outputFormatId = ROLAPVirtualQueryStrategy.calculateMergeFormatId("Multiply", outputFormatId, cell);
                    continue block10;
                }
                case 3: {
                    if (allNull) {
                        allNull = false;
                        outputValue = j == 0 ? value : value * -1.0;
                    } else {
                        outputValue -= value;
                    }
                    outputFormatId = ROLAPVirtualQueryStrategy.calculateMergeFormatId("Subtract", outputFormatId, cell);
                    continue block10;
                }
                case 4: {
                    if (allNull) {
                        if (j == 0) {
                            outputValue = value;
                            allNull = false;
                        }
                    } else {
                        outputValue = value != 0.0 ? (outputValue /= value) : Double.NaN;
                    }
                    outputFormatId = ROLAPVirtualQueryStrategy.calculateMergeFormatId("Divide", outputFormatId, cell);
                    continue block10;
                }
                case 5: {
                    if (allNull) {
                        outputValue = value;
                        allNull = false;
                    } else if (value > outputValue) {
                        outputValue = value;
                    }
                    outputFormatId = ROLAPVirtualQueryStrategy.calculateMergeFormatId("Add", outputFormatId, cell);
                    continue block10;
                }
                case 6: {
                    if (allNull) {
                        outputValue = value;
                        allNull = false;
                    } else if (value < outputValue) {
                        outputValue = value;
                    }
                    outputFormatId = ROLAPVirtualQueryStrategy.calculateMergeFormatId("Add", outputFormatId, cell);
                    continue block10;
                }
                case 7: {
                    if (j == opCubeIndex || allNull) {
                        outputValue = value;
                        allNull = false;
                    }
                    outputFormatId = ROLAPVirtualQueryStrategy.calculateMergeFormatId("Add", outputFormatId, cell);
                    continue block10;
                }
                default: {
                    if (allNull) {
                        allNull = false;
                        outputValue = value;
                    } else {
                        outputValue += value;
                    }
                    outputFormatId = ROLAPVirtualQueryStrategy.calculateMergeFormatId("Add", outputFormatId, cell);
                }
            }
        }
        if ((opId == 2 || opId == 4) && anyNull) {
            allNull = true;
        }
        DoubleValue value = null;
        if (Double.isNaN(outputValue)) {
            value = DataValueFactory.createDoubleValue();
            value.setState(ValueState.DIV_BY_ZERO);
        } else if (!allNull) {
            value = DataValueFactory.createDoubleValue();
            if (outputFormatId != null) {
                value.setFormatId(outputFormatId);
            } else {
                value.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
            }
            ((Value)value).set(outputValue);
        }
        return value;
    }

    static FormatId calculateMergeFormatId(String operation, FormatId currentOutputFormatId, Cell cell) {
        FormatId valueFormatId;
        Value cellValue = (Value)cell.getValue();
        if (cellValue != null && (valueFormatId = cellValue.getFormatId()) != null) {
            if (currentOutputFormatId == null) {
                return valueFormatId;
            }
            ArrayList<FormatId> formatIdList = new ArrayList<FormatId>();
            formatIdList.add(currentOutputFormatId);
            formatIdList.add(valueFormatId);
            return FormatService.getInstance().formatResult(operation, formatIdList);
        }
        return null;
    }

    private HashMapObjectLong<IMember> calculateMemberCompositions(Collection<IMember>[] selections) {
        ROLAPVirtualSecurityManager secManagerForCube = (ROLAPVirtualSecurityManager)((Cube)this.getCube()).getSecurityManager();
        if (secManagerForCube == null || secManagerForCube.hasNoRestrictions()) {
            return null;
        }
        ArrayList<IMember> membersList = new ArrayList<IMember>();
        for (Collection<IMember> dimMembers : selections) {
            membersList.addAll(dimMembers);
        }
        return secManagerForCube.calculateMemberCompositions(membersList);
    }

    static int opStringToId(String op) {
        int opId = 0;
        if (op.equalsIgnoreCase("+") || op.equalsIgnoreCase("SUM")) {
            opId = 1;
        } else if (op.equalsIgnoreCase("*") || op.equalsIgnoreCase("PRODUCT")) {
            opId = 2;
        } else if (op.equalsIgnoreCase("-") || op.equalsIgnoreCase("MINUS")) {
            opId = 3;
        } else if (op.equalsIgnoreCase("/") || op.equalsIgnoreCase("DIVIDE")) {
            opId = 4;
        } else if (op.equalsIgnoreCase("MAX")) {
            opId = 5;
        } else if (op.equalsIgnoreCase("MIN")) {
            opId = 6;
        } else if (op.equalsIgnoreCase("NOP")) {
            opId = 7;
        }
        return opId;
    }

    private void performSourceCubeQueries(ArrayList<IMember>[] vcSelectionsLists, Map<Cube, SourceCubeQueryReturnType> cubeToSourceCubeQueryResult) throws InterpreterException {
        ROLAPVirtualCube vCube = (ROLAPVirtualCube)this.getCube();
        ROLAPCube[] cubes = vCube.getSourceCubes();
        ThreadPool threadPool = ThreadPool.getInstance();
        ExecutorCompletionService<SourceCubeQueryReturnType> ecs = new ExecutorCompletionService<SourceCubeQueryReturnType>(threadPool);
        HashMap<Future<SourceCubeQueryReturnType>, ROLAPCube> futureToCube = new HashMap<Future<SourceCubeQueryReturnType>, ROLAPCube>(cubes.length);
        if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
            throw new OperationCanceledException();
        }
        int threadIndex = 1;
        for (ROLAPCube sourceCube : cubes) {
            Callable<SourceCubeQueryReturnType> thread = new SourceCubeQuery(sourceCube, vCube, vcSelectionsLists, this.getInfoData());
            thread = ROLAPCallable.decorateCallable(thread, ((ROLAPCallable)thread).getZipiAction(), vCube.getUniqueName() + "->" + sourceCube.getUniqueName(), threadIndex++);
            Future<SourceCubeQueryReturnType> future = ecs.submit(thread);
            futureToCube.put(future, sourceCube);
        }
        Throwable baseCubeException = null;
        String baseCubeWithException = "";
        for (int i = 0; i < cubes.length; ++i) {
            Future future = null;
            try {
                future = ecs.take();
                SourceCubeQueryReturnType result = (SourceCubeQueryReturnType)future.get();
                Cube sourceCube = result.getSourceCube();
                cubeToSourceCubeQueryResult.put(sourceCube, result);
                continue;
            }
            catch (Throwable e) {
                if (baseCubeException != null) continue;
                baseCubeException = e;
                if (future == null || futureToCube.get(future) == null) continue;
                baseCubeWithException = ((Cube)futureToCube.get(future)).getUniqueName();
            }
        }
        if (baseCubeException != null) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_ExceptionInSourceCubeQuery, baseCubeException, baseCubeWithException);
        }
    }

    private boolean isDataCacheEnabled() {
        ROLAPVirtualSecurityManager vsm = (ROLAPVirtualSecurityManager)((ROLAPVirtualCube)this.getCube()).getSecurityManager();
        if (!vsm.hasTupleSecurity()) {
            return ((ROLAPCube)this.getCube()).getBlockTupleStorage() != null;
        }
        return false;
    }

    public final ROLAPQueryExecuteMetrics getLastQueryMetrics() {
        return this.lastQueryMetrics;
    }

    @Override
    public final void setCubeletHint(String aCubeletHint) {
        this.cubeletHint = aCubeletHint;
    }

    @Override
    public final String getCubeletHint() {
        return this.cubeletHint;
    }

    private static class SourceCubeResultIterator
    implements Iterator<Cell[]> {
        private static final int SRC_RESULT_IDX_0 = 0;
        private static final int SRC_RESULT_IDX_1 = 1;
        private static final int SRC_RESULT_IDX_BOTH = -1;
        private final SourceCubeQueryReturnType[] sourceResults;
        private final IResultSet[] sourceResultSets;
        private final ArrayList<IMember>[] vcSelections;
        private final IResultSetIterator[] sourceResultIters;
        private final Cell[] nextCells;
        private final Cell[] currentCells;
        private final int[][] vcSelectionOrdinals;
        private final int[] currentVCSelectionOrdinals;
        private int lowIndex;
        CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();

        SourceCubeResultIterator(SourceCubeQueryReturnType[] srcResults, ArrayList<IMember>[] vcSels) {
            int i;
            this.vcSelections = vcSels;
            ArrayList<SourceCubeQueryReturnType> srcResultList = new ArrayList<SourceCubeQueryReturnType>();
            for (i = 0; i < srcResults.length; ++i) {
                IResultSet srcResultSet = srcResults[i].getResultSet();
                if (srcResultSet == null) continue;
                srcResultList.add(srcResults[i]);
            }
            this.sourceResults = srcResultList.toArray(new SourceCubeQueryReturnType[srcResultList.size()]);
            this.sourceResultSets = new IResultSet[this.sourceResults.length];
            this.sourceResultIters = new IResultSetIterator[this.sourceResults.length];
            for (i = 0; i < this.sourceResults.length; ++i) {
                this.sourceResultSets[i] = this.sourceResults[i].getResultSet();
                this.sourceResultIters[i] = this.sourceResultSets[i].iterator();
            }
            this.vcSelectionOrdinals = new int[this.sourceResultSets.length][];
            boolean hasNext = false;
            this.nextCells = new Cell[this.sourceResultIters.length];
            for (int i2 = 0; i2 < this.sourceResultIters.length; ++i2) {
                if (this.sourceResultIters[i2].hasNext()) {
                    this.nextCells[i2] = (Cell)this.sourceResultIters[i2].next();
                    this.vcSelectionOrdinals[i2] = this.computeVCSetOrdinals(i2);
                    hasNext = true;
                    continue;
                }
                this.nextCells[i2] = null;
            }
            if (hasNext) {
                this.lowIndex = this.getLowIndex();
            }
            this.currentCells = new Cell[this.sourceResultIters.length];
            this.currentVCSelectionOrdinals = new int[vcSels.length];
        }

        @Override
        public boolean hasNext() {
            for (int i = 0; i < this.nextCells.length; ++i) {
                if (this.nextCells[i] == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public Cell[] next() {
            if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            if (this.lowIndex == -1) {
                int i;
                for (i = 0; i < this.nextCells.length; ++i) {
                    this.currentCells[i] = this.nextCells[i];
                }
                for (i = 0; i < this.currentVCSelectionOrdinals.length; ++i) {
                    this.currentVCSelectionOrdinals[i] = this.vcSelectionOrdinals[0][i];
                }
            } else {
                int i;
                for (i = 0; i < this.nextCells.length; ++i) {
                    this.currentCells[i] = i == this.lowIndex ? this.nextCells[i] : null;
                }
                for (i = 0; i < this.currentVCSelectionOrdinals.length; ++i) {
                    this.currentVCSelectionOrdinals[i] = this.vcSelectionOrdinals[this.lowIndex][i];
                }
            }
            this.moveSourceIterators();
            this.lowIndex = this.getLowIndex();
            return this.currentCells;
        }

        public int[] nextRegisters() {
            return this.currentVCSelectionOrdinals;
        }

        private void moveSourceIterators() {
            if (this.lowIndex == -1) {
                this.moveSourceIterator(0);
                this.moveSourceIterator(1);
            } else {
                this.moveSourceIterator(this.lowIndex);
            }
        }

        private void moveSourceIterator(int srcResultIdx) {
            if (this.nextCells[srcResultIdx] == null) {
                return;
            }
            if (!this.sourceResultIters[srcResultIdx].hasNext()) {
                this.nextCells[srcResultIdx] = null;
                return;
            }
            this.nextCells[srcResultIdx] = (Cell)this.sourceResultIters[srcResultIdx].next();
            this.vcSelectionOrdinals[srcResultIdx] = this.computeVCSetOrdinals(srcResultIdx);
        }

        private int getLowIndex() {
            if (this.nextCells.length <= 1) {
                return 0;
            }
            if (this.nextCells[0] != null && this.nextCells[1] != null) {
                for (int i = 0; i < this.vcSelections.length; ++i) {
                    if (this.vcSelectionOrdinals[0][i] == this.vcSelectionOrdinals[1][i]) continue;
                    if (this.vcSelectionOrdinals[0][i] < this.vcSelectionOrdinals[1][i]) {
                        return 0;
                    }
                    return 1;
                }
            } else {
                if (this.nextCells[0] != null && this.nextCells[1] == null) {
                    return 0;
                }
                if (this.nextCells[0] == null && this.nextCells[1] != null) {
                    return 1;
                }
            }
            return -1;
        }

        private long[] computeSrcSetOrdinals(Cell cell, ISet[] srcSelections) {
            OrdinalMath ordinalMath = new OrdinalMath();
            OrdinalMath.SetArrayInfo setArrayInfo = ordinalMath.getSetArrayInfo(srcSelections);
            long[] srcSetOrdinals = ordinalMath.getSetOrdinals(cell.getOrdinal(), setArrayInfo);
            return srcSetOrdinals;
        }

        private int[] computeVCSetOrdinals(int resultIdx) {
            if (this.nextCells[resultIdx] == null) {
                return null;
            }
            long[] srcSetOrds = this.computeSrcSetOrdinals(this.nextCells[resultIdx], this.sourceResultSets[resultIdx].getQuerySet().getSets());
            int[] hierIndexToVCHierIndex = this.sourceResults[resultIdx].getHierarchyIndexToVCHierarchyIndex();
            ArrayListInt[] selIndexToVCSelIndex = this.sourceResults[resultIdx].getSelIndexToVCSelIndex();
            int[] vcSetOrdinals = new int[this.vcSelections.length];
            for (int j = 0; j < srcSetOrds.length; ++j) {
                if (hierIndexToVCHierIndex[j] == -1) continue;
                vcSetOrdinals[hierIndexToVCHierIndex[j]] = selIndexToVCSelIndex[j].get((int)srcSetOrds[j]);
            }
            int[] vcHierMappings = this.sourceResults[resultIdx].getVCHierarchyMappings();
            for (int i = 0; i < this.vcSelections.length; ++i) {
                if (vcHierMappings[i] == -2 || vcHierMappings[i] == -1) continue;
                vcSetOrdinals[i] = vcHierMappings[i];
            }
            return vcSetOrdinals;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SourceCubeQueryReturnType {
        private final Cube mSourceCube;
        private ArrayListInt[] selIndexToVCSelIndex;
        private int[] hierIndexToVCHierIndex;
        private int[] vcHierarchyMappings;
        private IResultSet mResultSet;

        SourceCubeQueryReturnType(Cube sourceCube) {
            this.mSourceCube = sourceCube;
        }

        public IResultSet getResultSet() {
            return this.mResultSet;
        }

        public void setResultSet(IResultSet resultSet) {
            this.mResultSet = resultSet;
        }

        public Cube getSourceCube() {
            return this.mSourceCube;
        }

        public void setSelIndexToVCSelIndex(ArrayListInt[] selectionsMap) {
            this.selIndexToVCSelIndex = selectionsMap;
        }

        public ArrayListInt[] getSelIndexToVCSelIndex() {
            return this.selIndexToVCSelIndex;
        }

        public void setHierarchyIndexToVCHierarchyIndex(int[] hierarchyMap) {
            this.hierIndexToVCHierIndex = hierarchyMap;
        }

        public int[] getHierarchyIndexToVCHierarchyIndex() {
            return this.hierIndexToVCHierIndex;
        }

        public void setVCHierarchyMappings(int[] vcHierMaps) {
            this.vcHierarchyMappings = vcHierMaps;
        }

        public int[] getVCHierarchyMappings() {
            return this.vcHierarchyMappings;
        }
    }

    private static class SourceCubeQuery
    extends ROLAPCallable<SourceCubeQueryReturnType> {
        private static final int SOURCE_HIERARCHY_DEFAULTED = -1;
        private static final int VIRTUAL_HIERARCHY_MAPPED = -1;
        private static final int VIRTUAL_HIER_NOT_MAPPED_AND_NO_ALL_MEMBER = -2;
        private static final String MSG_SRC_HIERS_UNSATISFIED = "does not map to any unhidden hierarchies of the source cube.";
        private static final String MSG_NONCONF_ALLMEMBER = " Source members will merge only to the virtual ALL member.";
        private static final String MSG_VIRTUAL_HIERARCHY = "Virtual hierarchy ";
        private static final String MSG_HIERARCHY = "Hierarchy ";
        private static final String TASK_DESCRIPTION = "Dynamic Cube Source Cube Query: ";
        private final ROLAPCube mSourceCube;
        private final ROLAPVirtualCube mVirtualCube;
        private final ArrayList<IMember>[] mVcSelections;
        private final SecurityManagerInterface securityManager;
        private final QueryContext mVirtualQueryContext;
        private final SourceCubeQueryReturnType result;

        SourceCubeQuery(ROLAPCube sourceCube, ROLAPVirtualCube virtualCube, ArrayList<IMember>[] vcSelectionsLists, QueryContext virtualQueryContext) {
            super(virtualCube);
            this.mSourceCube = sourceCube;
            this.mVirtualCube = virtualCube;
            this.mVcSelections = vcSelectionsLists;
            this.mVirtualQueryContext = virtualQueryContext;
            this.securityManager = this.mSourceCube.getSecurityManager();
            this.result = new SourceCubeQueryReturnType(sourceCube);
            this.mZipiAction = "DCSourceCubeQuery";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SourceCubeQueryReturnType callImpl() throws Exception {
            TraceContext traceCtx = TraceContext.enter();
            traceCtx.addAttribute("rolapCube", this.mSourceCube.getName());
            ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPQuery.Performance", "Started execution of source cube query thread.");
            boolean needToRemoveCubeName = false;
            try {
                needToRemoveCubeName = ROLAPContext.setCurrentCubeName(this.mSourceCube.getName());
                this.performSubQuery();
                SourceCubeQueryReturnType sourceCubeQueryReturnType = this.result;
                return sourceCubeQueryReturnType;
            }
            finally {
                ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
                ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPQuery.Performance", "Exiting source cube query thread.");
                traceCtx.exit();
            }
        }

        private void performSubQuery() throws InterpreterException {
            CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
            Hierarchy[] hierarchies = this.mSourceCube.getHierarchies().toArray(new Hierarchy[0]);
            int hierCount = hierarchies.length;
            HashMapObjectInt<IHierarchy> hierarchyToIndex = new HashMapObjectInt<IHierarchy>();
            for (int i = 0; i < hierCount; ++i) {
                hierarchyToIndex.put(hierarchies[i], i);
            }
            ArrayList<Integer> srcSelectionHierarchyOrder = new ArrayList<Integer>();
            HashMapObjectInt<IMember>[] selectionToIndexByHier = this.getFilteredSourceCubeSelections(hierarchyToIndex, hierCount, srcSelectionHierarchyOrder);
            if (selectionToIndexByHier == null) {
                if (ROLAPLog.isOn("ROLAPCubes.Virtual", LogLevel.INFO)) {
                    ROLAPLog.log("ROLAPCubes.Virtual", "Source cube query unnecessary. No tuples map to the source cube.");
                }
                return;
            }
            boolean[] isDefaulted = new boolean[hierCount];
            int numDefaultedHiers = this.getDefaultSelectionForMissingHierarchies(this.mSourceCube.getName(), hierarchies, srcSelectionHierarchyOrder, selectionToIndexByHier, hierarchyToIndex, isDefaulted);
            if (!this.isSubQueryNecessary(this.mSourceCube, isDefaulted, numDefaultedHiers)) {
                if (ROLAPLog.isOn("ROLAPCubes.Virtual", LogLevel.INFO)) {
                    ROLAPLog.log("ROLAPCubes.Virtual", "Source cube query unnecessary. Hierarchy constraints are unsatisfied.");
                }
                return;
            }
            ISet[] sets = new com.cognos.xqe.runtree.olap.mdx.interpreter.Set[hierCount];
            for (int j = 0; j < hierCount; ++j) {
                int hierIdx = srcSelectionHierarchyOrder.get(j);
                IMember[] selections = new IMember[selectionToIndexByHier[hierIdx].size()];
                Set<IMember> mems = selectionToIndexByHier[hierIdx].keySet();
                for (IMember mem : mems) {
                    int idx = selectionToIndexByHier[hierIdx].get(mem);
                    selections[idx] = mem;
                }
                sets[j] = new com.cognos.xqe.runtree.olap.mdx.interpreter.Set(Tuple.createTupleList(selections));
            }
            boolean cjsEmpty = false;
            for (int i = 0; i < sets.length; ++i) {
                com.cognos.xqe.runtree.olap.mdx.interpreter.Set set = sets[i];
                if (set.size() != 0L) continue;
                cjsEmpty = true;
                break;
            }
            if (!cjsEmpty) {
                QueryStrategy qs = this.mSourceCube.getQueryStrategy();
                qs.setInfoData(this.mVirtualQueryContext);
                qs.setCube(this.mSourceCube);
                CrossJoinedSet subQuery = new CrossJoinedSet(sets);
                IResultSet tempResultSet = SecuredResultSetHelper.createSecuredResultSet(subQuery, this.mSourceCube.getSecurityManager());
                if (ROLAPLog.isOn("ROLAPCubes.Virtual", LogLevel.INFO)) {
                    ROLAPLog.log("ROLAPCubes.Virtual", "Executing source cube query for set:" + NEWLN + subQuery.toString());
                }
                if (cancelManager != null && cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                XQueryStrategy profiler = (XQueryStrategy)this.mVirtualQueryContext.getQueryStrategyProfileNode();
                profiler.setMode(XProfileInfoCollector.ProfileMode.NESTED);
                qs.execute(subQuery, tempResultSet);
                this.result.setResultSet(tempResultSet);
            } else if (ROLAPLog.isOn("ROLAPCubes.Virtual", LogLevel.INFO)) {
                ROLAPLog.log("ROLAPCubes.Virtual", "Source cube query unnecessary. Empty set.");
            }
        }

        private int getDefaultSelectionForMissingHierarchies(String sourceCubeName, Hierarchy[] hierarchies, ArrayList<Integer> srcSelectionHierarchyOrder, HashMapObjectInt<IMember>[] selectionToIndexByHier, HashMapObjectInt<IHierarchy> hierarchyToIndex, boolean[] isDefaulted) {
            int numDefaultedHiers = 0;
            for (Hierarchy hierarchy : hierarchies) {
                int hierIdx = hierarchyToIndex.get(hierarchy);
                if (selectionToIndexByHier[hierIdx] != null && !this.getHiddenFlagsForSourceCubeHierarchies()[hierIdx]) {
                    isDefaulted[hierIdx] = false;
                    continue;
                }
                srcSelectionHierarchyOrder.add(hierIdx);
                isDefaulted[hierIdx] = true;
                ++numDefaultedHiers;
                IMember defaultMember = this.getHierarchyDefaultMember(sourceCubeName, hierarchy);
                if (ROLAPVirtualHierarchy.isCalculatedMember(defaultMember)) {
                    if (ROLAPLog.isOn("ROLAPCubes.Virtual", LogLevel.WARN)) {
                        ROLAPLog.log("ROLAPCubes.Virtual", MSG_HIERARCHY + hierarchy.getUniqueName() + " could not be defaulted because the default member " + defaultMember.getUniqueName() + " is a calculation.");
                    }
                    return -1;
                }
                HashMapObjectInt<IMember> defSelection = new HashMapObjectInt<IMember>(-1);
                defSelection.put(defaultMember, 0);
                selectionToIndexByHier[hierIdx] = defSelection;
            }
            return numDefaultedHiers;
        }

        private boolean[] getHiddenFlagsForSourceCubeHierarchies() {
            List<IHierarchy> hierarchies = this.mSourceCube.getHierarchies();
            int hierCount = hierarchies.size();
            boolean[] isHidden = new boolean[hierCount];
            HashSet<String> hiddenHierarchies = this.mVirtualCube.getROLAPVirtualCubeDef().getHiddenHierarchies();
            HashSet<String> hiddenDimensions = this.mVirtualCube.getROLAPVirtualCubeDef().getHiddenDimensions();
            for (int j = 0; j < hierCount; ++j) {
                String hiddenHierName = ROLAPVirtualCube.getFullyQualifiedUniqueName(this.mSourceCube, (IMetadata)hierarchies.get(j));
                String hiddenDimName = ROLAPVirtualCube.getFullyQualifiedUniqueName(this.mSourceCube, (IMetadata)hierarchies.get(j).getDimension());
                isHidden[j] = hiddenHierarchies.contains(hiddenHierName) || hiddenDimensions.contains(hiddenDimName);
            }
            return isHidden;
        }

        private IMember getHierarchyDefaultMember(String sourceCubeName, Hierarchy hierarchy) {
            IMember defaultMember = null;
            String defaultMemberName = this.mVirtualCube.getROLAPVirtualCubeDef().getVHierarchyUniqueNameToDefaultMember().get(ROLAPVirtualCube.getFullyQualifiedUniqueName(sourceCubeName, (IMetadata)hierarchy));
            if (defaultMemberName != null) {
                defaultMember = hierarchy.findMember(defaultMemberName);
            }
            if (defaultMember == null) {
                defaultMember = hierarchy.getDefaultMember();
            }
            return defaultMember;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HashMapObjectInt<IMember>[] getFilteredSourceCubeSelections(HashMapObjectInt<IHierarchy> hierarchyToIndex, int hierCount, ArrayList<Integer> srcSelectionHierarchyOrder) {
            HashSet<String> alreadySeen = new HashSet<String>();
            HashMapObjectInt[] selectionToIndexByHier = (HashMapObjectInt[])ArrayCast.uncheckedCast(new HashMapObjectInt[hierCount]);
            ArrayListInt[] selectionIndexToVCSelectionIndex = (ArrayListInt[])ArrayCast.uncheckedCast(new ArrayListInt[hierCount]);
            int[] hierarchyIndexToVCHierarchyIndex = new int[hierCount];
            Arrays.fill(hierarchyIndexToVCHierarchyIndex, -1);
            int[] vcHierMappings = new int[this.mVcSelections.length];
            int vcSelHierIdx = -1;
            for (int i = 0; i < this.mVcSelections.length; ++i) {
                boolean isSharedDimension = false;
                int[] sharedDimensionCubeIndexes = null;
                Pair[] sharedMembers = null;
                vcHierMappings[i] = -1;
                boolean hasMemberInSourceCube = false;
                int indexOfAllMember = -1;
                IROLAPMember allMember = null;
                block4: for (int j = 0; j < this.mVcSelections[i].size(); ++j) {
                    IMember virtualMember = this.mVcSelections[i].get(j);
                    if (j == 0) {
                        isSharedDimension = virtualMember.getDimension().isShareable();
                        if (isSharedDimension) {
                            sharedDimensionCubeIndexes = ((ShareableROLAPDimension)virtualMember.getDimension()).getVirtualCubeSourceCubeIndexes(this.mVirtualCube.getName());
                            sharedMembers = new Pair[sharedDimensionCubeIndexes.length];
                        }
                        if (isSharedDimension) {
                            String previousCurrentCubeName = ROLAPContext.getCurrentCubeName();
                            ROLAPContext.removeCurrentCubeName(previousCurrentCubeName != null);
                            try {
                                ROLAPContext.setCurrentCubeName(this.mVirtualCube.getName());
                                allMember = ((IROLAPMember)virtualMember).getROLAPHierarchy().getROLAPAllMember();
                            }
                            finally {
                                ROLAPContext.removeCurrentCubeName(true);
                                if (previousCurrentCubeName != null) {
                                    ROLAPContext.setCurrentCubeName(previousCurrentCubeName);
                                }
                            }
                        } else {
                            allMember = ((IROLAPMember)virtualMember).getROLAPHierarchy().getROLAPAllMember();
                        }
                    }
                    if (virtualMember == allMember) {
                        indexOfAllMember = j;
                    }
                    Pair[] sourceMembers = isSharedDimension ? sharedMembers : ((IROLAPMember)virtualMember).getSourceMembers();
                    for (int k = 0; k < sourceMembers.length; ++k) {
                        ROLAPCube sourceMemberCube;
                        IMember sourceMember;
                        if (isSharedDimension) {
                            sourceMember = virtualMember;
                            sourceMemberCube = this.mVirtualCube.getSourceCubes()[sharedDimensionCubeIndexes[k]];
                        } else {
                            sourceMember = (IMember)sourceMembers[k].getFirst();
                            sourceMemberCube = this.mVirtualCube.getSourceCubes()[(Integer)sourceMembers[k].getSecond()];
                        }
                        if (sourceMember == null) continue;
                        IHierarchy hier = sourceMember.getHierarchy();
                        IDimension sourceDim = sourceMember.getDimension();
                        if (sourceMemberCube != this.mSourceCube) continue;
                        if (!hasMemberInSourceCube) {
                            hasMemberInSourceCube = true;
                            hierarchyIndexToVCHierarchyIndex[++vcSelHierIdx] = i;
                        }
                        int hierIdx = hierarchyToIndex.get(hier);
                        if (!alreadySeen.add(sourceMember.getUniqueName())) continue block4;
                        if (selectionToIndexByHier[hierIdx] == null) {
                            selectionToIndexByHier[hierIdx] = new HashMapObjectInt(-1);
                            srcSelectionHierarchyOrder.add(hierIdx);
                        }
                        if (selectionIndexToVCSelectionIndex[srcSelectionHierarchyOrder.size() - 1] == null) {
                            selectionIndexToVCSelectionIndex[srcSelectionHierarchyOrder.size() - 1] = new ArrayListInt();
                        }
                        if (this.securityManager != null) {
                            if (this.securityManager.isDimensionSecured(sourceDim) && sourceMember != hier.getDefaultMember()) {
                                if (!ROLAPLog.isOn("ROLAPCubes.Virtual", LogLevel.TRACE)) continue block4;
                                ROLAPLog.log("ROLAPCubes.Virtual", "Source member filtered by security (dimension is secured): " + sourceMember.getUniqueName());
                                continue block4;
                            }
                            IMember[] allowedMembers = this.securityManager.applySecurity(new IMember[]{sourceMember}, sourceMember.getHierarchy());
                            if (allowedMembers != null && allowedMembers.length > 0) {
                                selectionToIndexByHier[hierIdx].put(sourceMember, selectionToIndexByHier[hierIdx].size());
                                selectionIndexToVCSelectionIndex[srcSelectionHierarchyOrder.size() - 1].add(j);
                                continue block4;
                            }
                            if (!ROLAPLog.isOn("ROLAPCubes.Virtual", LogLevel.TRACE)) continue block4;
                            ROLAPLog.log("ROLAPCubes.Virtual", "Source member filtered by security: " + sourceMember.getUniqueName());
                            continue block4;
                        }
                        selectionToIndexByHier[hierIdx].put(sourceMember, selectionToIndexByHier[hierIdx].size());
                        selectionIndexToVCSelectionIndex[srcSelectionHierarchyOrder.size() - 1].add(j);
                        continue block4;
                    }
                }
                if (hasMemberInSourceCube) continue;
                if (indexOfAllMember != -1) {
                    vcHierMappings[i] = indexOfAllMember;
                    if (!ROLAPLog.isOn("ROLAPCubes.Virtual", LogLevel.TRACE)) continue;
                    IHierarchy virtualHierarchy = this.mVcSelections[i].get(0).getHierarchy();
                    ROLAPLog.log("ROLAPCubes.Virtual", MSG_VIRTUAL_HIERARCHY + virtualHierarchy.getUniqueName() + MSG_SRC_HIERS_UNSATISFIED + MSG_NONCONF_ALLMEMBER);
                    continue;
                }
                vcHierMappings[i] = -2;
                if (ROLAPLog.isOn("ROLAPCubes.Virtual", LogLevel.TRACE)) {
                    IHierarchy virtualHierarchy = this.mVcSelections[i].get(0).getHierarchy();
                    ROLAPLog.log("ROLAPCubes.Virtual", MSG_VIRTUAL_HIERARCHY + virtualHierarchy.getUniqueName() + MSG_SRC_HIERS_UNSATISFIED);
                }
                return null;
            }
            this.result.setSelIndexToVCSelIndex(selectionIndexToVCSelectionIndex);
            this.result.setHierarchyIndexToVCHierarchyIndex(hierarchyIndexToVCHierarchyIndex);
            this.result.setVCHierarchyMappings(vcHierMappings);
            return selectionToIndexByHier;
        }

        private boolean isSubQueryNecessary(Cube cube, boolean[] isDefaulted, int numDefaultedHiers) {
            Hierarchy[] hierarchies = cube.getHierarchies().toArray(new Hierarchy[isDefaulted.length]);
            int hierCount = hierarchies.length;
            if (numDefaultedHiers < 0) {
                return false;
            }
            boolean[] isHidden = this.getHiddenFlagsForSourceCubeHierarchies();
            for (int j = 0; j < hierCount; ++j) {
                boolean shouldMerge;
                boolean bl = shouldMerge = isDefaulted[j] == isHidden[j];
                if (shouldMerge) continue;
                if (ROLAPLog.isOn("ROLAPCubes.Virtual", LogLevel.INFO)) {
                    String explanation = " has no selections.";
                    if (isHidden[j]) {
                        explanation = " is hidden but could not be defaulted.";
                    }
                    ROLAPLog.log("ROLAPCubes.Virtual", MSG_HIERARCHY + hierarchies[j].getUniqueName() + explanation);
                }
                return false;
            }
            return true;
        }

        public String toString() {
            return TASK_DESCRIPTION + this.mVirtualCube.getUniqueName() + " -> " + this.mSourceCube.getUniqueName();
        }
    }

    private static class SelectionsIterator {
        int[] tupleSlice;
        int[] dimSelectionsSize;
        int total = 1;
        int count = 0;
        long[] weights;
        CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();

        SelectionsIterator(ArrayList<IMember>[] vcSelections) {
            int numDims = vcSelections.length;
            this.tupleSlice = new int[numDims];
            this.dimSelectionsSize = new int[numDims];
            for (int i = 0; i < numDims; ++i) {
                this.dimSelectionsSize[i] = vcSelections[i].size();
                this.total *= this.dimSelectionsSize[i];
                this.tupleSlice[i] = 0;
                if (this.total == 0) break;
            }
            long weight = 1L;
            this.weights = new long[numDims];
            for (int i = numDims - 1; i >= 0; --i) {
                this.weights[i] = weight;
                weight = this.weights[i] * (long)this.dimSelectionsSize[i];
            }
        }

        public boolean hasNext() {
            return this.count < this.total;
        }

        public int[] getNext() {
            if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            if (this.count == 0) {
                ++this.count;
                return this.tupleSlice;
            }
            for (int k = this.tupleSlice.length - 1; k >= 0; --k) {
                int n = k;
                this.tupleSlice[n] = this.tupleSlice[n] + 1;
                if (this.tupleSlice[k] != this.dimSelectionsSize[k]) break;
                this.tupleSlice[k] = 0;
            }
            ++this.count;
            return this.tupleSlice;
        }

        public long size() {
            return this.total;
        }

        public static Tuple getTuple(ArrayList<IMember>[] vcSelections, int[] registers) {
            IMember[] members = new IMember[registers.length];
            for (int j = 0; j < registers.length; ++j) {
                members[j] = vcSelections[j].get(registers[j]);
            }
            return new Tuple(members, false);
        }
    }
}

