/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.TupleStorageLogger;
import com.cognos.xqe.runtree.olap.mdx.storage.TupleNotFoundException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.BTree;
import org.apache.xindice.core.filer.BTreeException;
import org.apache.xindice.core.filer.BTreeNotFoundException;
import org.apache.xindice.util.Configuration;

public class BTreeTupleIDHelper {
    private static final String USER_DIMENSION_STRING = "__USERDIM__";
    private static final int NUMBER_3 = 3;
    private static final int NUMBER_MINUS3 = -3;
    protected static final int NUMBER_128 = 128;
    protected static final int NUMBER_8 = 8;
    protected static final int NUMBER_HEX_FF = 255;
    private static final String OPEN_BRACE = "[";
    private static final String DIMINDEX_SUFFIX = "]!__DimIndex__";
    protected static final String MAXID_SUFFIX = ":__MaxID__";
    protected int bytesPerID = 3;
    protected boolean includeUserID = true;
    protected AtomicBoolean testForDimensionOrder = new AtomicBoolean();
    private ReentrantReadWriteLock indexLock = new ReentrantReadWriteLock();
    protected BTree index;
    private String indexFilename;
    private boolean deleteFilesOnClose = false;
    private boolean cubeScope = true;

    protected BTreeTupleIDHelper(String fileName, Configuration config, boolean create, boolean deleteFiles, boolean includeUser) {
        this.indexFilename = fileName;
        this.deleteFilesOnClose = deleteFiles;
        this.includeUserID = includeUser;
        this.testForDimensionOrder.set(true);
        File indexf = new File(this.indexFilename);
        this.index = new BTree(indexf);
        if (config != null) {
            this.index.setConfig(config);
        }
        try {
            if (create) {
                this.index.create();
            } else {
                this.index.open();
                TupleStorageLogger.getLogger().reuse(this.indexFilename);
            }
        }
        catch (DBException e) {
            throw new XQERuntimeException(e);
        }
    }

    protected BTreeTupleIDHelper(String fileName, Configuration config, Map<String, Integer> uniqueNameToID, HashMap<Dimension, Integer> dimensionToMemberCount, boolean includeUser) {
        this(fileName, config, true, true, includeUser);
        this.initialiseIndex(uniqueNameToID, dimensionToMemberCount);
    }

    protected byte[] tupleToByteArray(Tuple t, String userName, boolean create) throws TupleNotFoundException {
        if (this.testForDimensionOrder.get()) {
            this.initialiseDimensionOrder(t);
        }
        int tSize = t.size();
        if (this.includeUserID) {
            ++tSize;
        }
        int userID = -1;
        if (this.includeUserID && userName != null) {
            userID = this.getIndexIDForUserName(userName, create);
        }
        byte[] b = new byte[tSize * this.bytesPerID];
        int j = 0;
        for (int i = 0; i < tSize; ++i) {
            int memberOrderValue;
            if (this.includeUserID) {
                if (i == 0) {
                    memberOrderValue = userID;
                } else {
                    IMember mem = t.getMember(i - 1);
                    memberOrderValue = this.getIndexIDForMember(mem, create);
                }
            } else {
                IMember mem = t.getMember(i);
                memberOrderValue = this.getIndexIDForMember(mem, create);
            }
            for (int k = this.bytesPerID - 1; k >= 0; --k) {
                b[j] = (byte)((memberOrderValue >> 8 * k) - 128 & 0xFF);
                ++j;
            }
        }
        return b;
    }

    protected byte[] tupleToByteArray(Tuple t, boolean create, boolean includeDimensionID) throws TupleNotFoundException {
        if (this.testForDimensionOrder.get()) {
            this.initialiseDimensionOrder(t);
        }
        int tSize = t.size();
        int bytesPerMem = includeDimensionID ? this.bytesPerID + 1 : this.bytesPerID;
        byte[] b = new byte[tSize * bytesPerMem];
        int j = 0;
        for (int i = 0; i < tSize; ++i) {
            IMember mem = t.getMember(i);
            int memberOrderValue = this.getIndexIDForMember(mem, create);
            int dimIndex = mem.getDimension().getIndex();
            b[j] = (byte)(dimIndex - 128 & 0xFF);
            ++j;
            for (int k = this.bytesPerID - 1; k >= 0; --k) {
                b[j] = (byte)((memberOrderValue >> 8 * k) - 128 & 0xFF);
                ++j;
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initialiseDimensionOrder(Tuple tup) {
        if (!this.testForDimensionOrder.get()) {
            return;
        }
        Value testKey = new Value("__DimOrderSet__");
        try {
            this.indexLock.writeLock().lock();
            try {
                int n = (int)this.indexFindValue(testKey);
            }
            catch (BTreeNotFoundException e) {
                int offset = 0;
                if (this.includeUserID) {
                    offset = 1;
                    String key = "[__USERDIM__]!__DimIndex__";
                    Value val = new Value(key);
                    this.index.addValue(val, 0L);
                }
                for (int i = 0; i < tup.size(); ++i) {
                    IMember mem = tup.getMember(i);
                    Dimension dim = (Dimension)mem.getDimension();
                    String key = OPEN_BRACE + dim.getName() + DIMINDEX_SUFFIX;
                    Value val = new Value(key);
                    this.index.addValue(val, (long)i + (long)offset);
                }
                this.index.addValue(testKey, 1L);
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        catch (BTreeException e) {
            throw new XQERuntimeException(e);
        }
        this.testForDimensionOrder.set(false);
    }

    protected long indexFindValue(Value key) throws IOException, BTreeException {
        return BTreeTupleIDHelper.safeFindValue(this.indexLock, this.index, key);
    }

    protected void indexAddValue(Value key, long id) throws IOException, BTreeException {
        BTreeTupleIDHelper.safeAddValue(this.indexLock, this.index, key, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long safeFindValue(ReentrantReadWriteLock lock, BTree tree, Value key) throws IOException, BTreeException {
        long id = -1L;
        lock.readLock().lock();
        try {
            id = tree.findValue(key);
        }
        finally {
            lock.readLock().unlock();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void safeAddValue(ReentrantReadWriteLock lock, BTree tree, Value key, long id) throws IOException, BTreeException {
        lock.writeLock().lock();
        try {
            tree.addValue(key, id);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void safeRemoveValue(ReentrantReadWriteLock lock, BTree tree, Value key) throws BTreeException, IOException {
        lock.writeLock().lock();
        try {
            tree.removeValue(key);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public int getIndexIDForMemberName(String dimName, String memName, boolean create) throws TupleNotFoundException {
        int id;
        block8: {
            id = -1;
            try {
                Value memKey = new Value(memName);
                try {
                    id = (int)this.indexFindValue(memKey);
                }
                catch (BTreeNotFoundException e) {
                    if (create) {
                        String maxDimIDKey = dimName + MAXID_SUFFIX;
                        Value maxKey = new Value(maxDimIDKey);
                        id = 0;
                        try {
                            id = (int)this.indexFindValue(maxKey);
                            ++id;
                        }
                        catch (BTreeNotFoundException bTreeNotFoundException) {
                            // empty catch block
                        }
                        this.indexAddValue(maxKey, id);
                        this.indexAddValue(memKey, id);
                        break block8;
                    }
                    throw new TupleNotFoundException("X01507", new String[]{memName}, e);
                }
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            catch (BTreeException e) {
                throw new XQERuntimeException(e);
            }
        }
        return id;
    }

    public int getIndexIDForMember(IMember mem, boolean create) throws TupleNotFoundException {
        int id = (int)((IMemberCubics)mem).getMemberId();
        if (id == -1) {
            id = this.getIndexIDForMemberName(mem.getDimension().getName(), mem.getUniqueName(), create);
            if (this.cubeScope) {
                ((IMemberCubics)mem).setMemberId(id);
            }
        }
        return id;
    }

    public int getIndexIDForUserName(String userName, boolean create) throws TupleNotFoundException {
        int id;
        block8: {
            id = -1;
            try {
                Value memKey = new Value(userName);
                try {
                    id = (int)this.indexFindValue(memKey);
                }
                catch (BTreeNotFoundException e) {
                    if (create) {
                        String dimName = USER_DIMENSION_STRING;
                        String maxDimIDKey = dimName + MAXID_SUFFIX;
                        Value maxKey = new Value(maxDimIDKey);
                        id = 0;
                        try {
                            id = (int)this.indexFindValue(maxKey);
                            ++id;
                        }
                        catch (BTreeNotFoundException bTreeNotFoundException) {
                            // empty catch block
                        }
                        this.indexAddValue(maxKey, id);
                        this.indexAddValue(memKey, id);
                        break block8;
                    }
                    throw new TupleNotFoundException("X01507", new String[]{userName}, e);
                }
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            catch (BTreeException e) {
                throw new XQERuntimeException(e);
            }
        }
        return id;
    }

    private int getIndexIDForMember(String uniqueName, Dimension dim, boolean create) throws TupleNotFoundException {
        int id;
        block8: {
            id = -3;
            try {
                Value memKey = new Value(uniqueName);
                try {
                    id = (int)this.indexFindValue(memKey);
                }
                catch (BTreeNotFoundException e) {
                    if (create) {
                        String dimName = dim.getName();
                        String maxDimIDKey = dimName + MAXID_SUFFIX;
                        Value maxKey = new Value(maxDimIDKey);
                        id = 0;
                        try {
                            id = (int)this.indexFindValue(maxKey);
                            ++id;
                        }
                        catch (BTreeNotFoundException bTreeNotFoundException) {
                            // empty catch block
                        }
                        this.indexAddValue(maxKey, id);
                        this.indexAddValue(memKey, id);
                        break block8;
                    }
                    throw new TupleNotFoundException("X01507", new String[]{uniqueName}, e);
                }
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            catch (BTreeException e) {
                throw new XQERuntimeException(e);
            }
        }
        return id;
    }

    protected byte[] tupleToByteArray(String[] uniqueNames, Cube cube, boolean create) throws TupleNotFoundException {
        int tSize = uniqueNames.length;
        byte[] b = new byte[tSize * this.bytesPerID];
        int j = 0;
        for (int i = 0; i < tSize; ++i) {
            String uniqueName = uniqueNames[i];
            Dimension dim = (Dimension)cube.getDimension(i);
            int memberOrderValue = this.getIndexIDForMember(uniqueName, dim, create);
            for (int k = this.bytesPerID - 1; k >= 0; --k) {
                b[j] = (byte)((memberOrderValue >> 8 * k) - 128 & 0xFF);
                ++j;
            }
        }
        return b;
    }

    protected byte[] tupleToByteArray(String[] uniqueNames, List<IDimension> dims, boolean create) throws TupleNotFoundException {
        int tSize = uniqueNames.length;
        byte[] b = new byte[tSize * this.bytesPerID];
        int j = 0;
        for (int i = 0; i < tSize; ++i) {
            String uniqueName = uniqueNames[i];
            Dimension dim = (Dimension)dims.get(i);
            int memberOrderValue = this.getIndexIDForMember(uniqueName, dim, create);
            for (int k = this.bytesPerID - 1; k >= 0; --k) {
                b[j] = (byte)((memberOrderValue >> 8 * k) - 128 & 0xFF);
                ++j;
            }
        }
        return b;
    }

    public void close() {
        this.indexLock.writeLock().lock();
        try {
            if (this.index != null) {
                this.index.drop();
                this.index.close();
            }
            this.testForDimensionOrder.set(true);
        }
        catch (DBException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            if (this.deleteFilesOnClose && this.indexFilename != null) {
                File indexf = new File(this.indexFilename);
                indexf.delete();
            }
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initialiseIndex(Map<String, Integer> uniqueNameToID, Map<Dimension, Integer> dimensionToMemberCount) {
        Set<Map.Entry<Dimension, Integer>> entrySet = dimensionToMemberCount.entrySet();
        Iterator<Map.Entry<Dimension, Integer>> it = entrySet.iterator();
        this.indexLock.writeLock().lock();
        try {
            int id;
            while (it.hasNext()) {
                Map.Entry<Dimension, Integer> entry = it.next();
                Dimension dim = entry.getKey();
                String maxDimIDKey = dim.getName() + MAXID_SUFFIX;
                Value maxKey = new Value(maxDimIDKey);
                id = entry.getValue();
                try {
                    this.index.addValue(maxKey, (long)id);
                }
                catch (IOException e) {
                    throw new XQERuntimeException(e);
                }
                catch (BTreeException e) {
                    throw new XQERuntimeException(e);
                }
            }
            Set<Map.Entry<String, Integer>> nameEntrySet = uniqueNameToID.entrySet();
            Iterator<Map.Entry<String, Integer>> nameEntryIterator = nameEntrySet.iterator();
            while (it.hasNext()) {
                Map.Entry<String, Integer> entry = nameEntryIterator.next();
                Value key = new Value(entry.getKey());
                id = entry.getValue();
                try {
                    this.index.addValue(key, (long)id);
                }
                catch (IOException e) {
                    throw new XQERuntimeException(e);
                }
                catch (BTreeException e) {
                    throw new XQERuntimeException(e);
                    return;
                }
            }
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    public void setScope(boolean theCubeScope) {
        this.cubeScope = theCubeScope;
    }
}

