/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage;

import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.bibushandler.CubeRequestMetrics;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.ObjectValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.TestEnvironmentOptions;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.functions.Utilities;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.runtree.olap.mdx.storage.ExpressionCacheResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.primitive.ArrayListInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;

public class ExpressionCacheManager {
    public static final String CONFIG_EXPRESSIONCACHE_ENABLED = "qsExpressionCacheEnabled";
    public static final boolean DEFAULT_EXPRESSIONCACHE_ENABLED = true;
    private static MultiRequestContext multiRequestContext = ExecutionEnvironmentContext.getExecutionEnvironment().getMultiRequestContext();
    private static XQELogger expCacheLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MDXEngine.ExpressionCache", LogLevel.TRACE);

    public static void put(XQEBaseQueryNode node, Block resultBlock, InterpreterContext ic, long calcTime) throws InterpreterException {
        if (!ExpressionCacheManager.getExpressionCacheEnabled() || ic.inPrimingPhase()) {
            return;
        }
        if (node == null) {
            return;
        }
        String expStr = node.dumpToString(false);
        if (expStr.length() == 0) {
            return;
        }
        if (expCacheLogger.isOn(LogLevel.TRACE)) {
            expCacheLogger.log(LogLevel.TRACE, "Attempting to store node with key: " + expStr);
        }
        ExpressionCacheManager.storeInQueryCache(expStr, resultBlock, ic, calcTime);
        if (((XMdxNode)node).isCacheableNode(ic.getXDataContext())) {
            if (expStr.indexOf("\"XQE_") == -1) {
                ExpressionCacheManager.storeInCubeCache(expStr, resultBlock);
            }
        } else if (expCacheLogger.isOn(LogLevel.TRACE)) {
            expCacheLogger.log(LogLevel.TRACE, "Node can not be saved in the expression cache. A caclulated member or named set was evaluated during the node evaluation");
        }
    }

    private static void storeInCubeCache(String exprStr, Block block) throws InterpreterException {
        ICube cube = block.getContextSet()[0].getHierarchies()[0].getDimension().getCube();
        IBlockTupleStorage blockStorage = ((Cube)cube).getBlockTupleStorage();
        if (blockStorage == null) {
            return;
        }
        if (block.getDefaultValue() != null) {
            return;
        }
        CrossJoinedSet nonDegenSet = new CrossJoinedSet(block.getSets());
        if (nonDegenSet.isEmpty()) {
            if (ExpressionCacheManager.mapSetToCubeHierarchies(cube, new CrossJoinedSet(block.getContextSet())) == null) {
                return;
            }
            ObjectValue defaultValue = DataValueFactory.createObjectValue();
            ((Value)defaultValue).set(block.first());
            blockStorage.putDefaultValue(exprStr, defaultValue);
            return;
        }
        if (nonDegenSet.isLargeSet()) {
            if (expCacheLogger.isOn(LogLevel.TRACE)) {
                expCacheLogger.log(LogLevel.TRACE, "Expression not cached because set size > Long.MAX_Value.  Expression key is " + exprStr);
            }
            return;
        }
        int[] hierarchyMap = ExpressionCacheManager.mapSetToCubeHierarchies(cube, nonDegenSet);
        if (hierarchyMap == null) {
            return;
        }
        ArrayList<TupleValue> resultsToCache = new ArrayList<TupleValue>();
        boolean setContainsCalculation = false;
        boolean tupleContainsCalculation = false;
        BlockIterator blockIter = block.iterator();
        while (blockIter.hasNext()) {
            Object[] blockObjs = (Object[])blockIter.next();
            Tuple contextTuple = (Tuple)blockIter.getCurrentTuple();
            if (contextTuple.size() == 0) {
                block.iterator(true);
            }
            tupleContainsCalculation = false;
            IMember[] members = new IMember[hierarchyMap.length];
            for (int i = 0; i < contextTuple.size(); ++i) {
                members[i] = contextTuple.getMember(hierarchyMap[i]);
                if (!members[i].isCalculatedMember()) continue;
                tupleContainsCalculation = true;
                setContainsCalculation = true;
                break;
            }
            if (tupleContainsCalculation) continue;
            contextTuple = new Tuple(members);
            ObjectValue value = DataValueFactory.createObjectValue();
            ((Value)value).set(blockObjs[0]);
            resultsToCache.add(new TupleValue(contextTuple, new Cell(value, -1L, false)));
        }
        if (expCacheLogger.isOn(LogLevel.TRACE)) {
            if (setContainsCalculation) {
                expCacheLogger.log(LogLevel.TRACE, "Found calculation in context. " + resultsToCache.size() + " tuples cached.");
            } else {
                expCacheLogger.log(LogLevel.TRACE, "Cached all " + resultsToCache.size() + " tuples.");
            }
        }
        if (resultsToCache.size() == 0) {
            return;
        }
        blockStorage.putTupleValues(exprStr, nonDegenSet, resultsToCache.iterator());
    }

    private static void storeInQueryCache(String expStr, Block resultBlock, InterpreterContext ic, long calcTime) {
        Block.cacheBlock(expStr, resultBlock, ic, calcTime);
    }

    public static ExpressionCacheResult get(XQEBaseQueryNode node, String nodeName, InterpreterContext interpreterContext) throws InterpreterException {
        ExpressionCacheResult queryCache;
        if (!ExpressionCacheManager.getExpressionCacheEnabled()) {
            return null;
        }
        if (node == null) {
            return null;
        }
        RequestEnvironment reqEnv = (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment();
        CubeRequestMetrics reqMetrics = reqEnv.getRequestMetrics().getCubeMetrics(interpreterContext.getCube());
        HighPrecisionStopWatch timer = new HighPrecisionStopWatch(true);
        String expStr = node.dumpToString(false);
        if (expStr.length() == 0) {
            reqMetrics.addExpressionCacheRequest(timer.getElapsedTimeInMilliseconds(), false);
            return null;
        }
        if (expCacheLogger.isOn(LogLevel.TRACE)) {
            expCacheLogger.log(LogLevel.TRACE, "Attempting to get node with key: " + expStr);
        }
        if ((queryCache = ExpressionCacheManager.searchQueryCache(expStr, nodeName, interpreterContext)) != null) {
            reqMetrics.addExpressionCacheRequest(timer.getElapsedTimeInMilliseconds(), true);
            return queryCache;
        }
        ExpressionCacheResult cubeCache = ExpressionCacheManager.searchCubeCache(expStr, interpreterContext);
        reqMetrics.addExpressionCacheRequest(timer.getElapsedTimeInMilliseconds(), cubeCache != null);
        return cubeCache;
    }

    private static ExpressionCacheResult searchQueryCache(String expStr, String nodeName, InterpreterContext interpreterContext) throws InterpreterException {
        Block.cacheLog(nodeName + ": Looking in expression cache.");
        Block retBlock = Block.getCachedBlock(expStr, interpreterContext);
        if (retBlock == null) {
            return null;
        }
        if (interpreterContext.getContextSet().size() < 0L) {
            return null;
        }
        ExpressionCacheResult cacheResult = new ExpressionCacheResult(retBlock, null);
        return cacheResult;
    }

    private static ExpressionCacheResult searchCubeCache(String expStr, InterpreterContext interpreterContext) throws InterpreterException {
        Cube cube = (Cube)interpreterContext.getCube();
        IBlockTupleStorage blockStorage = cube.getBlockTupleStorage();
        if (blockStorage == null) {
            return null;
        }
        CrossJoinedSet fetchSet = interpreterContext.getContextSet();
        ArrayList<TupleValue> cachedResults = new ArrayList<TupleValue>();
        ArrayListInt intNonDegenSets = new ArrayListInt();
        ObjectValue defaultValue = DataValueFactory.createObjectValue();
        defaultValue.setNull();
        ISet contextTuplesNotCached = blockStorage.getTupleValues(expStr, fetchSet, cachedResults, defaultValue, intNonDegenSets);
        if (contextTuplesNotCached.size() == fetchSet.size()) {
            return null;
        }
        if (expCacheLogger != null && expCacheLogger.isOn(LogLevel.INFO)) {
            if (expCacheLogger.isOn(LogLevel.TRACE)) {
                expCacheLogger.log(LogLevel.TRACE, "Expression cache hit for " + expStr + " for report " + Utilities.getReportName());
            } else {
                expCacheLogger.log(LogLevel.INFO, "Expression cache hit for report " + Utilities.getReportName());
            }
        }
        if (!defaultValue.isNull()) {
            ISet cachedSet = (ISet)((Value)defaultValue).getObject();
            ISet newSet = (ISet)cachedSet.copy();
            Block retBlock = new Block(interpreterContext, newSet);
            ExpressionCacheResult cacheResult = new ExpressionCacheResult(retBlock, contextTuplesNotCached);
            return cacheResult;
        }
        TreeSet<Cell> blockCells = new TreeSet<Cell>();
        for (TupleValue tv : cachedResults) {
            long cellOrd = tv.getCell().getOrdinal();
            Value cellValue = (Value)tv.getCell().getObjectValue();
            ISet cachedSet = (ISet)cellValue.getObject();
            ISet newSet = (ISet)cachedSet.copy();
            Cell blockCell = new Cell(newSet, cellOrd, false);
            blockCells.add(blockCell);
        }
        ExpressionCacheManager.trackCacheHitMetrics(cachedResults.size());
        Block retBlock = new Block(interpreterContext, blockCells, intNonDegenSets);
        ExpressionCacheResult cacheResult = new ExpressionCacheResult(retBlock, contextTuplesNotCached);
        return cacheResult;
    }

    private static void trackCacheHitMetrics(int numCachedResults) {
        TestEnvironmentOptions.TestHitCountTracker thct = TestEnvironmentOptions.TestHitCountTracker.current();
        if (thct != null) {
            thct.getExpressionCacheListener().incrementHits(numCachedResults);
        }
    }

    public static ISet getTuplesNotCached(XQEBaseQueryNode node, Cube cube, ISet fetchSet) throws InterpreterException {
        IBlockTupleStorage blockStorage = cube.getBlockTupleStorage();
        if (blockStorage == null) {
            return fetchSet;
        }
        if (node == null) {
            return fetchSet;
        }
        RequestEnvironment reqEnv = (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment();
        CubeRequestMetrics reqMetrics = reqEnv.getRequestMetrics().getCubeMetrics(cube);
        HighPrecisionStopWatch timer = new HighPrecisionStopWatch(true);
        String expStr = node.dumpToString(false);
        if (expStr.length() == 0) {
            reqMetrics.addExpressionCacheRequest(timer.getElapsedTimeInMilliseconds(), false);
            return fetchSet;
        }
        ArrayList<TupleValue> cachedResults = new ArrayList<TupleValue>();
        ArrayListInt intNonDegenSets = new ArrayListInt();
        ObjectValue defaultValue = DataValueFactory.createObjectValue();
        defaultValue.setNull();
        ISet contextTuplesNotCached = blockStorage.getTupleValues(expStr, fetchSet, cachedResults, defaultValue, intNonDegenSets);
        if (!defaultValue.isNull()) {
            reqMetrics.addExpressionCacheRequest(timer.getElapsedTimeInMilliseconds(), true);
            return new Set(new Tuple[0]);
        }
        reqMetrics.addExpressionCacheRequest(timer.getElapsedTimeInMilliseconds(), contextTuplesNotCached.size() > 0L);
        if (contextTuplesNotCached.size() > 0L) {
            return contextTuplesNotCached;
        }
        return new Set(new Tuple[0]);
    }

    private static int[] mapSetToCubeHierarchies(ICube cube, ISet set) {
        List<IHierarchy> setHierarchies = Arrays.asList(set.getHierarchies());
        List<IHierarchy> cubeHierarchies = ((Cube)cube).getHierarchies();
        int[] hierarchyMap = new int[setHierarchies.size()];
        int mapIdx = 0;
        for (int i = 0; i < cubeHierarchies.size(); ++i) {
            int setHierIdx = setHierarchies.indexOf(cubeHierarchies.get(i));
            if (setHierIdx == -1) continue;
            hierarchyMap[mapIdx++] = setHierIdx;
        }
        if (mapIdx < hierarchyMap.length) {
            return null;
        }
        return hierarchyMap;
    }

    public static boolean getExpressionCacheEnabled() {
        return multiRequestContext.fetchBooleanConfiguration(CONFIG_EXPRESSIONCACHE_ENABLED, true);
    }

    public static void setExpressionCacheEnabled(boolean enabled) {
        multiRequestContext.getXQEConfiguration().setProperty(CONFIG_EXPRESSIONCACHE_ENABLED, String.valueOf(enabled));
    }
}

