/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage;

import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.util.primitive.ArrayListLong;

public class ExpressionCacheResult {
    Block block;
    private final ArrayListLong emptyCellOrdinals;
    private final ISet unresolvedContext;

    public ExpressionCacheResult(Block blockToCache, ISet unresolvedCtxt) {
        this.block = blockToCache;
        this.unresolvedContext = unresolvedCtxt != null && unresolvedCtxt.size() > 0L ? unresolvedCtxt : null;
        long tupleSetSize = this.block.tupleSetSize();
        if (tupleSetSize < 0L) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "", String.valueOf(tupleSetSize), "long");
        }
        this.emptyCellOrdinals = new ArrayListLong();
        long emptyCellOrd = 0L;
        BlockIterator blockIter = this.block.iterator();
        while (blockIter.hasNext()) {
            blockIter.next();
            long cellOrd = blockIter.pos();
            for (long i = emptyCellOrd; i < cellOrd; ++i) {
                this.emptyCellOrdinals.add(i);
            }
            emptyCellOrd = cellOrd + 1L;
        }
        if (emptyCellOrd < tupleSetSize) {
            for (long i = emptyCellOrd; i < tupleSetSize; ++i) {
                this.emptyCellOrdinals.add(i);
            }
        }
    }

    public ArrayListLong getEmptyOrdinals() {
        return this.emptyCellOrdinals;
    }

    public Block getBlock() {
        return this.block;
    }

    public ISet getUnresolvedContext() {
        return this.unresolvedContext;
    }
}

