/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage;

import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.storage.ICellStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.InMemoryCellStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorageFetchResult;
import com.cognos.xqe.runtree.olap.mdx.util.CompareNumbers;
import com.cognos.xqe.runtree.olap.mdx.util.ICellCombiner;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class InStreamCellStorage
implements ICellStorage {
    private IBlockTupleStorage streamStorage = null;
    private HashMap<Number, ICell> cmStorage = new HashMap();
    private TreeSet<Number> ordinalSet = new TreeSet<Number>(new CompareNumbers());
    private InMemoryCellStorage memoryPool = null;
    private ResultSet resultSet = null;

    public InStreamCellStorage(ResultSet rSet, IBlockTupleStorage storage) {
        this.resultSet = rSet;
        this.streamStorage = storage;
        this.memoryPool = new InMemoryCellStorage(this.resultSet);
    }

    @Override
    public void clear() {
        this.ordinalSet.clear();
        this.memoryPool.clear();
    }

    @Override
    public ICell get(Number ordinal) {
        IBlockTupleStorageFetchResult tupleValues;
        if (!this.ordinalSet.contains(ordinal)) {
            return null;
        }
        ICell cell = this.cmStorage.get(ordinal);
        if (cell != null) {
            return cell;
        }
        ITuple tuple = null;
        if (ordinal instanceof BigInteger) {
            this.resultSet.getTupleByCellOrdinal((BigInteger)ordinal);
        } else {
            this.resultSet.getTupleByCellOrdinal((Long)ordinal);
        }
        Set singleTupeSet = new Set(tuple);
        try {
            tupleValues = this.streamStorage.getTupleValues(singleTupeSet);
        }
        catch (InterpreterException e) {
            return null;
        }
        cell = tupleValues.getTuplesValues().get(0).getCell();
        return cell;
    }

    @Override
    public ICell put(Number ordinal, ICell cell) {
        this.ordinalSet.add(ordinal);
        Tuple tuple = null;
        if (ordinal instanceof BigInteger) {
            this.resultSet.getTupleByCellOrdinal((BigInteger)ordinal);
        } else {
            this.resultSet.getTupleByCellOrdinal((Long)ordinal);
        }
        if (tuple.containsCalculation()) {
            this.cmStorage.put(ordinal, cell);
        }
        return cell;
    }

    @Override
    public ICell remove(Number ordinal) {
        ICell removedCell = this.get(ordinal);
        this.ordinalSet.remove(ordinal);
        this.memoryPool.remove(ordinal);
        return removedCell;
    }

    @Override
    public int size() {
        return this.ordinalSet.size();
    }

    @Override
    public IBlockTupleStorage getStreamStorage() {
        return this.streamStorage;
    }

    @Override
    public boolean isCalculationCell(Number ordinal) {
        Cell cell = (Cell)this.cmStorage.get(ordinal);
        return cell != null && cell.isCalculation();
    }

    @Override
    public Iterator<ICell> getCellIterator() {
        return new InStreamValues().iterator();
    }

    @Override
    public Iterator<Number> getOrdinalIterator() {
        return this.ordinalSet.iterator();
    }

    @Override
    public void add(List<ICellStorage> others, ICellCombiner cellCombiner, ResultSet originalResultSet) {
    }

    private class InStreamValueIterator
    implements Iterator<ICell> {
        private Iterator<Number> baseIterator = null;

        InStreamValueIterator(Iterator<Number> ordinalSetIterator) {
            this.baseIterator = ordinalSetIterator;
        }

        @Override
        public boolean hasNext() {
            return this.baseIterator.hasNext();
        }

        @Override
        public ICell next() {
            return InStreamCellStorage.this.get(this.baseIterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class InStreamValues
    implements Collection<ICell> {
        private InStreamValues() {
        }

        @Override
        public boolean contains(Object o) {
            return InStreamCellStorage.this.ordinalSet.contains(((ICell)o).getOrdinal());
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (ICell cell : c) {
                if (InStreamCellStorage.this.ordinalSet.contains(cell.getOrdinal())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return InStreamCellStorage.this.ordinalSet.isEmpty();
        }

        @Override
        public Iterator<ICell> iterator() {
            return new InStreamValueIterator(InStreamCellStorage.this.ordinalSet.iterator());
        }

        @Override
        public int size() {
            return InStreamCellStorage.this.ordinalSet.size();
        }

        @Override
        public boolean add(ICell o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends ICell> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }
    }
}

