/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage;

import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleStorage;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.TupleStorageLogger;
import com.cognos.xqe.runtree.olap.mdx.storage.BTreeTupleIDHelper;
import com.cognos.xqe.util.io.ByteBufferOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.Record;
import org.apache.xindice.core.filer.BTreeCorruptException;
import org.apache.xindice.core.filer.BTreeFiler;
import org.apache.xindice.util.Configuration;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ValueTupleStorage
implements TupleStorage {
    private static final String TBL_EXT = ".tbl";
    private BTreeFiler valueStorage;
    private Map<IMember, IDataType> measureToType;
    private int measureDimensionIndex = -1;
    private Map<IDataType, Short> dataTypeToTypeId;
    private List<IDataType> typeIdToDataType;
    private ReadWriteLock dataTypeLock = new ReentrantReadWriteLock();
    private AtomicInteger dataTypeCounter = new AtomicInteger();
    private boolean measureDataTypeInconsistent = true;
    protected BTreeTupleIDHelper tupleIDHelper;
    private String dataFileName;
    private Cube cube;
    private boolean deleteBTreeFile = true;
    private ReadWriteLock btreeFilerLock = new ReentrantReadWriteLock();
    private final AtomicBoolean mCorrupted = new AtomicBoolean(false);

    public ValueTupleStorage(Cube c, String dataFile, String indexFileName, boolean create, boolean deleteFilesOnClose, boolean inconsistentDataType) {
        this(dataFile, indexFileName, create, deleteFilesOnClose, inconsistentDataType);
        this.cube = c;
    }

    public ValueTupleStorage(String dataFile, String indexFileName, boolean create, boolean deleteFilesOnClose, boolean inconsistentDataType) {
        this.dataFileName = dataFile;
        this.measureDataTypeInconsistent = inconsistentDataType;
        this.valueStorage = new BTreeFiler();
        this.deleteBTreeFile = deleteFilesOnClose;
        this.valueStorage.setLocation(null, this.dataFileName);
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            InputSource src = new InputSource(new StringReader("<xindice>    <root-collection dbroot='./db/' name='db'>        <queryengine>            <resolver autoindex='false' class='org.apache.xindice.core.query.XPathQueryResolver'/>            <resolver class='org.apache.xindice.core.xupdate.XUpdateQueryResolver'/>        </queryengine>    </root-collection>    <xml-rpc>        <driver name='xerces'/>    </xml-rpc></xindice>"));
            document = parser.parse(src);
        }
        catch (Exception e1) {
            throw XQERuntimeException.wrap(e1);
        }
        Configuration config = new Configuration(document, false);
        this.valueStorage.setConfig(config);
        this.tupleIDHelper = new BTreeTupleIDHelper(indexFileName, config, create, deleteFilesOnClose, false);
        try {
            if (create) {
                if (!this.valueStorage.create()) {
                    throw new XQERuntimeException();
                }
                TupleStorageLogger.getLogger().create(this.dataFileName + TBL_EXT);
            } else {
                TupleStorageLogger.getLogger().reuse(dataFile + TBL_EXT);
            }
            if (!this.valueStorage.open()) {
                throw new XQERuntimeException();
            }
        }
        catch (DBException e) {
            throw new XQERuntimeException(e);
        }
        if (this.measureDataTypeInconsistent) {
            this.dataTypeToTypeId = new HashMap<IDataType, Short>();
            this.typeIdToDataType = new ArrayList<IDataType>();
        } else {
            this.measureToType = new HashMap<IMember, IDataType>();
        }
    }

    @Override
    public void close() {
        this.btreeFilerLock.writeLock().lock();
        try {
            this.closeStorage();
        }
        finally {
            this.btreeFilerLock.writeLock().unlock();
        }
    }

    private void closeStorage() {
        this.tupleIDHelper.close();
        try {
            this.valueStorage.close();
        }
        catch (DBException f) {
        }
        finally {
            if (this.deleteBTreeFile) {
                TupleStorageLogger.getLogger().delete(this.dataFileName + TBL_EXT);
                File f = new File(this.dataFileName + TBL_EXT);
                f.delete();
            }
        }
    }

    @Override
    public boolean contains(Tuple tup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double get(Tuple tup) {
        Value tupleValue = this.getValue(tup);
        double value = 0.0;
        if (tupleValue != null && !tupleValue.isNull()) {
            value = tupleValue.getDouble();
        }
        return value;
    }

    @Override
    public String getDataFileName() {
        return this.dataFileName;
    }

    @Override
    public void increment(Tuple tup, double value, int aggregationType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void increment(Tuple tup, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(String[] uniqueNames, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(Tuple tup, double value) {
        this.put(tup, null, value);
    }

    public void put(Tuple tup, String userIdentifier, double value) {
        if (Double.isNaN(value)) {
            return;
        }
        DoubleValue data = DataValueFactory.createDoubleValue();
        data.set(value);
        if (!data.isNull()) {
            this.putValue(tup, data, userIdentifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short getDataTypeID(IDataType dataType) {
        this.dataTypeLock.readLock().lock();
        Short id = null;
        try {
            id = this.dataTypeToTypeId.get(dataType);
        }
        finally {
            this.dataTypeLock.readLock().unlock();
        }
        if (id != null) {
            return id;
        }
        this.dataTypeLock.writeLock().lock();
        try {
            id = this.dataTypeToTypeId.get(dataType);
            if (id != null) {
                short s = id;
                return s;
            }
            id = (short)this.dataTypeCounter.getAndIncrement();
            this.dataTypeToTypeId.put(dataType, id);
            this.typeIdToDataType.add(id.shortValue(), dataType);
        }
        finally {
            this.dataTypeLock.writeLock().unlock();
        }
        return id;
    }

    private IDataType getDataTypeByID(short id) {
        this.dataTypeLock.readLock().lock();
        try {
            IDataType iDataType = this.typeIdToDataType.get(id);
            return iDataType;
        }
        finally {
            this.dataTypeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void associateMeasureDataType(Tuple tup, IDataType valueDataType) {
        IDataType ds;
        int index = -1;
        this.dataTypeLock.readLock().lock();
        try {
            index = this.measureDimensionIndex;
        }
        finally {
            this.dataTypeLock.readLock().unlock();
        }
        if (index == -1) {
            this.dataTypeLock.writeLock().lock();
            try {
                if (this.measureDimensionIndex == -1) {
                    int idx = 0;
                    IDimension[] dims = tup.getDimensions();
                    while (this.measureDimensionIndex == -1) {
                        if (dims[idx].isMeasuresDimension()) {
                            this.measureDimensionIndex = idx;
                        }
                        ++idx;
                    }
                }
            }
            finally {
                this.dataTypeLock.writeLock().unlock();
            }
        }
        IMember measure = tup.getMember(this.measureDimensionIndex);
        this.dataTypeLock.readLock().lock();
        try {
            ds = this.measureToType.get(measure);
        }
        finally {
            this.dataTypeLock.readLock().unlock();
        }
        if (ds == null) {
            this.dataTypeLock.writeLock().lock();
            try {
                ds = this.measureToType.get(measure);
                if (ds != null) return;
                this.measureToType.put(measure, valueDataType);
                return;
            }
            finally {
                this.dataTypeLock.writeLock().unlock();
            }
        } else {
            if (DataTypeComparator.isValidCast(ds, valueDataType)) return;
            throw new RuntimeException("Measure type inconsistent with types already seen in storage. " + valueDataType + "!=" + ds);
        }
    }

    public void putValue(Tuple tup, Value value) {
        this.putValue(tup, value, null);
    }

    public void putValue(Tuple tup, Value value, String userIdentifier) {
        IDataType dataType = value.getDataType();
        ByteBufferOutputStream bos = new ByteBufferOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            if (this.measureDataTypeInconsistent) {
                dos.writeShort(this.getDataTypeID(dataType));
            } else {
                this.associateMeasureDataType(tup, dataType);
            }
            value.encode(dos);
        }
        catch (IOException e) {
            try {
                dos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new XQERuntimeException(e);
        }
        ByteBuffer buf = bos.getByteBuffer();
        byte[] bufArray = buf.array();
        try {
            Key tupleKey = new Key(this.tupleIDHelper.tupleToByteArray(tup, userIdentifier, true));
            this.btreeFilerLock.writeLock().lock();
            try {
                if (!this.getValueStorage().isOpened()) {
                    this.getValueStorage().open();
                }
                this.getValueStorage().writeRecord(tupleKey, new org.apache.xindice.core.data.Value(bufArray));
            }
            catch (BTreeCorruptException e) {
                this.handleCorruptedTupleStorage();
                throw e;
            }
            finally {
                this.btreeFilerLock.writeLock().unlock();
                dos.close();
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    public void putLongArray(Tuple tup, long[] valueArray) {
        ByteBufferOutputStream bos = new ByteBufferOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(valueArray.length);
            for (int i = 0; i < valueArray.length; ++i) {
                dos.writeLong(valueArray[i]);
            }
        }
        catch (IOException e) {
            try {
                dos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new XQERuntimeException(e);
        }
        ByteBuffer buf = bos.getByteBuffer();
        byte[] bufArray = buf.array();
        try {
            Key tupleKey = new Key(this.tupleIDHelper.tupleToByteArray(tup, true, true));
            this.btreeFilerLock.writeLock().lock();
            try {
                if (!this.getValueStorage().isOpened()) {
                    this.getValueStorage().open();
                }
                this.getValueStorage().writeRecord(tupleKey, new org.apache.xindice.core.data.Value(bufArray));
            }
            catch (BTreeCorruptException e) {
                this.handleCorruptedTupleStorage();
                throw e;
            }
            finally {
                this.btreeFilerLock.writeLock().unlock();
                dos.close();
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    public Value getValue(Tuple tup) {
        return this.getValue(tup, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getValue(Tuple tup, String userIdentifier) {
        Record aRecord;
        Value result;
        block35: {
            result = null;
            aRecord = null;
            try {
                Key tupleKey = new Key(this.tupleIDHelper.tupleToByteArray(tup, userIdentifier, true));
                boolean storageOpen = false;
                BTreeCorruptException bTreeException = null;
                this.btreeFilerLock.readLock().lock();
                try {
                    if (this.getValueStorage().isOpened()) {
                        aRecord = this.getValueStorage().readRecord(tupleKey);
                        storageOpen = true;
                    }
                }
                catch (BTreeCorruptException e) {
                    bTreeException = e;
                }
                finally {
                    this.btreeFilerLock.readLock().unlock();
                }
                if (bTreeException != null) {
                    this.btreeFilerLock.writeLock().lock();
                    try {
                        this.handleCorruptedTupleStorage();
                        throw bTreeException;
                    }
                    catch (Throwable throwable) {
                        this.btreeFilerLock.writeLock().unlock();
                        throw throwable;
                    }
                }
                if (storageOpen) break block35;
                this.btreeFilerLock.writeLock().lock();
                try {
                    if (!this.getValueStorage().isOpened()) {
                        this.getValueStorage().open();
                    }
                    aRecord = this.getValueStorage().readRecord(tupleKey);
                }
                catch (BTreeCorruptException e) {
                    this.handleCorruptedTupleStorage();
                    throw e;
                }
                finally {
                    this.btreeFilerLock.writeLock().unlock();
                }
            }
            catch (Exception e) {
                throw XQERuntimeException.wrap(e);
            }
        }
        if (aRecord == null) {
            return null;
        }
        org.apache.xindice.core.data.Value aValue = aRecord.getValue();
        DataInputStream dis = new DataInputStream(aValue.getInputStream());
        boolean success = false;
        try {
            IDataType dataType;
            if (this.measureDataTypeInconsistent) {
                short dataTypeId = dis.readShort();
                dataType = this.getDataTypeByID(dataTypeId);
            } else {
                this.dataTypeLock.readLock().lock();
                try {
                    if (this.measureDimensionIndex == -1) {
                        throw new IllegalStateException();
                    }
                    IMember measure = tup.getMember(this.measureDimensionIndex);
                    dataType = this.measureToType.get(measure);
                }
                finally {
                    this.dataTypeLock.readLock().unlock();
                }
            }
            if (dataType == null) {
                throw new IllegalStateException();
            }
            result = (Value)dataType.createValue();
            result.decode(dis);
            success = true;
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            block38: {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    if (!success) break block38;
                    throw new XQERuntimeException(e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getLongArray(Tuple tup) {
        Record aRecord;
        long[] result;
        block29: {
            result = null;
            aRecord = null;
            try {
                Key tupleKey = new Key(this.tupleIDHelper.tupleToByteArray(tup, true, true));
                boolean storageOpen = false;
                BTreeCorruptException bTreeException = null;
                this.btreeFilerLock.readLock().lock();
                try {
                    if (this.getValueStorage().isOpened()) {
                        aRecord = this.getValueStorage().readRecord(tupleKey);
                        storageOpen = true;
                    }
                }
                catch (BTreeCorruptException e) {
                    bTreeException = e;
                }
                finally {
                    this.btreeFilerLock.readLock().unlock();
                }
                if (bTreeException != null) {
                    this.btreeFilerLock.writeLock().lock();
                    try {
                        this.handleCorruptedTupleStorage();
                        throw bTreeException;
                    }
                    catch (Throwable throwable) {
                        this.btreeFilerLock.writeLock().unlock();
                        throw throwable;
                    }
                }
                if (storageOpen) break block29;
                this.btreeFilerLock.writeLock().lock();
                try {
                    if (!this.getValueStorage().isOpened()) {
                        this.getValueStorage().open();
                    }
                    aRecord = this.getValueStorage().readRecord(tupleKey);
                }
                catch (BTreeCorruptException e) {
                    this.handleCorruptedTupleStorage();
                    throw e;
                }
                finally {
                    this.btreeFilerLock.writeLock().unlock();
                }
            }
            catch (Exception e) {
                throw XQERuntimeException.wrap(e);
            }
        }
        if (aRecord == null) {
            return null;
        }
        org.apache.xindice.core.data.Value aValue = aRecord.getValue();
        DataInputStream dis = new DataInputStream(aValue.getInputStream());
        boolean success = false;
        try {
            int valueSize = dis.readInt();
            result = new long[valueSize];
            for (int i = 0; i < valueSize; ++i) {
                result[i] = dis.readLong();
            }
            success = true;
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            block31: {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    if (!success) break block31;
                    throw new XQERuntimeException(e);
                }
            }
        }
        return result;
    }

    private BTreeFiler getValueStorage() {
        this.checkIfCorrupted();
        return this.valueStorage;
    }

    private void handleCorruptedTupleStorage() {
        if (this.mCorrupted.compareAndSet(false, true)) {
            this.close();
            this.cube.forceRecreateTupleStorage();
        }
    }

    private void checkIfCorrupted() {
        if (this.mCorrupted.get()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "BTree corruption detected.");
        }
    }

    public long getRecordCount() {
        try {
            return this.getValueStorage().getRecordCount();
        }
        catch (DBException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Failed to get BTree record count.");
        }
    }
}

