/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IContextable;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.storage.ICellStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.util.ICellCombiner;
import com.cognos.xqe.trace.XQELog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.Record;
import org.apache.xindice.core.data.RecordSet;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.BTreeFiler;
import org.apache.xindice.core.filer.Filer;
import org.apache.xindice.util.Configuration;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XindiceCellStorage
implements ICellStorage,
IContextable {
    String cacheName;
    Filer filer;

    public XindiceCellStorage(String name) {
        this.cacheName = name;
        this.filer = this.createFiler(name);
    }

    public XindiceCellStorage() {
        this("cells_" + System.currentTimeMillis());
    }

    private Filer createFiler(String name) {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String cacheDirName = config.getXqeTempDirectory() + File.separator + "cellStorage";
        BTreeFiler newFiler = new BTreeFiler();
        try {
            File cacheDir = new File(cacheDirName);
            if (!cacheDir.exists()) {
                cacheDir.mkdirs();
            }
            newFiler.setLocation(cacheDir, name);
            Document document = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            InputSource src = new InputSource(new StringReader("<xindice>    <root-collection dbroot='./db/' name='db'>        <queryengine>            <resolver autoindex='false' class='org.apache.xindice.core.query.XPathQueryResolver'/>            <resolver class='org.apache.xindice.core.xupdate.XUpdateQueryResolver'/>        </queryengine>    </root-collection>    <xml-rpc>        <driver name='xerces'/>    </xml-rpc></xindice>"));
            document = parser.parse(src);
            Configuration filerConfig = new Configuration(document, false);
            newFiler.setConfig(filerConfig);
            newFiler.create();
            newFiler.open();
        }
        catch (ParserConfigurationException e) {
            throw new XQERuntimeException(e);
        }
        catch (DBException e) {
            throw new XQERuntimeException(e);
        }
        catch (SAXException e) {
            throw new XQERuntimeException(e);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        return newFiler;
    }

    @Override
    public void add(List<ICellStorage> others, ICellCombiner cellCombiner, ResultSet originalResultSet) {
        for (ICellStorage other : others) {
            Iterator<Number> it = other.getOrdinalIterator();
            while (it.hasNext()) {
                Number ordinal = it.next();
                ICell myCell = this.get(ordinal);
                if (myCell == null) {
                    if (!originalResultSet.isTupleValueVisible(ordinal)) continue;
                    ICell otherCell = other.get(ordinal);
                    Cell myNewCell = new Cell((Cell)otherCell);
                    Object copyOfValue = otherCell.getValue().copy();
                    myNewCell.setValue(copyOfValue);
                    this.put(ordinal, myNewCell);
                    continue;
                }
                cellCombiner.combine(myCell, other.get(ordinal));
            }
        }
    }

    @Override
    public void clear() {
        try {
            this.filer.close();
        }
        catch (DBException e) {
            throw new XQERuntimeException(e);
        }
        this.filer = this.createFiler(this.cacheName);
    }

    private Key createKey(Number ordinal) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(baos);
            os.writeObject(ordinal);
            return new Key(baos.toByteArray());
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    private Value createValue(ICell cell) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(baos);
            os.writeObject(cell);
            return new Key(baos.toByteArray());
        }
        catch (NotSerializableException e) {
            throw new XQERuntimeException(e);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    private Object getObject(Value value) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(value.getData());
            ObjectInputStream is = new ObjectInputStream(bais);
            Object object = is.readObject();
            is.close();
            XQELog.logConsole("retrieved object = " + object);
            return object;
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public ICell get(Number ordinal) {
        try {
            Record record = this.filer.readRecord(this.createKey(ordinal));
            if (record == null) {
                return null;
            }
            return (ICell)this.getObject(record.getValue());
        }
        catch (DBException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public Iterator<ICell> getCellIterator() {
        return new CellIterator();
    }

    @Override
    public Iterator<Number> getOrdinalIterator() {
        return new OrdinalIterator();
    }

    @Override
    public IBlockTupleStorage getStreamStorage() {
        return null;
    }

    @Override
    public boolean isCalculationCell(Number ordinal) {
        Cell cell = (Cell)this.get(ordinal);
        return cell != null && cell.isCalculation();
    }

    @Override
    public ICell put(Number ordinal, ICell cell) {
        XQELog.logConsole(ordinal + "," + cell);
        try {
            Key key = this.createKey(ordinal);
            Value value = this.createValue(cell);
            this.filer.writeRecord(key, value);
            return cell;
        }
        catch (DBException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public ICell remove(Number ordinal) {
        try {
            Key key = this.createKey(ordinal);
            this.filer.deleteRecord(key);
            return null;
        }
        catch (DBException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public int size() {
        try {
            return (int)this.filer.getRecordCount();
        }
        catch (DBException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public void release() {
        try {
            this.filer.close();
            this.filer.drop();
        }
        catch (DBException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public boolean isSessionScope() {
        return false;
    }

    private final class OrdinalIterator
    implements Iterator<Number> {
        private SortedKeyIterator iterator;

        private OrdinalIterator() {
            this.iterator = new SortedKeyIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Number next() {
            Key key = this.iterator.next();
            return (Number)XindiceCellStorage.this.getObject((Value)key);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class CellIterator
    implements Iterator<ICell> {
        private SortedKeyIterator iterator;

        private CellIterator() {
            this.iterator = new SortedKeyIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ICell next() {
            try {
                Key key = this.iterator.next();
                Record record = XindiceCellStorage.this.filer.readRecord(key);
                return (ICell)XindiceCellStorage.this.getObject(record.getValue());
            }
            catch (DBException e) {
                throw new XQERuntimeException(e);
            }
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class SortedKeyIterator
    implements Iterator<Key> {
        private TreeSet<Key> keys = new TreeSet();
        private Key current;
        private Iterator<Key> iterator;

        private SortedKeyIterator() {
            try {
                RecordSet recordSet = XindiceCellStorage.this.filer.getRecordSet();
                while (recordSet.hasMoreRecords()) {
                    Key key = recordSet.getNextKey();
                    this.keys.add(key);
                }
            }
            catch (DBException e) {
                throw new XQERuntimeException(e);
            }
            this.iterator = this.keys.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Key next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            try {
                XindiceCellStorage.this.filer.deleteRecord(this.current);
            }
            catch (DBException e) {
                throw new XQERuntimeException(e);
            }
        }
    }
}

