/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.MemberLevelInfo;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.util.NumberOp;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class BlockTupleStorageUtil {
    protected static final int NUM_BITS_IN_LONG = 63;
    protected static final CrossJoinedSet EMPTY_CJS = new CrossJoinedSet(new ISet[0]);

    public static CrossJoinedSet generateCrossJoinedSetInCubeHierarchyOrder(ISet aSet) {
        if (aSet.isEmpty()) {
            return EMPTY_CJS;
        }
        if (BlockTupleStorageUtil.isSetInCubeHierarchyOrder(aSet)) {
            return (CrossJoinedSet)aSet;
        }
        IHierarchy[] hierarchies = aSet.getHierarchies();
        List<IHierarchy> cubeHiersList = ((Cube)hierarchies[0].getDimension().getCube()).getHierarchies();
        IHierarchy[] cubeHiers = cubeHiersList.toArray(new IHierarchy[cubeHiersList.size()]);
        IMember[][] allHierSelections = aSet.getMembers(cubeHiers);
        return BlockTupleStorageUtil.createCjsFromMemberSelections(allHierSelections);
    }

    private static boolean isSetInCubeHierarchyOrder(ISet set) {
        IHierarchy[] setHiers = set.getHierarchies();
        List<IHierarchy> cubeHiers = ((Cube)setHiers[0].getDimension().getCube()).getHierarchies();
        for (int i = 0; i < setHiers.length; ++i) {
            if (setHiers[i] == cubeHiers.get(i)) continue;
            return false;
        }
        return true;
    }

    public static long getCombinationsSize(HashSet<IMember>[] selections) {
        long size = 0L;
        for (int i = 0; i < selections.length; ++i) {
            HashSet<IMember> set = selections[i];
            if (i == 0) {
                size = set.size();
                continue;
            }
            size *= (long)set.size();
        }
        return size;
    }

    public static long getCombinationsSize(IMember[][] allSelections) {
        long size = 0L;
        for (int i = 0; i < allSelections.length; ++i) {
            IMember[] dimSelections = allSelections[i];
            if (i == 0) {
                size = dimSelections.length;
                continue;
            }
            size *= (long)dimSelections.length;
        }
        return size;
    }

    public static boolean hasUnknownMbrs(HashSet<IMember>[] selections) {
        IMember[][] selectionsArrays = BlockTupleStorageUtil.selectionSetsToArrays(selections);
        return BlockTupleStorageUtil.hasUnknownMbrs(selectionsArrays);
    }

    public static boolean hasUnknownMbrs(IMember[][] selections) {
        for (int i = 0; i < selections.length; ++i) {
            if (selections[i].length <= 0) continue;
            return true;
        }
        return false;
    }

    public static CrossJoinedSet createCjsFromMemberSelections(Collection<IMember>[] selections) {
        IMember[][] selectionsArrays = BlockTupleStorageUtil.selectionSetsToArrays(selections);
        return BlockTupleStorageUtil.createCjsFromMemberSelections(selectionsArrays);
    }

    public static CrossJoinedSet createCjsFromMemberSelections(IMember[][] selections) {
        return BlockTupleStorageUtil.createCjsFromMemberSelections(selections, null, false);
    }

    public static CrossJoinedSet createCjsFromMemberSelections(IMember[][] selections, MemberLevelInfo existingLevelInfo, boolean allSetsAreDistinct) {
        ISet[] sets = new Set[selections.length];
        for (int j = 0; j < selections.length; ++j) {
            ITupleList tupleList = Tuple.createTupleList(selections[j]);
            if (tupleList != null) {
                tupleList.setDistinctFlag(allSetsAreDistinct);
            }
            sets[j] = new Set(tupleList);
        }
        CrossJoinedSet cjs = new CrossJoinedSet(sets);
        if (existingLevelInfo != null) {
            cjs.populateMemberLevelInfo(existingLevelInfo);
        }
        return cjs;
    }

    public static IMember[][] selectionSetsToArrays(Collection<IMember>[] selections) {
        IMember[][] selectionsArrays = new IMember[selections.length][];
        for (int j = 0; j < selections.length; ++j) {
            selectionsArrays[j] = selections[j].toArray(new IMember[selections[j].size()]);
        }
        return selectionsArrays;
    }

    public static Collection<IMember>[] arraysToSelectionSets(IMember[][] selections) {
        Collection[] arrayOfCollections = new Collection[selections.length];
        for (int i = 0; i < selections.length; ++i) {
            arrayOfCollections[i] = Arrays.asList(selections[i]);
        }
        return arrayOfCollections;
    }

    public static boolean isLargeSet(Number setSize) {
        if (setSize instanceof BigInteger) {
            BigInteger bigIntSetSize = (BigInteger)setSize;
            return bigIntSetSize.bitLength() > 63;
        }
        return setSize.longValue() < 0L;
    }

    public static Number getSetSize(int[] hierSizes) {
        Number size = 1L;
        for (int hierSize : hierSizes) {
            size = NumberOp.multiply(size, (Number)hierSize);
        }
        return size;
    }
}

