/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.FilteredTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleListFilter;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import java.util.ArrayList;
import java.util.List;

public final class BlockletFetchResult {
    private final ISet requestSet;
    private final ISet[] requestSets;
    private List<long[][]> requestOrdList;
    private List<TupleValue> tupleValues;
    private IValue defaultValue;

    public BlockletFetchResult(ISet reqSet, List<TupleValue> dstTupleValues) {
        this.requestSet = reqSet;
        this.requestSets = this.requestSet instanceof CrossJoinedSet ? ((CrossJoinedSet)reqSet).getSets() : new ISet[]{reqSet};
        long[][] fetchOrd = new long[this.requestSets.length][0];
        for (int i = 0; i < this.requestSets.length; ++i) {
            fetchOrd[i] = new long[(int)this.requestSets[i].size()];
            ResourceMonitor.checkMaxSetSize(this.requestSets[i].size(), null, XQEMessageKeys.MDX_MaxCrossjoinSize);
            int j = 0;
            while ((long)j < this.requestSets[i].size()) {
                fetchOrd[i][j] = j;
                ++j;
            }
        }
        this.requestOrdList = new ArrayList<long[][]>();
        this.requestOrdList.add(fetchOrd);
        this.tupleValues = dstTupleValues;
    }

    public List<long[][]> getSelectionsToFetch() {
        return this.requestOrdList;
    }

    public void setSelectionsToFetch(List<long[][]> ordList) {
        this.requestOrdList = ordList;
    }

    public ISet getRequestSet() {
        return this.requestSet;
    }

    public ISet[] getRequestSets() {
        return this.requestSets;
    }

    public List<TupleValue> getTuplesValues() {
        return this.tupleValues;
    }

    public IValue getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(IValue defValue) {
        this.defaultValue = defValue;
    }

    public ISet createSetFromOrdinalList(List<long[][]> ordList) throws InterpreterException {
        if (ordList == null || ordList.size() == 0) {
            return new Set(new Tuple[0]);
        }
        ArrayList<CrossJoinedSet> setsToUnion = new ArrayList<CrossJoinedSet>();
        for (int listIdx = 0; listIdx < ordList.size(); ++listIdx) {
            long[][] exceptOrds = ordList.get(listIdx);
            ISet[] exceptSets = new ISet[exceptOrds.length];
            for (int setIdx = 0; setIdx < exceptOrds.length; ++setIdx) {
                ISet workingSet = null;
                workingSet = exceptOrds.length > 1 ? this.requestSets[setIdx] : this.requestSet;
                TupleListFilter exceptFilter = new TupleListFilter(workingSet.size());
                for (int tupleIdx = 0; tupleIdx < exceptOrds[setIdx].length; ++tupleIdx) {
                    exceptFilter.enable(exceptOrds[setIdx][tupleIdx]);
                }
                ITupleList outputList = FilteredTupleList.construct(((Set)workingSet).getTupleList(), exceptFilter);
                exceptSets[setIdx] = new Set(outputList);
            }
            setsToUnion.add(new CrossJoinedSet(exceptSets));
        }
        return Set.union(setsToUnion.toArray(new Set[setsToUnion.size()]), true);
    }

    public static boolean isEmpty(List<long[][]> selections) {
        if (selections == null || selections.size() == 0) {
            return true;
        }
        for (int i = 0; i < selections.size(); ++i) {
            for (int j = 0; j < selections.get(i).length; ++j) {
                if (selections.get(i)[j].length <= 0) continue;
                return false;
            }
        }
        return true;
    }
}

