/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.MemberLevelInfo;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AbstractAggregateCalculationTask;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationMetrics;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateMemberCalculator;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateSelector;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateUtilities;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.CalculationDescription;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.ResultSetAggregateCalculationTask;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.TupleValueAggregateCalculationTask;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.ConfigurationValues;
import com.cognos.xqe.util.Pipe;
import com.cognos.xqe.util.concurrent.ThreadPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;

public class AggregateCalculationEngine {
    private static final int DEFAULT_CALCULATIONS_PER_TASK = 4;
    private static final String CALCULATIONS_PER_TASK = "AggregateCalculationEngineCalculationsPerTask";
    private static final int PROPORTION_OF_AVAILABLE_THREADS = 8;
    public static final String MAX_NUM_TASKS = "InMemoryAggregatesMaxTasks";
    private static final int MAX_NUM_TASKS_NOT_SPECIFIED = -1;
    public static final String CELLS_PER_TASK = "InMemoryAggregatesCellsPerTask";
    private static final int DEFAULT_CELLS_PER_TASK = 15000;
    private static final int MIN_NUM_MAX_TASKS = 4;
    private static final int MAX_MEMBERS_TO_PRINT = 15;
    private final CrossJoinedSet querySet;
    private List<List<ILevel>> allTargetLevels = null;
    private List<CalculationDescription> calcDescriptions = null;
    private Iterator<TupleValue>[] sourceTupleIterators = null;
    private int estimateNumSourceTuplesFromIterators = -1;
    private final IHierarchy[] hiers;
    private final List<Set<IMember>> filterMeasures;
    private ResultSet calculatedResultSet = null;
    private ResultSet overfetchResultSet = null;
    private HashMap<Tuple, Cell>[] calculatedTupleToCellMaps = null;

    public AggregateCalculationEngine(CrossJoinedSet destinationQuerySet) {
        this.querySet = destinationQuerySet;
        this.hiers = destinationQuerySet.getHierarchies();
        this.filterMeasures = null;
    }

    public AggregateCalculationEngine(List<List<ILevel>> allTgtLevels, List<Set<IMember>> aFilterMeasures) {
        this.allTargetLevels = allTgtLevels;
        this.querySet = null;
        this.filterMeasures = aFilterMeasures;
        List<ILevel> sampleTargetLevels = this.allTargetLevels.get(0);
        this.hiers = new IHierarchy[sampleTargetLevels.size()];
        for (int i = 0; i < this.hiers.length; ++i) {
            this.hiers[i] = sampleTargetLevels.get(i).getHierarchy();
        }
    }

    public static Collection<TupleValue> calculateValuesAtLevelsetFromSourceValues(Collection<TupleValue> sourceTupleValues, List<ILevel> levelSet, Set<IMember> filterMeasures) throws InterpreterException {
        ArrayList<List<ILevel>> levelSetList = new ArrayList<List<ILevel>>();
        levelSetList.add(levelSet);
        ArrayList<Set<IMember>> filterMeasureList = new ArrayList<Set<IMember>>();
        filterMeasureList.add(filterMeasures);
        List<List<TupleValue>> targetTupleValues = AggregateCalculationEngine.calculateValuesAtLevelsetFromSourceValues(sourceTupleValues, levelSetList, filterMeasureList);
        return targetTupleValues.get(0);
    }

    public static List<List<TupleValue>> calculateValuesAtLevelsetFromSourceValues(Collection<TupleValue> sourceTupleValues, List<List<ILevel>> levelSetList, List<Set<IMember>> filterMeasureList) throws InterpreterException {
        if (sourceTupleValues.isEmpty()) {
            ArrayList<List<TupleValue>> returnList = new ArrayList<List<TupleValue>>();
            for (List<ILevel> list : levelSetList) {
                returnList.add(Collections.emptyList());
            }
            return returnList;
        }
        if (filterMeasureList != null && filterMeasureList.size() != levelSetList.size()) {
            throw new IllegalArgumentException("The levelSetList and filterMeasureLists need to be the same size");
        }
        AggregateCalculationMetrics metrics = new AggregateCalculationMetrics();
        AggregateCalculationEngine ace = new AggregateCalculationEngine(levelSetList, filterMeasureList);
        ArrayList<TupleValue> sourceValues = sourceTupleValues instanceof List ? (ArrayList<TupleValue>)sourceTupleValues : new ArrayList<TupleValue>(sourceTupleValues);
        ace.setSourceData(sourceValues);
        List<List<TupleValue>> targetTupleValues = ace.calculate(metrics);
        return targetTupleValues;
    }

    public static List<List<TupleValue>> calculateValuesAtLevelsetFromSourceValues(Iterator<TupleValue>[] sourceTupleValues, int sourceTupleCountEstimate, List<ILevel> sourceLevels, List<List<ILevel>> tgtLevelSetList, List<Set<IMember>> filterMeasureList) throws InterpreterException {
        if (filterMeasureList != null && filterMeasureList.size() != tgtLevelSetList.size()) {
            throw new IllegalArgumentException("The levelSetList and filterMeasureLists need to be the same size.");
        }
        AggregateCalculationMetrics metrics = new AggregateCalculationMetrics();
        AggregateCalculationEngine ace = new AggregateCalculationEngine(tgtLevelSetList, filterMeasureList);
        ace.setSourceData(sourceTupleValues, sourceLevels, sourceTupleCountEstimate);
        List<List<TupleValue>> targetTupleValues = ace.calculate(metrics);
        return targetTupleValues;
    }

    public static List<List<TupleValue>> calculateValuesAtLevelsetFromSourceValues(Pipe<TupleValue> sourceTupleValues, int sourceTupleCountEstimate, List<ILevel> sourceLevels, List<List<ILevel>> tgtLevelSetList, List<Set<IMember>> filterMeasureList) throws InterpreterException {
        int numTasks = AggregateCalculationEngine.calcNumTasks(tgtLevelSetList.size());
        Iterator[] tvIters = new Iterator[numTasks];
        for (int i = 0; i < numTasks; ++i) {
            tvIters[i] = sourceTupleValues.iterator();
        }
        return AggregateCalculationEngine.calculateValuesAtLevelsetFromSourceValues(tvIters, sourceTupleCountEstimate, sourceLevels, tgtLevelSetList, filterMeasureList);
    }

    public void setSourceData(IBlockTupleStorage aggregateCache, AggregateSelector.AggregateSelection aggregateSelection, IMember[][] querySetMembers, AggregateCalculationMetrics metrics) throws InterpreterException {
        MemberLevelInfo targetMemberLevelInfo;
        AggregateDefinition aggregate = aggregateSelection.getAggregateDefintion();
        Set<IHierarchy> directMatchHierarchies = aggregateSelection.getDirectMatchHierarchies();
        HashMap<IHierarchy, ILevel> hierToAggrLevelMap = new HashMap<IHierarchy, ILevel>();
        for (ILevel aggregateLevel : aggregate.getLevels()) {
            hierToAggrLevelMap.put(aggregateLevel.getHierarchy(), aggregateLevel);
        }
        if (this.querySet != null) {
            targetMemberLevelInfo = this.querySet.getMemberLevelInfo();
        } else {
            if (this.allTargetLevels.size() > 1) {
                throw new UnsupportedOperationException("Currently cannot have an aggregate as a source with >1 target levels");
            }
            targetMemberLevelInfo = new MemberLevelInfo(this.allTargetLevels.get(0));
        }
        this.calcDescriptions = CalculationDescription.createFor(this.hiers, querySetMembers, aggregate, hierToAggrLevelMap, directMatchHierarchies, targetMemberLevelInfo);
        this.traceCalcDescriptions();
        AggregateMemberCalculator memberCalculator = new AggregateMemberCalculator(hierToAggrLevelMap);
        IMember[][] aggregateMembers = memberCalculator.getMembers(this.hiers, querySetMembers, aggregate, directMatchHierarchies, targetMemberLevelInfo);
        if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE)) {
            String membersAsString = AggregateUtilities.formatAsString(aggregateMembers, 15);
            ROLAPLog.logTrace("ROLAPCubes.AggregateCache", "Aggregate members accessed: " + membersAsString);
        }
        List<Iterator<TupleValue>> sourceTupleIters = AggregateUtilities.fetchAggregateValueIterators(aggregateCache, aggregate, aggregateMembers, metrics);
        this.sourceTupleIterators = AggregateUtilities.wrapIteratorsForAggregateCache(sourceTupleIters);
        this.estimateNumSourceTuplesFromIterators = AggregateUtilities.estimateNumberOfCellsFetchedFromAggregate(aggregate, aggregateMembers);
    }

    public void setSourceData(List<TupleValue> tupleValueList) {
        if (tupleValueList == null || tupleValueList.size() == 0) {
            throw new IllegalArgumentException("Cannot set a tupleValueList of zero items.");
        }
        if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE)) {
            this.validateSourceTupleValues(tupleValueList);
        }
        List<ILevel> sourceLevels = AggregateCalculationEngine.getLevelsForTuple(tupleValueList.get(0).getTuple(), this.hiers, null);
        this.setupCalcDescriptions(sourceLevels);
        int numTasks = AggregateCalculationEngine.calcNumberOfTasks(tupleValueList.size(), this.calcDescriptions);
        this.sourceTupleIterators = AggregateUtilities.createIterators(tupleValueList, numTasks);
        this.estimateNumSourceTuplesFromIterators = tupleValueList.size();
    }

    public void setSourceData(Iterator<TupleValue>[] tupleValueIterators, List<ILevel> sourceLevels, int sourceTupleCountEstimate) {
        if (tupleValueIterators == null || tupleValueIterators.length == 0) {
            throw new IllegalArgumentException("Cannot set a tupleValueIterators of zero items.");
        }
        this.setupCalcDescriptions(sourceLevels);
        this.sourceTupleIterators = tupleValueIterators;
        this.estimateNumSourceTuplesFromIterators = sourceTupleCountEstimate;
    }

    private void setupCalcDescriptions(List<ILevel> sourceLevels) {
        if (this.allTargetLevels == null) {
            MemberLevelInfo querySetLevelInfo = this.querySet.getMemberLevelInfo();
            for (IHierarchy h : this.hiers) {
                if (querySetLevelInfo.getLevelIndexes(h).size() <= 1) continue;
                throw new UnsupportedOperationException("Cannot have a multi level querySet.  Multiple levels exists on hier " + h);
            }
            List<ILevel> tupleLevels = AggregateCalculationEngine.getLevelsForTuple(this.querySet.getTuple(0L), this.hiers, null);
            this.allTargetLevels = new ArrayList<List<ILevel>>();
            this.allTargetLevels.add(tupleLevels);
        }
        this.calcDescriptions = new ArrayList<CalculationDescription>();
        for (List<ILevel> targetLevels : this.allTargetLevels) {
            this.calcDescriptions.add(CalculationDescription.createFor(sourceLevels, targetLevels));
        }
        this.traceCalcDescriptions();
    }

    private void validateSourceTupleValues(List<TupleValue> tupleValueList) {
        List<ILevel> firstTupleLevels = AggregateCalculationEngine.getLevelsForTuple(tupleValueList.get(0).getTuple(), this.hiers, null);
        List<ILevel> levels = new ArrayList<ILevel>();
        for (TupleValue tv : tupleValueList) {
            levels = AggregateCalculationEngine.getLevelsForTuple(tv.getTuple(), this.hiers, levels);
            for (int i = 0; i < firstTupleLevels.size(); ++i) {
                if (firstTupleLevels.size() != levels.size()) {
                    throw new IllegalArgumentException("Tuples have different number of members.  First tuple is " + tupleValueList.get(0) + " and other is " + tv);
                }
                if (firstTupleLevels.get(i) == levels.get(i)) continue;
                throw new IllegalArgumentException("All source tuples must be at the same levels at the same position.  First tuple is " + tupleValueList.get(0) + " and other is at " + tv);
            }
        }
    }

    public static List<ILevel> getLevelsForTuple(ITuple tpl, IHierarchy[] hiers, List<ILevel> levels) {
        if (levels == null) {
            levels = new ArrayList<ILevel>();
        } else {
            levels.clear();
        }
        IMember[] mbrs = tpl.getMembers();
        for (int i = 0; i < mbrs.length; ++i) {
            levels.add(mbrs[i].getLevel());
            if (hiers == null || mbrs[i].getHierarchy().equals(hiers[i])) continue;
            throw new IllegalArgumentException("Tuple has hierarchy " + mbrs[i].getHierarchy() + " in position " + i + " but querySet has hier " + hiers[i]);
        }
        return levels;
    }

    private void traceCalcDescriptions() {
        if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.calcDescriptions.size(); ++i) {
                sb.append("CalculationDescription " + i + " " + this.calcDescriptions.get(i));
            }
            ROLAPLog.logTrace("ROLAPCubes.AggregateCache", sb.toString());
        }
    }

    public ISet calculate(IResultSet origResultSet, AggregateCalculationMetrics metrics) throws InterpreterException {
        long querySetCopyStartTime = System.currentTimeMillis();
        CrossJoinedSet cjs = (CrossJoinedSet)origResultSet.getQuerySet().copy();
        cjs.size();
        long querySetCopyEndTime = System.currentTimeMillis();
        ROLAPLog.log("ROLAPCubes.AggregateCache", querySetCopyEndTime - querySetCopyStartTime + " ms to copy the querySet for the calculation resultSet");
        this.calculate(cjs, metrics);
        origResultSet.add(this.calculatedResultSet, false);
        return null;
    }

    public List<List<TupleValue>> calculate(AggregateCalculationMetrics metrics) throws InterpreterException {
        this.calculate((CrossJoinedSet)null, metrics);
        ArrayList<List<TupleValue>> tvLists = new ArrayList<List<TupleValue>>(this.calculatedTupleToCellMaps.length);
        for (int i = 0; i < this.calculatedTupleToCellMaps.length; ++i) {
            ArrayList<TupleValue> tvList = new ArrayList<TupleValue>(this.calculatedTupleToCellMaps[i].size());
            tvLists.add(tvList);
            for (Map.Entry<Tuple, Cell> entry : this.calculatedTupleToCellMaps[i].entrySet()) {
                TupleValue tv = new TupleValue(entry.getKey(), entry.getValue());
                tvList.add(tv);
            }
        }
        return tvLists;
    }

    private void calculate(CrossJoinedSet setForCalculatedResultSet, AggregateCalculationMetrics metrics) throws InterpreterException {
        if (this.sourceTupleIterators == null) {
            throw new IllegalStateException("setSourceData() was not called");
        }
        LinkedBlockingQueue<AggregateCalculationResult> resultQueue = new LinkedBlockingQueue<AggregateCalculationResult>();
        ROLAPCube cube = (ROLAPCube)this.hiers[0].getDimension().getCube();
        List<AbstractAggregateCalculationTask> tasks = this.createTasksFromIterators(resultQueue, setForCalculatedResultSet, cube);
        if (tasks.size() == 1) {
            try {
                tasks.get(0).callImpl();
            }
            catch (Exception e) {
                RuntimeException re = XQERuntimeException.wrap(e);
                throw re;
            }
        } else {
            ThreadPool threadPool = ThreadPool.getInstance();
            for (AbstractAggregateCalculationTask task : tasks) {
                Callable<Void> decoratedTask = AbstractAggregateCalculationTask.decorateCallable(task);
                threadPool.submit(decoratedTask);
            }
        }
        this.waitForResults(resultQueue, tasks.size(), metrics);
        metrics.setCellRollupLocations(this.calcDescriptions.size());
        if (this.calculatedResultSet != null) {
            metrics.setCellsInRequestedQuery(this.calculatedResultSet.cellCount());
        } else {
            long size = 0L;
            for (int i = 0; i < this.calculatedTupleToCellMaps.length; ++i) {
                size += (long)this.calculatedTupleToCellMaps[i].size();
            }
            metrics.setCellsInRequestedQuery(size);
        }
        if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE) && tasks.size() > 1) {
            if (this.calculatedResultSet != null) {
                AggregateUtilities.logResultSet("Final aggregate calculation result: ", this.calculatedResultSet);
                AggregateUtilities.logResultSet("Final aggregate overfetch calculation result: ", this.overfetchResultSet);
            } else {
                for (int i = 0; i < this.calculatedTupleToCellMaps.length; ++i) {
                    TupleValueAggregateCalculationTask.logTupleValueSet("Thread final values for calculation " + i + " : ", this.calculatedTupleToCellMaps[i]);
                }
            }
        }
    }

    public final IResultSet getCalculatedResultSet() {
        return this.calculatedResultSet;
    }

    public final IResultSet getOverfetchResultSet() {
        return this.overfetchResultSet;
    }

    private List<AbstractAggregateCalculationTask> createTasksFromIterators(BlockingQueue<AggregateCalculationResult> resultQueue, CrossJoinedSet setForCalculatedResultSet, ROLAPCube cube) {
        ArrayList<AbstractAggregateCalculationTask> tasks = new ArrayList<AbstractAggregateCalculationTask>(this.sourceTupleIterators.length);
        int estimateNumTuplesPerIterator = this.estimateNumSourceTuplesFromIterators / this.sourceTupleIterators.length;
        for (Iterator<TupleValue> sourceTupleIterator : this.sourceTupleIterators) {
            AbstractAggregateCalculationTask task = setForCalculatedResultSet != null ? new ResultSetAggregateCalculationTask(cube, resultQueue, this.hiers, this.querySet, setForCalculatedResultSet, this.calcDescriptions) : new TupleValueAggregateCalculationTask(cube, resultQueue, this.hiers, this.calcDescriptions, estimateNumTuplesPerIterator, this.filterMeasures);
            task.setAggregateData(sourceTupleIterator);
            tasks.add(task);
        }
        return tasks;
    }

    private static int calcNumberOfTasks(int numSourceTuples, List<CalculationDescription> calculationDescriptions) {
        long numTasks;
        int cellsPerTask = ConfigurationValues.getInt(CELLS_PER_TASK, 15000);
        if (cellsPerTask <= 0) {
            return 1;
        }
        int maxTasks = AggregateCalculationEngine.calcMaxTasks();
        if (maxTasks <= 1) {
            return 1;
        }
        double calcModifier = 1.0;
        if (calculationDescriptions.size() > 2) {
            calcModifier = (double)calculationDescriptions.size() / 2.0;
        }
        if ((numTasks = (long)((double)numSourceTuples * calcModifier / (double)cellsPerTask) + 1L) < 1L) {
            numTasks = 1L;
        } else if (numTasks > (long)maxTasks) {
            numTasks = maxTasks;
        }
        if (numTasks > (long)numSourceTuples && numSourceTuples > 0) {
            numTasks = numSourceTuples;
        }
        if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.INFO)) {
            ROLAPLog.log("ROLAPCubes.AggregateCache", "Using " + numTasks + " tasks to process aggregate.  Total number of aggregate cells accessed: " + numSourceTuples + " with a calculation modifier of " + calcModifier);
        }
        return (int)numTasks;
    }

    private static int calcNumTasks(int numCalculations) {
        int maxTasks = AggregateCalculationEngine.calcMaxTasks();
        int calculationsPerTask = ConfigurationValues.getInt(CALCULATIONS_PER_TASK, 4, 1, Integer.MAX_VALUE);
        int taskCount = Math.min(numCalculations / calculationsPerTask + 1, maxTasks);
        taskCount = Math.max(taskCount, 1);
        return taskCount;
    }

    private void waitForResults(BlockingQueue<AggregateCalculationResult> resultQueue, int numberOfTasks, AggregateCalculationMetrics metrics) {
        ResultSet combinedResultSet = null;
        ResultSet combinedOverfetchResultSet = null;
        HashMap<Tuple, Cell>[] combinedCellMap = null;
        while (numberOfTasks > 0) {
            AggregateCalculationResult calcResult;
            try {
                calcResult = resultQueue.take();
            }
            catch (InterruptedException e) {
                throw new XQERuntimeException(e);
            }
            if (calcResult.getException() != null) {
                throw calcResult.getException();
            }
            if (calcResult.getResultSet() != null) {
                if (combinedResultSet == null) {
                    combinedResultSet = calcResult.getResultSet();
                    combinedOverfetchResultSet = calcResult.getOverfetchResultSet();
                } else {
                    combinedResultSet.add(calcResult.getResultSet(), true);
                    combinedOverfetchResultSet.add(calcResult.getOverfetchResultSet(), true);
                }
            } else {
                combinedCellMap = combinedCellMap == null ? calcResult.getTupleToCellMaps() : TupleValueAggregateCalculationTask.combineResults(combinedCellMap, calcResult.getTupleToCellMaps());
            }
            metrics.add(calcResult.getMetrics());
            numberOfTasks -= calcResult.getNumberOfTasks();
        }
        this.overfetchResultSet = combinedOverfetchResultSet;
        this.calculatedResultSet = combinedResultSet;
        this.calculatedTupleToCellMaps = combinedCellMap;
    }

    private static int calcMaxTasks() {
        int maxTasks = ConfigurationValues.getInt(MAX_NUM_TASKS, -1);
        if (maxTasks < 0) {
            ThreadPool tp = ThreadPool.getInstance();
            maxTasks = Math.max(4, (tp.getMaximumPoolSize() - tp.getActiveCount()) / 8);
        }
        return maxTasks;
    }

    public static boolean canRollupMeasure(IMember measure) {
        AggregateTypeEnum measureType = measure.getRegularAggregate();
        boolean isSemiAggregate = measure.getAggregateRules().length > 0;
        boolean canRollup = !isSemiAggregate && (measureType == AggregateTypeEnum.COUNT || measureType == AggregateTypeEnum.SUM || measureType == AggregateTypeEnum.MAX || measureType == AggregateTypeEnum.MIN);
        return canRollup;
    }
}

