/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.AggregateCalculationGraphSubscriber;
import com.cognos.xqe.util.primitive.HashMapObjectInt;
import java.util.List;

public class AggregateDefinitionGraphSubscriber
implements AggregateCalculationGraphSubscriber {
    private final boolean loaded;
    private final AggregateDefinition aggregateDefinition;
    private final int[][] levels;

    public AggregateDefinitionGraphSubscriber(ROLAPCube cube, boolean alreadyLoaded, AggregateDefinition theAggregateDefinition) {
        this.loaded = alreadyLoaded;
        this.aggregateDefinition = theAggregateDefinition;
        this.levels = this.createLevels(cube);
    }

    private int[][] createLevels(ROLAPCube cube) {
        List<ILevel> allLevels = this.aggregateDefinition.getLevels();
        HashMapObjectInt<IHierarchy> hierToLevelNumber = new HashMapObjectInt<IHierarchy>(-1);
        for (ILevel l : allLevels) {
            hierToLevelNumber.put(l.getHierarchy(), l.getIndex());
        }
        List<IHierarchy> allHiers = cube.getHierarchies();
        int[][] theLevels = new int[allHiers.size()][];
        for (int i = 0; i < allHiers.size(); ++i) {
            theLevels[i] = new int[1];
            int levelNumber = hierToLevelNumber.get(allHiers.get(i));
            theLevels[i][0] = levelNumber >= 0 ? levelNumber : 0;
        }
        return theLevels;
    }

    @Override
    public int[][] getLevels() {
        return this.levels;
    }

    @Override
    public IMember[] getMeasures() {
        return this.aggregateDefinition.getMeasures();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public AggregateDefinition getAggregateDefinition() {
        return this.aggregateDefinition;
    }

    public int[] getLevelsAsSingleArray() {
        int[] indexes = new int[this.levels.length];
        for (int i = 0; i < this.levels.length; ++i) {
            indexes[i] = this.levels[i][0];
            if (this.levels[i].length <= 1) continue;
            throw new IllegalStateException("Can only have one level per hierarchy.");
        }
        return indexes;
    }
}

