/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.MemberLevelInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateUtilities;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletMaintenanceService;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.primitive.HashSetInt;
import com.cognos.xqe.util.primitive.IteratorInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AggregateSelector {
    private static final String AGGREGATE_TXT = "Aggregate ";
    private final List<AggregateDefinition> aggregates;
    private final Map<AggregateDefinition, List<ILevel>> aggrToLevels;
    private AggregateCubeletStorage aggregateCache = null;

    public AggregateSelector(List<AggregateDefinition> theAggregates) {
        this.aggregates = theAggregates;
        this.aggrToLevels = this.buildAggregatesToLevels(theAggregates);
    }

    public AggregateSelection select(CrossJoinedSet set) {
        IDimension[] dimensions = set.getDimensions();
        if (dimensions == null || dimensions.length == 0) {
            return null;
        }
        int requestIncrementId = MultiRequestContext.getCurrentIncrementId(dimensions[0].getCube());
        return this.select(set, requestIncrementId);
    }

    public AggregateSelection select(CrossJoinedSet set, int requestIncrementId) {
        if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE)) {
            ROLAPLog.logTrace("ROLAPCubes.AggregateCache", "Start aggregate selection for " + set);
        }
        IMember[] measures = AggregateUtilities.getMeasures(set);
        AggregateSelection bestResult = null;
        double currentLowestCost = Double.MAX_VALUE;
        for (AggregateDefinition aggregateDef : this.aggregates) {
            AggregateSelection result = this.scoreAggregate(aggregateDef, measures, set.getMemberLevelInfo(), currentLowestCost, requestIncrementId);
            if (result == null) continue;
            bestResult = result;
            currentLowestCost = bestResult.getCost();
        }
        if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.INFO)) {
            if (bestResult == null) {
                ROLAPLog.log("ROLAPCubes.AggregateCache", "No aggregate selected.");
            } else {
                ROLAPLog.log("ROLAPCubes.AggregateCache", AGGREGATE_TXT + UniqueNameGenerator.createUniqueName(bestResult.getAggregateDefintion().getName()) + " selected  with cost " + bestResult.getCost());
            }
        }
        return bestResult;
    }

    public void setAggregateCache(AggregateCubeletStorage theAggregateCache) {
        this.aggregateCache = theAggregateCache;
    }

    private Map<AggregateDefinition, List<ILevel>> buildAggregatesToLevels(List<AggregateDefinition> theAggregates) {
        HashMap<AggregateDefinition, List<ILevel>> aggregateToLevels = new HashMap<AggregateDefinition, List<ILevel>>();
        for (AggregateDefinition aggregate : theAggregates) {
            ArrayList<ILevel> levels = new ArrayList<ILevel>();
            levels.addAll(aggregate.getLevels());
            Collections.sort(levels, new LevelComparator());
            aggregateToLevels.put(aggregate, levels);
        }
        return aggregateToLevels;
    }

    private AggregateSelection scoreAggregate(AggregateDefinition aggregateDef, IMember[] measures, MemberLevelInfo queryLevelInfo, double lowestCost, int requestIncrementId) {
        long size;
        if (requestIncrementId < aggregateDef.getBaseIncrementId()) {
            if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE)) {
                ROLAPLog.logTrace("ROLAPCubes.AggregateCache", AGGREGATE_TXT + UniqueNameGenerator.createUniqueName(aggregateDef.getName()) + " rejected because requested increment id " + requestIncrementId + " is before base incrementId " + aggregateDef.getBaseIncrementId());
            }
            return null;
        }
        AggregateSelection result = new AggregateSelection(aggregateDef);
        if (!this.scoreMeasures(measures, result)) {
            return null;
        }
        if (result.isRequireDirectMatch() && requestIncrementId != aggregateDef.getBaseIncrementId()) {
            if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE)) {
                ROLAPLog.logTrace("ROLAPCubes.AggregateCache", AGGREGATE_TXT + UniqueNameGenerator.createUniqueName(aggregateDef.getName()) + " rejected because exact match requires and requested increment id " + requestIncrementId + " is not the same as aggregate base incrementId " + aggregateDef.getBaseIncrementId());
            }
            return null;
        }
        List<ILevel> aggregateLevels = this.aggrToLevels.get(aggregateDef);
        for (ILevel aggregateLevel : aggregateLevels) {
            if (!this.scoreHierarchy(aggregateLevel, queryLevelInfo, result)) {
                result = null;
                break;
            }
            if (!(result.getCost() > lowestCost)) continue;
            if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE)) {
                ROLAPLog.logTrace("ROLAPCubes.AggregateCache", AGGREGATE_TXT + UniqueNameGenerator.createUniqueName(aggregateDef.getName()) + " rejected because cost " + result.getCost() + " too high.");
            }
            result = null;
            break;
        }
        if (result != null && aggregateDef.canBeEvicted() && (size = aggregateDef.getStorageLocation().getCubeletSize(aggregateDef.getName())) < 0L) {
            if (this.aggregateCache != null) {
                CubeletMaintenanceService.getInstance().maintain(this.aggregateCache, 0.0);
                this.aggregateCache = null;
            }
            if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE)) {
                ROLAPLog.logTrace("ROLAPCubes.AggregateCache", AGGREGATE_TXT + UniqueNameGenerator.createUniqueName(aggregateDef.getName()) + " rejected because its not found in cubeletStorage.");
            }
            result = null;
        }
        return result;
    }

    private boolean scoreHierarchy(ILevel aggregateLevel, MemberLevelInfo queryLevelInfo, AggregateSelection result) {
        IHierarchy hier = aggregateLevel.getHierarchy();
        boolean queryBelowAggregateLevel = false;
        boolean queryAboveAggregateLevel = false;
        boolean mustHaveDirectMatch = result.isRequireDirectMatch();
        int aggregateLevelCardinality = aggregateLevel.getCardinality();
        HashSetInt queryLevels = queryLevelInfo.getLevelIndexes(hier);
        long totalEstimatedCells = 0L;
        ILevel levelToTrace = null;
        IteratorInt iter = queryLevels.iterator();
        while (iter.hasNext()) {
            int queryLevel = iter.next();
            if (queryLevel > aggregateLevel.getIndex()) {
                queryBelowAggregateLevel = true;
                levelToTrace = hier.getLevel(queryLevel);
                break;
            }
            if (queryLevel >= aggregateLevel.getIndex()) continue;
            queryAboveAggregateLevel = true;
            if (mustHaveDirectMatch) {
                levelToTrace = hier.getLevel(queryLevel);
                break;
            }
            int numberOfMembersAtLevel = queryLevelInfo.getMemberCount(hier, queryLevel);
            int memberLevelCardinality = hier.getLevel(queryLevel).getCardinality();
            double pctOfMembersSelected = (double)numberOfMembersAtLevel / (double)memberLevelCardinality;
            totalEstimatedCells = (long)((double)aggregateLevelCardinality * pctOfMembersSelected);
        }
        if (queryBelowAggregateLevel || mustHaveDirectMatch && queryAboveAggregateLevel) {
            if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE)) {
                if (queryBelowAggregateLevel) {
                    ROLAPLog.logTrace("ROLAPCubes.AggregateCache", AGGREGATE_TXT + UniqueNameGenerator.createUniqueName(result.getAggregateDefintion().getName()) + " rejected because query set level " + levelToTrace.getUniqueName() + " is below the aggregation level of " + aggregateLevel.getUniqueName());
                } else {
                    ROLAPLog.logTrace("ROLAPCubes.AggregateCache", AGGREGATE_TXT + UniqueNameGenerator.createUniqueName(result.getAggregateDefintion().getName()) + " rejected because there must be a direct match, and the input set level " + levelToTrace.getUniqueName() + " is above the aggregation level of " + aggregateLevel.getUniqueName());
                }
            }
            return false;
        }
        if (queryAboveAggregateLevel) {
            long maxCost;
            double newCost = result.getCost() * (double)totalEstimatedCells;
            if (newCost > (double)(maxCost = result.getAggregateDefintion().getCellCount() / (long)result.getAggregateDefintion().getMeasures().length)) {
                newCost = maxCost;
            }
            result.setCost(newCost);
        } else {
            result.getDirectMatchHierarchies().add(hier);
        }
        return true;
    }

    private boolean scoreMeasures(IMember[] measures, AggregateSelection result) {
        AggregateDefinition aggregateDef = result.getAggregateDefintion();
        List<IMember> aggregateMeasures = Arrays.asList(aggregateDef.getMeasures());
        for (IMember measure : measures) {
            if (aggregateMeasures.contains(measure)) {
                if (result.isDirectMatch() || AggregateCalculationEngine.canRollupMeasure(measure)) continue;
                if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE)) {
                    ROLAPLog.logTrace("ROLAPCubes.AggregateCache", AGGREGATE_TXT + UniqueNameGenerator.createUniqueName(result.getAggregateDefintion().getName()) + " requiring a direct match because measure " + measure.getUniqueName() + " of type " + measure.getRegularAggregate() + " cannot be rolled up.");
                }
                result.setRequireDirectMatch(true);
                continue;
            }
            if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE)) {
                ROLAPLog.logTrace("ROLAPCubes.AggregateCache", AGGREGATE_TXT + UniqueNameGenerator.createUniqueName(result.getAggregateDefintion().getName()) + " rejected because measure " + measure.getUniqueName() + " is not in the aggregate.");
            }
            return false;
        }
        return true;
    }

    private static class LevelComparator
    implements Comparator<ILevel> {
        private LevelComparator() {
        }

        @Override
        public int compare(ILevel level1, ILevel level2) {
            int level2Cardinality;
            int level1Cardinality = level1.getCardinality();
            if (level1Cardinality == (level2Cardinality = level2.getCardinality())) {
                return 0;
            }
            if (level1Cardinality > level2Cardinality) {
                return 1;
            }
            return -1;
        }
    }

    public static final class AggregateSelection {
        private double cost = 1.0;
        private Set<IHierarchy> directMatchHierarchies = null;
        private AggregateDefinition aggregateDefintion = null;
        private boolean requireDirectMatch = false;

        private AggregateSelection(AggregateDefinition theAggregateDefintion) {
            this.aggregateDefintion = theAggregateDefintion;
            this.directMatchHierarchies = new HashSet<IHierarchy>();
        }

        public boolean isDirectMatch() {
            return this.aggregateDefintion.getLevels().size() == this.directMatchHierarchies.size();
        }

        public Set<IHierarchy> getDirectMatchHierarchies() {
            return this.directMatchHierarchies;
        }

        public AggregateDefinition getAggregateDefintion() {
            return this.aggregateDefintion;
        }

        public double getCost() {
            return this.cost;
        }

        private void setCost(double newCost) {
            this.cost = newCost;
        }

        private boolean isRequireDirectMatch() {
            return this.requireDirectMatch;
        }

        private void setRequireDirectMatch(boolean directMatch) {
            this.requireDirectMatch = directMatch;
        }
    }
}

