/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.combination;

import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.MemberLevelInfo;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageUtil;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorageFetchResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorageRequest;
import com.cognos.xqe.util.primitive.HashSetInt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BlockTupleStorageFetchResult
implements IBlockTupleStorageFetchResult {
    private List<TupleValue> tupleValues;
    private List<Iterator<TupleValue>> mTupleValueIterators = null;
    private IMember[][] selectionsToFetch;
    private MemberLevelInfo selectionLevels;
    private int numThreadsUsedForFetch = 0;
    private String hint = null;
    private String queryContext = null;

    public BlockTupleStorageFetchResult(IMember[][] defaultSelections) {
        this.selectionsToFetch = defaultSelections;
        this.tupleValues = new ArrayList<TupleValue>();
        this.selectionLevels = new MemberLevelInfo(this.selectionsToFetch);
    }

    public BlockTupleStorageFetchResult(IMember[][] defaultSelections, List<TupleValue> result, List<Iterator<TupleValue>> resultIterators) {
        this.selectionsToFetch = defaultSelections;
        this.tupleValues = result;
        this.mTupleValueIterators = resultIterators;
        this.selectionLevels = new MemberLevelInfo(this.selectionsToFetch);
    }

    public BlockTupleStorageFetchResult(IBlockTupleStorageRequest request) {
        this(request.getSelectionsInCubeOrder(), request.getTupleValues(), request.getTupleValueIterators());
        ISet requiredSet = request.getRequestSet();
        if (requiredSet instanceof CrossJoinedSet) {
            this.addLevelInformation(((CrossJoinedSet)requiredSet).getMemberLevelInfo());
        }
        this.hint = request.getHint();
        this.queryContext = request.getQueryContext();
    }

    @Override
    public List<TupleValue> getTuplesValues() {
        return this.tupleValues;
    }

    @Override
    public IMember[][] getSelectionsToFetch() {
        return this.selectionsToFetch;
    }

    public int getNumThreadsUsed() {
        return this.numThreadsUsedForFetch;
    }

    public void addNumThreadsUsed(int num) {
        this.numThreadsUsedForFetch += num;
    }

    public void setTupleValues(List<TupleValue> results) {
        this.tupleValues = results;
    }

    public void setSelectionToFetch(IMember[][] memberSelections) {
        this.selectionsToFetch = memberSelections;
        this.selectionLevels.selectionsSubsetted(memberSelections);
    }

    public HashSetInt getLevels(int hierIndex) {
        if (this.selectionsToFetch[hierIndex].length > 0) {
            return this.selectionLevels.getLevelIndexes(this.selectionsToFetch[hierIndex][0].getHierarchy());
        }
        return new HashSetInt();
    }

    public void addLevelInformation(MemberLevelInfo existingLevelInfo) {
        this.selectionLevels.populateFrom(existingLevelInfo);
    }

    public final MemberLevelInfo getSelectionLevels() {
        return this.selectionLevels;
    }

    public void setHint(String aHint) {
        this.hint = aHint;
    }

    public String getHint() {
        return this.hint;
    }

    public String getQueryContext() {
        return this.queryContext;
    }

    public void setQueryContext(String qContext) {
        this.queryContext = qContext;
    }

    public ISet createSet() {
        CrossJoinedSet cjs = BlockTupleStorageUtil.createCjsFromMemberSelections(this.selectionsToFetch, this.selectionLevels, true);
        return cjs;
    }

    @Override
    public List<Iterator<TupleValue>> getTupleValueIterators() {
        return this.mTupleValueIterators;
    }
}

