/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.composite;

import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SetSelections;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageRequest;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorageRequest;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.combination.BlockTupleStorageFetchResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.composite.CompositeCubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.composite.ICompositionCalculator;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Cubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletStorage;
import com.cognos.xqe.util.ArrayCast;
import com.cognos.xqe.util.primitive.HashMapLongObject;
import com.cognos.xqe.util.primitive.HashMapObjectLong;
import com.cognos.xqe.util.primitive.IteratorLong;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CompositeCubeletStorage
extends CubeletStorage {
    public CompositeCubeletStorage(Cube inputCube) {
        super(inputCube);
    }

    @Override
    public BlockTupleStorageFetchResult getTupleValues(IBlockTupleStorageRequest request) throws InterpreterException {
        HashMapObjectLong<IMember> memberCmps = request.getMemberCompositions();
        ICompositionCalculator cmpCalc = request.getCompositionCalculator();
        HashMapLongObject<Collection<IMember>[]> partitionedSelections = this.partitionSelectionsByTupleComposition(request, memberCmps, cmpCalc);
        int nHiers = request.getCubeHierarchies().length;
        Collection[] remainderSelections = (Collection[])ArrayCast.uncheckedCast(new Collection[nHiers]);
        for (int i = 0; i < nHiers; ++i) {
            remainderSelections[i] = new HashSet();
        }
        IteratorLong keyIterator = partitionedSelections.keySetIterator();
        while (keyIterator.hasNext()) {
            long key = keyIterator.next();
            Collection<IMember>[] selections = partitionedSelections.get(key);
            BlockTupleStorageRequest subRequest = new BlockTupleStorageRequest();
            subRequest.setRequestedSetSelections(new SetSelections(selections));
            subRequest.setCubeHierarchies(request.getCubeHierarchies());
            subRequest.setTupleValues(request.getTupleValues());
            subRequest.setCompositionCalculator(request.getCompositionCalculator());
            subRequest.setMemberCompositions(request.getMemberCompositions());
            subRequest.setHint(String.valueOf(key));
            BlockTupleStorageFetchResult result = this.scanStorage(subRequest);
            IMember[][] remainder = result.getSelectionsToFetch();
            for (int i = 0; i < remainder.length; ++i) {
                remainderSelections[i].addAll(Arrays.asList(remainder[i]));
            }
        }
        SetSelections remainderSet = new SetSelections(remainderSelections);
        IMember[][] selArrays = remainderSet.getSelectionsArrays(request.getCubeHierarchies(), false);
        return new BlockTupleStorageFetchResult(selArrays);
    }

    @Override
    public void putTupleValues(IBlockTupleStorageRequest request) throws InterpreterException {
        HashMapObjectLong<IMember> memberCmps = request.getMemberCompositions();
        ICompositionCalculator cmpCalc = request.getCompositionCalculator();
        HashMapLongObject<Collection<IMember>[]> partitionedSelections = this.partitionSelectionsByTupleComposition(request, memberCmps, cmpCalc);
        HashMapLongObject<List<TupleValue>> partitionedTupleValues = this.partitionTupleValuesByTupleComposition(request, memberCmps, cmpCalc);
        IteratorLong keyIterator = partitionedSelections.keySetIterator();
        while (keyIterator.hasNext()) {
            long key = keyIterator.next();
            Collection<IMember>[] selections = partitionedSelections.get(key);
            BlockTupleStorageRequest subRequest = new BlockTupleStorageRequest();
            subRequest.setRequestedSetSelections(new SetSelections(selections));
            subRequest.setCubeHierarchies(request.getCubeHierarchies());
            subRequest.setTupleValues(partitionedTupleValues.get(key));
            subRequest.setCompositionCalculator(request.getCompositionCalculator());
            subRequest.setMemberCompositions(request.getMemberCompositions());
            subRequest.setHint(String.valueOf(key));
            super.putTupleValues(subRequest);
        }
    }

    private HashMapLongObject<Collection<IMember>[]> partitionSelectionsByTupleComposition(IBlockTupleStorageRequest request, HashMapObjectLong<IMember> memberCmps, ICompositionCalculator cmpCalc) {
        HashMapLongObject<Collection<IMember>[]> partitionedSelections = new HashMapLongObject<Collection<IMember>[]>();
        ITupleList tl = ((Set)request.getRequestSet()).getTupleList();
        for (ITuple tuple : tl) {
            int i;
            long comp = cmpCalc.calculateTupleComposition((Tuple)tuple, memberCmps);
            Collection<IMember>[] selections = partitionedSelections.get(comp);
            if (selections == null) {
                selections = (Collection[])ArrayCast.uncheckedCast(new Collection[tuple.size()]);
                for (i = 0; i < tuple.size(); ++i) {
                    selections[i] = new HashSet<IMember>();
                }
                partitionedSelections.put(comp, selections);
            }
            for (i = 0; i < tuple.size(); ++i) {
                selections[i].add(tuple.getMember(i));
            }
        }
        return partitionedSelections;
    }

    private HashMapLongObject<List<TupleValue>> partitionTupleValuesByTupleComposition(IBlockTupleStorageRequest request, HashMapObjectLong<IMember> memberCmps, ICompositionCalculator cmpCalc) {
        HashMapLongObject<List<TupleValue>> partitionedTupleValues = new HashMapLongObject<List<TupleValue>>();
        List<TupleValue> tvs = request.getTupleValues();
        for (TupleValue tv : tvs) {
            long comp = cmpCalc.calculateTupleComposition(tv.getTuple(), memberCmps);
            List<TupleValue> partiTuples = partitionedTupleValues.get(comp);
            if (partiTuples == null) {
                partiTuples = new ArrayList<TupleValue>();
                partitionedTupleValues.put(comp, partiTuples);
            }
            partiTuples.add(tv);
        }
        return partitionedTupleValues;
    }

    @Override
    protected Cubelet createNewCubelet(ISet querySet, Iterator<TupleValue> tupleValues, String hint) {
        return new CompositeCubelet(querySet, tupleValues, null, hint);
    }
}

