/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRFetchingContextKey;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRFetchingLRUCache;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.IDMRMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.CubeContext;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageUtil;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorageFetchResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.AdaptiveCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IOrdinalValueStorage;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.primitive.HashMapIntObject;
import com.cognos.xqe.util.primitive.HashSetInt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class AdaptiveCubeletStorageManager {
    private final ConcurrentLinkedQueue<IHierarchy> hierarchiesInStorage = new ConcurrentLinkedQueue();
    private final ConcurrentMap<StoreKey, AdaptiveCubeletStorage> measureNameToCubeletStorage = new ConcurrentHashMap<StoreKey, AdaptiveCubeletStorage>();
    private final ReentrantReadWriteLock rwLockHierarchiesInStorage = new ReentrantReadWriteLock();
    private final Lock rLockHierarchiesInStorage = this.rwLockHierarchiesInStorage.readLock();
    private final Lock wLockHierarchiesInStorage = this.rwLockHierarchiesInStorage.writeLock();
    private CubeContext cubeContext;
    private DMRCube cube;
    private final DMRFetchingLRUCache fetching = new DMRFetchingLRUCache();

    public AdaptiveCubeletStorageManager(CubeContext inputCubeContext) {
        this.cubeContext = inputCubeContext;
    }

    public AdaptiveCubeletStorageManager(DMRCube inputCube) {
        this.cube = inputCube;
        List<IHierarchy> cubeHiers = this.cube.getHierarchies(false);
        for (IHierarchy hier : cubeHiers) {
            if (hier.getDimension().isMeasuresDimension()) continue;
            this.hierarchiesInStorage.add(hier);
        }
    }

    public DMRFetchingLRUCache getFetching() {
        return this.fetching;
    }

    public Lock getReadLock() {
        return this.rLockHierarchiesInStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncToCubeContext() {
        List<IHierarchy> cubeContextHiers;
        boolean bNeedToSync = false;
        this.rLockHierarchiesInStorage.lock();
        try {
            cubeContextHiers = this.cubeContext.getHierarchies(false);
            bNeedToSync = this.hierarchiesInStorage.size() < cubeContextHiers.size();
        }
        finally {
            this.rLockHierarchiesInStorage.unlock();
        }
        if (!bNeedToSync) {
            return;
        }
        this.wLockHierarchiesInStorage.lock();
        try {
            cubeContextHiers = this.cubeContext.getHierarchies(false);
            if (this.hierarchiesInStorage.size() < cubeContextHiers.size()) {
                if (!this.hierarchiesInStorage.isEmpty()) {
                    ArrayList<IHierarchy> newHierarchies = new ArrayList<IHierarchy>();
                    ArrayList<IMember> newRootMembers = new ArrayList<IMember>();
                    for (IHierarchy hier : cubeContextHiers) {
                        if (this.hierarchiesInStorage.contains(hier)) continue;
                        this.hierarchiesInStorage.add(hier);
                        newHierarchies.add(hier);
                        newRootMembers.add(hier.getDefaultMember());
                    }
                    this.appendNewHierarchiesToCubelets(newHierarchies, newRootMembers);
                } else {
                    this.hierarchiesInStorage.addAll(cubeContextHiers);
                }
            }
        }
        finally {
            this.wLockHierarchiesInStorage.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendNewHierarchiesToCubelets(ArrayList<IHierarchy> newHierarchies, ArrayList<IMember> newRootMembers) {
        Collection stores = this.measureNameToCubeletStorage.values();
        Iterator iterator = stores.iterator();
        while (iterator.hasNext()) {
            AdaptiveCubeletStorage store;
            AdaptiveCubeletStorage adaptiveCubeletStorage = store = (AdaptiveCubeletStorage)iterator.next();
            synchronized (adaptiveCubeletStorage) {
                store.appendNewHierarchiesToCubelets(newRootMembers);
            }
        }
    }

    protected List<IHierarchy> getHierarchies() {
        ArrayList<IHierarchy> r = new ArrayList<IHierarchy>();
        r.addAll(this.hierarchiesInStorage);
        return r;
    }

    private IMember[][] queryToStorageSelctions(IMember[][] selections, IHierarchy[] cubeHiers, List<IHierarchy> storageHiers, DMRFetchingContextKey fecthingKey) {
        IMember[][] r = new IMember[storageHiers.size()][];
        for (int i = 0; i < storageHiers.size(); ++i) {
            int idx = ArrayUtils.indexOf((Object[])cubeHiers, (Object)storageHiers.get(i));
            if (idx != -1) {
                r[i] = selections[idx];
                if (fecthingKey == null) continue;
                fecthingKey.initMembers(i, r[i].length);
                for (int j = 0; j < r[i].length; ++j) {
                    fecthingKey.addMember(i, j, ((IDMRMember)r[i][j]).getIndex());
                }
                continue;
            }
            r[i] = new IMember[1];
            r[i][0] = storageHiers.get(i).getDefaultMember();
            if (fecthingKey == null) continue;
            fecthingKey.initMembers(i, 1);
            fecthingKey.addMember(i, 0, ((IDMRMember)r[i][0]).getIndex());
        }
        return r;
    }

    private void queryToStorageMembers(IMember[] members, IMember[] newMembers, Map<IHierarchy, Integer> cubeHiersIndex, List<IHierarchy> storageHiers) {
        for (int i = 0; i < storageHiers.size(); ++i) {
            IHierarchy hier = storageHiers.get(i);
            int idx = cubeHiersIndex.get(hier);
            newMembers[i] = idx != -1 ? members[idx] : hier.getDefaultMember();
        }
    }

    public IMember[][] fetchSingleLevelCombination(int measurePos, IHierarchy[] cubeHiers, IMember[][] selections, AbstractResultSet resultSet) throws InterpreterException {
        return this.fetchSingleLevelCombinationReturnKey(measurePos, cubeHiers, selections, resultSet, null);
    }

    public IMember[][] fetchSingleLevelCombinationReturnKey(int measurePos, IHierarchy[] cubeHiers, IMember[][] selections, AbstractResultSet resultSet, DMRFetchingContextKey fecthingKey) throws InterpreterException {
        List<IHierarchy> storageHiers = this.getHierarchies();
        if (fecthingKey != null) {
            fecthingKey.init(storageHiers.size());
        }
        IMember[][] storageSelections = this.queryToStorageSelctions(selections, cubeHiers, storageHiers, fecthingKey);
        if (fecthingKey != null) {
            fecthingKey.fix();
        }
        StoreKey levelCombinationOrdinal = this.computeLevelCombinationOrdinal(storageSelections);
        if (fecthingKey != null) {
            fecthingKey.setLevelsOrdinal(levelCombinationOrdinal.levelsOrdinal, levelCombinationOrdinal.extLevelsOrdinal);
        }
        IMember[] measures = selections[measurePos];
        HashMap[] unknowns = new HashMap[cubeHiers.length];
        int i = 0;
        int j = 0;
        for (i = 0; i < cubeHiers.length; ++i) {
            unknowns[i] = new HashMap();
        }
        for (IMember m : measures) {
            StoreKey key;
            String name = m.getName();
            if (fecthingKey != null) {
                fecthingKey.addMeasure(name);
            }
            if (!this.measureNameToCubeletStorage.containsKey(key = new StoreKey(name, levelCombinationOrdinal.levelsOrdinal, levelCombinationOrdinal.extLevelsOrdinal))) {
                unknowns[measurePos].put(name, m);
                for (i = 0; i < selections.length; ++i) {
                    if (i == measurePos) continue;
                    for (j = 0; j < selections[i].length; ++j) {
                        Integer idxKey = XQEIntegerPool.getInteger(((IDMRMember)selections[i][j]).getIndex());
                        unknowns[i].put(idxKey, selections[i][j]);
                    }
                }
                continue;
            }
            CubeletStorage storage = (CubeletStorage)this.measureNameToCubeletStorage.get(key);
            CrossJoinedSet fetchSet = BlockTupleStorageUtil.createCjsFromMemberSelections(storageSelections);
            IBlockTupleStorageFetchResult result = storage.getTupleValues(fetchSet);
            int[] tupleHierToCubeHierMap = null;
            for (TupleValue tupleValue : result.getTuplesValues()) {
                IValue value = tupleValue.getCell().getValue();
                if (value == null) continue;
                Tuple tp = tupleValue.getTuple();
                if (tupleHierToCubeHierMap == null) {
                    IHierarchy[] tupleHierarchies = tp.getHierarchies();
                    tupleHierToCubeHierMap = new int[tupleHierarchies.length];
                    for (i = 0; i < tupleHierarchies.length; ++i) {
                        int idx;
                        tupleHierToCubeHierMap[i] = idx = ArrayUtils.indexOf((Object[])cubeHiers, (Object)tupleHierarchies[i]);
                    }
                }
                IMember[] ms = tp.getMembers();
                IMember[] newMembers = new IMember[selections.length];
                newMembers[measurePos] = m;
                for (i = 0; i < tupleHierToCubeHierMap.length; ++i) {
                    if (tupleHierToCubeHierMap[i] == -1) continue;
                    newMembers[tupleHierToCubeHierMap[i]] = ms[i];
                }
                if (resultSet == null) continue;
                resultSet.addCell(new Tuple(newMembers, false), tupleValue.getCell());
            }
            IMember[][] selectionToFetch = result.getSelectionsToFetch();
            if (!BlockTupleStorageUtil.hasUnknownMbrs(selectionToFetch)) continue;
            unknowns[measurePos].put(name, m);
            for (i = 0; i < selectionToFetch.length; ++i) {
                int idx = ArrayUtils.indexOf((Object[])cubeHiers, (Object)storageHiers.get(i));
                if (idx == -1) continue;
                for (j = 0; j < selectionToFetch[i].length; ++j) {
                    Integer idxKey = XQEIntegerPool.getInteger(((IDMRMember)selectionToFetch[i][j]).getIndex());
                    unknowns[idx].put(idxKey, selectionToFetch[i][j]);
                }
            }
        }
        if (unknowns[measurePos].isEmpty()) {
            return null;
        }
        IMember[][] r = new IMember[cubeHiers.length][];
        for (i = 0; i < unknowns.length; ++i) {
            Collection mems = unknowns[i].values();
            r[i] = mems.toArray(new IMember[mems.size()]);
        }
        return r;
    }

    private StoreKey computeLevelCombinationOrdinal(IMember[][] storageSelections) {
        int ord = 0;
        int extOrd = 0;
        int baseSectionSize = 1;
        for (int i = 0; i < storageSelections.length; ++i) {
            IMember firstMemebr = storageSelections[i][0];
            ILevel level = firstMemebr.getLevel();
            IDimension dim = level.getDimension();
            int levelIdx = level.getIndex();
            int extLevelIdx = this.getExtLevelIdx(firstMemebr);
            int dimLevels = dim.getLevelCount();
            ord += levelIdx * baseSectionSize;
            extOrd += extLevelIdx * baseSectionSize;
            baseSectionSize *= dimLevels;
        }
        return new StoreKey(ord, extOrd);
    }

    private int getExtLevelIdx(IMember firstMemebr) {
        if (firstMemebr instanceof DMRMemberProxy) {
            return ((DMRMemberProxy)firstMemebr).getHierarchyMemberType();
        }
        if (firstMemebr instanceof DMRMember) {
            return ((DMRMember)firstMemebr).getHierarchyMemberType();
        }
        return 0;
    }

    public void insertCubelet(String measureName, ArrayList<IHierarchy> cubeHiersExclMeasure, int[] levelIds, int[][] intQuerySet, HashMapIntObject<IMember>[] membersMap, IOrdinalValueStorage valuesStorage, long[] pageSizes) {
        int[] extLevelIds = new int[levelIds.length];
        List<IHierarchy> storageHiers = this.getHierarchies();
        StoreKey storageOrd = this.queryToStorageLevelsOrdinal(cubeHiersExclMeasure, levelIds, storageHiers, extLevelIds);
        StoreKey keyStorage = new StoreKey(measureName, storageOrd.levelsOrdinal, storageOrd.extLevelsOrdinal);
        AdaptiveCubeletStorage storage = new AdaptiveCubeletStorage(this);
        if (this.cube != null && !this.cube.isReusedCube()) {
            storage.setMaintainceOnAdd(false);
        }
        this.measureNameToCubeletStorage.put(keyStorage, storage);
        HashSetInt[] levelsArray = new HashSetInt[levelIds.length];
        for (int i = 0; i < levelIds.length; ++i) {
            levelsArray[i] = new HashSetInt();
            levelsArray[i].add(levelIds[i]);
        }
        storage.addCubelet(intQuerySet, valuesStorage, pageSizes, membersMap, levelsArray);
    }

    public void putTupleValues(ParamDefinition param) throws InterpreterException {
        List<IHierarchy> storageHiers = this.getHierarchies();
        HashMap<StoreKey, StoreKey> localToStorageOrdMap = new HashMap<StoreKey, StoreKey>();
        for (Map.Entry<StoreKey, Object[]> e : param.allFetchedValues.entrySet()) {
            StoreKey keyLocal = e.getKey();
            StoreKey localOrd = new StoreKey(keyLocal.levelsOrdinal, keyLocal.extLevelsOrdinal);
            StoreKey storageOrd = null;
            if (localToStorageOrdMap.containsKey(localOrd)) {
                storageOrd = (StoreKey)localToStorageOrdMap.get(localOrd);
            } else {
                storageOrd = this.queryToStorageLevelsOrdinal(param.cubeHiersExclMeasure, (int[])param.localOrdinalToLevelsMap.get(localOrd).getFirst(), storageHiers, (int[])param.localOrdinalToLevelsMap.get(localOrd).getSecond());
                localToStorageOrdMap.put(localOrd, storageOrd);
            }
            StoreKey keyStorage = new StoreKey(keyLocal.measureName, storageOrd.levelsOrdinal, storageOrd.extLevelsOrdinal);
            Object[] s = e.getValue();
            AdaptiveCubeletStorage storage = null;
            if (!this.measureNameToCubeletStorage.containsKey(keyStorage)) {
                AdaptiveCubeletStorage other;
                storage = new AdaptiveCubeletStorage(this);
                if (this.cube != null && !this.cube.isReusedCube()) {
                    storage.setMaintainceOnAdd(false);
                }
                if ((other = this.measureNameToCubeletStorage.putIfAbsent(keyStorage, storage)) != null) {
                    storage = other;
                }
            } else {
                storage = (AdaptiveCubeletStorage)this.measureNameToCubeletStorage.get(keyStorage);
            }
            ArrayList[] selections = (ArrayList[])s[0];
            IMember[][] storageSelections = new IMember[storageHiers.size()][];
            for (int i = 0; i < storageHiers.size(); ++i) {
                int idx = param.cubeHiersExclMeasure.indexOf(storageHiers.get(i));
                if (idx != -1) {
                    storageSelections[i] = selections[idx].toArray(new IMember[selections[idx].size()]);
                    continue;
                }
                storageSelections[i] = new IMember[1];
                storageSelections[i][0] = storageHiers.get(i).getDefaultMember();
            }
            CrossJoinedSet cjs = BlockTupleStorageUtil.createCjsFromMemberSelections(storageSelections);
            List values = (List)s[1];
            IMember[][] forCheckDuplicate = null;
            if (s.length >= 4 && (Boolean)s[3] == Boolean.TRUE) {
                forCheckDuplicate = storageSelections;
            }
            List<TupleValue> valuesNoDuplicate = this.getUniqueValueList(param.cubeHiersExclMeasure, storageHiers, values, forCheckDuplicate);
            storage.putTupleValues(cjs, valuesNoDuplicate.iterator());
        }
    }

    private StoreKey queryToStorageLevelsOrdinal(ArrayList<IHierarchy> cubeHiersExclMeasure, int[] levelIds, List<IHierarchy> storageHiers, int[] extLevelIds) {
        int ord = 0;
        int extord = 0;
        int baseSectionSize = 1;
        for (int i = 0; i < storageHiers.size(); ++i) {
            IHierarchy hier = storageHiers.get(i);
            int idx = cubeHiersExclMeasure.indexOf(hier);
            if (idx != -1) {
                ord += levelIds[idx] * baseSectionSize;
                extord += extLevelIds[idx] * baseSectionSize;
            }
            baseSectionSize *= hier.getLevelCount();
        }
        return new StoreKey(ord, extord);
    }

    private List<TupleValue> getUniqueValueList(List<IHierarchy> cubeHiersNoMeasure, List<IHierarchy> storageHiers, List<TupleValue> values, IMember[][] storageSelections) {
        HashMap<Integer, Integer> seen = null;
        HashMap[] munToLocalIdx = null;
        if (storageSelections != null) {
            seen = new HashMap<Integer, Integer>();
            munToLocalIdx = new HashMap[storageSelections.length];
            for (int i = 0; i < storageSelections.length; ++i) {
                munToLocalIdx[i] = new HashMap();
                int j = 0;
                for (IMember m : storageSelections[i]) {
                    munToLocalIdx[i].put(m, XQEIntegerPool.getInteger(j));
                    ++j;
                }
            }
        }
        ArrayList<TupleValue> r = new ArrayList<TupleValue>();
        Map<IHierarchy, Integer> storageToCubeHierIndex = this.buildHierarchyIndex(cubeHiersNoMeasure, storageHiers);
        for (TupleValue v : values) {
            IMember[] newMembers = new IMember[storageHiers.size()];
            IMember[] members = v.getTuple().getMembers();
            this.queryToStorageMembers(members, newMembers, storageToCubeHierIndex, storageHiers);
            if (storageSelections != null) {
                Integer ordinal = this.getTupleOrdinal(storageSelections, munToLocalIdx, newMembers);
                Integer nullPos = null;
                if (seen.containsKey(ordinal)) {
                    nullPos = (Integer)seen.get(ordinal);
                    if (nullPos == null || v.getCell().getValue().isNull()) continue;
                    r.set(nullPos, new TupleValue(new Tuple(newMembers, false), new Cell(v.getCell().getValue())));
                    seen.put(ordinal, null);
                    continue;
                }
                if (v.getCell().getValue().isNull()) {
                    nullPos = XQEIntegerPool.getInteger(r.size());
                }
                seen.put(ordinal, nullPos);
            }
            r.add(new TupleValue(new Tuple(newMembers, false), new Cell(v.getCell().getValue())));
        }
        return r;
    }

    private Map<IHierarchy, Integer> buildHierarchyIndex(List<IHierarchy> cubeHiers, List<IHierarchy> storageHiers) {
        HashMap<IHierarchy, Integer> index = new HashMap<IHierarchy, Integer>();
        for (IHierarchy storageHier : storageHiers) {
            index.put(storageHier, cubeHiers.indexOf(storageHier));
        }
        return index;
    }

    protected Integer getTupleOrdinal(IMember[][] storageSelections, HashMap<IMember, Integer>[] munToLocalIdx, IMember[] members) {
        int ord = 0;
        int baseTupleSize = 1;
        for (int i = 0; i < members.length; ++i) {
            Integer memberIdx = munToLocalIdx[i].get(members[i]);
            ord += memberIdx * baseTupleSize;
            baseTupleSize *= storageSelections[i].length;
        }
        return XQEIntegerPool.getInteger(ord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean measureExistInStorage(IMember[][] selections) {
        List<IHierarchy> storageHiers = this.getHierarchies();
        ArrayList<IHierarchy> queryHiersNoMeasure = new ArrayList<IHierarchy>();
        IMember[] measureSelection = null;
        IMember[][] selectionsNoMeasure = new IMember[selections.length - 1][];
        int i = 0;
        int j = 0;
        for (i = 0; i < selections.length; ++i) {
            IMember[] sel = selections[i];
            IMember mun = sel[0];
            if (mun.isMeasure()) {
                measureSelection = sel;
                continue;
            }
            selectionsNoMeasure[j] = sel;
            ++j;
            queryHiersNoMeasure.add(mun.getHierarchy());
        }
        IHierarchy[] queryHiers = queryHiersNoMeasure.toArray(new IHierarchy[queryHiersNoMeasure.size()]);
        IMember[][] selectionsStorage = this.queryToStorageSelctions(selectionsNoMeasure, queryHiers, storageHiers, null);
        StoreKey levelCombinationOrdinal = this.computeLevelCombinationOrdinal(selectionsStorage);
        try {
            CrossJoinedSet fetchSet = BlockTupleStorageUtil.createCjsFromMemberSelections(selectionsStorage);
            for (i = 0; i < measureSelection.length; ++i) {
                IBlockTupleStorageFetchResult result;
                CubeletStorage storage;
                String nm = measureSelection[i].getName();
                StoreKey key = new StoreKey(nm, levelCombinationOrdinal.levelsOrdinal, levelCombinationOrdinal.extLevelsOrdinal);
                if (!this.measureNameToCubeletStorage.containsKey(key)) continue;
                CubeletStorage cubeletStorage = storage = (CubeletStorage)this.measureNameToCubeletStorage.get(key);
                synchronized (cubeletStorage) {
                    result = storage.getTupleValues(fetchSet);
                }
                List<TupleValue> vs = result.getTuplesValues();
                if (vs.isEmpty()) continue;
                return true;
            }
        }
        catch (InterpreterException e) {
            throw new XQERuntimeException(e);
        }
        return false;
    }

    public final class StoreKey {
        private String measureName;
        private Integer levelsOrdinal;
        private Integer extLevelsOrdinal;

        private StoreKey(int mainOrdinal, int extordinal) {
            this.levelsOrdinal = XQEIntegerPool.getInteger(mainOrdinal);
            this.extLevelsOrdinal = XQEIntegerPool.getInteger(extordinal);
        }

        private StoreKey(Integer mainOrdinal, Integer extordinal) {
            this.levelsOrdinal = mainOrdinal;
            this.extLevelsOrdinal = extordinal;
        }

        private StoreKey(String name, Integer mainOrdinal, Integer extordinal) {
            this.measureName = name;
            this.levelsOrdinal = mainOrdinal;
            this.extLevelsOrdinal = extordinal;
        }

        public int hashCode() {
            HashCodeBuilder hcb = new HashCodeBuilder();
            if (this.measureName != null) {
                hcb.append((Object)this.measureName);
            }
            if (this.levelsOrdinal != null) {
                hcb.append((Object)this.levelsOrdinal);
            }
            if (this.extLevelsOrdinal != null) {
                hcb.append((Object)this.extLevelsOrdinal);
            }
            return hcb.toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StoreKey)) {
                return false;
            }
            StoreKey other = (StoreKey)obj;
            return this.isStringEquals(this.measureName, other.measureName) && this.isIntegerEquals(this.levelsOrdinal, other.levelsOrdinal) && this.isIntegerEquals(this.extLevelsOrdinal, other.extLevelsOrdinal);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.measureName != null) {
                sb.append(this.measureName);
            }
            if (this.levelsOrdinal != null) {
                sb.append(this.levelsOrdinal);
            }
            if (this.extLevelsOrdinal != null) {
                sb.append(this.extLevelsOrdinal);
            }
            return sb.toString();
        }

        private boolean isStringEquals(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return true;
            }
            if (s1 == null || s2 == null) {
                return false;
            }
            return s1.equals(s2);
        }

        private boolean isIntegerEquals(Integer i1, Integer i2) {
            if (i1 == null && i2 == null) {
                return true;
            }
            if (i1 == null || i2 == null) {
                return false;
            }
            return i1.equals(i2);
        }
    }

    public class ParamDefinition {
        protected AdaptiveCubeletStorageManager theManager;
        protected ArrayList<IHierarchy> cubeHiersExclMeasure = new ArrayList();
        protected HashMap<StoreKey, Pair> localOrdinalToLevelsMap = new HashMap();
        protected HashMap<StoreKey, Object[]> allFetchedValues = new HashMap();
        protected int[] levelIds = null;
        protected int[] extLevelIds = null;

        public ParamDefinition(AdaptiveCubeletStorageManager owner) {
            this.theManager = owner;
        }

        public void addNonMeasureHierarchy(IHierarchy hier) {
            this.cubeHiersExclMeasure.add(hier);
        }

        public void initialLevelIndex() {
            this.levelIds = new int[this.cubeHiersExclMeasure.size()];
            this.extLevelIds = new int[this.levelIds.length];
        }

        public HashMap<StoreKey, Object[]> getFetchedValues() {
            return this.allFetchedValues;
        }

        public void updateValueMap(TupleValue v, Boolean bCheckUnique) {
            Tuple tp = v.getTuple();
            IMember[] members = tp.getMembers();
            IMember[] newMembers = new IMember[members.length - 1];
            StoreKey key = this.skipMeasure(members, newMembers);
            Object[] s = null;
            int i = 0;
            ArrayList[] st = null;
            HashSet[] stIdx = null;
            if (!this.allFetchedValues.containsKey(key)) {
                s = new Object[4];
                st = new ArrayList[newMembers.length];
                stIdx = new HashSet[newMembers.length];
                for (i = 0; i < newMembers.length; ++i) {
                    st[i] = new ArrayList();
                    stIdx[i] = new HashSet();
                }
                s[0] = st;
                s[1] = new ArrayList();
                s[2] = stIdx;
                s[3] = bCheckUnique;
                this.allFetchedValues.put(key, s);
            } else {
                s = this.allFetchedValues.get(key);
                st = (ArrayList[])s[0];
                stIdx = (HashSet[])s[2];
            }
            for (i = 0; i < newMembers.length; ++i) {
                Integer idxObj = XQEIntegerPool.getInteger(((IDMRMember)newMembers[i]).getIndex());
                if (stIdx[i].contains(idxObj)) continue;
                st[i].add(newMembers[i]);
                stIdx[i].add(idxObj);
            }
            ((ArrayList)s[1]).add(new TupleValue(new Tuple(newMembers, false), new Cell(v.getCell().getValue())));
        }

        public StoreKey skipMeasure(IMember[] members, IMember[] newMembers) {
            String nm = null;
            int i = 0;
            int j = 0;
            int ord = 0;
            int extord = 0;
            int baseSectionSize = 1;
            for (i = 0; i < members.length; ++i) {
                if (members[i].isMeasure()) {
                    nm = members[i].getName();
                    continue;
                }
                newMembers[j] = members[i];
                ILevel level = newMembers[j].getLevel();
                IDimension dim = level.getDimension();
                this.levelIds[j] = level.getIndex();
                this.extLevelIds[j] = AdaptiveCubeletStorageManager.this.getExtLevelIdx(newMembers[j]);
                int dimLevels = dim.getLevelCount();
                ord += this.levelIds[j] * baseSectionSize;
                extord += this.extLevelIds[j] * baseSectionSize;
                baseSectionSize *= dimLevels;
                ++j;
            }
            Integer localOrd = XQEIntegerPool.getInteger(ord);
            Integer localExtOrd = XQEIntegerPool.getInteger(extord);
            if (!this.localOrdinalToLevelsMap.containsKey(localOrd)) {
                int[] newIdx = new int[this.levelIds.length];
                System.arraycopy(this.levelIds, 0, newIdx, 0, this.levelIds.length);
                int[] newExtIdx = new int[this.extLevelIds.length];
                System.arraycopy(this.extLevelIds, 0, newExtIdx, 0, this.extLevelIds.length);
                this.localOrdinalToLevelsMap.put(new StoreKey(localOrd, localExtOrd), new Pair(newIdx, newExtIdx));
            }
            return new StoreKey(nm, localOrd, localExtOrd);
        }

        public void updateValueMapNoValue(IMember[] firstTuple, IMember[][] nonMeasureSelections, boolean bCreateIfAbsent) {
            IMember[] newMembers = new IMember[firstTuple.length - 1];
            StoreKey key = this.skipMeasure(firstTuple, newMembers);
            if (!bCreateIfAbsent && !this.allFetchedValues.containsKey(key)) {
                return;
            }
            Object[] s = null;
            int i = 0;
            ArrayList[] st = null;
            HashSet[] stIdx = null;
            if (!this.allFetchedValues.containsKey(key)) {
                s = new Object[3];
                st = new ArrayList[newMembers.length];
                stIdx = new HashSet[newMembers.length];
                for (i = 0; i < newMembers.length; ++i) {
                    st[i] = new ArrayList();
                    stIdx[i] = new HashSet();
                }
                s[0] = st;
                s[1] = new ArrayList();
                s[2] = stIdx;
                this.allFetchedValues.put(key, s);
            } else {
                s = this.allFetchedValues.get(key);
                st = (ArrayList[])s[0];
                stIdx = (HashSet[])s[2];
            }
            for (i = 0; i < nonMeasureSelections.length; ++i) {
                IMember[] members = nonMeasureSelections[i];
                for (int j = 0; j < members.length; ++j) {
                    Integer idxObj = XQEIntegerPool.getInteger(((IDMRMember)members[j]).getIndex());
                    if (stIdx[i].contains(idxObj)) continue;
                    st[i].add(members[j]);
                    stIdx[i].add(idxObj);
                }
            }
        }
    }
}

