/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.OrdinalValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.BaseOrdinalValueStorage;
import com.cognos.xqe.util.JavaObjectMemorySize;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ArrayOrdinalValueStorage
extends BaseOrdinalValueStorage {
    protected OrdinalValue[] values;
    protected int currentIndex = 0;
    protected boolean arrayFixed = false;
    protected static ConcurrentLinkedQueue<OrdinalValue[]> defaultStorageQueue = new ConcurrentLinkedQueue();

    public ArrayOrdinalValueStorage() {
        this.initValuesArray();
    }

    public void initValuesArray() {
        this.values = defaultStorageQueue.poll();
        if (this.values == null) {
            this.values = new OrdinalValue[512];
        }
    }

    @Override
    public boolean getImpl(OrdinalValue ordinalValue) {
        int position = Arrays.binarySearch(this.values, ordinalValue);
        if (position < 0) {
            return false;
        }
        ordinalValue.setValue(this.values[position].getValue());
        return true;
    }

    @Override
    public void putImpl(OrdinalValue ordinalValue) {
        if (this.arrayFixed) {
            throw new IllegalStateException();
        }
        if (this.currentIndex == this.values.length) {
            OrdinalValue[] tempCopy = new OrdinalValue[this.values.length * 2];
            System.arraycopy(this.values, 0, tempCopy, 0, this.values.length);
            this.returnArraytoDefaultQueue();
            this.values = tempCopy;
        }
        this.values[this.currentIndex++] = ordinalValue;
    }

    @Override
    public void fixImpl() {
        this.arrayFixed = true;
        if (this.currentIndex < this.values.length) {
            OrdinalValue[] tempCopy = new OrdinalValue[this.currentIndex];
            System.arraycopy(this.values, 0, tempCopy, 0, this.currentIndex);
            this.returnArraytoDefaultQueue();
            this.values = tempCopy;
        }
        Arrays.sort(this.values);
    }

    private void returnArraytoDefaultQueue() {
        if (this.values.length == 512) {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = null;
            }
            defaultStorageQueue.add(this.values);
        }
    }

    @Override
    protected long estimateSizeToHoldValues() {
        return JavaObjectMemorySize.getJavaObjectSize(0L, this.values.length);
    }

    @Override
    public OrdinalValue get(int index, OrdinalValue returnOrdinalValue) {
        if (returnOrdinalValue == null) {
            returnOrdinalValue = new OrdinalValue(0L, null);
        }
        returnOrdinalValue.setOrdinal(this.values[index].getOrdinal());
        returnOrdinalValue.setValue(this.values[index].getValue());
        return returnOrdinalValue;
    }

    @Override
    public int getIndex(OrdinalValue ordinalValue) {
        return Arrays.binarySearch(this.values, ordinalValue);
    }
}

