/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.OrdinalValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.VectorValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.ArrayOrdinalValueStorage;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ArrayVectorValueStorage
extends ArrayOrdinalValueStorage {
    private static ConcurrentLinkedQueue<VectorValue[]> largeValueSetStorageQueue = new ConcurrentLinkedQueue();

    @Override
    public void initValuesArray() {
        this.values = largeValueSetStorageQueue.poll();
        if (this.values == null) {
            this.values = new VectorValue[512];
        }
    }

    @Override
    public void putImpl(OrdinalValue ordinalValue) {
        if (this.arrayFixed) {
            throw new IllegalStateException();
        }
        if (this.currentIndex == this.values.length) {
            VectorValue[] tempCopy = new VectorValue[this.values.length * 2];
            System.arraycopy(this.values, 0, tempCopy, 0, this.values.length);
            this.returnArraytoDefaultQueue();
            this.values = tempCopy;
        }
        this.values[this.currentIndex++] = (VectorValue)ordinalValue;
    }

    @Override
    public void fixImpl() {
        this.arrayFixed = true;
        if (this.currentIndex < this.values.length) {
            VectorValue[] tempCopy = new VectorValue[this.currentIndex];
            System.arraycopy(this.values, 0, tempCopy, 0, this.currentIndex);
            this.returnArraytoDefaultQueue();
            this.values = tempCopy;
        }
        Arrays.sort(this.values);
    }

    private void returnArraytoDefaultQueue() {
        if (this.values.length == 512) {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = null;
            }
            largeValueSetStorageQueue.add((VectorValue[])this.values);
        }
    }

    @Override
    public VectorValue get(int index, OrdinalValue returnOrdinalValue) {
        if (returnOrdinalValue == null) {
            returnOrdinalValue = new VectorValue(null, null);
        }
        VectorValue largeReturnOrdinalValue = (VectorValue)returnOrdinalValue;
        largeReturnOrdinalValue.setMemberIds(((VectorValue)this.values[index]).getMemberIds());
        largeReturnOrdinalValue.setValue(this.values[index].getValue());
        return largeReturnOrdinalValue;
    }

    @Override
    public OrdinalValue createOrdinalValue() {
        return new VectorValue(null, null);
    }
}

