/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageRequest;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.combination.BlockTupleStorageFetchResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Cubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletMaintenanceService;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletStorage;
import java.util.Iterator;
import java.util.List;

public class ContextualCubeletStorage
extends CubeletStorage {
    public ContextualCubeletStorage(Cube inputCube) {
        super(inputCube);
    }

    @Override
    public BlockTupleStorageFetchResult getTupleValues(ISet requiredSet, List<TupleValue> tupleValues, String queryContext) throws InterpreterException {
        BlockTupleStorageRequest request = new BlockTupleStorageRequest();
        request.setSelectionsInCubeOrder(this.getSetSelectionsInCubeDimensionOrder(requiredSet));
        if (this.multipleHierarchySupport()) {
            IMember[][] selections = request.getSelectionsInCubeOrder();
            IHierarchy[] hierarchies = new IHierarchy[selections.length];
            for (int i = 0; i < selections.length; ++i) {
                hierarchies[i] = selections[i][0].getHierarchy();
            }
            request.setCubeHierarchies(hierarchies);
        } else {
            request.setCubeHierarchies(this.getHierarchies().toArray(new IHierarchy[this.getHierarchies().size()]));
        }
        request.setRequestedSet(requiredSet);
        request.setTupleValues(tupleValues);
        request.setQueryContext(queryContext);
        return this.getTupleValues(request);
    }

    @Override
    public void putTupleValues(ISet querySet, Iterator<TupleValue> tupleValues, String queryContext) throws InterpreterException {
        Cubelet cubelet = this.createNewCubelet(querySet, tupleValues, queryContext);
        this.addCubelet(cubelet);
        if (this.maintenanceOnAdd) {
            CubeletMaintenanceService.getInstance().maintain(this, 0.0);
        }
    }

    @Override
    protected Cubelet createNewCubelet(ISet querySet, Iterator<TupleValue> tupleValues, String queryContext) {
        return new ContextualCubelet(querySet, tupleValues, queryContext);
    }

    private final class ContextualCubelet
    extends Cubelet {
        private String queryContext;

        protected ContextualCubelet(ISet set, Iterator<TupleValue> tupleValues, String qContext) {
            super(set, tupleValues, null, null);
            this.queryContext = null;
            this.queryContext = qContext;
        }

        @Override
        public BlockTupleStorageFetchResult fetch(BlockTupleStorageFetchResult result) throws InterpreterException {
            if (!this.isSameContext(result.getQueryContext())) {
                return result;
            }
            return super.fetch(result);
        }

        @Override
        public boolean contains(Cubelet other) {
            if (super.contains(other)) {
                return !(other instanceof ContextualCubelet) || this.isSameContext(((ContextualCubelet)other).queryContext);
            }
            return false;
        }

        private boolean isSameContext(String qContext) {
            if (this.queryContext != null) {
                return this.queryContext.equals(qContext);
            }
            return qContext == null;
        }
    }
}

