/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.util.ArrayCast;
import com.cognos.xqe.util.primitive.IntArrayList;

public class CubletIndexIDHelper {
    private static final int NUMBER_3 = 3;
    private static final int NUMBER_MINUS3 = -3;
    protected static final int NUMBER_128 = 128;
    protected static final int NUMBER_8 = 8;
    protected static final int NUMBER_100 = 100;
    protected static final int NUMBER_HEX_FF = 255;
    protected int bytesPerID = 3;
    private boolean cubeScope = true;
    int rowNumber = 0;

    protected CubletIndexIDHelper() {
    }

    protected CubletIndexIDHelper(int sequenceNumber) {
        this.rowNumber = sequenceNumber;
    }

    protected byte[] dimensionToByteArray(int[][] levelArray) {
        int size = this.bytesPerID + (this.bytesPerID + 1) * levelArray.length;
        byte[] b = new byte[size];
        int j = 0;
        for (int k = this.bytesPerID - 1; k >= 0; --k) {
            b[j] = (byte)((this.rowNumber >> 8 * k) - 128 & 0xFF);
            ++j;
        }
        for (int i = 0; i < levelArray.length; ++i) {
            int levelOrderValue = levelArray[i].length;
            int dimIndex = i;
            b[j] = (byte)(dimIndex - 128 & 0xFF);
            ++j;
            for (int k = this.bytesPerID - 1; k >= 0; --k) {
                b[j] = (byte)((levelOrderValue >> 8 * k) - 128 & 0xFF);
                ++j;
            }
        }
        return b;
    }

    byte[] computeByteArrayGivenSet(ISet set) {
        IDimension[] dims = set.getDimensions();
        int dimCount = dims.length;
        int[][] levelDimArray = new int[dimCount][];
        IntArrayList levelList = new IntArrayList(100);
        for (int i = 0; i < dimCount; ++i) {
            IMember[] selectionsMemArray = (IMember[])ArrayCast.uncheckedCast(((Set)set).getMembers(dims[i]));
            for (int j = 0; j < selectionsMemArray.length; ++j) {
                boolean contains = false;
                contains = levelList.contains(selectionsMemArray[j].getParentLevelNumber() + 1);
                if (contains) continue;
                levelList.add(selectionsMemArray[j].getParentLevelNumber() + 1);
            }
            levelDimArray[i] = levelList.toArray();
            levelList.clear();
        }
        byte[] b = this.dimensionToByteArray(levelDimArray);
        return b;
    }
}

