/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Cubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.UpdateableCacheEntry;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.UpdateableCubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.IncrementManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class UpdateableCubeletStorage
extends CubeletStorage {
    protected IncrementManager incrementMgr = null;

    public UpdateableCubeletStorage(Cube inputCube) {
        super(inputCube);
    }

    public void setIncrementManager(IncrementManager incrementManager) {
        this.incrementMgr = incrementManager;
    }

    @Override
    protected Cubelet createNewCubelet(ISet querySet, Iterator<TupleValue> tupleValues, String hint) {
        return new UpdateableCubelet(querySet, tupleValues, this.cubeletMonitor, hint);
    }

    public Collection<UpdateableCacheEntry> getUpdateableCubelets() {
        HashSet<UpdateableCacheEntry> updateableCubelets = new HashSet<UpdateableCacheEntry>();
        this.fill(updateableCubelets, this.tupleStorage.getCache().iterator());
        this.fill(updateableCubelets, this.tupleStorage.getOldCache().iterator());
        return updateableCubelets;
    }

    public int getUpdateableCubeletsOldestIncrementId() {
        int oldestId = Integer.MAX_VALUE;
        for (UpdateableCacheEntry cubelet : this.getUpdateableCubelets()) {
            oldestId = Math.min(oldestId, cubelet.getLatestIncrementId());
        }
        return oldestId;
    }

    public int getNumCublets() {
        return this.tupleStorage.getCache().size() + this.tupleStorage.getOldCache().size();
    }

    @Override
    protected void removeExpiredCubelets(ConcurrentLinkedQueue<Cubelet> cubelets) {
        if (this.incrementMgr != null) {
            int oldestActiveIncrementID = this.incrementMgr.getOldestActiveIncrementID();
            for (Cubelet cubelet : cubelets) {
                if (cubelet.isUpdateable() || cubelet.getBaseIncrementId() >= oldestActiveIncrementID) continue;
                cubelets.remove(cubelet);
            }
        }
    }

    private void fill(Set<UpdateableCacheEntry> updateableCubelets, Iterator<Cubelet> cubeletIterator) {
        if (cubeletIterator != null) {
            while (cubeletIterator.hasNext()) {
                Cubelet cubelet = cubeletIterator.next();
                if (!cubelet.isUpdateable()) continue;
                updateableCubelets.add((UpdateableCacheEntry)((Object)cubelet));
            }
        }
    }
}

