/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.OrdinalValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.VectorValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.AbstractDoubleValueStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.primitive.ArrayListInt;
import com.cognos.xqe.util.primitive.Arrays;
import com.cognos.xqe.util.primitive.CompactIntArrayList;
import com.cognos.xqe.util.primitive.ConstantCompactIntArrayList;
import com.cognos.xqe.util.primitive.IntArrayComparator;
import java.util.Collections;

public class VectorDoubleNativeValueStorage
extends AbstractDoubleValueStorage {
    private CompactIntArrayList memberIdList;
    private boolean fixed = false;

    public VectorDoubleNativeValueStorage(int memberIdArrayWidth) {
        this.memberIdList = new CompactIntArrayList(memberIdArrayWidth);
    }

    @Override
    public boolean getImpl(OrdinalValue ordinalValue) {
        if (!(ordinalValue instanceof VectorValue)) {
            throw new UnsupportedOperationException("Cannot get via an OrdinalValue.");
        }
        int position = Collections.binarySearch(this.memberIdList, ((VectorValue)ordinalValue).getMemberIds(), IntArrayComparator.getInstance());
        if (position < 0) {
            return false;
        }
        DoubleValue dv = this.buildValue(position);
        ordinalValue.setValue(dv);
        return true;
    }

    @Override
    public void putImpl(OrdinalValue ordinalValue) {
        if (this.fixed) {
            throw new IllegalStateException("Cannot add a value after fix() has been called.");
        }
        if (!(ordinalValue instanceof VectorValue)) {
            throw new UnsupportedOperationException("Cannot put via an OrdinalValue.");
        }
        this.memberIdList.add(((VectorValue)ordinalValue).getMemberIds());
        super.putImpl(ordinalValue);
    }

    @Override
    public void fixImpl() {
        if (!this.fixed) {
            super.fixImpl();
            this.memberIdList = new ConstantCompactIntArrayList(this.memberIdList);
            Arrays.sort(this.memberIdList, this.getDoubleValues(), this.getFormatIds(), this.getValueStates());
            this.fixed = true;
        }
    }

    @Override
    protected long estimateSizeToHoldValues() {
        long baseSize = super.estimateSizeToHoldValues();
        long memberIdSize = this.memberIdList.estimateMemoryUsage();
        VectorDoubleNativeValueStorage.traceEstimatedSize(memberIdSize);
        return memberIdSize + baseSize;
    }

    public static long estimateSizeToHoldValues(long cellCount, boolean cellsHaveSameFormatIds, boolean includeSizeOfValueStates, int[] hierarchyCardinality, boolean[] moreThanOneMemberUsedInHier) {
        long baseSize = AbstractDoubleValueStorage.estimateSizeToHoldValues(cellCount, cellsHaveSameFormatIds, includeSizeOfValueStates);
        ArrayListInt hierCountsWithMoreThanOneMember = new ArrayListInt();
        for (int i = 0; i < moreThanOneMemberUsedInHier.length; ++i) {
            if (!moreThanOneMemberUsedInHier[i]) continue;
            hierCountsWithMoreThanOneMember.add(hierarchyCardinality[i]);
        }
        long estimatedRetainedSizeOfMemberIds = CompactIntArrayList.estimateMemoryUsage((int)cellCount, hierCountsWithMoreThanOneMember.toArray());
        VectorDoubleNativeValueStorage.traceEstimatedSize(estimatedRetainedSizeOfMemberIds);
        return baseSize + estimatedRetainedSizeOfMemberIds;
    }

    public static long estimateSizeToHoldValues(long cellCount, boolean cellsHaveSameFormatIds, boolean includeSizeOfValueStates) {
        throw new UnsupportedOperationException("Use estimateSizeToHoldValues(long, boolean, boolean, int[])");
    }

    private static void traceEstimatedSize(long estimatedRetainedSizeOfOrdinalsObject) {
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            TRACE_LOGGER.log(String.format("memberIds retained size = %,d bytes", estimatedRetainedSizeOfOrdinalsObject));
        }
    }

    @Override
    public OrdinalValue get(int index, OrdinalValue returnOrdinalValue) {
        VectorValue returnedOrdinalValueLarge = returnOrdinalValue == null ? new VectorValue(null, null) : (VectorValue)returnOrdinalValue;
        returnedOrdinalValueLarge.setMemberIds(this.memberIdList.get(index, returnedOrdinalValueLarge.getMemberIds()));
        returnedOrdinalValueLarge.setValue(this.buildValue(index));
        return returnedOrdinalValueLarge;
    }

    public boolean updateValue(OrdinalValue ov) {
        if (!(ov instanceof VectorValue)) {
            throw new UnsupportedOperationException("Cannot update via an OrdinalValue, need OrdinalValueLarge.");
        }
        int position = Collections.binarySearch(this.memberIdList, ((VectorValue)ov).getMemberIds(), IntArrayComparator.getInstance());
        if (position < 0) {
            return false;
        }
        super.updateValue(position, ov);
        return true;
    }

    @Override
    public OrdinalValue createOrdinalValue() {
        return new VectorValue(null, null);
    }

    public int getMemberIdArrayWidth() {
        return this.memberIdList.getArrayWidth();
    }

    public int[] getBytesPerHierarchyStats() {
        return this.memberIdList.getMemoryUsageStats();
    }

    @Override
    public int getIndex(OrdinalValue ordinalValue) {
        return Collections.binarySearch(this.memberIdList, ((VectorValue)ordinalValue).getMemberIds(), IntArrayComparator.getInstance());
    }
}

