/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinitionGraphSubscriber;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.AggregateCalculationGraphSubscriber;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.IStreamedValues;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.LeafLevelSetWithMeasures;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.LevelSet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.LevelSetWithMeasures;
import com.cognos.xqe.util.primitive.ArrayListInt;
import com.cognos.xqe.util.primitive.HashMapIntObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class AggregateCalculationGraph
implements Iterable<AGNode> {
    private final AGNode rootNode;
    private final RollupCostEstimator costEstimator;
    private int nodeCount = 1;
    private final ArrayListInt pchHierIdxs;

    public AggregateCalculationGraph(ROLAPBaseCube cube, boolean includeMeasures) {
        this.costEstimator = new RollupCostEstimator(cube);
        this.pchHierIdxs = this.getPchHierIndexes(cube);
        int[] rootLevelSet = this.costEstimator.getLeafLevelSet();
        this.rootNode = includeMeasures ? this.createNode(new LeafLevelSetWithMeasures(rootLevelSet, cube.getMeasures()), null) : this.createNode(new LevelSet(rootLevelSet), null);
    }

    private ArrayListInt getPchHierIndexes(ROLAPBaseCube cube) {
        ArrayListInt thePchHierIndexes = new ArrayListInt();
        List<IHierarchy> hiers = cube.getHierarchies();
        for (int i = 0; i < hiers.size(); ++i) {
            if (!hiers.get(i).isParentChild()) continue;
            thePchHierIndexes.add(i);
        }
        return thePchHierIndexes;
    }

    public AGNode insertNode(LevelSet levelSet, Collection<? extends AggregateCalculationGraphSubscriber> subscribers) {
        AGNode newNode = this.createNode(levelSet, subscribers);
        if (!this.rootNode.rollsUpTo(newNode)) {
            throw new XQERuntimeException();
        }
        AGNode insertedNode = this.rootNode.insertNode(newNode, null, this.costEstimator);
        if (newNode.equals(insertedNode)) {
            ++this.nodeCount;
        }
        return insertedNode;
    }

    private AGNode createNode(LevelSet levelSet, Collection<? extends AggregateCalculationGraphSubscriber> subscribers) {
        return new AGNode(levelSet, subscribers);
    }

    public void optimize() {
        this.rootNode.optimizeSelfAndDependents(this.pchHierIdxs);
        this.rootNode.getSelfAndDepsAdditiveMeasures();
    }

    public String toString() {
        Set levelNodes;
        int maxLevelIdx = -1;
        HashMapIntObject<LinkedHashSet<AGNode>> levelIdxToNodes = new HashMapIntObject<LinkedHashSet<AGNode>>();
        for (AGNode currNode : this) {
            int level = currNode.getMaxNumberEdgesToSource(this.rootNode);
            levelNodes = (LinkedHashSet<AGNode>)levelIdxToNodes.get(level);
            if (levelNodes == null) {
                levelNodes = new LinkedHashSet<AGNode>();
                levelIdxToNodes.put(level, (LinkedHashSet<AGNode>)levelNodes);
            }
            levelNodes.add(currNode);
            maxLevelIdx = Math.max(maxLevelIdx, level);
        }
        String nl = "\n";
        StringBuilder sb = new StringBuilder("ACG: node count = " + this.size() + "\n");
        for (int i = 0; i <= maxLevelIdx; ++i) {
            levelNodes = (Set)levelIdxToNodes.get(i);
            for (AGNode node : levelNodes) {
                sb.append(node.toStringSelfAndDeps() + "\n");
            }
            sb.append("-----------------------------------------------------------------\n");
        }
        return sb.toString();
    }

    public AGNode getRootNode() {
        return this.rootNode;
    }

    public boolean removeNode(AGNode node) {
        if (node == this.rootNode || node.getDependents().size() > 0) {
            return false;
        }
        ArrayList<AGNode> sourceNodes = new ArrayList<AGNode>();
        for (AGEdge source : node.getSources()) {
            sourceNodes.add(source.getSource());
        }
        for (AGNode sourceNode : sourceNodes) {
            node.removeSource(sourceNode);
        }
        --this.nodeCount;
        return true;
    }

    @Override
    public Iterator<AGNode> iterator() {
        return new AGIterator(this);
    }

    public int size() {
        return this.nodeCount;
    }

    public static class AGIterator
    implements Iterator<AGNode> {
        private final Iterator<AGNode> distinctIterator;

        public AGIterator(AggregateCalculationGraph acg) {
            AGNode root = acg.getRootNode();
            LinkedHashSet<AGNode> iterationSet = new LinkedHashSet<AGNode>();
            ArrayList<AGNode> currentLevel = new ArrayList<AGNode>();
            currentLevel.add(root);
            while (!currentLevel.isEmpty()) {
                ArrayList<AGNode> nextLevel = new ArrayList<AGNode>();
                for (AGNode node : currentLevel) {
                    nextLevel.addAll(node.getDependents());
                    if (iterationSet.add(node)) continue;
                    iterationSet.remove(node);
                    iterationSet.add(node);
                }
                currentLevel = nextLevel;
            }
            this.distinctIterator = iterationSet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.distinctIterator.hasNext();
        }

        @Override
        public AGNode next() {
            return this.distinctIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class RollupCostEstimator {
        private final int[][] levelCardinalities;
        private final int[] leafLevelSet;

        public RollupCostEstimator(ROLAPBaseCube cube) {
            List<IHierarchy> hiers = cube.getHierarchies();
            this.levelCardinalities = new int[hiers.size()][];
            this.leafLevelSet = new int[hiers.size()];
            for (int i = 0; i < hiers.size(); ++i) {
                IHierarchy hier = hiers.get(i);
                List<ILevel> levels = hier.getLevels();
                this.leafLevelSet[i] = levels.size() - 1;
                this.levelCardinalities[i] = new int[levels.size()];
                for (int j = 0; j < levels.size(); ++j) {
                    this.levelCardinalities[i][j] = levels.get(j).getCardinality();
                }
            }
        }

        public int[] getLeafLevelSet() {
            return this.leafLevelSet;
        }

        public double calculateCostFromNodeToNode(AGNode sourceNode, AGNode destinationNode) {
            double destCardinality = this.getNodeLevelSetLogCardinality(destinationNode);
            double sourceCardinality = this.getNodeLevelSetLogCardinality(sourceNode);
            return sourceCardinality - destCardinality;
        }

        private double getNodeLevelSetLogCardinality(AGNode node) {
            int[] levels = node.getLevelSet().getIndexes();
            double cardinality = 0.0;
            for (int i = 0; i < levels.length; ++i) {
                cardinality += Math.log10(this.levelCardinalities[i][levels[i]]);
            }
            return cardinality;
        }
    }

    public static class AGEdge
    implements Comparable<AGEdge> {
        private final double cost;
        private final AGNode source;

        public AGEdge(double cst, AGNode src) {
            this.cost = cst;
            this.source = src;
        }

        public double getCost() {
            return this.cost;
        }

        public AGNode getSource() {
            return this.source;
        }

        @Override
        public int compareTo(AGEdge o) {
            return Double.compare(this.cost, o.cost);
        }

        public String toString() {
            return "[" + this.cost + ": " + this.source.toString() + "]";
        }
    }

    public static class AGNode {
        private static final int NUM_DEPENDENTS_FOR_ADDED_NODE = 4;
        private final LevelSet levelSet;
        private final Collection<AggregateCalculationGraphSubscriber> subscribers;
        private Collection<TupleValue> values = new ArrayList<TupleValue>();
        private IStreamedValues<TupleValue> valueStream = null;
        private Iterator<TupleValue>[] valueIterators = null;
        private final List<AGEdge> sources = new ArrayList<AGEdge>(1);
        private final List<AGNode> destinations = new ArrayList<AGNode>(1);
        private Set<IMember> selfAndDepsAdditiveMeasures = null;

        public AGNode(LevelSet lvlSet, Collection<? extends AggregateCalculationGraphSubscriber> theSubscribers) {
            this.levelSet = lvlSet;
            this.subscribers = theSubscribers == null ? new ArrayList<AggregateCalculationGraphSubscriber>(1) : new ArrayList<AggregateCalculationGraphSubscriber>(theSubscribers);
        }

        public AGNode insertNode(AGNode newNode, AGNode prevSrc, RollupCostEstimator costEstimator) {
            AGNode insertedNode = null;
            if (newNode.equals(this)) {
                insertedNode = this;
            } else if (newNode.hasSameLevelSet(this)) {
                this.merge(newNode, costEstimator);
                insertedNode = this;
            } else if (newNode.rollsUpTo(this)) {
                this.addSource(newNode, costEstimator);
                this.removeSource(prevSrc);
                insertedNode = newNode;
            } else if (this.rollsUpTo(newNode)) {
                AGNode[] dependents;
                for (AGNode dependent : dependents = this.getDependentsAsArray()) {
                    AGNode tmp = dependent.insertNode(newNode, this, costEstimator);
                    if (insertedNode != null) continue;
                    insertedNode = tmp;
                }
                if (insertedNode == null) {
                    newNode.addSource(this, costEstimator);
                    insertedNode = newNode;
                }
            } else {
                this.findIndirectDependents(newNode, costEstimator);
            }
            return insertedNode;
        }

        private void findIndirectDependents(AGNode newNode, RollupCostEstimator costEstimator) {
            AGNode[] dependents;
            for (AGNode dependent : dependents = this.getDependentsAsArray()) {
                if (newNode.rollsUpTo(dependent)) {
                    dependent.addSource(newNode, costEstimator);
                    continue;
                }
                dependent.findIndirectDependents(newNode, costEstimator);
            }
        }

        private boolean isIndirectlySourcedFrom(AGNode sourceNode) {
            for (AGEdge edge : this.sources) {
                AGNode source = edge.getSource();
                if (source.hasSameLevelSet(sourceNode)) {
                    return true;
                }
                if (!source.isIndirectlySourcedFrom(sourceNode)) continue;
                return true;
            }
            return false;
        }

        public int getMaxNumberEdgesToSource(AGNode sourceNode) {
            if (this.hasSameLevelSet(sourceNode)) {
                return 0;
            }
            if (!this.isIndirectlySourcedFrom(sourceNode)) {
                return -1;
            }
            int max = 0;
            for (AGEdge edge : this.sources) {
                AGNode source = edge.getSource();
                if (source.hasSameLevelSet(sourceNode)) {
                    max = Math.max(max, 1);
                    continue;
                }
                max = Math.max(max, 1 + source.getMaxNumberEdgesToSource(sourceNode));
            }
            return max;
        }

        protected boolean isUnnecessary() {
            return this.destinations.isEmpty() && this.subscribers.isEmpty();
        }

        public void optimizeSelfAndDependents(ArrayListInt pchHierIndexes) {
            AGNode[] dependents;
            this.optimize(pchHierIndexes);
            for (AGNode dependent : dependents = this.getDependentsAsArray()) {
                dependent.optimizeSelfAndDependents(pchHierIndexes);
            }
        }

        private void optimize(ArrayListInt pchHierIndexes) {
            if (this.sources.isEmpty()) {
                return;
            }
            AGEdge cheapestSource = this.getBestSource(pchHierIndexes);
            Iterator<AGEdge> it = this.sources.iterator();
            while (it.hasNext()) {
                AGEdge edge = it.next();
                if (edge.equals(cheapestSource)) continue;
                it.remove();
                edge.getSource().removeDependent(this);
            }
            if (this.isUnnecessary()) {
                cheapestSource.getSource().removeDependent(this);
            }
            if (this.sources.size() > 1) {
                ROLAPLog.logError("ROLAPCubes.IncrementalUpdates", "Node " + this + " has multiple source nodes after optimize().  Sources are " + this.sources);
            }
        }

        public boolean rollsUpTo(AGNode otherNode) {
            return this.levelSet.compareTo(otherNode.levelSet) < 0 || this.levelSet.equals(otherNode.levelSet);
        }

        public boolean hasSameLevelSet(AGNode otherNode) {
            return this.levelSet.equals(otherNode.levelSet);
        }

        public AGEdge getBestSource(ArrayListInt hierIndexesForClosestEdge) {
            if (this.sources.isEmpty()) {
                return null;
            }
            Collection<AGEdge> possibleSources = this.sources;
            if (hierIndexesForClosestEdge != null && hierIndexesForClosestEdge.size() > 0) {
                possibleSources = this.findClosestEdges(this.sources, hierIndexesForClosestEdge);
            }
            return Collections.min(possibleSources);
        }

        private Collection<AGEdge> findClosestEdges(List<AGEdge> possibleSources, ArrayListInt hierIndexes) {
            ArrayList<AGEdge> matches = new ArrayList<AGEdge>();
            int shortestHierDistance = Integer.MAX_VALUE;
            for (AGEdge edge : possibleSources) {
                int hierDistance = this.getDistanceFrom(edge.getSource(), hierIndexes);
                if (hierDistance < shortestHierDistance) {
                    matches.clear();
                    matches.add(edge);
                    shortestHierDistance = hierDistance;
                    continue;
                }
                if (hierDistance != shortestHierDistance) continue;
                matches.add(edge);
            }
            return matches;
        }

        private int getDistanceFrom(AGNode other, ArrayListInt hierIndexes) {
            int totalDistance = 0;
            int[] otherLevelIndexes = other.getLevelSet().getIndexes();
            int[] myLevelIndex = this.levelSet.getIndexes();
            for (int i = 0; i < hierIndexes.size(); ++i) {
                int hierIndex = hierIndexes.get(i);
                totalDistance += Math.abs(otherLevelIndexes[hierIndex] - myLevelIndex[hierIndex]);
            }
            return totalDistance;
        }

        public void addSource(AGNode sourceNode, RollupCostEstimator costEstimator) {
            AGEdge[] srcs;
            if (this.containsSource(sourceNode)) {
                return;
            }
            for (AGEdge edge : srcs = this.getSourcesAsArray()) {
                AGNode src = edge.getSource();
                if (!src.rollsUpTo(sourceNode)) continue;
                this.removeSource(src);
                sourceNode.addSource(src, costEstimator);
            }
            double cost = costEstimator.calculateCostFromNodeToNode(sourceNode, this);
            AGEdge newEdge = new AGEdge(cost, sourceNode);
            this.sources.add(newEdge);
            sourceNode.addDependent(this);
        }

        public boolean containsSource(AGNode sourceNode) {
            for (AGEdge edge : this.sources) {
                if (!edge.getSource().hasSameLevelSet(sourceNode)) continue;
                return true;
            }
            return false;
        }

        public void removeSource(AGNode sourceNode) {
            Iterator<AGEdge> it = this.sources.iterator();
            while (it.hasNext()) {
                AGEdge edge = it.next();
                if (!edge.getSource().hasSameLevelSet(sourceNode)) continue;
                it.remove();
                sourceNode.removeDependent(this);
            }
        }

        public double getSourceCost(AGNode sourceNode) {
            for (AGEdge edge : this.sources) {
                if (!edge.getSource().hasSameLevelSet(sourceNode)) continue;
                return edge.getCost();
            }
            return -1.0;
        }

        public List<AGEdge> getSources() {
            return Collections.unmodifiableList(this.sources);
        }

        private AGEdge[] getSourcesAsArray() {
            AGEdge[] srcs = this.sources.toArray(new AGEdge[this.sources.size()]);
            return srcs;
        }

        private void addDependent(AGNode dependentNode) {
            this.destinations.add(dependentNode);
        }

        private void removeDependent(AGNode dependentNode) {
            this.destinations.remove(dependentNode);
        }

        public List<AGNode> getDependents() {
            return Collections.unmodifiableList(this.destinations);
        }

        private AGNode[] getDependentsAsArray() {
            AGNode[] dependents = this.getDependents().toArray(new AGNode[this.getDependents().size()]);
            return dependents;
        }

        private void merge(AGNode otherNode, RollupCostEstimator costEstimator) {
            AGEdge[] srcs;
            AGNode[] dependents;
            this.subscribers.addAll(otherNode.getSubscribers());
            for (AGNode dep : dependents = otherNode.getDependentsAsArray()) {
                dep.removeSource(otherNode);
                dep.addSource(this, costEstimator);
            }
            for (AGEdge src : srcs = otherNode.getSourcesAsArray()) {
                AGNode sourceNode = src.getSource();
                this.addSource(sourceNode, costEstimator);
                otherNode.removeSource(sourceNode);
            }
        }

        public Collection<AggregateCalculationGraphSubscriber> getSubscribers() {
            return Collections.unmodifiableCollection(this.subscribers);
        }

        public Collection<TupleValue> getValues() {
            return this.values;
        }

        public void setValues(Collection<TupleValue> leafValues) {
            this.values = leafValues;
        }

        public void addValues(Collection<TupleValue> leafValues) {
            this.values.addAll(leafValues);
        }

        public IStreamedValues<TupleValue> getValueStream() {
            return this.valueStream;
        }

        public void setValueStream(IStreamedValues<TupleValue> leafValuesAsStream) {
            this.valueStream = leafValuesAsStream;
        }

        public Iterator<TupleValue>[] getValueIterators() {
            return this.valueIterators;
        }

        public void setValueIterators(Iterator<TupleValue>[] theValueIterators) {
            this.valueIterators = theValueIterators;
        }

        public LevelSet getLevelSet() {
            return this.levelSet;
        }

        public String toStringSelfAndDeps() {
            StringBuilder sb = new StringBuilder(this.toString());
            sb.append("  (" + this.subscribers.size() + " subscribers");
            if (this.subscribers.size() > 0 && this.subscribers.iterator().next() instanceof AggregateDefinitionGraphSubscriber) {
                sb.append(':');
                for (AggregateCalculationGraphSubscriber subscriber : this.subscribers) {
                    String aggName = ((AggregateDefinitionGraphSubscriber)subscriber).getAggregateDefinition().getName();
                    sb.append(" [" + aggName + "],");
                }
            }
            sb.append(')');
            if (this.selfAndDepsAdditiveMeasures != null) {
                sb.append("  ( " + this.selfAndDepsAdditiveMeasures.size() + " additve measures used)");
            }
            for (AGNode dest : this.destinations) {
                sb.append("\n     ==> " + dest.toString() + ",   (" + dest.getSourceCost(this) + ") ");
            }
            return sb.toString();
        }

        public String toStringSelfAndSrcs() {
            return this.toString() + "\n <== " + this.sources;
        }

        public String toString() {
            return "AGN: " + this.levelSet.toString();
        }

        public List<LevelSet> calculateAdditionalOptimalLevelSets() {
            ArrayList<LevelSet> newLevelSets = new ArrayList<LevelSet>();
            for (int endIndex = 4; endIndex <= this.destinations.size(); endIndex += 4) {
                List<AGNode> nodeSubset = this.destinations.subList(endIndex - 4, endIndex);
                LevelSet gcdLevelSet = this.findGreatestCommonLevelSet(nodeSubset);
                if (gcdLevelSet == null) continue;
                newLevelSets.add(gcdLevelSet);
            }
            for (AGNode dependent : this.destinations) {
                newLevelSets.addAll(dependent.calculateAdditionalOptimalLevelSets());
            }
            return newLevelSets;
        }

        private LevelSet findGreatestCommonLevelSet(Collection<AGNode> nodes) {
            LevelSet gcdLevelSet = null;
            int[] gcdLevels = new int[this.levelSet.size()];
            gcdLevelSet = this.levelSet instanceof LevelSetWithMeasures ? new LevelSetWithMeasures(gcdLevels, new HashSet<IMember>()) : new LevelSet(gcdLevels);
            for (AGNode dependent : nodes) {
                gcdLevelSet.superset(dependent.getLevelSet());
            }
            return gcdLevelSet;
        }

        public Set<IMember> getSelfAndDepsAdditiveMeasures() {
            if (this.selfAndDepsAdditiveMeasures == null) {
                this.selfAndDepsAdditiveMeasures = new HashSet<IMember>();
                for (AGNode dependent : this.destinations) {
                    this.selfAndDepsAdditiveMeasures.addAll(dependent.getSelfAndDepsAdditiveMeasures());
                }
                for (AggregateCalculationGraphSubscriber subscriber : this.subscribers) {
                    for (IMember measure : subscriber.getMeasures()) {
                        if (!AggregateCalculationEngine.canRollupMeasure(measure)) continue;
                        this.selfAndDepsAdditiveMeasures.add(measure);
                    }
                }
            }
            return this.selfAndDepsAdditiveMeasures;
        }
    }
}

