/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import com.cognos.xqe.data.values.IAddable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.util.ICellCombiner;

public class AdditiveCellCombiner
implements ICellCombiner {
    private static AdditiveCellCombiner combiner = null;

    public static AdditiveCellCombiner getInstance() {
        if (combiner == null) {
            combiner = new AdditiveCellCombiner();
        }
        return combiner;
    }

    protected AdditiveCellCombiner() {
    }

    @Override
    public void combine(ICell c1, ICell c2) {
        IValue newCellValue = (IValue)c1.getValue().copy();
        IValue otherCellValue = c2.getValue();
        if (!(c1.getValue() instanceof IAddable)) {
            throw new UnsupportedOperationException("Cells in resultSets can only be combined if the value is of type IAddable.  This cells value is a " + c1.getValue().getClass());
        }
        ((IAddable)newCellValue).add(otherCellValue);
        c1.setValue(newCellValue);
    }

    @Override
    public IValue combine(ITuple tuple, IValue v1, IValue v2) {
        IValue newCellValue = (IValue)v1.copy();
        if (!(newCellValue instanceof IAddable)) {
            throw new UnsupportedOperationException("Values can only be combined if the value is of type IAddable.  This value is a " + v1.getClass());
        }
        ((IAddable)newCellValue).add(v2);
        return newCellValue;
    }
}

