/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.util.AdditiveCellCombiner;
import com.cognos.xqe.runtree.olap.mdx.util.ICellCombiner;
import com.cognos.xqe.runtree.olap.mdx.util.MaxCellCombiner;
import com.cognos.xqe.runtree.olap.mdx.util.MinCellCombiner;

public class CellCombiner
implements ICellCombiner {
    private ResultSet resultSet = null;
    private long[] axesSizes = null;
    private int measuresAxisIndex = -1;
    private int measuresTupleIndex = -1;
    private IMember slicerMeasure = null;
    private int measureIndex = -1;

    @Override
    public void combine(ICell c1, ICell c2) {
        if (this.axesSizes == null) {
            IMember[] members;
            ISet[] axes = this.resultSet.getAxes();
            this.axesSizes = new long[axes.length];
            for (int i = 0; i < axes.length; ++i) {
                this.axesSizes[i] = axes[i].size();
                IDimension[] axesDimensions = axes[i].getDimensions();
                for (int j = 0; j < axesDimensions.length; ++j) {
                    if (!axesDimensions[j].isMeasuresDimension()) continue;
                    this.measuresAxisIndex = i;
                    this.measuresTupleIndex = j;
                }
            }
            if (this.measuresAxisIndex < 0 && !this.resultSet.getSlicer().isEmpty() && (members = this.resultSet.getSlicer().getTuple(0L).getMembers())[0].isMeasure()) {
                this.slicerMeasure = members[0];
            }
            if (this.measuresAxisIndex < 0 && this.slicerMeasure == null) {
                Exception e = new Exception("Cannot find measures axis");
                throw new XQERuntimeException(e);
            }
        }
        AggregateTypeEnum measureType = AggregateTypeEnum.UNKNOWN;
        if (this.measuresAxisIndex >= 0) {
            IMember[] measures = this.resultSet.getMembersOnAxis(c1.getOrdinal(), this.measuresAxisIndex, this.axesSizes);
            measureType = measures[this.measuresTupleIndex].getRegularAggregate();
        } else {
            measureType = this.slicerMeasure.getRegularAggregate();
        }
        switch (measureType) {
            case MAX: {
                MaxCellCombiner.getInstance().combine(c1, c2);
                break;
            }
            case MIN: {
                MinCellCombiner.getInstance().combine(c1, c2);
                break;
            }
            default: {
                AdditiveCellCombiner.getInstance().combine(c1, c2);
            }
        }
    }

    public void setResultSet(ResultSet rs) {
        this.resultSet = rs;
    }

    @Override
    public IValue combine(ITuple tuple, IValue v1, IValue v2) {
        IValue result;
        if (this.measureIndex == -1) {
            this.initMeasureIndex(tuple);
        }
        IMember measure = tuple.getMember(this.measureIndex);
        AggregateTypeEnum measureType = AggregateTypeEnum.UNKNOWN;
        measureType = measure.getRegularAggregate();
        switch (measureType) {
            case MAX: {
                result = MaxCellCombiner.getInstance().combine(null, v1, v2);
                break;
            }
            case MIN: {
                result = MinCellCombiner.getInstance().combine(null, v1, v2);
                break;
            }
            default: {
                result = AdditiveCellCombiner.getInstance().combine(null, v1, v2);
            }
        }
        return result;
    }

    private synchronized void initMeasureIndex(ITuple tuple) {
        if (this.measureIndex == -1) {
            this.measureIndex = Tuple.getMeasureIndex(tuple, true);
        }
    }
}

