/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.MembersIterator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.primitive.HashMapLongObject;
import com.cognos.xqe.util.primitive.HashMapObjectInt;
import java.util.ArrayList;
import java.util.List;

public class SetTupleMap {
    private final List<HashMapObjectInt<IMember>> memberMapsByHier;
    private static final int NUMBER_64 = 64;
    private static final int MEMBER_MAP_NULL_VALUE = Integer.MIN_VALUE;
    private final int[] hierarchyBitIndex;
    private final int[] bitsRequired;
    private final IHierarchy[] hierarchies;
    private final HashMapLongObject<long[]> tupleToIndexes;
    private final int[][] hierarchiesToIndexesBySet;

    public SetTupleMap(CrossJoinedSet set) {
        int i;
        Set[] sets = set.getSets();
        this.hierarchies = set.getHierarchies();
        this.memberMapsByHier = new ArrayList<HashMapObjectInt<IMember>>();
        int[] hierCard = new int[this.hierarchies.length];
        int[] hierCardWithDuplicates = new int[this.hierarchies.length];
        IMember[][] allMembers = set.getMembersRetainDuplicates(this.hierarchies);
        for (int i2 = 0; i2 < this.hierarchies.length; ++i2) {
            IMember[] members = allMembers[i2];
            HashMapObjectInt<IMember> memberMapByHier = new HashMapObjectInt<IMember>(members.length, Integer.MIN_VALUE);
            this.memberMapsByHier.add(memberMapByHier);
            int memberID = 1;
            for (int j = 0; j < members.length; ++j) {
                int origValue = memberMapByHier.put(members[j], memberID);
                if (origValue == Integer.MIN_VALUE) {
                    ++memberID;
                    continue;
                }
                memberMapByHier.put(members[j], origValue);
            }
            hierCard[i2] = memberMapByHier.size();
            hierCardWithDuplicates[i2] = members.length;
        }
        this.tupleToIndexes = new HashMapLongObject((int)Math.min(Integer.MAX_VALUE, set.calculateTupleToIndexSize()));
        this.hierarchyBitIndex = new int[hierCard.length + 1];
        this.bitsRequired = new int[hierCard.length];
        int index = 0;
        for (i = 0; i < hierCard.length; ++i) {
            this.bitsRequired[i] = hierCardWithDuplicates[i] == 1 ? 0 : (int)Math.ceil(Math.log(hierCard[i] + 1) / Math.log(2.0));
            this.hierarchyBitIndex[i] = index;
            index += this.bitsRequired[i];
        }
        this.hierarchyBitIndex[hierCard.length] = index;
        if (index > 64) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "SetTupleMap,init: dimensionBitIndex overflow");
        }
        this.hierarchiesToIndexesBySet = new int[sets.length][];
        for (i = 0; i < sets.length; ++i) {
            this.hierarchiesToIndexesBySet[i] = this.hierarchiesToIndexesBySet(sets[i]);
        }
        this.populateTupleToIndex(set);
    }

    private void populateTupleToIndex(CrossJoinedSet s) {
        CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
        Set[] sets = s.getSets();
        for (int i = 0; i < sets.length; ++i) {
            Set set = sets[i];
            int tupleIndex = 0;
            MembersIterator itr = new MembersIterator(set.getTupleList().iterator());
            while (itr.hasNext()) {
                if (cancelManager != null && cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                IMember[] mems = itr.next();
                long tupleBitMap = this.getTupleBitMapBySetIndex(mems, i);
                long[] indexes = this.tupleToIndexes.get(tupleBitMap);
                if (indexes == null) {
                    indexes = new long[]{tupleIndex};
                } else if (indexes[0] == 0L && tupleIndex == 0) {
                    indexes = new long[]{tupleIndex};
                } else {
                    long[] newIndexes = new long[indexes.length + 1];
                    System.arraycopy(indexes, 0, newIndexes, 0, indexes.length);
                    newIndexes[indexes.length] = tupleIndex;
                    indexes = newIndexes;
                }
                this.tupleToIndexes.put(tupleBitMap, indexes);
                ++tupleIndex;
            }
        }
    }

    public long getTupleBitMapBySetIndex(IMember[] mems, int setIndex) {
        long tupleBitMap = 0L;
        int[] hierarchiesToIndex = this.hierarchiesToIndexesBySet[setIndex];
        for (int i = 0; i < this.hierarchies.length; ++i) {
            IMember member;
            int idx = hierarchiesToIndex[i];
            HashMapObjectInt<IMember> memberMapByHier = this.memberMapsByHier.get(i);
            if (idx == -1 || (member = mems[idx]) == null) continue;
            int memberID = memberMapByHier.get(member);
            if (memberID == Integer.MIN_VALUE) {
                return -1L;
            }
            if (this.bitsRequired[i] <= 0) continue;
            tupleBitMap |= (long)memberID << this.hierarchyBitIndex[i];
        }
        return tupleBitMap;
    }

    private int[] hierarchiesToIndexesBySet(Set set) {
        IHierarchy[] setHierarchies = set.getHierarchies();
        if (setHierarchies.length == 0) {
            return new int[0];
        }
        int[] hierarchiesToIndex = new int[this.hierarchies.length];
        for (int hierIndex = 0; hierIndex < this.hierarchies.length; ++hierIndex) {
            IHierarchy hierarchy = this.hierarchies[hierIndex];
            boolean found = false;
            int i = 0;
            while (i < setHierarchies.length && !found) {
                if (setHierarchies[i].equals(hierarchy)) {
                    found = true;
                    continue;
                }
                ++i;
            }
            hierarchiesToIndex[hierIndex] = found ? i : -1;
        }
        return hierarchiesToIndex;
    }

    public HashMapLongObject<long[]> getTupleToIndexes() {
        return this.tupleToIndexes;
    }
}

