/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import com.cognos.xqe.runtree.olap.mdx.platform.StringReplacer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StringSubstitutionEngine {
    private static final int NUMBER_127 = 127;
    private static final int NUMBER_32 = 32;
    private static final String AMPERSAND_POUND = "&#";
    private static final String SEMI_COLON = ";";

    public static String escapeSQLString(String s) {
        StringBuilder str = new StringBuilder();
        int len = s != null ? s.length() : 0;
        block3: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\'': {
                    str.append("''");
                    continue block3;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static String substitute(String source, String oldString, String newString) {
        return StringReplacer.substitute(source, oldString, newString);
    }

    public static String substitute(String source, HashMap<String, String> params) {
        String result = source;
        Set<Map.Entry<String, String>> set = params.entrySet();
        Iterator<Map.Entry<String, String>> iter = set.iterator();
        if (result != null) {
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                String key = entry.getKey();
                if (result.indexOf(key) == -1) continue;
                String value = entry.getValue();
                result = StringReplacer.substitute(result, key, value);
            }
        }
        return result;
    }

    public static String escapeString(String s, String charsToReplace) {
        StringBuilder str = new StringBuilder();
        int len = s != null ? s.length() : 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    if (charsToReplace.indexOf(60) >= 0) {
                        str.append("&lt;");
                        continue block7;
                    }
                    str.append("<");
                    continue block7;
                }
                case '>': {
                    if (charsToReplace.indexOf(62) >= 0) {
                        str.append("&gt;");
                        continue block7;
                    }
                    str.append(">");
                    continue block7;
                }
                case '&': {
                    if (charsToReplace.indexOf(38) >= 0) {
                        str.append("&amp;");
                        continue block7;
                    }
                    str.append("&");
                    continue block7;
                }
                case '\"': {
                    if (charsToReplace.indexOf(34) >= 0) {
                        str.append("&quot;");
                        continue block7;
                    }
                    str.append("\"");
                    continue block7;
                }
                case '\'': {
                    if (charsToReplace.indexOf(39) >= 0) {
                        str.append("&apos;");
                        continue block7;
                    }
                    str.append("'");
                    continue block7;
                }
                default: {
                    char ival = ch;
                    if (ival < ' ' || ival > '\u007f') {
                        char ch2;
                        if (Character.isHighSurrogate(ch) && i + 1 < s.length() && Character.isLowSurrogate(ch2 = s.charAt(i + 1))) {
                            str.append(AMPERSAND_POUND);
                            str.append(String.valueOf(Character.toCodePoint(ch, ch2)));
                            str.append(SEMI_COLON);
                            ++i;
                            continue block7;
                        }
                        str.append(AMPERSAND_POUND);
                        str.append(String.valueOf((int)ival));
                        str.append(SEMI_COLON);
                        continue block7;
                    }
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static String escapeString(String s) {
        int escNdx = StringSubstitutionEngine.needsEscaping(s);
        if (escNdx != -1) {
            StringBuilder str = new StringBuilder();
            if (escNdx > 0) {
                str.append(s.substring(0, escNdx));
            }
            int len = s.length();
            block7: for (int i = escNdx; i < len; ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '<': {
                        str.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        str.append("&gt;");
                        continue block7;
                    }
                    case '&': {
                        str.append("&amp;");
                        continue block7;
                    }
                    case '\"': {
                        str.append("&quot;");
                        continue block7;
                    }
                    case '\'': {
                        str.append("&apos;");
                        continue block7;
                    }
                    default: {
                        char ival = ch;
                        if (ival < ' ' || ival > '\u007f') {
                            char ch2;
                            if (Character.isHighSurrogate(ch) && i + 1 < s.length() && Character.isLowSurrogate(ch2 = s.charAt(i + 1))) {
                                str.append(AMPERSAND_POUND);
                                str.append(String.valueOf(Character.toCodePoint(ch, ch2)));
                                str.append(SEMI_COLON);
                                ++i;
                                continue block7;
                            }
                            str.append(AMPERSAND_POUND);
                            str.append(String.valueOf((int)ival));
                            str.append(SEMI_COLON);
                            continue block7;
                        }
                        str.append(ch);
                    }
                }
            }
            return str.toString();
        }
        if (s == null) {
            return "";
        }
        return s;
    }

    private static int needsEscaping(String s) {
        if (s == null) {
            return -1;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    return i;
                }
            }
            char ival = ch;
            if (ival >= ' ' && ival <= '\u007f') continue;
            return i;
        }
        return -1;
    }

    public static String escapeStringForHTML(String s) {
        StringBuilder str = new StringBuilder();
        int len = s != null ? s.length() : 0;
        block6: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block6;
                }
                case '>': {
                    str.append("&gt;");
                    continue block6;
                }
                case '&': {
                    str.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block6;
                }
                default: {
                    char ival = ch;
                    if (ival < ' ' || ival > '\u007f') {
                        str.append(AMPERSAND_POUND);
                        str.append(String.valueOf((int)ival));
                        str.append(SEMI_COLON);
                        continue block6;
                    }
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static String unicodeEscapeString(String s) {
        StringBuilder str = new StringBuilder();
        int len = s != null ? s.length() : 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    str.append("&apos;");
                    continue block7;
                }
                default: {
                    int ival = Character.getNumericValue(ch);
                    if (ival < 32 || ival > 127) {
                        str.append(AMPERSAND_POUND);
                        str.append(String.valueOf(ival));
                        str.append(SEMI_COLON);
                        continue block7;
                    }
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }
}

