/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util.math;

import java.util.Arrays;

public class Statistics {
    private double sum;
    private double mean;
    private double median;
    private double min;
    private double max;
    private double stdDev;
    private double stdDevP;
    private double variance;
    private double varianceP;
    private int valueCount;

    public static double getSum(Double[] values) {
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i].doubleValue();
        }
        return sum;
    }

    public static double getMin(Double[] values) {
        double min = values[0];
        for (int i = 1; i < values.length; ++i) {
            min = Math.min(min, values[i]);
        }
        return min;
    }

    public static double getMax(Double[] values) {
        double max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = Math.max(max, values[i]);
        }
        return max;
    }

    public static double getMean(Double[] values) {
        double mean = Statistics.getSum(values) / (double)values.length;
        return mean;
    }

    public static double getMedian(Double[] values) {
        double median;
        Arrays.sort((Object[])values);
        if (values.length % 2 == 1) {
            int aux = values.length / 2;
            median = values[aux];
        } else {
            median = (values[values.length / 2] + values[values.length / 2 - 1]) / 2.0;
        }
        return median;
    }

    private static double getVarianceBullis(Double[] values) {
        double total = 0.0;
        double squaredTotal = 0.0;
        int count = 0;
        while (count < values.length) {
            double v = values[count];
            ++count;
            squaredTotal += v * v;
            total += v;
        }
        total = (double)count * squaredTotal - total * total;
        return total /= (double)(count * (count - 1));
    }

    private static double getVariancePBullis(Double[] values) {
        double total = 0.0;
        double squaredTotal = 0.0;
        int count = 0;
        while (count < values.length) {
            double v = values[count];
            ++count;
            squaredTotal += v * v;
            total += v;
        }
        total = (double)count * squaredTotal - total * total;
        return total /= (double)(count * count);
    }

    public static double getVariance(Double[] values) {
        double variance = Statistics.getVarianceBullis(values);
        return variance;
    }

    public static double getVarianceP(Double[] values) {
        double varianceP = Statistics.getVariancePBullis(values);
        return varianceP;
    }

    public static double getStdDev(Double[] values) {
        double stdDev = Math.sqrt(Statistics.getVariance(values));
        return stdDev;
    }

    public static double getStdDevP(Double[] values) {
        double stdDev = Math.sqrt(Statistics.getVarianceP(values));
        return stdDev;
    }

    public Statistics(Double[] values) {
        double[] vals = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            vals[i] = values[i];
        }
        this.init(vals);
    }

    public Statistics(double[] values) {
        this.init(values);
    }

    private void init(double[] values) {
        this.sum = 0.0;
        this.max = values[0];
        this.min = values[0];
        this.valueCount = values.length;
        for (int i = 0; i < values.length; ++i) {
            double value = values[i];
            this.sum += value;
            this.max = Math.max(this.max, value);
            this.min = Math.min(this.min, value);
        }
        this.mean = this.sum / (double)this.valueCount;
        Arrays.sort(values);
        if (this.valueCount % 2 == 1) {
            int aux = this.valueCount / 2;
            this.median = values[aux];
        } else {
            this.median = (values[this.valueCount / 2] + values[this.valueCount / 2 - 1]) / 2.0;
        }
        double std = 0.0;
        for (int i = 0; i < values.length; ++i) {
            std += Math.pow(values[i] - this.mean, 2.0);
        }
        this.variance = std / (double)(this.valueCount - 1);
        this.varianceP = std / (double)this.valueCount;
        this.stdDev = Math.sqrt(this.variance);
        this.stdDevP = Math.sqrt(this.varianceP);
    }

    public double getSum() {
        return this.sum;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getMean() {
        return this.mean;
    }

    public double getMedian() {
        return this.median;
    }

    public double getVariance() {
        return this.variance;
    }

    public double getVarianceP() {
        return this.varianceP;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public double getStdDevP() {
        return this.stdDevP;
    }
}

