/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.v5provider;

import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAbstractHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.ROLAPSecurityPaddingMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderAggregateCombinationRule;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderCombination;
import java.util.ArrayList;
import java.util.List;

public class V5ProviderAggregateCombination
extends V5ProviderCombination {
    List<AggregateRuleTargetMemberList> membersWithRule;

    public V5ProviderAggregateCombination(List<AggregateRuleTargetMemberList> ruleTargetMembers) {
        this.membersWithRule = ruleTargetMembers;
    }

    public List<List<IMember>> getPerHierarchyMemberList(ROLAPMetaAggregateCube aggrCube) {
        ArrayList<List<IMember>> perHierarchyMemberList = new ArrayList<List<IMember>>();
        for (AggregateRuleTargetMemberList ruleMemberList : this.membersWithRule) {
            ArrayList<IMember> resolvedFLMembers = new ArrayList<IMember>();
            ILevel lowestLevel = null;
            for (IMember member : ruleMemberList.getTargetMembers()) {
                if (aggrCube != null && lowestLevel == null) {
                    lowestLevel = aggrCube.getLowestAggregateLevel(member.getHierarchy());
                }
                IMember resolvedMember = V5ProviderAggregateCombination.getResolvedMember(ruleMemberList.getAggregateRule(), member, lowestLevel);
                resolvedFLMembers.add(resolvedMember);
            }
            perHierarchyMemberList.add(resolvedFLMembers);
        }
        return perHierarchyMemberList;
    }

    private static IMember getResolvedMember(V5ProviderAggregateCombinationRule rule, IMember mem, ILevel lowestLevel) {
        List<IMember> children;
        IDimension dim = mem.getDimension();
        ILevel scopeLevel = null;
        scopeLevel = lowestLevel != null ? lowestLevel : dim.getLevel(dim.getLevelCount() - 1);
        int scopeLevelIdx = scopeLevel.getIndex();
        IMember childMember = mem;
        for (int currentLevelIdx = mem.getLevel().getIndex(); currentLevelIdx < scopeLevelIdx && (children = childMember.getChildren()).size() != 0; ++currentLevelIdx) {
            if (rule.getRuleAggregate() == AggregateTypeEnum.LAST) {
                childMember = children.get(children.size() - 1);
                if (!(childMember instanceof ROLAPSecurityPaddingMemberProxy)) continue;
                childMember = children.get(children.size() - 2);
                continue;
            }
            if (rule.getRuleAggregate() == AggregateTypeEnum.CURRENTPERIOD) {
                IMember currentPeriodLeafMember = null;
                IHierarchy hierarchy = mem.getHierarchy();
                if (hierarchy instanceof ROLAPAbstractHierarchy) {
                    currentPeriodLeafMember = ((ROLAPAbstractHierarchy)hierarchy).getLeafLevelCurrentPeriodMember();
                }
                if (currentPeriodLeafMember != null && MemberOperations.isAncestorOf(childMember, currentPeriodLeafMember)) {
                    while (currentPeriodLeafMember.getLevel().getIndex() > scopeLevelIdx) {
                        currentPeriodLeafMember = currentPeriodLeafMember.getParent();
                    }
                    return currentPeriodLeafMember;
                }
                childMember = children.get(children.size() - 1);
                if (!(childMember instanceof ROLAPSecurityPaddingMemberProxy)) continue;
                childMember = children.get(children.size() - 2);
                continue;
            }
            childMember = children.get(0);
        }
        return childMember;
    }

    public static class AggregateRuleTargetMemberList {
        private List<IMember> targetMembers;
        private V5ProviderAggregateCombinationRule rule;

        public AggregateRuleTargetMemberList(V5ProviderAggregateCombinationRule aRule, List<IMember> members) {
            this.rule = aRule;
            this.targetMembers = members;
        }

        public V5ProviderAggregateCombinationRule getAggregateRule() {
            return this.rule;
        }

        public List<IMember> getTargetMembers() {
            return this.targetMembers;
        }
    }
}

