/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.v5provider;

import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderSelection;
import java.util.ArrayList;
import java.util.List;

public class V5ProviderCombination {
    int measuresIndex = -1;
    protected List<V5ProviderSelection> selections;

    public V5ProviderCombination() {
        this.selections = new ArrayList<V5ProviderSelection>();
    }

    public V5ProviderCombination(List<V5ProviderSelection> sels) {
        this.selections = sels;
    }

    public V5ProviderCombination copy() {
        V5ProviderCombination copy = new V5ProviderCombination();
        for (V5ProviderSelection sel : this.selections) {
            copy.addSelection(sel);
        }
        return copy;
    }

    public void addSelection(V5ProviderSelection selection) {
        this.selections.add(selection);
    }

    public List<V5ProviderSelection> getSelections() {
        return this.selections;
    }

    public List<Object> getSelectionList() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (V5ProviderSelection sel : this.selections) {
            list.add(sel.getMembers());
        }
        return list;
    }

    public boolean containsMeasure(IMeasure m) {
        int mIndex = this.getMeasuresIndex();
        if (mIndex != -1) {
            V5ProviderSelection sel = this.selections.get(mIndex);
            List<IMember> measures = sel.getMembersList();
            return measures.contains(m);
        }
        return false;
    }

    private int getMeasuresIndex() {
        if (this.measuresIndex == -1) {
            int i = 0;
            for (V5ProviderSelection sel : this.selections) {
                if (sel.getFirstMember() instanceof IMeasure) {
                    this.measuresIndex = i;
                    break;
                }
                ++i;
            }
        }
        return this.measuresIndex;
    }

    public String toString() {
        return "V5ProviderCombination: " + this.selections;
    }
}

