/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.v5provider;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SetSelections;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderAggregateCombination;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderAggregateCombinationRule;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderAggregateSelection;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderCombination;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQuery;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderSelection;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.primitive.HashMapObjectInt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class V5ProviderQueryStrategy
extends QueryStrategy {
    protected Map<IMeasure, HashSet<IDimension>> firstLastAggregatesMeasureMap = new HashMap<IMeasure, HashSet<IDimension>>();
    protected Map<IMeasure, List<V5ProviderAggregateCombinationRule>> firstLastAggregateRules = new HashMap<IMeasure, List<V5ProviderAggregateCombinationRule>>();

    @Override
    public void execute(CrossJoinedSet cjs, IResultSet resultSet) throws InterpreterException {
        this.executeAndFetchFromStore(cjs, resultSet, this.getCube());
    }

    protected abstract void executeAndFetchFromStore(CrossJoinedSet var1, IResultSet var2, ICube var3) throws InterpreterException;

    public abstract V5ProviderQuery combinationToV5ProviderQuery(int var1, List<V5ProviderSelection> var2, boolean var3, boolean var4, boolean var5);

    protected Map<IDimension, Integer> getDimToIndexMap() {
        HashMap<IDimension, Integer> dimToIndex = new HashMap<IDimension, Integer>();
        List<IDimension> dimensions = this.getCube().getDimensions();
        dimToIndex = new HashMap();
        int idx = 0;
        for (IDimension dimension : dimensions) {
            dimToIndex.put(dimension, new Integer(idx++));
        }
        return dimToIndex;
    }

    public HashMapObjectInt<String> getHierToIndexMap() {
        HashMapObjectInt<String> hierToIndex = null;
        List<IHierarchy> cubeHierarchies = ((Cube)this.getCube()).getHierarchies();
        hierToIndex = new HashMapObjectInt<String>();
        for (int i = 0; i < cubeHierarchies.size(); ++i) {
            Hierarchy hier = (Hierarchy)cubeHierarchies.get(i);
            hierToIndex.put(hier.getUniqueName(), i);
        }
        return hierToIndex;
    }

    boolean measureHasAggregateRule(IMember measure) {
        for (List<V5ProviderAggregateCombinationRule> aggregateRules : this.firstLastAggregateRules.values()) {
            for (V5ProviderAggregateCombinationRule rule : aggregateRules) {
                if (rule.getMeasure() != measure) continue;
                return true;
            }
        }
        return false;
    }

    protected List<V5ProviderCombination> buildCombinations(V5ProviderCombination baseCombination, List<V5ProviderAggregateCombinationRule> aggregateRules) {
        V5ProviderCombination aggregateCombination;
        ArrayList<V5ProviderCombination> aggregatedCombinations = new ArrayList<V5ProviderCombination>();
        V5ProviderCombination reducedCombination = this.buildReducedCombination(baseCombination);
        if (reducedCombination != null) {
            aggregatedCombinations.add(reducedCombination);
        }
        if ((aggregateCombination = this.buildAggregateCombinations(baseCombination, aggregateRules)) != null) {
            aggregatedCombinations.add(aggregateCombination);
        }
        return aggregatedCombinations;
    }

    protected List<V5ProviderCombination> handleFirstLastAggregatesInCombinations(List<V5ProviderCombination> combinations, int hierCount) {
        if (ROLAPLog.isOn("ROLAPQuery", LogLevel.TRACE)) {
            ROLAPLog.logTrace("ROLAPQuery", "handleFirstLastAggregatesInCombinations original combinations: " + combinations.toString());
        }
        ArrayList<V5ProviderCombination> combinationList = new ArrayList<V5ProviderCombination>();
        Iterator<V5ProviderCombination> it = combinations.iterator();
        while (it.hasNext()) {
            V5ProviderCombination com = it.next();
            boolean containsSemiAggMeas = false;
            for (IMeasure meas : this.firstLastAggregateRules.keySet()) {
                if (!com.containsMeasure(meas)) continue;
                containsSemiAggMeas = true;
                break;
            }
            if (containsSemiAggMeas) continue;
            combinationList.add(com);
            it.remove();
        }
        List<V5ProviderCombination> combList = combinations;
        for (List<V5ProviderAggregateCombinationRule> aggregateRules : this.firstLastAggregateRules.values()) {
            for (V5ProviderCombination eCombination : combList) {
                if (aggregateRules.isEmpty() || !eCombination.containsMeasure(aggregateRules.get(0).getMeasure())) continue;
                List<V5ProviderCombination> v5Combinations = this.buildCombinations(eCombination, aggregateRules);
                if (!v5Combinations.isEmpty()) {
                    combinationList.addAll(v5Combinations);
                }
                if (!ROLAPLog.isOn("ROLAPQuery", LogLevel.TRACE)) continue;
                ROLAPLog.logTrace("ROLAPQuery", "\nFor rules: " + aggregateRules + ",\nAdding combinations: " + v5Combinations);
            }
        }
        return combinationList;
    }

    protected void buildFLAggregatesRulesMap(SetSelections setSel, Hierarchy[] hierarchies, int measuresIndex) throws InterpreterException {
        this.firstLastAggregatesMeasureMap.clear();
        this.firstLastAggregateRules.clear();
        Collection<IMember> measureSelections = setSel.getSelections(hierarchies)[measuresIndex];
        for (IMeasure iMeasure : measureSelections) {
            for (IAggregateRule rule : iMeasure.getAggregateRules()) {
                if (rule.getAggregate() != AggregateTypeEnum.FIRST && rule.getAggregate() != AggregateTypeEnum.LAST && rule.getAggregate() != AggregateTypeEnum.CURRENTPERIOD) continue;
                List<V5ProviderAggregateCombinationRule> combinationRules = this.firstLastAggregateRules.get(iMeasure);
                if (combinationRules == null) {
                    combinationRules = new ArrayList<V5ProviderAggregateCombinationRule>();
                    this.firstLastAggregateRules.put(iMeasure, combinationRules);
                }
                V5ProviderAggregateCombinationRule combinationRule = new V5ProviderAggregateCombinationRule(rule, iMeasure);
                IDimension dim = this.getCube().getDimension(rule.getDimensionRef());
                combinationRule.add(dim);
                combinationRules.add(combinationRule);
                HashSet<IDimension> aggregateFirstLastDimension = this.firstLastAggregatesMeasureMap.get(iMeasure);
                if (aggregateFirstLastDimension == null) {
                    aggregateFirstLastDimension = new HashSet();
                    this.firstLastAggregatesMeasureMap.put(iMeasure, aggregateFirstLastDimension);
                }
                aggregateFirstLastDimension.add(dim);
            }
        }
    }

    private V5ProviderCombination buildAggregateCombinations(V5ProviderCombination baseCombination, List<V5ProviderAggregateCombinationRule> aggregateRules) {
        HashSet<Object> dimSet = new HashSet<Object>();
        Object multiHierarchyRuleDim = null;
        for (V5ProviderSelection sel : baseCombination.getSelections()) {
            Object dim;
            if (!(sel instanceof V5ProviderAggregateSelection) || dimSet.add(dim = sel.getFirstMember().getDimension())) continue;
            multiHierarchyRuleDim = dim;
            break;
        }
        ArrayList<V5ProviderSelection> resultSelections = new ArrayList<V5ProviderSelection>();
        ArrayList<V5ProviderAggregateCombination.AggregateRuleTargetMemberList> membersWithRule = new ArrayList<V5ProviderAggregateCombination.AggregateRuleTargetMemberList>();
        for (V5ProviderSelection sel : baseCombination.getSelections()) {
            V5ProviderAggregateCombinationRule rule = null;
            if (sel instanceof V5ProviderAggregateSelection) {
                rule = null;
                IDimension selectionDim = sel.getFirstMember().getDimension();
                for (V5ProviderAggregateCombinationRule aRule : aggregateRules) {
                    for (IDimension aRefDim : aRule.getDimensions()) {
                        if (!aRefDim.equals(selectionDim)) continue;
                        rule = aRule;
                        break;
                    }
                    if (rule == null) continue;
                    break;
                }
                if (rule == null) {
                    throw new XQERuntimeException();
                }
                List<V5ProviderSelection> decomposedSelections = ((V5ProviderAggregateSelection)sel).decomposeSelection(rule);
                if (decomposedSelections.size() == 1 && !sel.getFirstMember().getDimension().equals(multiHierarchyRuleDim) && sel.getFirstMember().getLevel().isLeafLevel()) {
                    resultSelections.addAll(decomposedSelections);
                    continue;
                }
                resultSelections.add(sel);
                ArrayList membersWithRuleInSel = new ArrayList();
                for (V5ProviderSelection s : decomposedSelections) {
                    membersWithRuleInSel.addAll(s.getMembersList());
                }
                membersWithRule.add(new V5ProviderAggregateCombination.AggregateRuleTargetMemberList(rule, membersWithRuleInSel));
                continue;
            }
            if (sel.getFirstMember() instanceof IMeasure) {
                List<V5ProviderSelection> measureSelectionsOfTheRule = sel.decomposeMeasureSelection(aggregateRules.get(0));
                if (measureSelectionsOfTheRule.size() == 0) {
                    return null;
                }
                ArrayList<IMember> measures = new ArrayList<IMember>();
                for (V5ProviderSelection aMeasureSelection : measureSelectionsOfTheRule) {
                    measures.addAll(aMeasureSelection.getMembersList());
                }
                V5ProviderSelection resultMeasureSelection = new V5ProviderSelection(measures);
                resultSelections.add(resultMeasureSelection);
                continue;
            }
            resultSelections.addAll(sel.decomposeSelection(null));
        }
        V5ProviderCombination resultCombination = null;
        resultCombination = !membersWithRule.isEmpty() ? new V5ProviderAggregateCombination((List<V5ProviderAggregateCombination.AggregateRuleTargetMemberList>)membersWithRule) : new V5ProviderCombination();
        for (V5ProviderSelection sel : resultSelections) {
            resultCombination.addSelection(sel);
        }
        return resultCombination;
    }

    private V5ProviderCombination buildReducedCombination(V5ProviderCombination baseCombination) {
        V5ProviderCombination reducedCombination = new V5ProviderCombination();
        for (V5ProviderSelection selection : baseCombination.getSelections()) {
            if (selection.getFirstMember() instanceof IMeasure) {
                ArrayList<IMember> mems = new ArrayList<IMember>();
                for (IMember m : selection.getMembersList()) {
                    if (this.measureHasAggregateRule(m)) continue;
                    mems.add(m);
                }
                if (mems.isEmpty()) {
                    return null;
                }
                V5ProviderSelection measureSel = new V5ProviderSelection(mems);
                reducedCombination.addSelection(measureSel);
                continue;
            }
            reducedCombination.addSelection(selection);
        }
        return reducedCombination;
    }
}

