/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.v5provider;

import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.mdx.v5provider.XQueryStrategy;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.Timer;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.List;

public abstract class XProfileInfoCollector
extends XNode {
    private static final long serialVersionUID = 1L;
    private final ThreadLocal<ProfileMode> mMode = new ThreadLocal();
    private final ThreadLocal<Long> mLocalElapsedTime = new ThreadLocal();
    private final ThreadLocal<Long> mLocalCpuTime = new ThreadLocal();
    private final List<Long> mElapsedTimeSeries = new ArrayList<Long>();
    private final List<Long> mCpuTimeSeries = new ArrayList<Long>();

    public synchronized void begin() {
        switch (this.getMode()) {
            case SERIAL: {
                XQETrace trace = this.getTrace();
                if (trace == null) break;
                this.startTimer(trace);
                break;
            }
        }
    }

    public synchronized void end() {
        switch (this.getMode()) {
            case SERIAL: {
                XQETrace trace = this.getTrace();
                if (trace == null) break;
                this.stopTimer(trace);
                break;
            }
        }
    }

    @Override
    protected void startTimer(XQETrace traceObj) {
        if (!QueryEngineLoggingUtils.isProfilingEnabled(traceObj)) {
            return;
        }
        this.mLocalElapsedTime.set(System.nanoTime());
        this.mLocalCpuTime.set(Timer.getCurrentThreadCpuTime());
    }

    @Override
    protected void stopTimer(XQETrace traceObj) {
        if (!QueryEngineLoggingUtils.isProfilingEnabled(traceObj)) {
            return;
        }
        this.addElapsedTime(System.nanoTime() - this.mLocalElapsedTime.get());
        this.addCpuTime(Timer.getCurrentThreadCpuTime() - this.mLocalCpuTime.get());
    }

    protected XQETrace getTrace() {
        XDataContext dc = this.getDataContext();
        if (dc == null) {
            return null;
        }
        return dc.getTrace();
    }

    protected XDataContext getDataContext() {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        XDataContext ctx = execEnv.getDataContext();
        if (ctx == null) {
            ctx = execEnv.pushDataContext();
        }
        return ctx;
    }

    public synchronized ProfileMode getMode() {
        ProfileMode mode = this.mMode.get();
        if (mode == null) {
            mode = ProfileMode.SERIAL;
        }
        return mode;
    }

    public synchronized void setMode(ProfileMode mode) {
        this.mMode.set(mode);
    }

    @Override
    public synchronized long getTotalElapsedTime() {
        long elapsedTime = super.getTotalElapsedTime();
        if (elapsedTime != 0L) {
            return elapsedTime;
        }
        long grandTotal = 0L;
        for (Long time : this.mElapsedTimeSeries) {
            grandTotal += time.longValue();
        }
        return grandTotal;
    }

    @Override
    public synchronized void setTotalElapsedTime(long time) {
        super.setTotalElapsedTime(time);
    }

    public synchronized void addElapsedTime(long delta) {
        super.addTotalElapsedTime(delta);
    }

    @Override
    public synchronized long getTotalCPUTime() {
        long cpuTime = super.getTotalCPUTime();
        if (cpuTime != 0L) {
            return cpuTime;
        }
        long grandTotal = 0L;
        for (Long time : this.mCpuTimeSeries) {
            grandTotal += time.longValue();
        }
        return grandTotal;
    }

    @Override
    public synchronized void setTotalCPUTime(long time) {
        super.setTotalCPUTime(time);
    }

    public synchronized void addCpuTime(long delta) {
        super.addTotalCPUTime(delta);
    }

    @Override
    public synchronized void setRowCount(long count) {
        super.addRowCount(count);
    }

    @Override
    public synchronized long getRowCount() {
        return super.getRowCount();
    }

    @Override
    public synchronized void resetProfilingInfo(IRequestEnvironment reqEnv) {
        if (!QueryEngineLoggingUtils.isProfilingEnabled(reqEnv)) {
            return;
        }
        super.setTotalElapsedTime(0L);
        super.setTotalCPUTime(0L);
        super.setRowCount(0L);
        this.mElapsedTimeSeries.clear();
        this.mCpuTimeSeries.clear();
        super.resetProfilingInfo(reqEnv);
    }

    protected void commitToSeries() {
        int count = this.getQueryStrategy().getQueryStrategyCount();
        if (count > 0) {
            this.mElapsedTimeSeries.add(super.getTotalElapsedTime() / (long)count);
            this.mCpuTimeSeries.add(super.getTotalCPUTime() / (long)count);
            super.setTotalElapsedTime(0L);
            super.setTotalCPUTime(0L);
        }
    }

    protected abstract XQueryStrategy getQueryStrategy();

    public static enum ProfileMode {
        SERIAL,
        NESTED;

    }
}

