/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPPrePlan;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.virtual.VirtualMember;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.IDMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIQueryResult;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIRowCallback;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SingleHierarchySimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.AdaptiveCubeletStorageManager;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQueryResult;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.FilterPushdownUtility;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.IPushdownAdapter;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownUtility;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.TopBottomCountPushdownUtility;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanUtilities;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DMRPushdownAdapter
implements IPushdownAdapter {
    private static final String DMR = "DMR";
    private static final String UTF8 = "UTF-8";
    private static final String ALL_ROWS = "allRows";

    @Override
    public boolean isMultipleDataQueriesSupported(PushdownManager pushdownManager) {
        return false;
    }

    @Override
    public boolean isParentChildHierarchiesSupported(PushdownManager pushdownManager) {
        return false;
    }

    @Override
    public boolean isCubeEnabledForPushdown(String cubeName) {
        return true;
    }

    @Override
    public void logCancelExplanation(String explanation) {
    }

    @Override
    public boolean executeImpl(QueryStrategy queryStrategy, Object setToFetch, IMember[] measuresMembers, IResultSet resultSet, Object blockStorage) throws InterpreterException {
        DMRCube cube = (DMRCube)measuresMembers[0].getDimension().getCube();
        if (!this.isSetValidForPushdown(queryStrategy.getPushdownManager(), (IMember[][])setToFetch, measuresMembers)) {
            return false;
        }
        return ((DMRQueryStrategy)queryStrategy).executePushdown(cube, (IMember[][])setToFetch, (AbstractResultSet)resultSet, (AdaptiveCubeletStorageManager)blockStorage);
    }

    private boolean isSetValidForPushdown(PushdownManager pushdownManager, IMember[][] setToFetch, IMember[] measuresMembers) {
        StringBuilder reason = new StringBuilder();
        if (setToFetch.length < 0) {
            reason.append("set size (");
            reason.append(setToFetch.length);
            reason.append(") is smaller than the threshold (");
            reason.append(PushdownUtility.getPushDownSizeThreshold());
            reason.append(").");
        } else if (measuresMembers.length != 1) {
            reason.append("only one measure may appear in the set. Measure count was ");
            reason.append(measuresMembers.length);
            reason.append(".");
        } else if (measuresMembers[0].getAggregateRules().length != 0) {
            reason.append("measures with aggregate rules are unsupported for pushdown.");
        }
        int minSize = 0;
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities(DMR);
        if (pushdownManager.isBottomCount() || pushdownManager.isTopCount()) {
            minSize = providerCapabilities.getIntegerValue("topBottomCountPushdownMinimumSetSize");
        } else if (pushdownManager.isFilter()) {
            minSize = providerCapabilities.getIntegerValue("FilterPushdownMinimumSetSize");
        }
        int size = 1;
        for (int i = 0; i < setToFetch.length; ++i) {
            IMember[] selection = setToFetch[i];
            size *= selection.length;
        }
        if (size < minSize) {
            reason.append("Set size is below configuration threshold.");
        }
        if (reason.length() > 0) {
            this.logCancelExplanation(reason.toString());
            pushdownManager.resetQsPushdownManager();
        }
        return reason.length() == 0;
    }

    @Override
    public void generatePushdownV5Expression(List<IMember> measureSelections, PlanningEnvironment planEnv, IXQEQueryNode query, IXQEQueryNode selection, IXQEQueryNode groupBody, PushdownManager pushdownManager) {
        XQENodeFactory nodeFactory = planEnv.getNodeFactory();
        String functionName = pushdownManager.getTopPushdownFunctionName();
        V5Query v5Query = (V5Query)query;
        if (pushdownManager.isTopCount()) {
            TopBottomCountPushdownUtility.generateRankExpression(DMR, v5Query, (V5GroupBody)groupBody, nodeFactory, true, pushdownManager, functionName);
            this.generateInExpression(pushdownManager, functionName, v5Query, planEnv);
        } else if (pushdownManager.isBottomCount()) {
            TopBottomCountPushdownUtility.generateRankExpression(DMR, v5Query, (V5GroupBody)groupBody, nodeFactory, false, pushdownManager, functionName);
        } else {
            if (pushdownManager.isHead() || pushdownManager.isTail()) {
                return;
            }
            FilterPushdownUtility.generateFilterExpression(DMR, (V5Query)query, nodeFactory, (String)pushdownManager.getParameter(functionName, "dataItemName"), (List)pushdownManager.getParameter(functionName, "comparisonExpression"), (Integer)pushdownManager.getParameter(functionName, "booleanOperator"));
            this.generateInExpression(pushdownManager, functionName, v5Query, planEnv);
        }
    }

    private void generateInExpression(PushdownManager pushdownManager, String functionName, V5Query query, PlanningEnvironment planEnv) {
        ISet contexts = (ISet)pushdownManager.getParameter(functionName, "contexts");
        if (contexts == null || contexts.size() <= 0L) {
            return;
        }
        for (int k = 0; k < contexts.getDimensions().length; ++k) {
            IDimension dim = contexts.getDimensions()[k];
            IMember[] members = contexts.getMembers(dim);
            HashSet<IMember> memberSet = new HashSet<IMember>();
            for (IMember member : members) {
                memberSet.add(member);
            }
            AbstractV5BooleanExpression expression = DMRUtilities.createINExpressionForMembers(planEnv, memberSet);
            this.generateFilters((IXQEQueryNode)query, planEnv.getNodeFactory(), expression);
        }
    }

    protected void generateFilters(IXQEQueryNode query, XQENodeFactory nodeFactory, AbstractV5BooleanExpression filterExpression) {
        V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
        detailFilter.setPostAutoAggregation(false);
        query.addChild(detailFilter);
        detailFilter.addChild(filterExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block executeImpl(String queryString, String contextInfo, List<Level> levelList, InterpreterContext interpreterContext, PushdownManager pushdownManager, boolean customValuePushdown) throws Exception {
        DMRCube cube = (DMRCube)interpreterContext.getCube();
        boolean cacheMeasureValue = true;
        TreeSet<Cell> retCells = new TreeSet<Cell>();
        Block retBlock = new Block(interpreterContext, retCells);
        List<Tuple> contextTuples = null;
        V5ProviderQueryResult v5Result = null;
        HashMap<String, Integer> columnMap = null;
        HashSet<IHierarchy> contextIndependentHierarchies = null;
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        MultiRequestContext originalMultiReqCtx = execEnv.getMultiRequestContext();
        RequestEnvironment newReqEnv = ((RequestEnvironment)execEnv.getRequestEnvironment()).duplicate();
        PlanningEnvironment newPlanningEnv = QueryPlanner.setupEnvironment(newReqEnv);
        if (newPlanningEnv.getMetadataConnection() == null) {
            if (customValuePushdown) {
                newPlanningEnv.setMetdataConnection(cube.getMeasureDimension().getConnection());
            } else {
                newPlanningEnv.setMetdataConnection(levelList.get(0).getDimension().getConnection());
            }
        }
        ExecutionEnvironment newExecEnv = (ExecutionEnvironment)newReqEnv.getExecutionEnvironment();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(newExecEnv);
        V5QuerySet v5QuerySet = null;
        try {
            originalMultiReqCtx.incrementRefCount();
            try {
                PlannedV5QuerySet plannedQuerySet;
                block31: {
                    newReqEnv.initializeRequestPAC(newExecEnv.getConnectionElement());
                    plannedQuerySet = null;
                    try {
                        IXQEQueryNode[] detailFilters;
                        v5QuerySet = this.buildV5QuerySet(newPlanningEnv, cube, queryString, pushdownManager, customValuePushdown);
                        String strLC = (String)v5QuerySet.getPropertyValue("expressionLocale");
                        if (strLC != null && !strLC.isEmpty()) {
                            ((RequestEnvironment)newPlanningEnv.getRequestEnvironment()).setExpressionLocale(LocaleConverter.strToLocale(strLC));
                        }
                        if (customValuePushdown) {
                            v5QuerySet.setPropertyValue("customValuePushDown", true);
                        }
                        for (IXQEQueryNode detailFilter : detailFilters = v5QuerySet.getDescendantsOfType(101008, false)) {
                            cacheMeasureValue = cacheMeasureValue && ((V5DetailFilter)detailFilter).getPostAutoAggregation();
                        }
                        contextIndependentHierarchies = this.getContextIndependentHierarchies(contextInfo, cube);
                        contextTuples = this.injectContext(interpreterContext, newPlanningEnv, v5QuerySet, contextIndependentHierarchies);
                        if (!interpreterContext.isDeferCustomSetExecution()) break block31;
                        VirtualMember vm = new VirtualMember(levelList.get(0).getV5UniqueName() + ".CustomSetQuery", levelList.get(0), v5QuerySet);
                        Set cs = new Set(SingleHierarchySimpleTupleList.construct(new IMember[]{vm}));
                        CrossJoinedSet contextSet = interpreterContext.getContextSet();
                        for (long ordinal = 0L; ordinal < ((Set)contextSet).size(); ++ordinal) {
                            retCells.add(new Cell(cs, ordinal, false));
                        }
                        Block block = retBlock;
                        return block;
                    }
                    catch (Exception e) {
                        throw XQERuntimeException.wrap(XQEMessageKeys.PLN_UnsupportedDMRSubQuery, e);
                    }
                }
                columnMap = !customValuePushdown ? this.buildColumnMap(v5QuerySet) : this.buildColumnMap4CustomValue(v5QuerySet);
                plannedQuerySet = QueryPlanner.getInstance().planQuery(v5QuerySet, newPlanningEnv);
                if (newReqEnv.getRequestParameters().hasUnresolvedQueryParameters() || newReqEnv.getRequestParameters().hasUnresolvedParameters()) {
                    throw new UnresolvedParameterException(newReqEnv, null, newReqEnv.getRequestParameters().getUnresolvedParameters());
                }
                IXQEQueryNode[] datasets = plannedQuerySet.getChildrenOfType(401005);
                v5Result = new V5ProviderQueryResult(new RSAPIQueryResult((RSAPIDataset)datasets[0], newExecEnv));
            }
            finally {
                originalMultiReqCtx.decrementRefCount();
            }
        }
        finally {
            executionEnvironmentContext.exit();
        }
        RSAPIQueryResult queryResult = v5Result.getRSAPIQueryResult();
        if (queryResult != null) {
            try {
                RowHandler rowHandler = null;
                ArrayList<Level> contextLevelList = null;
                if (customValuePushdown) {
                    HashMap<Tuple, Integer> contextTuplesMap = null;
                    HashMap<DMRLevel, Integer> levelToCol = null;
                    if (contextTuples != null && !contextTuples.isEmpty()) {
                        contextTuplesMap = new HashMap<Tuple, Integer>();
                        levelToCol = new HashMap<DMRLevel, Integer>();
                        contextLevelList = new ArrayList();
                        this.buildContextTupleMap4CustomValue(contextTuples, columnMap, contextTuplesMap, levelToCol, contextLevelList);
                    }
                    rowHandler = new RowHandler(contextTuplesMap, levelToCol, contextLevelList);
                } else {
                    if (contextTuples != null && !contextTuples.isEmpty()) {
                        IMember[] members;
                        contextLevelList = new ArrayList<Level>();
                        for (IMember member : members = contextTuples.get(0).getMembers()) {
                            contextLevelList.add((Level)member.getLevel());
                        }
                    }
                    rowHandler = new RowHandler(levelList, contextLevelList, columnMap, cacheMeasureValue);
                }
                queryResult.iterateResult(rowHandler);
                if (customValuePushdown) {
                    TreeMap<Integer, IValue> customValuesMap = rowHandler.getCustomValues();
                    for (Integer ordinal : customValuesMap.keySet()) {
                        retCells.add(new Cell(customValuesMap.get(ordinal), ordinal.intValue(), false));
                    }
                }
                this.iterateCustomSetResult(interpreterContext, retCells, contextIndependentHierarchies, rowHandler, contextLevelList);
            }
            finally {
                queryResult.release();
                v5Result = null;
            }
        } else {
            XQEDebugLog.out.println("No result for the query query.getName()");
        }
        return retBlock;
    }

    private void buildContextTupleMap4CustomValue(List<Tuple> contextTuples, Map<String, Integer> columnMap, Map<Tuple, Integer> contextTuplesMap, Map<DMRLevel, Integer> levelToCol, List<Level> contextLevelList) {
        for (int i = 0; i < contextTuples.size(); ++i) {
            Tuple tp = contextTuples.get(i);
            contextTuplesMap.put(tp, i);
            if (i != 0) continue;
            IMember[] members = tp.getMembers();
            for (IMember member : members) {
                contextLevelList.add((Level)member.getLevel());
            }
            for (Level l : contextLevelList) {
                DMRLevel lvl = (DMRLevel)l;
                List<DMRLevel> levels = lvl.getParentLevelToQueryWith();
                for (DMRLevel aDMRL : levels) {
                    String levelName = aDMRL.getUniqueName();
                    Integer pos = columnMap.get(levelName);
                    if (pos == null) {
                        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "V5Query for CustomValue does not have projected column for " + levelName);
                    }
                    levelToCol.put(aDMRL, pos);
                }
            }
        }
    }

    private void iterateCustomSetResult(InterpreterContext interpreterContext, TreeSet<Cell> retCells, HashSet<IHierarchy> contextIndependentHierarchies, RowHandler rowHandler, List<Level> contextLevelList) throws InterpreterException {
        List<ITuple> tupleList = rowHandler.getTupleList();
        List<ITuple> contextTupleList = rowHandler.getContextTupleList();
        Set returnSet = null;
        CrossJoinedSet contextSet = interpreterContext.getContextSet();
        if (contextTupleList.isEmpty()) {
            if (((Set)contextSet).isEmpty()) {
                returnSet = new Set(SimpleTupleList.construct(tupleList.toArray(new ITuple[0])));
                retCells.add(new Cell(returnSet, 0L, false));
            } else {
                for (long ordinal = 0L; ordinal < ((Set)contextSet).size(); ++ordinal) {
                    returnSet = new Set(SimpleTupleList.construct(tupleList.toArray(new ITuple[0])));
                    retCells.add(new Cell(returnSet, ordinal, false));
                }
            }
        } else {
            HashMap<Object, ArrayList<ITuple>> setByContext = new HashMap<Object, ArrayList<ITuple>>();
            for (int i = 0; i < contextTupleList.size(); ++i) {
                ITuple contextTuple = contextTupleList.get(i);
                ArrayList<ITuple> aTupleList = (ArrayList<ITuple>)setByContext.get(contextTuple);
                if (aTupleList == null) {
                    aTupleList = new ArrayList<ITuple>();
                    setByContext.put(contextTuple, aTupleList);
                }
                aTupleList.add(tupleList.get(i));
            }
            HashSet<IHierarchy> contextHierarchies = new HashSet<IHierarchy>();
            for (Level level : contextLevelList) {
                contextHierarchies.add(level.getHierarchy());
            }
            for (long ordinal = 0L; ordinal < ((Set)contextSet).size(); ++ordinal) {
                Tuple contextTuple = (Tuple)((Set)contextSet).getTuple(ordinal);
                List tupleListByContext = (List)setByContext.get(contextTuple = this.skipContextIndependentHierarchies(contextTuple, contextHierarchies, contextIndependentHierarchies));
                returnSet = tupleListByContext != null ? new Set(SimpleTupleList.construct(tupleListByContext.toArray(new ITuple[0]))) : new Set(new Tuple[0]);
                retCells.add(new Cell(returnSet, ordinal, false));
            }
        }
        rowHandler.saveTupleValueToStorage();
    }

    private Tuple skipContextIndependentHierarchies(Tuple contextTuple, HashSet<IHierarchy> contextHierarchies, HashSet<IHierarchy> contextIndependentHierarchies) throws InterpreterException {
        IMember[] allMems;
        ArrayList<IMember> mems = new ArrayList<IMember>();
        boolean bNeedSkip = false;
        for (IMember aM : allMems = contextTuple.getMembers()) {
            if (aM.isMeasure()) {
                bNeedSkip = true;
                continue;
            }
            ILevel lvl = aM.getLevel();
            if (lvl.getIndex() == 0) {
                bNeedSkip = true;
                continue;
            }
            IDimension d = lvl.getDimension();
            String dimName = d.getName();
            if (dimName.equals("dummy") || dimName.equals("secondDummy") || dimName.equals("tagDimension")) {
                bNeedSkip = true;
                continue;
            }
            if (contextIndependentHierarchies != null && contextIndependentHierarchies.contains(lvl.getHierarchy())) {
                bNeedSkip = true;
                continue;
            }
            if (!contextHierarchies.contains(lvl.getHierarchy())) {
                bNeedSkip = true;
                continue;
            }
            mems.add(aM);
        }
        if (!bNeedSkip) {
            return contextTuple;
        }
        return new Tuple(mems.toArray(new IMember[mems.size()]), false, contextTuple.getCube());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V5QuerySet buildV5QuerySet(PlanningEnvironment planningEnv, DMRCube cube, String queryString, PushdownManager pushdownManager, boolean customValuePushdown) throws Exception {
        IXQEQueryNode[] queries;
        Document customSetQueryDocument = null;
        SAXReader xmlReader = XQESAXReaderPool.getInstance().borrowReader();
        try {
            customSetQueryDocument = xmlReader.read((InputStream)new ByteArrayInputStream(queryString.getBytes(UTF8)));
        }
        finally {
            if (xmlReader != null) {
                if (customSetQueryDocument == null) {
                    XQESAXReaderPool.getInstance().invalidateReader(xmlReader);
                } else {
                    XQESAXReaderPool.getInstance().returnReader(xmlReader);
                }
            }
        }
        Element rootElement = customSetQueryDocument.getRootElement();
        Element querySetElement = rootElement.element("querySet");
        XQENodeFactory nodeFactory = planningEnv.getNodeFactory();
        V5QuerySet v5QuerySet = (V5QuerySet)nodeFactory.createNode(101002);
        v5QuerySet.capture(planningEnv, querySetElement);
        v5QuerySet.addToIndex();
        for (IXQEQueryNode query : this.getInnerMostQueries(v5QuerySet)) {
            V5Query innerQuery = (V5Query)query;
            this.addCubeDetailFilters(v5QuerySet, innerQuery, cube, nodeFactory, customValuePushdown);
        }
        planningEnv.setRoot(v5QuerySet);
        v5QuerySet.setUnreferencedQueriesRemoved();
        Governors governors = null;
        List<IMetadata> allJoins = null;
        CubeWrapper modelCube = cube.getModelCube();
        if (modelCube instanceof CubeWrapper) {
            CubeWrapper cubeWrapper = modelCube;
            RQPPrePlan prePlan = cubeWrapper.getRQPPrePlanQuery();
            if (prePlan != null) {
                allJoins = PrePlanUtilities.getAllJoins(prePlan);
            }
            governors = cubeWrapper.getGovernors();
        }
        if (governors != null) {
            governors.setExecutionOptimization(ALL_ROWS);
            DMRUtilities.SubqueryType type = DMRUtilities.SubqueryType.getPushdownSubqueryType(pushdownManager);
            DMRUtilities.useRelationalCache(cube, planningEnv, governors, type);
        }
        for (IXQEQueryNode query : queries = v5QuerySet.getDescendantsOfType(101006, false)) {
            query.setPropertyValue("relationalSubquery", true);
            query.setPropertyValue("relationalSubquerySource", V5Query.RelationalSubquerySource.DMR.getName());
            if (allJoins != null) {
                query.setPropertyValue("allJoins", allJoins);
            }
            if (((V5Query)query).containsQueryHints()) {
                String crossProductAllowed = (String)query.getPropertyValue(V5Query.QueryHint.CROSS_PRODUCT_ALLOWED.getPropertyName());
                if (crossProductAllowed != null) {
                    Governors governorObj = null;
                    governorObj = governors != null ? governors.copy() : new Governors();
                    governorObj.setCrossProdAllowed(crossProductAllowed);
                    ((V5Query)query).setGovernors(governorObj);
                }
            } else if (governors != null) {
                ((V5Query)query).setGovernors(governors);
            }
            ((V5Query)query).getV5Source().setPropertyValue("relational", true);
        }
        return v5QuerySet;
    }

    private void addCubeDetailFilters(V5QuerySet v5QuerySet, V5Query query, DMRCube cube, XQENodeFactory nodeFactory, boolean customValuePushdown) {
        IXQEQueryNode[] dataItems;
        ArrayList<IMetadata> projectedColumns = new ArrayList<IMetadata>();
        V5Selection selection = query.getV5Selection();
        for (IXQEQueryNode aDataItem : dataItems = selection.getChildrenOfType(101003)) {
            IMetadata projectedMetadata;
            String metadataIdentifier = (String)aDataItem.getPropertyValue("identifier");
            if (metadataIdentifier == null || (projectedMetadata = cube.getWrapper(metadataIdentifier)) == null) continue;
            projectedColumns.add(projectedMetadata);
        }
        boolean[] twoFlags = new boolean[]{false, false};
        if (!customValuePushdown && v5QuerySet.getPropertyValue("v5Version") != null) {
            twoFlags[1] = true;
        }
        V5QueryOverTabularStream.addCubeDetailFiltersToV5Query(v5QuerySet, query, cube, projectedColumns, twoFlags, nodeFactory, null);
    }

    private void addMemberInFilter(IMember member, HashMap<Level, HashSet<IMember>> membersPerLevel) {
        IMember aContextMember = member;
        DMRLevel level = (DMRLevel)aContextMember.getLevel();
        while (!level.isRootLevel()) {
            HashSet<IMember> memberSet = membersPerLevel.get(level);
            if (memberSet == null) {
                memberSet = new HashSet();
                membersPerLevel.put(level, memberSet);
            }
            memberSet.add(aContextMember);
            aContextMember = aContextMember.getParent();
            level = (DMRLevel)aContextMember.getLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<IHierarchy> getContextIndependentHierarchies(String contextInfo, DMRCube cube) throws Exception {
        Document customSetQueryDocument;
        HashSet<IHierarchy> expContextMembers = new HashSet<IHierarchy>();
        SAXReader xmlReader = XQESAXReaderPool.getInstance().borrowReader();
        try {
            customSetQueryDocument = xmlReader.read((InputStream)new ByteArrayInputStream(contextInfo.getBytes(UTF8)));
        }
        finally {
            if (xmlReader != null) {
                XQESAXReaderPool.getInstance().returnReader(xmlReader);
            }
        }
        Element rootElement = customSetQueryDocument.getRootElement();
        Iterator it = rootElement.elementIterator("hierarchy");
        while (it.hasNext()) {
            IHierarchy h;
            Element eMb = (Element)it.next();
            String mun = eMb.attributeValue("name");
            String[] parts = UniqueNameParser.parseNoThrow(mun);
            IDimension d = cube.getDimension(parts[0]);
            if (d == null || (h = d.getHierarchy(parts[1])) == null) continue;
            expContextMembers.add(h);
        }
        return expContextMembers;
    }

    private List<Tuple> injectContext(InterpreterContext interpreterContext, PlanningEnvironment planningEnv, V5QuerySet v5QuerySet, HashSet<IHierarchy> contextIndependentHierarchies) {
        IHierarchy[] hierarchies;
        ArrayList<Tuple> contextTuples = new ArrayList<Tuple>();
        List<IXQEQueryNode> queries = this.getInnerMostQueries(v5QuerySet);
        Set contextSet = interpreterContext.getContextSet();
        if ((contextSet = this.removeAllLevel(contextSet)).isEmpty()) {
            return null;
        }
        for (IHierarchy hierarchy : hierarchies = contextSet.getHierarchies()) {
            IMember[] contextMembers;
            HashMap<Level, HashSet<IMember>> membersPerLevel = new HashMap<Level, HashSet<IMember>>();
            if (contextIndependentHierarchies.contains(hierarchy)) continue;
            for (IMember member : contextMembers = contextSet.getMembers(hierarchy)) {
                this.addMemberInFilter(member, membersPerLevel);
            }
            ArrayList<HashSet<IMember>> memberListPerLevel = new ArrayList<HashSet<IMember>>(membersPerLevel.values());
            for (IXQEQueryNode query : queries) {
                this.generateFilters(query, memberListPerLevel, planningEnv);
            }
        }
        for (IHierarchy hierarchy : hierarchies) {
            if (contextSet.getMembers(hierarchy).length != 1 && !contextIndependentHierarchies.contains(hierarchy)) continue;
            contextSet = (Set)contextSet.removeHierarchy(hierarchy, false);
        }
        if (contextSet.getTupleList() != null) {
            ITupleIterator tupleIterator = contextSet.getTupleList().iterator();
            while (tupleIterator.hasNext()) {
                contextTuples.add((Tuple)tupleIterator.next());
            }
        }
        return contextTuples;
    }

    private List<IXQEQueryNode> getInnerMostQueries(V5QuerySet v5QuerySet) {
        IXQEQueryNode[] queries;
        ArrayList<IXQEQueryNode> queryList = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode aQuery : queries = v5QuerySet.getDescendantsOfType(101006, false)) {
            V5Source source = ((V5Query)aQuery).getV5Source();
            if (source.getReferencedQueries() != null) continue;
            queryList.add(aQuery);
        }
        return queryList;
    }

    private Set removeAllLevel(Set contextSet) {
        IHierarchy[] hierarchies;
        contextSet = (Set)contextSet.copy();
        ITuple firstTuple = contextSet.getTuple(0L);
        for (IHierarchy hierarchy : hierarchies = contextSet.getHierarchies()) {
            IMember member = firstTuple.getMember(hierarchy);
            if (member.isMeasure()) {
                contextSet = (Set)contextSet.removeHierarchy(hierarchy, false);
                continue;
            }
            DMRLevel level = (DMRLevel)member.getLevel();
            if (level.isMappedToRelationalColumn() && !level.isAllLevel()) continue;
            contextSet = (Set)contextSet.removeHierarchy(hierarchy, false);
        }
        return contextSet;
    }

    private void generateFilters(IXQEQueryNode query, List<HashSet<IMember>> filteringMembers, PlanningEnvironment planningEnv) {
        XQENodeFactory nodeFactory = planningEnv.getNodeFactory();
        for (int i = 0; i < filteringMembers.size(); ++i) {
            V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
            detailFilter.setPostAutoAggregation(false);
            query.addChild(detailFilter);
            detailFilter.addChild(DMRUtilities.createINExpressionForMembers(planningEnv, (Collection<IMember>)filteringMembers.get(i)));
        }
    }

    private HashMap<String, Integer> buildColumnMap(V5QuerySet v5QuerySet) {
        HashMap<String, Integer> levelToColumnMap = new HashMap<String, Integer>();
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)v5QuerySet.getFirstDescendantOfTypeOrdered(101055, false);
        V5Query v5Query = qrd.getV5Query();
        V5Selection v5Selection = v5Query.getV5Selection();
        List<String> columnList = this.getProjectedDataItemNames(qrd);
        for (int i = 0; i < columnList.size(); ++i) {
            String metadataIdentifier;
            V5DataItem dataItem = v5Selection.getDataItemByRefName(columnList.get(i));
            V5Expression expression = (V5Expression)dataItem.getFirstChildByType(101004);
            String strExpr = (String)expression.getPropertyValue("expression");
            try {
                while (strExpr.startsWith("[PushdownQuery")) {
                    String[] parts = UniqueNameParser.parse(strExpr);
                    dataItem = DMRPushdownAdapter.getDataItemReference(v5QuerySet, parts);
                    expression = (V5Expression)dataItem.getFirstChildByType(101004);
                    strExpr = (String)expression.getPropertyValue("expression");
                }
            }
            catch (Exception e) {
                throw new MDXEngineException("X01433", strExpr + " is an invalid data item reference.");
            }
            if (!levelToColumnMap.containsKey(strExpr)) {
                levelToColumnMap.put(strExpr, i);
            }
            if ((metadataIdentifier = (String)dataItem.getPropertyValue("identifier")) == null || !metadataIdentifier.startsWith("[Measures].[Measures]")) continue;
            levelToColumnMap.put(metadataIdentifier, i);
        }
        return levelToColumnMap;
    }

    private List<String> getProjectedDataItemNames(V5QueryResultDefinition qrd) {
        List<IXQEQueryNode> valueSetList = qrd.getDescendantsOfTypeOrdered(101057, false);
        ArrayList<String> columnList = new ArrayList<String>();
        for (int i = 0; i < valueSetList.size(); ++i) {
            V5ValueSet aValueSet = (V5ValueSet)valueSetList.get(i);
            String refProperty = aValueSet.getRefDataItemProperty();
            if (refProperty != null) {
                columnList.add(refProperty);
                continue;
            }
            IXQEQueryNode groupBody = aValueSet.getFirstChildByType(101051);
            if (groupBody == null) continue;
            List<IXQEQueryNode> dataItemRefs = groupBody.getDescendantsOfTypeOrdered(101015, false);
            for (int j = 0; j < dataItemRefs.size(); ++j) {
                V5DataItemRef ref = (V5DataItemRef)dataItemRefs.get(j);
                columnList.add(ref.getDataItemRefProperty());
            }
        }
        return columnList;
    }

    private HashMap<String, Integer> buildColumnMap4CustomValue(V5QuerySet v5QuerySet) {
        HashMap<String, Integer> levelToColumnMap = new HashMap<String, Integer>();
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)v5QuerySet.getFirstDescendantOfTypeOrdered(101055, false);
        V5Query v5Query = qrd.getV5Query();
        V5Selection v5Selection = v5Query.getV5Selection();
        List<String> columnList = this.getProjectedDataItemNames(qrd);
        for (int i = 0; i < columnList.size(); ++i) {
            V5DataItem dataItem = v5Selection.getDataItemByRefName(columnList.get(i));
            String metadataIdentifier = (String)dataItem.getPropertyValue("identifier");
            if (metadataIdentifier == null) continue;
            levelToColumnMap.put(metadataIdentifier, i);
        }
        return levelToColumnMap;
    }

    public static V5DataItem getDataItemReference(V5QuerySet v5QuerySet, String[] nameParts) {
        if (nameParts.length != 2) {
            return null;
        }
        V5DataItem dataItem = null;
        V5Query queryRef = v5QuerySet.getV5Query(nameParts[0]);
        if (queryRef != null) {
            V5Selection selection = queryRef.getV5Selection();
            dataItem = selection.getDataItemByRefName(nameParts[1]);
        }
        return dataItem;
    }

    private final class LevelInfoForHandler {
        protected DMRLevel level = null;
        protected Boolean needCaption = null;
        protected List<FormatId> formatId = null;

        private LevelInfoForHandler() {
        }
    }

    private final class RowHandler
    implements RSAPIRowCallback {
        private HashMap<String, Integer> queryColumnMap;
        private List<Level> outputMemberLevels = null;
        private List<Level> contextMemberLevels = null;
        private List<ITuple> tupleList = new ArrayList<ITuple>();
        private List<ITuple> contextTupleList = new ArrayList<ITuple>();
        private HashMap<DMRMeasure, Integer> projectedMeasures = new HashMap();
        private TreeMap<Integer, IValue> customValues = null;
        private Map<Tuple, Integer> tupleToOrdinalMap = null;
        private Map<DMRLevel, Integer> levelToColPosMap = null;
        protected IMember[] currentMembers;
        private Map<IDimension, Integer> dimToIndex = null;
        private AdaptiveCubeletStorageManager storageManager = null;
        private AdaptiveCubeletStorageManager.ParamDefinition cubeletParam = null;
        IMember[] defaultDataTuple = null;

        public List<ITuple> getContextTupleList() {
            return this.contextTupleList;
        }

        public List<ITuple> getTupleList() {
            return this.tupleList;
        }

        public TreeMap<Integer, IValue> getCustomValues() {
            return this.customValues;
        }

        RowHandler(Map<Tuple, Integer> contextTuplesMap, Map<DMRLevel, Integer> levelToCol, List<Level> contextLevels) {
            this.customValues = new TreeMap();
            if (contextLevels != null && !contextLevels.isEmpty()) {
                this.contextMemberLevels = contextLevels;
                this.tupleToOrdinalMap = contextTuplesMap;
                this.levelToColPosMap = levelToCol;
                this.currentMembers = new IMember[contextLevels.size()];
            }
        }

        RowHandler(List<Level> outputLevels, List<Level> contextLevels, HashMap<String, Integer> columnMap, boolean cacheMeasureValue) {
            this.outputMemberLevels = outputLevels;
            this.contextMemberLevels = contextLevels;
            this.queryColumnMap = columnMap;
            DMRCube cube = (DMRCube)this.outputMemberLevels.get(0).getDimension().getCube();
            if (cacheMeasureValue) {
                for (String string : this.queryColumnMap.keySet()) {
                    DMRMeasure dmrMeasure = (DMRMeasure)cube.getMeasuresHierarchy().getMember(string);
                    if (dmrMeasure == null) continue;
                    this.projectedMeasures.put(dmrMeasure, this.queryColumnMap.get(string));
                }
            }
            AdaptiveCubeletStorageManager adaptiveCubeletStorageManager = this.storageManager = cube.getCubeletStorage();
            adaptiveCubeletStorageManager.getClass();
            this.cubeletParam = adaptiveCubeletStorageManager.new AdaptiveCubeletStorageManager.ParamDefinition(this.storageManager);
            List<IHierarchy> cubeHiers = cube.getHierarchies(false);
            for (IHierarchy hier : cubeHiers) {
                if (hier.getDimension().isMeasuresDimension()) continue;
                this.cubeletParam.addNonMeasureHierarchy(hier);
            }
            this.cubeletParam.initialLevelIndex();
            List<IDimension> list = cube.getDimensions();
            this.dimToIndex = new HashMap<IDimension, Integer>();
            int idx = 0;
            for (IDimension dimension : list) {
                this.dimToIndex.put(dimension, idx++);
            }
            this.defaultDataTuple = new IMember[list.size()];
            for (IDimension dim : list) {
                this.defaultDataTuple[this.dimToIndex.get((Object)dim).intValue()] = dim.getDefaultHierarchy().getDefaultMember();
            }
        }

        private DMRMember getExistingMember(Value key, FormatId keyFormat, IMember parentMember) {
            Value keyValueCopy = (Value)key.copy();
            if (keyValueCopy.getFormatId() == FormatId.INVALID_FORMAT_FID) {
                keyValueCopy.setFormatId(keyFormat);
            }
            String businessKeyText = keyValueCopy.getV5formattedString();
            if (keyValueCopy.isNull()) {
                businessKeyText = "";
            }
            return (DMRMember)parentMember.getChildMember(businessKeyText);
        }

        private Integer getTupleOrdinal(RSAPIRow row, RSAPIColumn[] columns, FormatId[] formatIDs) {
            if (this.contextMemberLevels != null && !this.contextMemberLevels.isEmpty()) {
                for (int i = 0; i < this.contextMemberLevels.size(); ++i) {
                    DMRLevel aLevel = (DMRLevel)this.contextMemberLevels.get(i);
                    List<DMRLevel> levels = aLevel.getParentLevelToQueryWith();
                    Collections.reverse(levels);
                    IMember parentMember = ((DMRLevel)aLevel.getHierarchy().getLevel(0)).getMember(0);
                    if (parentMember == null) {
                        return null;
                    }
                    int sz = levels.size();
                    for (int lvlPos = 0; lvlPos < sz; ++lvlPos) {
                        DMRLevel level = levels.get(lvlPos);
                        Integer keyPos = this.levelToColPosMap.get(level);
                        Value key = (Value)row.getColumn(keyPos);
                        parentMember = this.getExistingMember(key, formatIDs[keyPos], parentMember);
                        if (parentMember != null) continue;
                        return null;
                    }
                    this.currentMembers[i] = parentMember;
                }
                Tuple tuple = new Tuple(this.currentMembers);
                return this.tupleToOrdinalMap.get(tuple);
            }
            return 0;
        }

        @Override
        public void consumeRow(RSAPIRow row, RSAPIColumn[] columns, FormatId[] formatIDs) {
            if (this.customValues != null) {
                Value measureValue = (Value)row.getColumn(columns.length - 1);
                if (measureValue == null || measureValue.isNull()) {
                    return;
                }
                measureValue = (Value)measureValue.copy();
                Integer ordinal = this.getTupleOrdinal(row, columns, formatIDs);
                if (ordinal != null) {
                    this.customValues.put(ordinal, measureValue);
                }
                return;
            }
            IMember[] outputTuple = new IMember[this.outputMemberLevels.size()];
            for (int tupleMemberIndex = 0; tupleMemberIndex < this.outputMemberLevels.size(); ++tupleMemberIndex) {
                Level aLevel = this.outputMemberLevels.get(tupleMemberIndex);
                String levelKeyString = ((DMRLevel)aLevel).getQueryItemExpressionForKey();
                int levelColumnIndex = this.queryColumnMap.get(levelKeyString);
                outputTuple[tupleMemberIndex] = this.getTupleMember(row, formatIDs, (DMRLevel)aLevel, levelColumnIndex);
            }
            Tuple tuple = new Tuple(outputTuple);
            this.tupleList.add(tuple);
            IMember[] contextTuple = null;
            if (this.contextMemberLevels != null && !this.contextMemberLevels.isEmpty()) {
                contextTuple = new IMember[this.contextMemberLevels.size()];
                for (int tupleMemberIndex = 0; tupleMemberIndex < this.contextMemberLevels.size(); ++tupleMemberIndex) {
                    Level aLevel = this.contextMemberLevels.get(tupleMemberIndex);
                    String levelKeyString = ((DMRLevel)aLevel).getQueryItemExpressionForKey();
                    int levelColumnIndex = this.queryColumnMap.get(levelKeyString);
                    contextTuple[tupleMemberIndex] = this.getContextTupleMember(row, formatIDs, (DMRLevel)aLevel, levelColumnIndex);
                }
                this.contextTupleList.add(new Tuple(contextTuple));
            }
            for (DMRMeasure measure : this.projectedMeasures.keySet()) {
                Value measureValue = (Value)row.getColumn(this.projectedMeasures.get(measure));
                if (measureValue == null || measureValue.isNull()) continue;
                measureValue = (Value)measureValue.copy();
                FormatId formatId = DMRUtilities.resolveFormatIdForMeasure(measure, measureValue);
                measureValue.setFormatId(formatId);
                ArrayList<IMember> tupleMembers = new ArrayList<IMember>();
                tupleMembers.addAll(Arrays.asList(outputTuple));
                if (contextTuple != null) {
                    tupleMembers.addAll(Arrays.asList(contextTuple));
                }
                Tuple dataTuple = new Tuple(this.defaultDataTuple);
                dataTuple.addMember(measure);
                for (IMember m : outputTuple) {
                    dataTuple.addMember(m);
                }
                if (contextTuple != null) {
                    for (IMember m : contextTuple) {
                        dataTuple.addMember(m);
                    }
                }
                TupleValue tupleValue = new TupleValue(dataTuple, new Cell(measureValue));
                this.cubeletParam.updateValueMap(tupleValue, Boolean.FALSE);
            }
        }

        private IMember getContextTupleMember(RSAPIRow row, FormatId[] formatIds, DMRLevel aLevel, int columnOffset) {
            DMRCube currentCube = (DMRCube)aLevel.getDimension().getCube();
            boolean membersCachedInMemberStorage = currentCube.memberStorageEnabled();
            if (membersCachedInMemberStorage && aLevel.isV5LevelWrapper()) {
                membersCachedInMemberStorage = false;
            }
            IMemberCubics currentParent = (IMemberCubics)((DMRLevel)aLevel.getHierarchy().getLevel(0)).getMember(0);
            LevelInfoForHandler[] levels = new LevelInfoForHandler[aLevel.getIndex()];
            DMRLevel currentLevel = aLevel;
            while (true) {
                String levelCaptionString;
                String levelKeyString;
                int i = currentLevel.getIndex() - 1;
                levels[i] = new LevelInfoForHandler();
                levels[i].level = currentLevel;
                FormatId businessKeyId = currentLevel.getBusinessKeyFormatId();
                FormatId captionId = currentLevel.getCaptionFormatId();
                boolean bHasFormat = businessKeyId != null || captionId != null;
                ArrayList<FormatId> formats = new ArrayList<FormatId>();
                formats.add(businessKeyId);
                formats.add(captionId);
                if (bHasFormat) {
                    levels[i].formatId = formats;
                }
                levels[i].needCaption = (levelKeyString = currentLevel.getQueryItemExpressionForKey()).equals(levelCaptionString = currentLevel.getQueryItemExpressionForCaption()) ? Boolean.FALSE : Boolean.TRUE;
                if (levels[i].needCaption.booleanValue() && i < aLevel.getIndex() - 1) {
                    --columnOffset;
                }
                if ((currentLevel = (DMRLevel)currentLevel.getPreviousLevel()).isRootLevel()) break;
                --columnOffset;
            }
            IDMRMember currentMember = null;
            for (LevelInfoForHandler currentLevelInfo : levels) {
                Value businessKey = (Value)row.getColumn(columnOffset);
                if (businessKey == null) {
                    businessKey = DMRMember.DEFAULT_BUSINESSKEY;
                }
                if (currentLevelInfo.formatId != null && !currentLevelInfo.formatId.isEmpty() && currentLevelInfo.formatId.get(0) != null) {
                    businessKey.setFormatId(currentLevelInfo.formatId.get(0));
                }
                if (businessKey.getFormatId() == FormatId.INVALID_FORMAT_FID) {
                    businessKey.setFormatId(formatIds[columnOffset]);
                }
                ++columnOffset;
                if (currentLevelInfo.needCaption == Boolean.TRUE) {
                    ++columnOffset;
                }
                if (currentParent != null) {
                    Value[] rtBusinessKey = new Value[]{null};
                    String memberNameKey = DMRMember.convertBusinessKeyToDMRMemberName(businessKey, rtBusinessKey);
                    if (rtBusinessKey[0] != null) {
                        businessKey = rtBusinessKey[0];
                    }
                    currentMember = (IDMRMember)currentParent.searchChildrenOrderedMap(memberNameKey);
                }
                currentParent = currentMember;
            }
            return currentMember;
        }

        private IDMRMember getTupleMember(RSAPIRow row, FormatId[] formatIDs, DMRLevel aLevel, int columnOffset) {
            DMRCube currentCube = (DMRCube)aLevel.getDimension().getCube();
            boolean membersCachedInMemberStorage = currentCube.memberStorageEnabled();
            if (membersCachedInMemberStorage && aLevel.isV5LevelWrapper()) {
                membersCachedInMemberStorage = false;
            }
            IMemberCubics currentParent = (IMemberCubics)((DMRLevel)aLevel.getHierarchy().getLevel(0)).getMember(0);
            LevelInfoForHandler[] levels = new LevelInfoForHandler[aLevel.getIndex()];
            DMRLevel currentLevel = aLevel;
            while (true) {
                String levelCaptionString;
                String levelKeyString;
                int i = currentLevel.getIndex() - 1;
                levels[i] = new LevelInfoForHandler();
                levels[i].level = currentLevel;
                FormatId businessKeyId = currentLevel.getBusinessKeyFormatId();
                FormatId captionId = currentLevel.getCaptionFormatId();
                boolean bHasFormat = businessKeyId != null || captionId != null;
                ArrayList<FormatId> formats = new ArrayList<FormatId>();
                formats.add(businessKeyId);
                formats.add(captionId);
                if (bHasFormat) {
                    levels[i].formatId = formats;
                }
                levels[i].needCaption = (levelKeyString = currentLevel.getQueryItemExpressionForKey()).equals(levelCaptionString = currentLevel.getQueryItemExpressionForCaption()) ? Boolean.FALSE : Boolean.TRUE;
                if (levels[i].needCaption.booleanValue() && i < aLevel.getIndex() - 1) {
                    --columnOffset;
                }
                if ((currentLevel = (DMRLevel)currentLevel.getPreviousLevel()).isRootLevel()) break;
                --columnOffset;
            }
            IDMRMember currentMember = null;
            for (LevelInfoForHandler currentLevelInfo : levels) {
                FormatId businessKeyId = null;
                FormatId captionId = null;
                List<FormatId> formats = currentLevelInfo.formatId;
                if (formats != null) {
                    businessKeyId = formats.get(0);
                    captionId = formats.get(1);
                }
                Value businessKey = (Value)row.getColumn(columnOffset);
                Value memberName = null;
                if (businessKey == null) {
                    businessKey = DMRMember.DEFAULT_BUSINESSKEY;
                }
                if (businessKeyId != null) {
                    businessKey.setFormatId(businessKeyId);
                }
                if (businessKey.getFormatId() == FormatId.INVALID_FORMAT_FID) {
                    businessKey.setFormatId(formatIDs[columnOffset]);
                }
                ++columnOffset;
                if (currentLevelInfo.needCaption == Boolean.TRUE) {
                    memberName = (Value)row.getColumn(columnOffset);
                    if (captionId != null) {
                        memberName.setFormatId(captionId);
                    }
                    if (memberName.getFormatId() == FormatId.INVALID_FORMAT_FID) {
                        memberName.setFormatId(formatIDs[columnOffset]);
                    }
                    ++columnOffset;
                } else {
                    memberName = (Value)businessKey.copy();
                    if (captionId != null) {
                        memberName.setFormatId(captionId);
                    }
                    memberName.setFormatId(businessKey.getFormatId());
                }
                if (currentParent != null) {
                    Value[] rtBusinessKey = new Value[]{null};
                    String memberNameKey = DMRMember.convertBusinessKeyToDMRMemberName(businessKey, rtBusinessKey);
                    if (rtBusinessKey[0] != null) {
                        businessKey = rtBusinessKey[0];
                    }
                    currentMember = (IDMRMember)currentParent.searchChildrenOrderedMap(memberNameKey);
                }
                if (currentMember == null) {
                    if (memberName == null || memberName.isNull()) {
                        memberName = DataValueFactory.createStringValue();
                        memberName.set("");
                    } else {
                        memberName = (Value)memberName.copy();
                    }
                    DMRMember dmrMember = new DMRMember(memberName, (Value)businessKey.copy(), currentLevelInfo.level);
                    currentMember = membersCachedInMemberStorage ? DMRMemberProxy.cacheMember(dmrMember, currentParent) : dmrMember;
                    if (currentParent != null) {
                        currentParent.addMemberToChildrenOrderedMap(currentMember);
                        if (currentParent instanceof IDMRMember) {
                            ((IDMRMember)currentParent).addChildToBusinessKeyMap(currentMember);
                        }
                        currentMember.setParentMember(currentParent);
                    }
                    currentLevelInfo.level.addMember(currentMember);
                }
                currentParent = currentMember;
            }
            return currentMember;
        }

        public void saveTupleValueToStorage() throws InterpreterException {
            if (this.projectedMeasures.isEmpty()) {
                return;
            }
            this.storageManager.putTupleValues(this.cubeletParam);
        }

        @Override
        public boolean reRun() {
            return false;
        }

        @Override
        public boolean needReIterateRows() {
            return false;
        }
    }
}

