/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.mdx.XMdxCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.XMdxElement;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRProvider;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterRuntimeException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NamedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ExtractTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPProvider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageUtil;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.HashSet;
import java.util.List;

public class PushdownUtility {
    public static final String CONFIG_ENABLE = "qsPushdownSetFunctionsToRelational";
    public static final String CONFIG_MIN_SET_SIZE = "qsPushdownMinimumSetSize";
    public static final String CONFIG_DISABLED_CUBES = "qsPushdownDisabledCubes";
    private static final String CUBE_LIST_DELIMITER = ";";
    public static final long DEFAULT_PUSHDOWN_SET_SIZE = 10000L;
    public static final boolean DEFAULT_PUSHDOWN_ENABLED = true;
    public static final String DEFAULT_PUSHDOWN_DISABLED_CUBES = "";
    private static final String STR_COALESCE_REF = "coalesced1RefMeasure";
    private static final String STR_COALESCE = "coalesce";
    private static final String CLOSE_PARENTHESIS_STR = ")";
    private static final String OPEN_PARENTHESIS_STR = "(";
    private static XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);

    public static long getPushDownSizeThreshold() {
        return configuration.getLongProperty(CONFIG_MIN_SET_SIZE, 10000L);
    }

    public static void setPushDownSizeThreshold(long minSize) {
        configuration.setProperty(CONFIG_MIN_SET_SIZE, String.valueOf(minSize));
    }

    private static String getPushdownCubes() {
        return configuration.getStringProperty(CONFIG_DISABLED_CUBES, DEFAULT_PUSHDOWN_DISABLED_CUBES);
    }

    public static void setPushdownDisabledCubes(String cubeList) {
        configuration.setProperty(CONFIG_DISABLED_CUBES, cubeList);
    }

    public static boolean getPushdownEnabledForCube(String cubeName) {
        String[] cubeNames;
        String cubes = PushdownUtility.getPushdownCubes();
        for (String name : cubeNames = cubes.split(CUBE_LIST_DELIMITER)) {
            if (!name.trim().equalsIgnoreCase(cubeName)) continue;
            return false;
        }
        return true;
    }

    public static boolean getPushdownEnabled(InterpreterContext interpreterContext) {
        if (interpreterContext != null && interpreterContext.getCube() instanceof ROLAPVirtualCube) {
            return false;
        }
        return configuration.getBooleanProperty(CONFIG_ENABLE, true);
    }

    public static void setPushdownEnabled(boolean enabled) {
        configuration.setProperty(CONFIG_ENABLE, String.valueOf(enabled));
    }

    public static void resetPushdownConfigurations() {
        PushdownUtility.setPushDownSizeThreshold(10000L);
        PushdownUtility.setPushdownDisabledCubes(DEFAULT_PUSHDOWN_DISABLED_CUBES);
        PushdownUtility.setPushdownEnabled(true);
    }

    public static boolean evaluateContext(InterpreterContext interpreterContext) {
        CrossJoinedSet ctx = interpreterContext.getContextSet();
        return ctx.size() <= 0L || !ctx.getTupleList().containsCalculatedMembers();
    }

    public static HashSet<IMember> collectCalculationsInContext(InterpreterContext interpreterContext, Block numExpParam) {
        HashSet<IMember> calcSet = new HashSet<IMember>();
        if (numExpParam == null) {
            return calcSet;
        }
        Object obj = numExpParam.first();
        if (obj instanceof IMember) {
            IMember mbr = (IMember)obj;
            if (mbr.isCalculatedMember()) {
                calcSet.add(mbr);
            }
        } else if (obj instanceof ITuple) {
            ITuple tuple = (ITuple)obj;
            IMember[] mbr = tuple.getMembers();
            for (int i = 0; i < mbr.length; ++i) {
                if (!mbr[i].isCalculatedMember()) continue;
                calcSet.add(mbr[i]);
            }
        }
        CrossJoinedSet ctx = interpreterContext.getContextSet();
        calcSet.addAll(ctx.getTupleList().getCalculatedMembers());
        return calcSet;
    }

    public static boolean validateSetParameter(Block setParam) {
        BlockIterator blockIter = setParam.iterator();
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Set set = (Set)blockObj[0];
            if (set.size() <= 0L || !set.getTupleList().containsCalculatedMembers()) continue;
            return false;
        }
        return true;
    }

    private static ISet getContextSetSlices(Block numExpParam) {
        ISet[] numExpContextSet = numExpParam.getContextSet();
        CrossJoinedSet cjs = new CrossJoinedSet(numExpContextSet);
        return cjs.getMultipleTupleSets();
    }

    private static boolean evaluateAsTuple(ITuple tuple, PushdownManager pushdownManager, InterpreterContext interpreterContext) {
        IMember[] mbr = tuple.getMembers();
        for (int i = 0; i < mbr.length; ++i) {
            if (PushdownUtility.evaluateAsMemberOrMeasure(mbr[i], interpreterContext)) continue;
            return false;
        }
        return true;
    }

    public static boolean evaluateAsMemberOrMeasure(IMember mbr, InterpreterContext interpreterContext) {
        if (mbr.isMeasure()) {
            if (mbr.isCalculatedMember()) {
                CalculatedMember cm = (CalculatedMember)mbr;
                XMdxCalculatedMember x = cm.getRuntreeCalculatedMember();
                boolean val = PushdownUtility.evaluateNode(x, interpreterContext);
                return val;
            }
            return true;
        }
        return mbr instanceof MemberProxy;
    }

    private static boolean evaluateNode(IXQEQueryNode node, InterpreterContext interpreterContext) {
        boolean returnVal = false;
        IXQEQueryNode[] children = node.getChildren();
        for (int i = 0; i < children.length; ++i) {
            XNode x = (XNode)children[i];
            if (x.getType() == 501059) {
                Object val = ((XMdxElement)x).evaluate(interpreterContext.getXDataContext());
                if (val instanceof Boolean) {
                    returnVal = (Boolean)val;
                } else if (val instanceof CalculatedMember) {
                    CalculatedMember calcMbr = (CalculatedMember)val;
                    XMdxCalculatedMember calcNode = calcMbr.getRuntreeCalculatedMember();
                    returnVal = PushdownUtility.evaluateNode(calcNode, interpreterContext);
                } else if (val instanceof NamedSet) {
                    NamedSet namedSet = (NamedSet)val;
                    XNode setNode = namedSet.getRuntreeSetNode();
                    returnVal = PushdownUtility.evaluateNode(setNode, interpreterContext);
                }
            } else {
                if (x.getType() == 501074 || x.getType() == 501067) {
                    return false;
                }
                returnVal = PushdownUtility.evaluateNode(x, interpreterContext);
            }
            if (returnVal) continue;
            return returnVal;
        }
        return returnVal;
    }

    public static boolean evaluateNumericExpressionBlock(PushdownManager pushdownManager, InterpreterContext interpreterContext, Block numExpParam) {
        if (numExpParam == null) {
            return false;
        }
        Object obj = numExpParam.first();
        if (obj instanceof IMember) {
            IMember mbr = (IMember)obj;
            return PushdownUtility.evaluateAsMemberOrMeasure(mbr, interpreterContext);
        }
        if (obj instanceof ITuple) {
            ITuple tuple = (ITuple)obj;
            return PushdownUtility.evaluateAsTuple(tuple, pushdownManager, interpreterContext);
        }
        return false;
    }

    public static ISet evaluateNumericExpression(ParameterFetcher parameterFetcher, PushdownManager pushdownManager, String functionName) throws InterpreterException {
        Block numExpParam;
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        if (PushdownUtility.evaluateNumericExpressionBlock(pushdownManager, interpreterContext, numExpParam = (Block)parameterFetcher.getParameter(2, false))) {
            return PushdownUtility.getContextSetSlices(numExpParam);
        }
        return null;
    }

    public static ISet[] partitionMultiContextSetByContext(ISet multiContextSet, ISet contexts) throws InterpreterRuntimeException, InterpreterException {
        if (contexts == null || contexts.isEmpty()) {
            return new ISet[]{multiContextSet};
        }
        ISet[] partitionedSets = new ISet[(int)contexts.size()];
        Set mcSet = (Set)multiContextSet;
        IHierarchy[] contextHiers = contexts.getHierarchies();
        HashSet<IMember>[] sels = ((Set)multiContextSet).selectionsInHierarchies(contextHiers);
        int i = 0;
        for (ITuple contextSlice : ((Set)contexts).getTupleList()) {
            IMember[] ctxMems = contextSlice.getMembers();
            HashSet[] partitionSels = new HashSet[sels.length];
            for (int j = 0; j < contextHiers.length; ++j) {
                partitionSels[j] = new HashSet();
                for (IMember m : sels[j]) {
                    if (ctxMems[j] != m && !MemberOperations.isAncestorOf(ctxMems[j], m)) continue;
                    partitionSels[j].add(m);
                }
                if (!partitionSels[j].isEmpty()) continue;
                partitionSels[j].add(ctxMems[j]);
            }
            CrossJoinedSet contextPartition = BlockTupleStorageUtil.createCjsFromMemberSelections(partitionSels);
            partitionedSets[i++] = mcSet.mergeSet(contextPartition);
        }
        return partitionedSets;
    }

    public static boolean doesProviderSupportPushdown(Provider provider) {
        if (provider instanceof ROLAPProvider) {
            return true;
        }
        return provider instanceof DMRProvider;
    }

    public static Set reorderSetByCubeHierarchies(Set set, Cube cube) {
        return PushdownUtility.reorderSetBySpecifiedHierarchies(set, cube.getHierarchies());
    }

    public static Set reorderSetBySpecifiedHierarchies(Set set, List<IHierarchy> hierarchies) {
        ITupleList origTl = set.getTupleList();
        int[] dimMap = new int[origTl.width()];
        int idx = 0;
        for (IHierarchy hierarchy : hierarchies) {
            dimMap[idx++] = set.getHierarchyIndex(hierarchy);
        }
        ITupleList tl = ExtractTupleList.construct(origTl, dimMap);
        return new Set(tl);
    }

    public static String addCoalesceDataItem(IXQEQueryNode selection, XQENodeFactory nodeFactory, String dataItemName) {
        IXQEQueryNode dataItem = nodeFactory.createNode(101003);
        dataItem.setPropertyValue("aggregate", "notApplicable");
        dataItem.setPropertyValue("name", STR_COALESCE_REF);
        selection.addChild(dataItem);
        IXQEQueryNode expression = nodeFactory.createNode(101004);
        expression.setPropertyValue("expression", "coalesce(" + UniqueNameGenerator.createUniqueName(dataItemName) + ", 0" + CLOSE_PARENTHESIS_STR);
        dataItem.addChild(expression);
        return STR_COALESCE_REF;
    }

    public static boolean checkNumericalExpression(IXQEQueryNode xNode) {
        IXQEQueryNode expressionList = xNode.getFirstChildByType(501061);
        IXQEQueryNode[] expressions = expressionList.getChildrenOfType(501060);
        if (expressions.length != 2) {
            return false;
        }
        IXQEQueryNode[] booleanPrim = expressions[1].getChildrenOfType(501056);
        if (booleanPrim.length != 1) {
            IXQEQueryNode[] booleanFactor = expressions[1].getChildrenOfType(501055);
            return booleanFactor.length == 1;
        }
        IXQEQueryNode booleanPrimary = booleanPrim[0];
        return booleanPrimary.getChildrenOfType(501076).length != 0;
    }
}

